/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.showcase.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.showcase.model.RandomShowcase;
import io.gs2.cdk.showcase.model.Showcase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-04-04";
    private String namespaceName;
    private List<Showcase> showcases;
    private List<RandomShowcase> randomShowcases;

    public CurrentMasterData(Stack stack, String namespaceName, List<Showcase> showcases, List<RandomShowcase> randomShowcases) {
        super("Showcase_CurrentShowcaseMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.showcases = showcases;
        this.randomShowcases = randomShowcases;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Showcase::CurrentShowcaseMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.showcases != null) {
            settings.put("showcases", this.showcases.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.randomShowcases != null) {
            settings.put("randomShowcases", this.randomShowcases.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

