/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.realtime.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.realtime.model.options.RoomOptions;
import io.gs2.cdk.realtime.ref.RoomRef;
import java.util.HashMap;
import java.util.Map;

public class Room
extends CdkResource {
    private Stack stack;
    private String ownerId;
    private String namespaceName;
    private String name;
    private String ipAddress = null;
    private Integer port = null;
    private String encryptionKey = null;

    public Room(Stack stack, String ownerId, String namespaceName, String name, RoomOptions options) {
        super("Realtime_Room_" + name);
        this.stack = stack;
        this.ownerId = ownerId;
        this.namespaceName = namespaceName;
        this.name = name;
        this.ipAddress = options.ipAddress;
        this.port = options.port;
        this.encryptionKey = options.encryptionKey;
        stack.addResource(this);
    }

    public Room(Stack stack, String ownerId, String namespaceName, String name) {
        super("Realtime_Room_" + name);
        this.stack = stack;
        this.ownerId = ownerId;
        this.namespaceName = namespaceName;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Realtime::Room";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.ownerId != null) {
            properties.put("OwnerId", this.ownerId);
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.ipAddress != null) {
            properties.put("IpAddress", this.ipAddress);
        }
        if (this.port != null) {
            properties.put("Port", this.port);
        }
        if (this.encryptionKey != null) {
            properties.put("EncryptionKey", this.encryptionKey);
        }
        return properties;
    }

    public RoomRef ref() {
        return new RoomRef(this.namespaceName, this.name);
    }

    public GetAttr getAttrRoomId() {
        return new GetAttr(this, "Item.RoomId", null);
    }
}

