/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.mission.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.mission.model.enums.MissionTaskModelTargetResetType;
import io.gs2.cdk.mission.model.options.MissionTaskModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MissionTaskModel {
    private String name;
    private String counterName;
    private Long targetValue;
    private String metadata = null;
    private MissionTaskModelTargetResetType targetResetType = null;
    private List<AcquireAction> completeAcquireActions = null;
    private String challengePeriodEventId = null;
    private String premiseMissionTaskName = null;

    public MissionTaskModel(String name, String counterName, Long targetValue, MissionTaskModelOptions options) {
        this.name = name;
        this.counterName = counterName;
        this.targetValue = targetValue;
        this.metadata = options.metadata;
        this.targetResetType = options.targetResetType;
        this.completeAcquireActions = options.completeAcquireActions;
        this.challengePeriodEventId = options.challengePeriodEventId;
        this.premiseMissionTaskName = options.premiseMissionTaskName;
    }

    public MissionTaskModel(String name, String counterName, Long targetValue) {
        this.name = name;
        this.counterName = counterName;
        this.targetValue = targetValue;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.counterName != null) {
            properties.put("counterName", this.counterName);
        }
        if (this.targetResetType != null) {
            properties.put("targetResetType", this.targetResetType.toString());
        }
        if (this.targetValue != null) {
            properties.put("targetValue", this.targetValue);
        }
        if (this.completeAcquireActions != null) {
            properties.put("completeAcquireActions", this.completeAcquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.challengePeriodEventId != null) {
            properties.put("challengePeriodEventId", this.challengePeriodEventId);
        }
        if (this.premiseMissionTaskName != null) {
            properties.put("premiseMissionTaskName", this.premiseMissionTaskName);
        }
        return properties;
    }
}

