/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.matchmaking.model;

import io.gs2.cdk.matchmaking.model.Attribute;
import io.gs2.cdk.matchmaking.model.options.PlayerOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Player {
    private String userId;
    private String roleName;
    private List<Attribute> attributes = null;
    private List<String> denyUserIds = null;

    public Player(String userId, String roleName, PlayerOptions options) {
        this.userId = userId;
        this.roleName = roleName;
        this.attributes = options.attributes;
        this.denyUserIds = options.denyUserIds;
    }

    public Player(String userId, String roleName) {
        this.userId = userId;
        this.roleName = roleName;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.userId != null) {
            properties.put("userId", this.userId);
        }
        if (this.attributes != null) {
            properties.put("attributes", this.attributes.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.roleName != null) {
            properties.put("roleName", this.roleName);
        }
        if (this.denyUserIds != null) {
            properties.put("denyUserIds", this.denyUserIds);
        }
        return properties;
    }
}

