/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.key.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.key.model.options.KeyOptions;
import io.gs2.cdk.key.ref.KeyRef;
import java.util.HashMap;
import java.util.Map;

public class Key
extends CdkResource {
    private Stack stack;
    private String namespaceName;
    private String name;
    private String description = null;

    public Key(Stack stack, String namespaceName, String name, KeyOptions options) {
        super("Key_Key_" + name);
        this.stack = stack;
        this.namespaceName = namespaceName;
        this.name = name;
        this.description = options.description;
        stack.addResource(this);
    }

    public Key(Stack stack, String namespaceName, String name) {
        super("Key_Key_" + name);
        this.stack = stack;
        this.namespaceName = namespaceName;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Key::Key";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        return properties;
    }

    public KeyRef ref() {
        return new KeyRef(this.namespaceName, this.name);
    }

    public GetAttr getAttrKeyId() {
        return new GetAttr(this, "Item.KeyId", null);
    }
}

