/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.identifier.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.identifier.model.options.IdentifierOptions;
import io.gs2.cdk.identifier.ref.IdentifierRef;
import java.util.HashMap;
import java.util.Map;

public class Identifier
extends CdkResource {
    private Stack stack;
    private String userName;

    public Identifier(Stack stack, String userName, IdentifierOptions options) {
        super("Identifier_Identifier_" + userName);
        this.stack = stack;
        this.userName = userName;
        stack.addResource(this);
    }

    public Identifier(Stack stack, String userName) {
        super("Identifier_Identifier_" + userName);
        this.stack = stack;
        this.userName = userName;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "userName";
    }

    @Override
    public String resourceType() {
        return "GS2::Identifier::Identifier";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.userName != null) {
            properties.put("UserName", this.userName);
        }
        return properties;
    }

    public IdentifierRef ref(String clientId) {
        return new IdentifierRef(this.userName, clientId);
    }

    public GetAttr getAttrClientId() {
        return new GetAttr(this, "Item.ClientId", null);
    }

    public GetAttr getAttrClientSecret() {
        return new GetAttr(this, "ClientSecret", null);
    }
}

