/*
 * Copyright 2016- Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package io.gs2.cdk.news.model;
import io.gs2.cdk.news.model.options.ContentOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.stream.Collectors;

public class Content {
    private String section;
    private String content;
    private String frontMatter;

    public Content(
        String section,
        String content,
        String frontMatter,
        ContentOptions options
    ) {
        this.section = section;
        this.content = content;
        this.frontMatter = frontMatter;
    }
    public Content(
        String section,
        String content,
        String frontMatter
    ) {
        this.section = section;
        this.content = content;
        this.frontMatter = frontMatter;
    }

    public Map<String, Object> properties(
    ) {
        var properties = new HashMap<String, Object>();

        if (this.section != null) {
            properties.put("section", this.section);
        }
        if (this.content != null) {
            properties.put("content", this.content);
        }
        if (this.frontMatter != null) {
            properties.put("frontMatter", this.frontMatter);
        }

        return properties;
    }
}
