/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.version.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.version.model.CurrentMasterData;
import io.gs2.cdk.version.model.VersionModel;
import io.gs2.cdk.version.model.options.NamespaceOptions;
import io.gs2.cdk.version.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String assumeUserId;
    private String description = null;
    private ScriptSetting acceptVersionScript = null;
    private String checkVersionTriggerScriptId = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, String assumeUserId, NamespaceOptions options) {
        super("Version_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.assumeUserId = assumeUserId;
        this.description = options.description;
        this.acceptVersionScript = options.acceptVersionScript;
        this.checkVersionTriggerScriptId = options.checkVersionTriggerScriptId;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name, String assumeUserId) {
        super("Version_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.assumeUserId = assumeUserId;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Version::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.assumeUserId != null) {
            properties.put("AssumeUserId", this.assumeUserId);
        }
        if (this.acceptVersionScript != null) {
            properties.put("AcceptVersionScript", this.acceptVersionScript.properties());
        }
        if (this.checkVersionTriggerScriptId != null) {
            properties.put("CheckVersionTriggerScriptId", this.checkVersionTriggerScriptId);
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<VersionModel> versionModels) {
        new CurrentMasterData(this.stack, this.name, versionModels).addDependsOn(this);
        return this;
    }
}

