/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.version.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.version.model.VersionModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-10-09";
    private String namespaceName;
    private List<VersionModel> versionModels;

    public CurrentMasterData(Stack stack, String namespaceName, List<VersionModel> versionModels) {
        super("Version_CurrentVersionMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.versionModels = versionModels;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Version::CurrentVersionMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.versionModels != null) {
            settings.put("versionModels", this.versionModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

