/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.stateMachine.integration;

import io.gs2.cdk.stateMachine.integration.Event;
import io.gs2.cdk.stateMachine.integration.ITask;
import io.gs2.cdk.stateMachine.integration.IVariable;
import io.gs2.cdk.stateMachine.integration.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WaitTask
implements ITask {
    String name;
    List<Result> results = new ArrayList<Result>();
    List<Event> events = new ArrayList<Event>();

    public WaitTask(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITask transition(Event event) {
        event.fromTaskName = this.name;
        this.events.add(event);
        return this;
    }

    @Override
    public Event[] getEvents() {
        return this.events.toArray(new Event[0]);
    }

    public WaitTask result(String resultName, Map<IVariable, String> emitEventArgumentVariableNames, String nextTaskName) {
        this.results.add(new Result(resultName, resultName, emitEventArgumentVariableNames));
        IVariable[] eventArguments = emitEventArgumentVariableNames.keySet().stream().collect(Collectors.toList()).toArray(new IVariable[0]);
        this.transition(new Event(resultName, eventArguments, nextTaskName));
        return this;
    }

    @Override
    public String gsl() {
        StringBuilder output = new StringBuilder();
        output.append(String.format("WaitTask %s {%n", this.name));
        for (Event event : this.events) {
            String argumentsPart = Arrays.stream(event.arguments).map(IVariable::gsl).collect(Collectors.joining(", "));
            output.append(String.format("Event %s(%s);\n", event.name, argumentsPart).indent(2));
        }
        output.append("}\n\n");
        return output.toString();
    }

    @Override
    public String mermaid() {
        StringBuilder output = new StringBuilder();
        for (Event event : this.events) {
            if (event.nextTaskName.equals("Error")) continue;
            output.append(String.format("{stateMachineName}_%s([{%s}]) -->|%s| {stateMachineName}_%s\n", event.fromTaskName, event.fromTaskName, event.name, event.nextTaskName));
        }
        return output.toString();
    }
}

