/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.stateMachine.integration;

import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.script.model.Namespace;
import io.gs2.cdk.stateMachine.integration.ArrayType;
import io.gs2.cdk.stateMachine.integration.BoolType;
import io.gs2.cdk.stateMachine.integration.ErrorTask;
import io.gs2.cdk.stateMachine.integration.Event;
import io.gs2.cdk.stateMachine.integration.FloatType;
import io.gs2.cdk.stateMachine.integration.IVariable;
import io.gs2.cdk.stateMachine.integration.InParam;
import io.gs2.cdk.stateMachine.integration.IntType;
import io.gs2.cdk.stateMachine.integration.MapType;
import io.gs2.cdk.stateMachine.integration.OutParam;
import io.gs2.cdk.stateMachine.integration.PassTask;
import io.gs2.cdk.stateMachine.integration.Script;
import io.gs2.cdk.stateMachine.integration.StateMachine;
import io.gs2.cdk.stateMachine.integration.StringType;
import io.gs2.cdk.stateMachine.integration.SubStateMachineTask;
import io.gs2.cdk.stateMachine.integration.Task;
import io.gs2.cdk.stateMachine.integration.WaitTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StateMachineDefinition {
    public String stateMachineName = "";
    List<StateMachine> stateMachines = new ArrayList<StateMachine>();

    public void add(StateMachine stateMachine) {
        this.stateMachines.add(stateMachine);
    }

    public void entryPointStateMachineName(String stateMachineName) {
        this.stateMachineName = stateMachineName;
    }

    public StateMachine stateMachine(String name, IVariable[] variables) {
        return new StateMachine(this, name, variables);
    }

    public Task scriptTask(String name, IVariable[] arguments, String script) {
        return new Task(name, arguments, script);
    }

    public SubStateMachineTask subStateMachineTask(String name, String subStateMachineName, InParam[] inParams, OutParam[] outParams, String nextTaskName) {
        SubStateMachineTask task = new SubStateMachineTask(name, subStateMachineName, inParams, outParams);
        task.transition(new Event("Pass", (IVariable[])Arrays.stream(outParams).map(v -> v.subStateMachineVariable).toArray(IVariable[]::new), nextTaskName));
        return task;
    }

    public InParam inParam(IVariable currentStateMachineVariable, IVariable subStateMachineVariable) {
        return new InParam(currentStateMachineVariable, subStateMachineVariable);
    }

    public OutParam outParam(IVariable subStateMachineVariable, IVariable currentStateMachineVariable) {
        return new OutParam(subStateMachineVariable, currentStateMachineVariable);
    }

    public WaitTask waitTask(String name) {
        return new WaitTask(name);
    }

    public PassTask passTask(String name) {
        return new PassTask(name);
    }

    public ErrorTask errorTask(String name) {
        return new ErrorTask(name);
    }

    public IntType intType(String name) {
        return new IntType(name);
    }

    public FloatType floatType(String name) {
        return new FloatType(name);
    }

    public BoolType boolType(String name) {
        return new BoolType(name);
    }

    public StringType stringType(String name) {
        return new StringType(name);
    }

    public ArrayType arrayType(String name) {
        return new ArrayType(name);
    }

    public MapType mapType(String name) {
        return new MapType(name);
    }

    public io.gs2.cdk.script.model.Script[] appendScripts(Stack stack, Namespace scriptNamespace) {
        ArrayList<io.gs2.cdk.script.model.Script> scripts = new ArrayList<io.gs2.cdk.script.model.Script>();
        for (StateMachine stateMachine : this.stateMachines) {
            for (Script script : stateMachine.scripts()) {
                io.gs2.cdk.script.model.Script deployScript = new io.gs2.cdk.script.model.Script(stack, scriptNamespace.getName(), script.name, script.payload.trim());
                deployScript.addDependsOn(scriptNamespace);
                scripts.add(deployScript);
            }
        }
        return scripts.toArray(new io.gs2.cdk.script.model.Script[0]);
    }

    public String gsl() {
        StringBuilder output = new StringBuilder();
        for (StateMachine stateMachine : this.stateMachines) {
            output.append(stateMachine.gsl()).append("\n");
        }
        return output.toString();
    }

    public String mermaid() {
        StringBuilder output = new StringBuilder("flowchart TD\n");
        output.append(String.format("Start ----> %s_{%s}\n", this.stateMachines.get((int)0).name, this.stateMachines.get((int)0).entryPointValue).indent(2));
        output.append(String.format("%s_Pass ----> Exit\n", this.stateMachines.get((int)0).name).indent(2));
        for (StateMachine stateMachine : this.stateMachines) {
            output.append(stateMachine.mermaid().indent(2)).append("\n");
        }
        for (StateMachine stateMachine : this.stateMachines) {
            output = new StringBuilder(output.toString().replace("{" + stateMachine.name + "_entryPoint}", stateMachine.entryPointValue));
        }
        return output.toString();
    }
}

