/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.showcase.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.core.model.ConsumeAction;
import io.gs2.cdk.showcase.model.options.RandomDisplayItemModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RandomDisplayItemModel {
    private String name;
    private List<AcquireAction> acquireActions;
    private Integer stock;
    private Integer weight;
    private String metadata = null;
    private List<ConsumeAction> consumeActions = null;

    public RandomDisplayItemModel(String name, List<AcquireAction> acquireActions, Integer stock, Integer weight, RandomDisplayItemModelOptions options) {
        this.name = name;
        this.acquireActions = acquireActions;
        this.stock = stock;
        this.weight = weight;
        this.metadata = options.metadata;
        this.consumeActions = options.consumeActions;
    }

    public RandomDisplayItemModel(String name, List<AcquireAction> acquireActions, Integer stock, Integer weight) {
        this.name = name;
        this.acquireActions = acquireActions;
        this.stock = stock;
        this.weight = weight;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.consumeActions != null) {
            properties.put("consumeActions", this.consumeActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.acquireActions != null) {
            properties.put("acquireActions", this.acquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.stock != null) {
            properties.put("stock", this.stock);
        }
        if (this.weight != null) {
            properties.put("weight", this.weight);
        }
        return properties;
    }
}

