/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.mission.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.mission.model.CounterModel;
import io.gs2.cdk.mission.model.MissionGroupModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-05-28";
    private String namespaceName;
    private List<MissionGroupModel> groups;
    private List<CounterModel> counters;

    public CurrentMasterData(Stack stack, String namespaceName, List<MissionGroupModel> groups, List<CounterModel> counters) {
        super("Mission_CurrentMissionMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.groups = groups;
        this.counters = counters;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Mission::CurrentMissionMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.groups != null) {
            settings.put("groups", this.groups.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.counters != null) {
            settings.put("counters", this.counters.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

