/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.lottery.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.lottery.model.LotteryModel;
import io.gs2.cdk.lottery.model.PrizeTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-02-21";
    private String namespaceName;
    private List<LotteryModel> lotteryModels;
    private List<PrizeTable> prizeTables;

    public CurrentMasterData(Stack stack, String namespaceName, List<LotteryModel> lotteryModels, List<PrizeTable> prizeTables) {
        super("Lottery_CurrentLotteryMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.lotteryModels = lotteryModels;
        this.prizeTables = prizeTables;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Lottery::CurrentLotteryMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.lotteryModels != null) {
            settings.put("lotteryModels", this.lotteryModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.prizeTables != null) {
            settings.put("prizeTables", this.prizeTables.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

