/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.idle.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.core.model.TransactionSetting;
import io.gs2.cdk.idle.model.CategoryModel;
import io.gs2.cdk.idle.model.CurrentMasterData;
import io.gs2.cdk.idle.model.options.NamespaceOptions;
import io.gs2.cdk.idle.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private TransactionSetting transactionSetting;
    private String description = null;
    private ScriptSetting receiveScript = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, TransactionSetting transactionSetting, NamespaceOptions options) {
        super("Idle_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.transactionSetting = transactionSetting;
        this.description = options.description;
        this.receiveScript = options.receiveScript;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name, TransactionSetting transactionSetting) {
        super("Idle_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.transactionSetting = transactionSetting;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Idle::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.transactionSetting != null) {
            properties.put("TransactionSetting", this.transactionSetting.properties());
        }
        if (this.receiveScript != null) {
            properties.put("ReceiveScript", this.receiveScript.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<CategoryModel> categoryModels) {
        new CurrentMasterData(this.stack, this.name, categoryModels).addDependsOn(this);
        return this;
    }
}

