/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.experience.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.core.model.TransactionSetting;
import io.gs2.cdk.experience.model.CurrentMasterData;
import io.gs2.cdk.experience.model.ExperienceModel;
import io.gs2.cdk.experience.model.options.NamespaceOptions;
import io.gs2.cdk.experience.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;
    private TransactionSetting transactionSetting = null;
    private String experienceCapScriptId = null;
    private ScriptSetting changeExperienceScript = null;
    private ScriptSetting changeRankScript = null;
    private ScriptSetting changeRankCapScript = null;
    private ScriptSetting overflowExperienceScript = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceOptions options) {
        super("Experience_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        this.transactionSetting = options.transactionSetting;
        this.experienceCapScriptId = options.experienceCapScriptId;
        this.changeExperienceScript = options.changeExperienceScript;
        this.changeRankScript = options.changeRankScript;
        this.changeRankCapScript = options.changeRankCapScript;
        this.overflowExperienceScript = options.overflowExperienceScript;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name) {
        super("Experience_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Experience::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.transactionSetting != null) {
            properties.put("TransactionSetting", this.transactionSetting.properties());
        }
        if (this.experienceCapScriptId != null) {
            properties.put("ExperienceCapScriptId", this.experienceCapScriptId);
        }
        if (this.changeExperienceScript != null) {
            properties.put("ChangeExperienceScript", this.changeExperienceScript.properties());
        }
        if (this.changeRankScript != null) {
            properties.put("ChangeRankScript", this.changeRankScript.properties());
        }
        if (this.changeRankCapScript != null) {
            properties.put("ChangeRankCapScript", this.changeRankCapScript.properties());
        }
        if (this.overflowExperienceScript != null) {
            properties.put("OverflowExperienceScript", this.overflowExperienceScript.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<ExperienceModel> experienceModels) {
        new CurrentMasterData(this.stack, this.name, experienceModels).addDependsOn(this);
        return this;
    }
}

