/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.showcase.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.core.model.ConsumeAction;
import io.gs2.cdk.showcase.model.options.SalesItemOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SalesItem {
    private String name;
    private List<AcquireAction> acquireActions;
    private String metadata = null;
    private List<ConsumeAction> consumeActions = null;

    public SalesItem(String name, List<AcquireAction> acquireActions, SalesItemOptions options) {
        this.name = name;
        this.acquireActions = acquireActions;
        this.metadata = options.metadata;
        this.consumeActions = options.consumeActions;
    }

    public SalesItem(String name, List<AcquireAction> acquireActions) {
        this.name = name;
        this.acquireActions = acquireActions;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.consumeActions != null) {
            properties.put("consumeActions", this.consumeActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.acquireActions != null) {
            properties.put("acquireActions", this.acquireActions.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        return properties;
    }
}

