/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.experience.model;

import io.gs2.cdk.experience.model.AcquireActionRate;
import io.gs2.cdk.experience.model.Threshold;
import io.gs2.cdk.experience.model.options.ExperienceModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExperienceModel {
    private String name;
    private Long defaultExperience;
    private Long defaultRankCap;
    private Long maxRankCap;
    private Threshold rankThreshold;
    private String metadata = null;
    private List<AcquireActionRate> acquireActionRates = null;

    public ExperienceModel(String name, Long defaultExperience, Long defaultRankCap, Long maxRankCap, Threshold rankThreshold, ExperienceModelOptions options) {
        this.name = name;
        this.defaultExperience = defaultExperience;
        this.defaultRankCap = defaultRankCap;
        this.maxRankCap = maxRankCap;
        this.rankThreshold = rankThreshold;
        this.metadata = options.metadata;
        this.acquireActionRates = options.acquireActionRates;
    }

    public ExperienceModel(String name, Long defaultExperience, Long defaultRankCap, Long maxRankCap, Threshold rankThreshold) {
        this.name = name;
        this.defaultExperience = defaultExperience;
        this.defaultRankCap = defaultRankCap;
        this.maxRankCap = maxRankCap;
        this.rankThreshold = rankThreshold;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.defaultExperience != null) {
            properties.put("defaultExperience", this.defaultExperience);
        }
        if (this.defaultRankCap != null) {
            properties.put("defaultRankCap", this.defaultRankCap);
        }
        if (this.maxRankCap != null) {
            properties.put("maxRankCap", this.maxRankCap);
        }
        if (this.rankThreshold != null) {
            properties.put("rankThreshold", this.rankThreshold.properties());
        }
        if (this.acquireActionRates != null) {
            properties.put("acquireActionRates", this.acquireActionRates.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        return properties;
    }
}

