/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.enchant.model;

import io.gs2.cdk.enchant.model.BalanceParameterValueModel;
import io.gs2.cdk.enchant.model.enums.BalanceParameterModelInitialValueStrategy;
import io.gs2.cdk.enchant.model.options.BalanceParameterModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BalanceParameterModel {
    private String name;
    private Long totalValue;
    private BalanceParameterModelInitialValueStrategy initialValueStrategy;
    private List<BalanceParameterValueModel> parameters;
    private String metadata = null;

    public BalanceParameterModel(String name, Long totalValue, BalanceParameterModelInitialValueStrategy initialValueStrategy, List<BalanceParameterValueModel> parameters, BalanceParameterModelOptions options) {
        this.name = name;
        this.totalValue = totalValue;
        this.initialValueStrategy = initialValueStrategy;
        this.parameters = parameters;
        this.metadata = options.metadata;
    }

    public BalanceParameterModel(String name, Long totalValue, BalanceParameterModelInitialValueStrategy initialValueStrategy, List<BalanceParameterValueModel> parameters) {
        this.name = name;
        this.totalValue = totalValue;
        this.initialValueStrategy = initialValueStrategy;
        this.parameters = parameters;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.totalValue != null) {
            properties.put("totalValue", this.totalValue);
        }
        if (this.initialValueStrategy != null) {
            properties.put("initialValueStrategy", this.initialValueStrategy.toString());
        }
        if (this.parameters != null) {
            properties.put("parameters", this.parameters.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        return properties;
    }
}

