/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.distributor.model;

import io.gs2.cdk.core.model.AcquireAction;
import io.gs2.cdk.core.model.ConsumeAction;
import io.gs2.cdk.distributor.model.options.StampSheetResultOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StampSheetResult {
    private String userId;
    private String transactionId;
    private AcquireAction sheetRequest;
    private List<ConsumeAction> taskRequests = null;
    private List<String> taskResults = null;
    private String sheetResult = null;
    private String nextTransactionId = null;
    private Long revision = null;

    public StampSheetResult(String userId, String transactionId, AcquireAction sheetRequest, StampSheetResultOptions options) {
        this.userId = userId;
        this.transactionId = transactionId;
        this.sheetRequest = sheetRequest;
        this.taskRequests = options.taskRequests;
        this.taskResults = options.taskResults;
        this.sheetResult = options.sheetResult;
        this.nextTransactionId = options.nextTransactionId;
        this.revision = options.revision;
    }

    public StampSheetResult(String userId, String transactionId, AcquireAction sheetRequest) {
        this.userId = userId;
        this.transactionId = transactionId;
        this.sheetRequest = sheetRequest;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.userId != null) {
            properties.put("userId", this.userId);
        }
        if (this.transactionId != null) {
            properties.put("transactionId", this.transactionId);
        }
        if (this.taskRequests != null) {
            properties.put("taskRequests", this.taskRequests.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.sheetRequest != null) {
            properties.put("sheetRequest", this.sheetRequest.properties());
        }
        if (this.taskResults != null) {
            properties.put("taskResults", this.taskResults);
        }
        if (this.sheetResult != null) {
            properties.put("sheetResult", this.sheetResult);
        }
        if (this.nextTransactionId != null) {
            properties.put("nextTransactionId", this.nextTransactionId);
        }
        return properties;
    }
}

