/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.Internal;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.gcp.observability.interceptors.InetAddressUtil;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.observabilitylog.v1.Address;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import io.grpc.observabilitylog.v1.Payload;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public class LogHelper {
    private static final Logger logger = Logger.getLogger(LogHelper.class.getName());
    static final Metadata.Key<byte[]> STATUS_DETAILS_KEY = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    private final Sink sink;
    private static final Set<String> NEVER_INCLUDED_METADATA = new HashSet<String>(Collections.singletonList(STATUS_DETAILS_KEY.name()));
    private static final Set<String> ALWAYS_INCLUDED_METADATA = new HashSet<String>(Collections.singletonList("grpc-trace-bin"));

    public LogHelper(Sink sink) {
        this.sink = sink;
    }

    void logClientHeader(long seqId, String serviceName, String methodName, String authority, @Nullable Duration timeout, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String callId, @Nullable SocketAddress peerAddress) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.SERVER ? 1 : 0) != 0, (Object)"peerAddress can only be specified by server");
        PayloadBuilderHelper<Payload.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        if (timeout != null) {
            ((Payload.Builder)pair.payloadBuilder).setTimeout(timeout);
        }
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(GrpcLogRecord.EventType.CLIENT_HEADER).setLogger(eventLogger).setPayload((Payload.Builder)pair.payloadBuilder).setPayloadTruncated(pair.truncated).setCallId(callId);
        if (peerAddress != null) {
            logEntryBuilder.setPeer(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logServerHeader(long seqId, String serviceName, String methodName, String authority, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String callId, @Nullable SocketAddress peerAddress) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.CLIENT ? 1 : 0) != 0, (Object)"peerAddress can only be specified for client");
        PayloadBuilderHelper<Payload.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(GrpcLogRecord.EventType.SERVER_HEADER).setLogger(eventLogger).setPayload((Payload.Builder)pair.payloadBuilder).setPayloadTruncated(pair.truncated).setCallId(callId);
        if (peerAddress != null) {
            logEntryBuilder.setPeer(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logTrailer(long seqId, String serviceName, String methodName, String authority, Status status, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String callId, @Nullable SocketAddress peerAddress) {
        byte[] statusDetailBytes;
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.CLIENT ? 1 : 0) != 0, (Object)"peerAddress can only be specified for client");
        PayloadBuilderHelper<Payload.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        ((Payload.Builder)pair.payloadBuilder).setStatusCode(status.getCode().value());
        String statusDescription = status.getDescription();
        if (statusDescription != null) {
            ((Payload.Builder)pair.payloadBuilder).setStatusMessage(statusDescription);
        }
        if ((statusDetailBytes = (byte[])metadata.get(STATUS_DETAILS_KEY)) != null) {
            ((Payload.Builder)pair.payloadBuilder).setStatusDetails(ByteString.copyFrom((byte[])statusDetailBytes));
        }
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(GrpcLogRecord.EventType.SERVER_TRAILER).setLogger(eventLogger).setPayload((Payload.Builder)pair.payloadBuilder).setPayloadTruncated(pair.truncated).setCallId(callId);
        if (peerAddress != null) {
            logEntryBuilder.setPeer(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    <T> void logRpcMessage(long seqId, String serviceName, String methodName, String authority, GrpcLogRecord.EventType eventType, T message, int maxMessageBytes, GrpcLogRecord.EventLogger eventLogger, String callId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        Preconditions.checkArgument((eventType == GrpcLogRecord.EventType.CLIENT_MESSAGE || eventType == GrpcLogRecord.EventType.SERVER_MESSAGE ? 1 : 0) != 0, (Object)"event type must correspond to client message or server message");
        Preconditions.checkNotNull(message, (Object)"message");
        byte[] messageBytesArray = null;
        if (message instanceof Message) {
            messageBytesArray = ((Message)message).toByteArray();
        } else if (message instanceof byte[]) {
            messageBytesArray = (byte[])message;
        } else {
            logger.log(Level.WARNING, "message is of UNKNOWN type, message and payload_size fields of GrpcLogRecord proto will not be logged");
        }
        PayloadBuilderHelper<Payload.Builder> pair = null;
        if (messageBytesArray != null) {
            pair = LogHelper.createMessageProto(messageBytesArray, maxMessageBytes);
        }
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(eventType).setLogger(eventLogger).setCallId(callId);
        if (pair != null) {
            logEntryBuilder.setPayload((Payload.Builder)pair.payloadBuilder).setPayloadTruncated(pair.truncated);
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logHalfClose(long seqId, String serviceName, String methodName, String authority, GrpcLogRecord.EventLogger eventLogger, String callId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(GrpcLogRecord.EventType.CLIENT_HALF_CLOSE).setLogger(eventLogger).setCallId(callId);
        this.sink.write(logEntryBuilder.build());
    }

    void logCancel(long seqId, String serviceName, String methodName, String authority, GrpcLogRecord.EventLogger eventLogger, String callId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)callId, (Object)"callId");
        GrpcLogRecord.Builder logEntryBuilder = GrpcLogRecord.newBuilder().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setType(GrpcLogRecord.EventType.CANCEL).setLogger(eventLogger).setCallId(callId);
        this.sink.write(logEntryBuilder.build());
    }

    static PayloadBuilderHelper<Payload.Builder> createMetadataProto(Metadata metadata, int maxHeaderBytes) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        Preconditions.checkArgument((maxHeaderBytes >= 0 ? 1 : 0) != 0, (Object)"maxHeaderBytes must be non negative");
        Joiner joiner = Joiner.on((String)",").skipNulls();
        Payload.Builder payloadBuilder = Payload.newBuilder();
        boolean truncated = false;
        int totalMetadataBytes = 0;
        for (String key : metadata.keys()) {
            String metadataValue;
            Iterable metadataValues;
            if (NEVER_INCLUDED_METADATA.contains(key)) continue;
            boolean forceInclude = ALWAYS_INCLUDED_METADATA.contains(key);
            if (key.endsWith("-bin")) {
                metadataValues = metadata.getAll(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER));
                ArrayList numList = new ArrayList();
                metadataValues.forEach(element -> numList.add(InternalMetadata.BASE64_ENCODING_OMIT_PADDING.encode(element)));
                metadataValue = joiner.join(numList);
            } else {
                metadataValues = metadata.getAll(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                metadataValue = joiner.join(metadataValues);
            }
            int metadataBytesAfterAdd = totalMetadataBytes + key.length() + metadataValue.length();
            if (!forceInclude && metadataBytesAfterAdd > maxHeaderBytes) {
                truncated = true;
                continue;
            }
            payloadBuilder.putMetadata(key, metadataValue);
            if (forceInclude) continue;
            totalMetadataBytes = metadataBytesAfterAdd;
        }
        return new PayloadBuilderHelper<Payload.Builder>(payloadBuilder, truncated);
    }

    static PayloadBuilderHelper<Payload.Builder> createMessageProto(byte[] message, int maxMessageBytes) {
        Preconditions.checkArgument((maxMessageBytes >= 0 ? 1 : 0) != 0, (Object)"maxMessageBytes must be non negative");
        Payload.Builder payloadBuilder = Payload.newBuilder();
        int desiredBytes = 0;
        int messageLength = message.length;
        if (maxMessageBytes > 0) {
            desiredBytes = Math.min(maxMessageBytes, messageLength);
        }
        ByteString messageData = ByteString.copyFrom((byte[])message, (int)0, (int)desiredBytes);
        payloadBuilder.setMessage(messageData);
        payloadBuilder.setMessageLength(messageLength);
        return new PayloadBuilderHelper<Payload.Builder>(payloadBuilder, maxMessageBytes < message.length);
    }

    static Address socketAddressToProto(SocketAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address");
        Address.Builder builder = Address.newBuilder();
        if (address instanceof InetSocketAddress) {
            InetAddress inetAddress = ((InetSocketAddress)address).getAddress();
            if (inetAddress instanceof Inet4Address) {
                builder.setType(Address.Type.TYPE_IPV4).setAddress(InetAddressUtil.toAddrString(inetAddress));
            } else if (inetAddress instanceof Inet6Address) {
                builder.setType(Address.Type.TYPE_IPV6).setAddress(InetAddressUtil.toAddrString(inetAddress));
            } else {
                logger.log(Level.SEVERE, "unknown type of InetSocketAddress: {}", address);
                builder.setAddress(address.toString());
            }
            builder.setIpPort(((InetSocketAddress)address).getPort());
        } else if (address.getClass().getName().equals("io.netty.channel.unix.DomainSocketAddress")) {
            builder.setType(Address.Type.TYPE_UNIX).setAddress(address.toString());
        } else {
            builder.setType(Address.Type.TYPE_UNKNOWN).setAddress(address.toString());
        }
        return builder.build();
    }

    static SocketAddress getPeerAddress(Attributes streamAttributes) {
        return (SocketAddress)streamAttributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
    }

    static Deadline min(@Nullable Deadline deadline0, @Nullable Deadline deadline1) {
        if (deadline0 == null) {
            return deadline1;
        }
        if (deadline1 == null) {
            return deadline0;
        }
        return deadline0.minimum(deadline1);
    }

    static final class PayloadBuilderHelper<T> {
        T payloadBuilder;
        boolean truncated;

        private PayloadBuilderHelper(T payload, boolean truncated) {
            this.payloadBuilder = payload;
            this.truncated = truncated;
        }
    }
}

