/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;

public final class Http2CodecUtil {
    public static final int CONNECTION_STREAM_ID = 0;
    public static final int HTTP_UPGRADE_STREAM_ID = 1;
    public static final CharSequence HTTP_UPGRADE_SETTINGS_HEADER = new AsciiString((CharSequence)"HTTP2-Settings");
    public static final CharSequence HTTP_UPGRADE_PROTOCOL_NAME = "h2c";
    public static final CharSequence TLS_UPGRADE_PROTOCOL_NAME = "h2";
    public static final int PING_FRAME_PAYLOAD_LENGTH = 8;
    public static final short MAX_UNSIGNED_BYTE = 255;
    public static final int MAX_UNSIGNED_SHORT = 65535;
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final int FRAME_HEADER_LENGTH = 9;
    public static final int SETTING_ENTRY_LENGTH = 6;
    public static final int PRIORITY_ENTRY_LENGTH = 5;
    public static final int INT_FIELD_LENGTH = 4;
    public static final short MAX_WEIGHT = 256;
    public static final short MIN_WEIGHT = 1;
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)24).writeBytes("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(CharsetUtil.UTF_8))));
    private static final ByteBuf EMPTY_PING = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)8).writeZero(8)));
    private static final int MAX_PADDING_LENGTH_LENGTH = 1;
    public static final int DATA_FRAME_HEADER_LENGTH = 10;
    public static final int HEADERS_FRAME_HEADER_LENGTH = 15;
    public static final int PRIORITY_FRAME_LENGTH = 14;
    public static final int RST_STREAM_FRAME_LENGTH = 13;
    public static final int PUSH_PROMISE_FRAME_HEADER_LENGTH = 14;
    public static final int GO_AWAY_FRAME_HEADER_LENGTH = 17;
    public static final int WINDOW_UPDATE_FRAME_LENGTH = 13;
    public static final int CONTINUATION_FRAME_HEADER_LENGTH = 10;
    public static final char SETTINGS_HEADER_TABLE_SIZE = '\u0001';
    public static final char SETTINGS_ENABLE_PUSH = '\u0002';
    public static final char SETTINGS_MAX_CONCURRENT_STREAMS = '\u0003';
    public static final char SETTINGS_INITIAL_WINDOW_SIZE = '\u0004';
    public static final char SETTINGS_MAX_FRAME_SIZE = '\u0005';
    public static final char SETTINGS_MAX_HEADER_LIST_SIZE = '\u0006';
    public static final int NUM_STANDARD_SETTINGS = 6;
    public static final int MAX_HEADER_TABLE_SIZE = Integer.MAX_VALUE;
    public static final long MAX_CONCURRENT_STREAMS = 0xFFFFFFFFL;
    public static final int MAX_INITIAL_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int MAX_FRAME_SIZE_LOWER_BOUND = 16384;
    public static final int MAX_FRAME_SIZE_UPPER_BOUND = 0xFFFFFF;
    public static final long MAX_HEADER_LIST_SIZE = Long.MAX_VALUE;
    public static final long MIN_HEADER_TABLE_SIZE = 0L;
    public static final long MIN_CONCURRENT_STREAMS = 0L;
    public static final int MIN_INITIAL_WINDOW_SIZE = 0;
    public static final long MIN_HEADER_LIST_SIZE = 0L;
    public static final int DEFAULT_WINDOW_SIZE = 65535;
    public static final boolean DEFAULT_ENABLE_PUSH = true;
    public static final short DEFAULT_PRIORITY_WEIGHT = 16;
    public static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int SMALLEST_MAX_CONCURRENT_STREAMS = 100;

    public static boolean isMaxFrameSizeValid(int maxFrameSize) {
        return maxFrameSize >= 16384 && maxFrameSize <= 0xFFFFFF;
    }

    public static ByteBuf connectionPrefaceBuf() {
        return CONNECTION_PREFACE.duplicate().retain();
    }

    public static ByteBuf emptyPingBuf() {
        return EMPTY_PING.duplicate().retain();
    }

    public static Http2Exception getEmbeddedHttp2Exception(Throwable cause) {
        while (cause != null) {
            if (cause instanceof Http2Exception) {
                return (Http2Exception)cause;
            }
            cause = cause.getCause();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf toByteBuf(ChannelHandlerContext ctx, Throwable cause) {
        if (cause == null || cause.getMessage() == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf debugData = ctx.alloc().buffer(cause.getMessage().length() * 3);
        boolean shouldRelease = true;
        try {
            ByteBufUtil.writeUtf8((ByteBuf)debugData, (CharSequence)cause.getMessage());
            shouldRelease = false;
        }
        finally {
            if (shouldRelease) {
                debugData.release();
            }
        }
        return debugData;
    }

    public static int readUnsignedInt(ByteBuf buf) {
        return (buf.readByte() & 0x7F) << 24 | (buf.readByte() & 0xFF) << 16 | (buf.readByte() & 0xFF) << 8 | buf.readByte() & 0xFF;
    }

    public static void writeUnsignedInt(long value, ByteBuf out) {
        out.writeByte((int)(value >> 24 & 0xFFL));
        out.writeByte((int)(value >> 16 & 0xFFL));
        out.writeByte((int)(value >> 8 & 0xFFL));
        out.writeByte((int)(value & 0xFFL));
    }

    public static void writeUnsignedShort(int value, ByteBuf out) {
        out.writeByte(value >> 8 & 0xFF);
        out.writeByte(value & 0xFF);
    }

    public static void writeFrameHeader(ByteBuf out, int payloadLength, byte type, Http2Flags flags, int streamId) {
        out.ensureWritable(9 + payloadLength);
        Http2CodecUtil.writeFrameHeaderInternal(out, payloadLength, type, flags, streamId);
    }

    public static int streamableBytes(StreamByteDistributor.StreamState state) {
        return Math.max(0, Math.min(state.pendingBytes(), state.windowSize()));
    }

    static void writeFrameHeaderInternal(ByteBuf out, int payloadLength, byte type, Http2Flags flags, int streamId) {
        out.writeMedium(payloadLength);
        out.writeByte((int)type);
        out.writeByte((int)flags.value());
        out.writeInt(streamId);
    }

    private Http2CodecUtil() {
    }

    static class SimpleChannelPromiseAggregator
    extends DefaultChannelPromise {
        private final ChannelPromise promise;
        private int expectedCount;
        private int successfulCount;
        private int failureCount;
        private boolean doneAllocating;

        SimpleChannelPromiseAggregator(ChannelPromise promise, Channel c, EventExecutor e) {
            super(c, e);
            assert (promise != null);
            this.promise = promise;
        }

        public ChannelPromise newPromise() {
            if (this.doneAllocating) {
                throw new IllegalStateException("Done allocating. No more promises can be allocated.");
            }
            ++this.expectedCount;
            return this;
        }

        public ChannelPromise doneAllocatingPromises() {
            if (!this.doneAllocating) {
                this.doneAllocating = true;
                if (this.successfulCount == this.expectedCount) {
                    this.promise.setSuccess();
                    return super.setSuccess(null);
                }
            }
            return this;
        }

        public boolean tryFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.failureCount;
                if (this.failureCount == 1) {
                    this.promise.tryFailure(cause);
                    return super.tryFailure(cause);
                }
                return true;
            }
            return false;
        }

        public ChannelPromise setFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.failureCount;
                if (this.failureCount == 1) {
                    this.promise.setFailure(cause);
                    return super.setFailure(cause);
                }
            }
            return this;
        }

        private boolean allowFailure() {
            return this.awaitingPromises() || this.expectedCount == 0;
        }

        private boolean awaitingPromises() {
            return this.successfulCount + this.failureCount < this.expectedCount;
        }

        public ChannelPromise setSuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.successfulCount;
                if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                    this.promise.setSuccess(result);
                    return super.setSuccess(result);
                }
            }
            return this;
        }

        public boolean trySuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.successfulCount;
                if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                    this.promise.trySuccess((Object)result);
                    return super.trySuccess((Object)result);
                }
                return true;
            }
            return false;
        }
    }
}

