/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.routeguide;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.examples.routeguide.Feature;
import io.grpc.examples.routeguide.Point;
import io.grpc.examples.routeguide.Rectangle;
import io.grpc.examples.routeguide.RouteGuideGrpc;
import io.grpc.examples.routeguide.RouteGuideUtil;
import io.grpc.examples.routeguide.RouteNote;
import io.grpc.examples.routeguide.RouteSummary;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RouteGuideServer {
    private static final Logger logger = Logger.getLogger(RouteGuideServer.class.getName());
    private final int port;
    private final Collection<Feature> features;
    private Server server;

    public RouteGuideServer(int port) {
        this(port, RouteGuideUtil.getDefaultFeaturesFile());
    }

    public RouteGuideServer(int port, URL featureFile) {
        try {
            this.port = port;
            this.features = RouteGuideUtil.parseFeatures(featureFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws IOException {
        this.server = ServerBuilder.forPort((int)this.port).addService(RouteGuideGrpc.bindService(new RouteGuideService(this.features))).build().start();
        logger.info("Server started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                RouteGuideServer.this.stop();
                System.err.println("*** server shut down");
            }
        });
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception {
        RouteGuideServer server = new RouteGuideServer(8980);
        server.start();
        server.blockUntilShutdown();
    }

    private static class RouteGuideService
    implements RouteGuideGrpc.RouteGuide {
        private final Collection<Feature> features;
        private final ConcurrentMap<Point, List<RouteNote>> routeNotes = new ConcurrentHashMap<Point, List<RouteNote>>();

        RouteGuideService(Collection<Feature> features) {
            this.features = features;
        }

        @Override
        public void getFeature(Point request, StreamObserver<Feature> responseObserver) {
            responseObserver.onNext((Object)this.checkFeature(request));
            responseObserver.onCompleted();
        }

        @Override
        public void listFeatures(Rectangle request, StreamObserver<Feature> responseObserver) {
            int left = Math.min(request.getLo().getLongitude(), request.getHi().getLongitude());
            int right = Math.max(request.getLo().getLongitude(), request.getHi().getLongitude());
            int top = Math.max(request.getLo().getLatitude(), request.getHi().getLatitude());
            int bottom = Math.min(request.getLo().getLatitude(), request.getHi().getLatitude());
            for (Feature feature : this.features) {
                if (!RouteGuideUtil.exists(feature)) continue;
                int lat = feature.getLocation().getLatitude();
                int lon = feature.getLocation().getLongitude();
                if (lon < left || lon > right || lat < bottom || lat > top) continue;
                responseObserver.onNext((Object)feature);
            }
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<Point> recordRoute(final StreamObserver<RouteSummary> responseObserver) {
            return new StreamObserver<Point>(){
                int pointCount;
                int featureCount;
                int distance;
                Point previous;
                long startTime = System.nanoTime();

                public void onNext(Point point) {
                    ++this.pointCount;
                    if (RouteGuideUtil.exists(RouteGuideService.this.checkFeature(point))) {
                        ++this.featureCount;
                    }
                    if (this.previous != null) {
                        this.distance = (int)((double)this.distance + RouteGuideService.calcDistance(this.previous, point));
                    }
                    this.previous = point;
                }

                public void onError(Throwable t) {
                    logger.log(Level.WARNING, "recordRoute cancelled");
                }

                public void onCompleted() {
                    long seconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTime);
                    responseObserver.onNext((Object)RouteSummary.newBuilder().setPointCount(this.pointCount).setFeatureCount(this.featureCount).setDistance(this.distance).setElapsedTime((int)seconds).build());
                    responseObserver.onCompleted();
                }
            };
        }

        @Override
        public StreamObserver<RouteNote> routeChat(final StreamObserver<RouteNote> responseObserver) {
            return new StreamObserver<RouteNote>(){

                public void onNext(RouteNote note) {
                    List notes = RouteGuideService.this.getOrCreateNotes(note.getLocation());
                    for (RouteNote prevNote : notes.toArray(new RouteNote[0])) {
                        responseObserver.onNext((Object)prevNote);
                    }
                    notes.add(note);
                }

                public void onError(Throwable t) {
                    logger.log(Level.WARNING, "routeChat cancelled");
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }

        private List<RouteNote> getOrCreateNotes(Point location) {
            List notes = Collections.synchronizedList(new ArrayList());
            List<RouteNote> prevNotes = this.routeNotes.putIfAbsent(location, notes);
            return prevNotes != null ? prevNotes : notes;
        }

        private Feature checkFeature(Point location) {
            for (Feature feature : this.features) {
                if (feature.getLocation().getLatitude() != location.getLatitude() || feature.getLocation().getLongitude() != location.getLongitude()) continue;
                return feature;
            }
            return Feature.newBuilder().setName("").setLocation(location).build();
        }

        private static double calcDistance(Point start, Point end) {
            double lat1 = RouteGuideUtil.getLatitude(start);
            double lat2 = RouteGuideUtil.getLatitude(end);
            double lon1 = RouteGuideUtil.getLongitude(start);
            double lon2 = RouteGuideUtil.getLongitude(end);
            int r = 6371000;
            double \u03c61 = Math.toRadians(lat1);
            double \u03c62 = Math.toRadians(lat2);
            double \u0394\u03c6 = Math.toRadians(lat2 - lat1);
            double \u0394\u03bb = Math.toRadians(lon2 - lon1);
            double a = Math.sin(\u0394\u03c6 / 2.0) * Math.sin(\u0394\u03c6 / 2.0) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.sin(\u0394\u03bb / 2.0) * Math.sin(\u0394\u03bb / 2.0);
            double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            return (double)r * c;
        }
    }
}

