/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.helloworld;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class GreeterGrpc {
    public static final String SERVICE_NAME = "helloworld.Greeter";
    public static final MethodDescriptor<HelloRequest, HelloReply> METHOD_SAY_HELLO = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"helloworld.Greeter", (String)"SayHello"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)HelloRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)HelloReply.getDefaultInstance()));
    private static final int METHODID_SAY_HELLO = 0;

    private GreeterGrpc() {
    }

    public static GreeterStub newStub(Channel channel) {
        return new GreeterStub(channel);
    }

    public static GreeterBlockingStub newBlockingStub(Channel channel) {
        return new GreeterBlockingStub(channel);
    }

    public static GreeterFutureStub newFutureStub(Channel channel) {
        return new GreeterFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(Greeter serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_SAY_HELLO, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 0))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final Greeter serviceImpl;
        private final int methodId;

        public MethodHandlers(Greeter serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.sayHello((HelloRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static class GreeterFutureStub
    extends AbstractStub<GreeterFutureStub>
    implements GreeterFutureClient {
        private GreeterFutureStub(Channel channel) {
            super(channel);
        }

        private GreeterFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterFutureStub build(Channel channel, CallOptions callOptions) {
            return new GreeterFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<HelloReply> sayHello(HelloRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request);
        }
    }

    public static class GreeterBlockingStub
    extends AbstractStub<GreeterBlockingStub>
    implements GreeterBlockingClient {
        private GreeterBlockingStub(Channel channel) {
            super(channel);
        }

        private GreeterBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterBlockingStub build(Channel channel, CallOptions callOptions) {
            return new GreeterBlockingStub(channel, callOptions);
        }

        @Override
        public HelloReply sayHello(HelloRequest request) {
            return (HelloReply)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_SAY_HELLO, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class GreeterStub
    extends AbstractStub<GreeterStub>
    implements Greeter {
        private GreeterStub(Channel channel) {
            super(channel);
        }

        private GreeterStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterStub build(Channel channel, CallOptions callOptions) {
            return new GreeterStub(channel, callOptions);
        }

        @Override
        public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static interface GreeterFutureClient {
        public ListenableFuture<HelloReply> sayHello(HelloRequest var1);
    }

    public static interface GreeterBlockingClient {
        public HelloReply sayHello(HelloRequest var1);
    }

    public static interface Greeter {
        public void sayHello(HelloRequest var1, StreamObserver<HelloReply> var2);
    }
}

