/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.header;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.logging.Logger;

public class HeaderServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = Logger.getLogger(HeaderServerInterceptor.class.getName());
    private static Metadata.Key<String> customHeadKey = Metadata.Key.of((String)"custom_server_header_key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(MethodDescriptor<ReqT, RespT> method, ServerCall<RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        logger.info("header received from client:" + requestHeaders);
        return next.startCall(method, (ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<RespT>(call){

            public void sendHeaders(Metadata responseHeaders) {
                responseHeaders.put(customHeadKey, (Object)"customRespondValue");
                super.sendHeaders(responseHeaders);
            }
        }, requestHeaders);
    }
}

