/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.header;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.examples.header.HeaderClientInterceptor;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomHeaderClient {
    private static final Logger logger = Logger.getLogger(CustomHeaderClient.class.getName());
    private final ManagedChannel originChannel;
    private final GreeterGrpc.GreeterBlockingStub blockingStub;

    private CustomHeaderClient(String host, int port) {
        this.originChannel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true).build();
        HeaderClientInterceptor interceptor = new HeaderClientInterceptor();
        Channel channel = ClientInterceptors.intercept((Channel)this.originChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
        this.blockingStub = GreeterGrpc.newBlockingStub(channel);
    }

    private void shutdown() throws InterruptedException {
        this.originChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    private void greet(String name) {
        HelloReply response;
        logger.info("Will try to greet " + name + " ...");
        HelloRequest request = HelloRequest.newBuilder().setName(name).build();
        try {
            response = this.blockingStub.sayHello(request);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
        logger.info("Greeting: " + response.getMessage());
    }

    public static void main(String[] args) throws Exception {
        CustomHeaderClient client = new CustomHeaderClient("localhost", 50051);
        try {
            String user = "world";
            if (args.length > 0) {
                user = args[0];
            }
            client.greet(user);
        }
        finally {
            client.shutdown();
        }
    }
}

