/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.experimental;

import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.internal.GrpcUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CompressingHelloWorldClient {
    private static final Logger logger = Logger.getLogger(CompressingHelloWorldClient.class.getName());
    private final ManagedChannel channel;

    public CompressingHelloWorldClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true).build();
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void greet(String name) {
        ClientCall call = this.channel.newCall(GreeterGrpc.METHOD_SAY_HELLO, CallOptions.DEFAULT);
        final CountDownLatch latch = new CountDownLatch(1);
        call.start((ClientCall.Listener)new ClientCall.Listener<HelloReply>(){

            public void onHeaders(Metadata headers) {
                super.onHeaders(headers);
                String encoding = (String)headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
                if (encoding == null) {
                    throw new RuntimeException("No compression selected!");
                }
            }

            public void onMessage(HelloReply message) {
                super.onMessage((Object)message);
                logger.info("Greeting: " + message.getMessage());
                latch.countDown();
            }

            public void onClose(Status status, Metadata trailers) {
                latch.countDown();
                if (!status.isOk()) {
                    throw status.asRuntimeException();
                }
            }
        }, new Metadata());
        call.setMessageCompression(true);
        call.sendMessage((Object)HelloRequest.newBuilder().setName(name).build());
        call.request(1);
        call.halfClose();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)100L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static void main(String[] args) throws Exception {
        CompressingHelloWorldClient client = new CompressingHelloWorldClient("localhost", 50051);
        try {
            String user = "world";
            if (args.length > 0) {
                user = args[0];
            }
            client.greet(user);
        }
        finally {
            client.shutdown();
        }
    }
}

