/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http2.Http2Headers;

class SendResponseHeadersCommand {
    private final int streamId;
    private final Http2Headers headers;
    private final boolean endOfStream;

    SendResponseHeadersCommand(int streamId, Http2Headers headers, boolean endOfStream) {
        this.streamId = streamId;
        this.headers = (Http2Headers)Preconditions.checkNotNull((Object)headers);
        this.endOfStream = endOfStream;
    }

    int streamId() {
        return this.streamId;
    }

    Http2Headers headers() {
        return this.headers;
    }

    boolean endOfStream() {
        return this.endOfStream;
    }

    public boolean equals(Object that) {
        if (that == null || !that.getClass().equals(SendResponseHeadersCommand.class)) {
            return false;
        }
        SendResponseHeadersCommand thatCmd = (SendResponseHeadersCommand)that;
        return thatCmd.streamId == this.streamId && thatCmd.headers.equals(this.headers) && thatCmd.endOfStream == this.endOfStream;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(streamId=" + this.streamId + ", headers=" + this.headers + ", endOfStream=" + this.endOfStream + ")";
    }

    public int hashCode() {
        return this.streamId;
    }
}

