/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.routeguide;

import io.grpc.examples.routeguide.Feature;
import io.grpc.examples.routeguide.Point;
import io.grpc.examples.routeguide.RouteGuideServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class RouteGuideUtil {
    private static final double COORD_FACTOR = 1.0E7;

    public static double getLatitude(Point location) {
        return (double)location.getLatitude() / 1.0E7;
    }

    public static double getLongitude(Point location) {
        return (double)location.getLongitude() / 1.0E7;
    }

    public static URL getDefaultFeaturesFile() {
        return RouteGuideServer.class.getResource("route_guide_db.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Feature> parseFeatures(URL file) throws IOException {
        InputStream input = file.openStream();
        try {
            JsonReader reader = Json.createReader((InputStream)input);
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (JsonValue value : reader.readArray()) {
                JsonObject obj = (JsonObject)value;
                String name = obj.getString("name", "");
                JsonObject location = obj.getJsonObject("location");
                int lat = location.getInt("latitude");
                int lon = location.getInt("longitude");
                Feature feature = Feature.newBuilder().setName(name).setLocation(Point.newBuilder().setLatitude(lat).setLongitude(lon).build()).build();
                features.add(feature);
            }
            ArrayList<Feature> arrayList = features;
            return arrayList;
        }
        finally {
            input.close();
        }
    }

    public static boolean exists(Feature feature) {
        return feature != null && !feature.getName().isEmpty();
    }
}

