/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.routeguide;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.examples.routeguide.Feature;
import io.grpc.examples.routeguide.Point;
import io.grpc.examples.routeguide.Rectangle;
import io.grpc.examples.routeguide.RouteNote;
import io.grpc.examples.routeguide.RouteSummary;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

public class RouteGuideGrpc {
    public static final String SERVICE_NAME = "routeguide.RouteGuide";
    public static final MethodDescriptor<Point, Feature> METHOD_GET_FEATURE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"routeguide.RouteGuide", (String)"GetFeature"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Point.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Feature.getDefaultInstance()));
    public static final MethodDescriptor<Rectangle, Feature> METHOD_LIST_FEATURES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.SERVER_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"routeguide.RouteGuide", (String)"ListFeatures"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Rectangle.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Feature.getDefaultInstance()));
    public static final MethodDescriptor<Point, RouteSummary> METHOD_RECORD_ROUTE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.CLIENT_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"routeguide.RouteGuide", (String)"RecordRoute"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Point.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)RouteSummary.getDefaultInstance()));
    public static final MethodDescriptor<RouteNote, RouteNote> METHOD_ROUTE_CHAT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"routeguide.RouteGuide", (String)"RouteChat"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)RouteNote.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)RouteNote.getDefaultInstance()));
    private static final int METHODID_GET_FEATURE = 0;
    private static final int METHODID_LIST_FEATURES = 1;
    private static final int METHODID_RECORD_ROUTE = 2;
    private static final int METHODID_ROUTE_CHAT = 3;

    private RouteGuideGrpc() {
    }

    public static RouteGuideStub newStub(Channel channel) {
        return new RouteGuideStub(channel);
    }

    public static RouteGuideBlockingStub newBlockingStub(Channel channel) {
        return new RouteGuideBlockingStub(channel);
    }

    public static RouteGuideFutureStub newFutureStub(Channel channel) {
        return new RouteGuideFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(RouteGuide serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_GET_FEATURE, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 0))).addMethod(METHOD_LIST_FEATURES, ServerCalls.asyncServerStreamingCall(new MethodHandlers(serviceImpl, 1))).addMethod(METHOD_RECORD_ROUTE, ServerCalls.asyncClientStreamingCall(new MethodHandlers(serviceImpl, 2))).addMethod(METHOD_ROUTE_CHAT, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 3))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final RouteGuide serviceImpl;
        private final int methodId;

        public MethodHandlers(RouteGuide serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.getFeature((Point)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.listFeatures((Rectangle)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return this.serviceImpl.recordRoute(responseObserver);
                }
                case 3: {
                    return this.serviceImpl.routeChat(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static class RouteGuideFutureStub
    extends AbstractStub<RouteGuideFutureStub>
    implements RouteGuideFutureClient {
        private RouteGuideFutureStub(Channel channel) {
            super(channel);
        }

        private RouteGuideFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected RouteGuideFutureStub build(Channel channel, CallOptions callOptions) {
            return new RouteGuideFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<Feature> getFeature(Point request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_FEATURE, this.getCallOptions()), (Object)request);
        }
    }

    public static class RouteGuideBlockingStub
    extends AbstractStub<RouteGuideBlockingStub>
    implements RouteGuideBlockingClient {
        private RouteGuideBlockingStub(Channel channel) {
            super(channel);
        }

        private RouteGuideBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected RouteGuideBlockingStub build(Channel channel, CallOptions callOptions) {
            return new RouteGuideBlockingStub(channel, callOptions);
        }

        @Override
        public Feature getFeature(Point request) {
            return (Feature)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_GET_FEATURE, (CallOptions)this.getCallOptions(), (Object)request);
        }

        @Override
        public Iterator<Feature> listFeatures(Rectangle request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_LIST_FEATURES, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class RouteGuideStub
    extends AbstractStub<RouteGuideStub>
    implements RouteGuide {
        private RouteGuideStub(Channel channel) {
            super(channel);
        }

        private RouteGuideStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected RouteGuideStub build(Channel channel, CallOptions callOptions) {
            return new RouteGuideStub(channel, callOptions);
        }

        @Override
        public void getFeature(Point request, StreamObserver<Feature> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_FEATURE, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void listFeatures(Rectangle request, StreamObserver<Feature> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_LIST_FEATURES, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public StreamObserver<Point> recordRoute(StreamObserver<RouteSummary> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(METHOD_RECORD_ROUTE, this.getCallOptions()), responseObserver);
        }

        @Override
        public StreamObserver<RouteNote> routeChat(StreamObserver<RouteNote> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_ROUTE_CHAT, this.getCallOptions()), responseObserver);
        }
    }

    public static interface RouteGuideFutureClient {
        public ListenableFuture<Feature> getFeature(Point var1);
    }

    public static interface RouteGuideBlockingClient {
        public Feature getFeature(Point var1);

        public Iterator<Feature> listFeatures(Rectangle var1);
    }

    public static interface RouteGuide {
        public void getFeature(Point var1, StreamObserver<Feature> var2);

        public void listFeatures(Rectangle var1, StreamObserver<Feature> var2);

        public StreamObserver<Point> recordRoute(StreamObserver<RouteSummary> var1);

        public StreamObserver<RouteNote> routeChat(StreamObserver<RouteNote> var1);
    }
}

