package live.xu.simplehttp.spring;

import live.xu.simplehttp.core.SimpleHttpContext;
import org.springframework.beans.factory.FactoryBean;

/**
 * SimpleHttp创建代理对象的工厂Bean
 * Create by xsg at 2023/08/04 11:32.
 */
public class SimpleHttpFactoryBean<T> implements FactoryBean<T> {

    private SimpleHttpContext simpleHttpContext;
    private final Class<T> simpleHttpInterface;

    public SimpleHttpFactoryBean(Class<T> simpleHttpInterface) {
        this.simpleHttpInterface = simpleHttpInterface;
    }

    public void setSimpleHttpContext(SimpleHttpContext simpleHttpContext) {
        this.simpleHttpContext = simpleHttpContext;
    }

    @Override
    public T getObject() throws Exception {
        return this.simpleHttpContext.get(this.simpleHttpInterface);
    }

    @Override
    public Class<?> getObjectType() {
        return this.simpleHttpInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

}
