package live.xu.simplehttp.spring;

import live.xu.simplehttp.core.annotation.SimpleHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.util.CollectionUtils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * SimpleHttpClient类注入器
 * Create by xsg at 2023/08/04 11:14.
 */
public class SimpleHttpClientClassPostProcessor implements BeanDefinitionRegistryPostProcessor, BeanClassLoaderAware {

    private static final List<Class<? extends Annotation>> serviceAnnotationTypes = Collections.singletonList(SimpleHttpClient.class);

    protected final Set<String> packagesToScan;
    private ClassLoader classLoader;

    public SimpleHttpClientClassPostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }


    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (!CollectionUtils.isEmpty(packagesToScan)) {
            this.registerSimpleHttpClientBeans(packagesToScan, beanDefinitionRegistry);
        }
    }

    //扫描类，注册beanDefinition
    private void registerSimpleHttpClientBeans(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        SimpleHttpClassPathBeanDefinitionScanner scanner = new SimpleHttpClassPathBeanDefinitionScanner(registry);

        serviceAnnotationTypes.forEach(annotationType -> {
            scanner.addIncludeFilter(new AnnotationTypeFilter(annotationType));
        });

        for (String packageToScan : packagesToScan) {
            scanner.scan(packageToScan);

            Set<BeanDefinition> beanDefinitions = scanner.findCandidateComponents(packageToScan);

            if (!CollectionUtils.isEmpty(beanDefinitions)) {
                for (BeanDefinition beanDefinition : beanDefinitions) {
                    GenericBeanDefinition genericBeanDefinition = (GenericBeanDefinition) beanDefinition;
                    genericBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(beanDefinition.getBeanClassName());
                    genericBeanDefinition.setBeanClass(SimpleHttpFactoryBean.class);
                    genericBeanDefinition.setAutowireMode(AbstractBeanDefinition.AUTOWIRE_BY_TYPE);
                }
            }
        }
    }


    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {

    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}
