/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.TaskStatusService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;

public class TaskStatus {
    public static TaskStatusGetRequest get(@NotNull String taskId) {
        return new TaskStatusGetRequest(taskId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskStatus)) {
            return false;
        }
        TaskStatus other = (TaskStatus)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskStatus;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TaskStatus()";
    }

    public static class TaskStatusGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String id;
        @JsonProperty(value="status")
        @NotNull
        private String status;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty
        @NotNull
        private Map<String, Object> result;

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String getStatus() {
            return this.status;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @NotNull
        public Map<String, Object> getResult() {
            return this.result;
        }

        @JsonProperty(value="task_id")
        public void setId(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @JsonProperty(value="status")
        public void setStatus(@NotNull String status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setResult(@NotNull Map<String, Object> result) {
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.result = result;
        }

        @Override
        public String toString() {
            return "TaskStatus.TaskStatusGetResponse(id=" + this.getId() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", result=" + this.getResult() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskStatusGetResponse)) {
                return false;
            }
            TaskStatusGetResponse other = (TaskStatusGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Map<String, Object> this$result = this.getResult();
            Map<String, Object> other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskStatusGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Map<String, Object> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }
    }

    public static class TaskStatusGetRequest
    extends StreamRequest<TaskStatusGetResponse> {
        @NotNull
        private String id;

        @Override
        protected Call<TaskStatusGetResponse> generateCall(Client client) throws StreamException {
            return client.create(TaskStatusService.class).get(this.id);
        }

        public TaskStatusGetRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }
}

