/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.ChannelType;
import io.getstream.chat.java.models.DeleteStrategy;
import io.getstream.chat.java.models.Event;
import io.getstream.chat.java.models.Language;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.MessagePaginationParameters;
import io.getstream.chat.java.models.PaginationParameters;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ChannelService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Channel {
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="type")
    @NotNull
    private String type;
    @JsonProperty(value="cid")
    @NotNull
    private String cId;
    @JsonProperty(value="team")
    @NotNull
    private String team;
    @JsonProperty(value="config")
    @NotNull
    private ChannelType.ChannelTypeWithCommands config;
    @JsonProperty(value="created_by")
    @Nullable
    private User createdBy;
    @JsonProperty(value="frozen")
    @NotNull
    private Boolean frozen;
    @JsonProperty(value="member_count")
    @NotNull
    private Integer memberCount;
    @JsonProperty(value="members")
    @Nullable
    private List<ChannelMember> members;
    @JsonProperty(value="messages")
    @Nullable
    private List<Message> messages;
    @JsonProperty(value="read")
    @Nullable
    private List<ChannelRead> read;
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @NotNull
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    @Nullable
    private Date deletedAt;
    @JsonProperty(value="last_message_at")
    @Nullable
    private Date lastMessageAt;
    @JsonProperty(value="truncated_by_id")
    @Nullable
    private String truncatedById;
    @JsonProperty(value="truncated_by")
    @Nullable
    private User truncatedBy;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static ChannelGetRequestData.ChannelGetRequest getOrCreate(@NotNull String type, @NotNull String id) {
        return new ChannelGetRequestData.ChannelGetRequest(type, id);
    }

    @NotNull
    public static ChannelGetRequestData.ChannelGetRequest getOrCreate(@NotNull String type) {
        return new ChannelGetRequestData.ChannelGetRequest(type, null);
    }

    @NotNull
    public static ChannelUpdateRequestData.ChannelUpdateRequest update(@NotNull String type, @NotNull String id) {
        return new ChannelUpdateRequestData.ChannelUpdateRequest(type, id);
    }

    @NotNull
    public static ChannelDeleteRequest delete(@NotNull String type, @NotNull String id) {
        return new ChannelDeleteRequest(type, id);
    }

    @NotNull
    public static ChannelDeleteManyRequest deleteMany(@NotNull List<String> cids) {
        return new ChannelDeleteManyRequest(cids);
    }

    @NotNull
    public static ChannelListRequestData.ChannelListRequest list() {
        return new ChannelListRequestData.ChannelListRequest();
    }

    @NotNull
    public static ChannelTruncateRequestData.ChannelTruncateRequest truncate(@NotNull String type, @NotNull String id) {
        return new ChannelTruncateRequestData.ChannelTruncateRequest(type, id);
    }

    @NotNull
    public static ChannelQueryMembersRequestData.ChannelQueryMembersRequest queryMembers() {
        return new ChannelQueryMembersRequestData.ChannelQueryMembersRequest();
    }

    @NotNull
    public static ChannelExportRequestData.ChannelExportRequest export() {
        return new ChannelExportRequestData.ChannelExportRequest();
    }

    @NotNull
    public static ChannelExportStatusRequest exportStatus(String taskId) {
        return new ChannelExportStatusRequest(taskId);
    }

    @NotNull
    public static ChannelHideRequestData.ChannelHideRequest hide(@NotNull String type, @NotNull String id) {
        return new ChannelHideRequestData.ChannelHideRequest(type, id);
    }

    @NotNull
    public static ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest markAllRead() {
        return new ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest();
    }

    @NotNull
    public static ChannelMarkReadRequestData.ChannelMarkReadRequest markRead(@NotNull String type, @NotNull String id) {
        return new ChannelMarkReadRequestData.ChannelMarkReadRequest(type, id);
    }

    @NotNull
    public static ChannelMuteRequestData.ChannelMuteRequest mute() {
        return new ChannelMuteRequestData.ChannelMuteRequest();
    }

    @NotNull
    public static ChannelShowRequestData.ChannelShowRequest show(@NotNull String type, @NotNull String id) {
        return new ChannelShowRequestData.ChannelShowRequest(type, id);
    }

    @NotNull
    public static ChannelUnMuteRequestData.ChannelUnMuteRequest unmute() {
        return new ChannelUnMuteRequestData.ChannelUnMuteRequest();
    }

    @NotNull
    public static ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest partialUpdate(@NotNull String type, @NotNull String id) {
        return new ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest(type, id);
    }

    @NotNull
    public static AssignRoleRequestData.AssignRoleRequest assignRoles(@NotNull String type, @NotNull String id) {
        return new AssignRoleRequestData.AssignRoleRequest(type, id);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public String getCId() {
        return this.cId;
    }

    @NotNull
    public String getTeam() {
        return this.team;
    }

    @NotNull
    public ChannelType.ChannelTypeWithCommands getConfig() {
        return this.config;
    }

    @Nullable
    public User getCreatedBy() {
        return this.createdBy;
    }

    @NotNull
    public Boolean getFrozen() {
        return this.frozen;
    }

    @NotNull
    public Integer getMemberCount() {
        return this.memberCount;
    }

    @Nullable
    public List<ChannelMember> getMembers() {
        return this.members;
    }

    @Nullable
    public List<Message> getMessages() {
        return this.messages;
    }

    @Nullable
    public List<ChannelRead> getRead() {
        return this.read;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    public Date getLastMessageAt() {
        return this.lastMessageAt;
    }

    @Nullable
    public String getTruncatedById() {
        return this.truncatedById;
    }

    @Nullable
    public User getTruncatedBy() {
        return this.truncatedBy;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="type")
    public void setType(@NotNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="cid")
    public void setCId(@NotNull String cId) {
        if (cId == null) {
            throw new NullPointerException("cId is marked non-null but is null");
        }
        this.cId = cId;
    }

    @JsonProperty(value="team")
    public void setTeam(@NotNull String team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.team = team;
    }

    @JsonProperty(value="config")
    public void setConfig(@NotNull ChannelType.ChannelTypeWithCommands config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @JsonProperty(value="created_by")
    public void setCreatedBy(@Nullable User createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="frozen")
    public void setFrozen(@NotNull Boolean frozen) {
        if (frozen == null) {
            throw new NullPointerException("frozen is marked non-null but is null");
        }
        this.frozen = frozen;
    }

    @JsonProperty(value="member_count")
    public void setMemberCount(@NotNull Integer memberCount) {
        if (memberCount == null) {
            throw new NullPointerException("memberCount is marked non-null but is null");
        }
        this.memberCount = memberCount;
    }

    @JsonProperty(value="members")
    public void setMembers(@Nullable List<ChannelMember> members) {
        this.members = members;
    }

    @JsonProperty(value="messages")
    public void setMessages(@Nullable List<Message> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="read")
    public void setRead(@Nullable List<ChannelRead> read) {
        this.read = read;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@NotNull Date updatedAt) {
        if (updatedAt == null) {
            throw new NullPointerException("updatedAt is marked non-null but is null");
        }
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="deleted_at")
    public void setDeletedAt(@Nullable Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @JsonProperty(value="last_message_at")
    public void setLastMessageAt(@Nullable Date lastMessageAt) {
        this.lastMessageAt = lastMessageAt;
    }

    @JsonProperty(value="truncated_by_id")
    public void setTruncatedById(@Nullable String truncatedById) {
        this.truncatedById = truncatedById;
    }

    @JsonProperty(value="truncated_by")
    public void setTruncatedBy(@Nullable User truncatedBy) {
        this.truncatedBy = truncatedBy;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$frozen = this.getFrozen();
        Boolean other$frozen = other.getFrozen();
        if (this$frozen == null ? other$frozen != null : !((Object)this$frozen).equals(other$frozen)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cId = this.getCId();
        String other$cId = other.getCId();
        if (this$cId == null ? other$cId != null : !this$cId.equals(other$cId)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        if (this$team == null ? other$team != null : !this$team.equals(other$team)) {
            return false;
        }
        ChannelType.ChannelTypeWithCommands this$config = this.getConfig();
        ChannelType.ChannelTypeWithCommands other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        User this$createdBy = this.getCreatedBy();
        User other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        List<ChannelMember> this$members = this.getMembers();
        List<ChannelMember> other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<ChannelRead> this$read = this.getRead();
        List<ChannelRead> other$read = other.getRead();
        if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$deletedAt = this.getDeletedAt();
        Date other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Date this$lastMessageAt = this.getLastMessageAt();
        Date other$lastMessageAt = other.getLastMessageAt();
        if (this$lastMessageAt == null ? other$lastMessageAt != null : !((Object)this$lastMessageAt).equals(other$lastMessageAt)) {
            return false;
        }
        String this$truncatedById = this.getTruncatedById();
        String other$truncatedById = other.getTruncatedById();
        if (this$truncatedById == null ? other$truncatedById != null : !this$truncatedById.equals(other$truncatedById)) {
            return false;
        }
        User this$truncatedBy = this.getTruncatedBy();
        User other$truncatedBy = other.getTruncatedBy();
        if (this$truncatedBy == null ? other$truncatedBy != null : !((Object)this$truncatedBy).equals(other$truncatedBy)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $frozen = this.getFrozen();
        result = result * 59 + ($frozen == null ? 43 : ((Object)$frozen).hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cId = this.getCId();
        result = result * 59 + ($cId == null ? 43 : $cId.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        ChannelType.ChannelTypeWithCommands $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        User $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        List<ChannelMember> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<ChannelRead> $read = this.getRead();
        result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Date $lastMessageAt = this.getLastMessageAt();
        result = result * 59 + ($lastMessageAt == null ? 43 : ((Object)$lastMessageAt).hashCode());
        String $truncatedById = this.getTruncatedById();
        result = result * 59 + ($truncatedById == null ? 43 : $truncatedById.hashCode());
        User $truncatedBy = this.getTruncatedBy();
        result = result * 59 + ($truncatedBy == null ? 43 : ((Object)$truncatedBy).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Channel(id=" + this.getId() + ", type=" + this.getType() + ", cId=" + this.getCId() + ", team=" + this.getTeam() + ", config=" + this.getConfig() + ", createdBy=" + this.getCreatedBy() + ", frozen=" + this.getFrozen() + ", memberCount=" + this.getMemberCount() + ", members=" + this.getMembers() + ", messages=" + this.getMessages() + ", read=" + this.getRead() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", deletedAt=" + this.getDeletedAt() + ", lastMessageAt=" + this.getLastMessageAt() + ", truncatedById=" + this.getTruncatedById() + ", truncatedBy=" + this.getTruncatedBy() + ", additionalFields=" + this.getAdditionalFields() + ")";
    }

    public static class ChannelPartialUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @NotNull
        private Channel channel;
        @JsonProperty(value="members")
        @NotNull
        private List<ChannelMember> members;

        @NotNull
        public Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="channel")
        public void setChannel(@NotNull Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
        }

        @JsonProperty(value="members")
        public void setMembers(@NotNull List<ChannelMember> members) {
            if (members == null) {
                throw new NullPointerException("members is marked non-null but is null");
            }
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelPartialUpdateResponse(channel=" + this.getChannel() + ", members=" + this.getMembers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelPartialUpdateResponse)) {
                return false;
            }
            ChannelPartialUpdateResponse other = (ChannelPartialUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelPartialUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelUnMuteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_mute")
        @Nullable
        private User.ChannelMute channelMute;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<User.ChannelMute> channelMutes;
        @JsonProperty(value="own_user")
        @Nullable
        private User.OwnUser ownUser;

        @Nullable
        public User.ChannelMute getChannelMute() {
            return this.channelMute;
        }

        @Nullable
        public List<User.ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public User.OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="channel_mute")
        public void setChannelMute(@Nullable User.ChannelMute channelMute) {
            this.channelMute = channelMute;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<User.ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@Nullable User.OwnUser ownUser) {
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "Channel.ChannelUnMuteResponse(channelMute=" + this.getChannelMute() + ", channelMutes=" + this.getChannelMutes() + ", ownUser=" + this.getOwnUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelUnMuteResponse)) {
                return false;
            }
            ChannelUnMuteResponse other = (ChannelUnMuteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User.ChannelMute this$channelMute = this.getChannelMute();
            User.ChannelMute other$channelMute = other.getChannelMute();
            if (this$channelMute == null ? other$channelMute != null : !((Object)this$channelMute).equals(other$channelMute)) {
                return false;
            }
            List<User.ChannelMute> this$channelMutes = this.getChannelMutes();
            List<User.ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            User.OwnUser this$ownUser = this.getOwnUser();
            User.OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelUnMuteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User.ChannelMute $channelMute = this.getChannelMute();
            result = result * 59 + ($channelMute == null ? 43 : ((Object)$channelMute).hashCode());
            List<User.ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            User.OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class ChannelMuteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_mute")
        @Nullable
        private User.ChannelMute channelMute;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<User.ChannelMute> channelMutes;
        @JsonProperty(value="own_user")
        @Nullable
        private User.OwnUser ownUser;

        @Nullable
        public User.ChannelMute getChannelMute() {
            return this.channelMute;
        }

        @Nullable
        public List<User.ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public User.OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="channel_mute")
        public void setChannelMute(@Nullable User.ChannelMute channelMute) {
            this.channelMute = channelMute;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<User.ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@Nullable User.OwnUser ownUser) {
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "Channel.ChannelMuteResponse(channelMute=" + this.getChannelMute() + ", channelMutes=" + this.getChannelMutes() + ", ownUser=" + this.getOwnUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMuteResponse)) {
                return false;
            }
            ChannelMuteResponse other = (ChannelMuteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User.ChannelMute this$channelMute = this.getChannelMute();
            User.ChannelMute other$channelMute = other.getChannelMute();
            if (this$channelMute == null ? other$channelMute != null : !((Object)this$channelMute).equals(other$channelMute)) {
                return false;
            }
            List<User.ChannelMute> this$channelMutes = this.getChannelMutes();
            List<User.ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            User.OwnUser this$ownUser = this.getOwnUser();
            User.OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelMuteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User.ChannelMute $channelMute = this.getChannelMute();
            result = result * 59 + ($channelMute == null ? 43 : ((Object)$channelMute).hashCode());
            List<User.ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            User.OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class ChannelMarkReadResponse
    extends StreamResponseObject {
        @JsonProperty(value="event")
        @Nullable
        private Event event;

        @Nullable
        public Event getEvent() {
            return this.event;
        }

        @JsonProperty(value="event")
        public void setEvent(@Nullable Event event) {
            this.event = event;
        }

        @Override
        public String toString() {
            return "Channel.ChannelMarkReadResponse(event=" + this.getEvent() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMarkReadResponse)) {
                return false;
            }
            ChannelMarkReadResponse other = (ChannelMarkReadResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelMarkReadResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            return result;
        }
    }

    public static class ChannelExportStatusResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String taskId;
        @JsonProperty(value="status")
        @NotNull
        private Status status;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;
        @JsonProperty(value="result")
        @Nullable
        private ExportChannelsResult result;
        @JsonProperty(value="error")
        @Nullable
        private ErrorResult error;

        @NotNull
        public String getTaskId() {
            return this.taskId;
        }

        @NotNull
        public Status getStatus() {
            return this.status;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @Nullable
        public ExportChannelsResult getResult() {
            return this.result;
        }

        @Nullable
        public ErrorResult getError() {
            return this.error;
        }

        @JsonProperty(value="task_id")
        public void setTaskId(@NotNull String taskId) {
            if (taskId == null) {
                throw new NullPointerException("taskId is marked non-null but is null");
            }
            this.taskId = taskId;
        }

        @JsonProperty(value="status")
        public void setStatus(@NotNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @JsonProperty(value="result")
        public void setResult(@Nullable ExportChannelsResult result) {
            this.result = result;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable ErrorResult error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "Channel.ChannelExportStatusResponse(taskId=" + this.getTaskId() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", duration=" + this.getDuration() + ", result=" + this.getResult() + ", error=" + this.getError() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportStatusResponse)) {
                return false;
            }
            ChannelExportStatusResponse other = (ChannelExportStatusResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            ExportChannelsResult this$result = this.getResult();
            ExportChannelsResult other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            ErrorResult this$error = this.getError();
            ErrorResult other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportStatusResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            ExportChannelsResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            ErrorResult $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        public static class ErrorResult {
            @JsonProperty(value="type")
            @Nullable
            private String type;
            @JsonProperty(value="description")
            @Nullable
            private String description;
            @JsonProperty(value="stacktrace")
            @Nullable
            private String stacktrace;
            @JsonProperty(value="version")
            @Nullable
            private String version;

            @Nullable
            public String getType() {
                return this.type;
            }

            @Nullable
            public String getDescription() {
                return this.description;
            }

            @Nullable
            public String getStacktrace() {
                return this.stacktrace;
            }

            @Nullable
            public String getVersion() {
                return this.version;
            }

            @JsonProperty(value="type")
            public void setType(@Nullable String type) {
                this.type = type;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(value="stacktrace")
            public void setStacktrace(@Nullable String stacktrace) {
                this.stacktrace = stacktrace;
            }

            @JsonProperty(value="version")
            public void setVersion(@Nullable String version) {
                this.version = version;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ErrorResult)) {
                    return false;
                }
                ErrorResult other = (ErrorResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$stacktrace = this.getStacktrace();
                String other$stacktrace = other.getStacktrace();
                if (this$stacktrace == null ? other$stacktrace != null : !this$stacktrace.equals(other$stacktrace)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ErrorResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $stacktrace = this.getStacktrace();
                result = result * 59 + ($stacktrace == null ? 43 : $stacktrace.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            public String toString() {
                return "Channel.ChannelExportStatusResponse.ErrorResult(type=" + this.getType() + ", description=" + this.getDescription() + ", stacktrace=" + this.getStacktrace() + ", version=" + this.getVersion() + ")";
            }
        }

        public static class ExportChannelsResult {
            @JsonProperty(value="url")
            @NotNull
            private String url;
            @JsonProperty(value="path")
            @NotNull
            private String path;
            @JsonProperty(value="s3_bucket_name")
            @NotNull
            private String s3BucketName;

            @NotNull
            public String getUrl() {
                return this.url;
            }

            @NotNull
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getS3BucketName() {
                return this.s3BucketName;
            }

            @JsonProperty(value="url")
            public void setUrl(@NotNull String url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                this.url = url;
            }

            @JsonProperty(value="path")
            public void setPath(@NotNull String path) {
                if (path == null) {
                    throw new NullPointerException("path is marked non-null but is null");
                }
                this.path = path;
            }

            @JsonProperty(value="s3_bucket_name")
            public void setS3BucketName(@NotNull String s3BucketName) {
                if (s3BucketName == null) {
                    throw new NullPointerException("s3BucketName is marked non-null but is null");
                }
                this.s3BucketName = s3BucketName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExportChannelsResult)) {
                    return false;
                }
                ExportChannelsResult other = (ExportChannelsResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                    return false;
                }
                String this$s3BucketName = this.getS3BucketName();
                String other$s3BucketName = other.getS3BucketName();
                return !(this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ExportChannelsResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                String $s3BucketName = this.getS3BucketName();
                result = result * 59 + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
                return result;
            }

            public String toString() {
                return "Channel.ChannelExportStatusResponse.ExportChannelsResult(url=" + this.getUrl() + ", path=" + this.getPath() + ", s3BucketName=" + this.getS3BucketName() + ")";
            }
        }

        public static enum Status {
            WAITING,
            PENDING,
            RUNNING,
            COMPLETED,
            FAILED,
            UNKNOWN;

        }
    }

    public static class ChannelExportResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String taskId;

        @NotNull
        public String getTaskId() {
            return this.taskId;
        }

        @JsonProperty(value="task_id")
        public void setTaskId(@NotNull String taskId) {
            if (taskId == null) {
                throw new NullPointerException("taskId is marked non-null but is null");
            }
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "Channel.ChannelExportResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportResponse)) {
                return false;
            }
            ChannelExportResponse other = (ChannelExportResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }
    }

    public static class ChannelQueryMembersResponse
    extends StreamResponseObject {
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelQueryMembersResponse(members=" + this.getMembers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelQueryMembersResponse)) {
                return false;
            }
            ChannelQueryMembersResponse other = (ChannelQueryMembersResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelQueryMembersResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelTruncateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Channel.ChannelTruncateResponse(channel=" + this.getChannel() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTruncateResponse)) {
                return false;
            }
            ChannelTruncateResponse other = (ChannelTruncateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTruncateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class ChannelListResponse
    extends StreamResponseObject {
        @JsonProperty(value="channels")
        @Nullable
        private List<ChannelGetResponse> channels;

        @Nullable
        public List<ChannelGetResponse> getChannels() {
            return this.channels;
        }

        @JsonProperty(value="channels")
        public void setChannels(@Nullable List<ChannelGetResponse> channels) {
            this.channels = channels;
        }

        @Override
        public String toString() {
            return "Channel.ChannelListResponse(channels=" + this.getChannels() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelListResponse)) {
                return false;
            }
            ChannelListResponse other = (ChannelListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<ChannelGetResponse> this$channels = this.getChannels();
            List<ChannelGetResponse> other$channels = other.getChannels();
            return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<ChannelGetResponse> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            return result;
        }
    }

    public static class ChannelDeleteManyResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        private String taskId;

        @JsonProperty(value="task_id")
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "Channel.ChannelDeleteManyResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteManyResponse)) {
                return false;
            }
            ChannelDeleteManyResponse other = (ChannelDeleteManyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteManyResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }

        public String getTaskId() {
            return this.taskId;
        }
    }

    public static class ChannelDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Channel.ChannelDeleteResponse(channel=" + this.getChannel() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteResponse)) {
                return false;
            }
            ChannelDeleteResponse other = (ChannelDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class ChannelUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="message")
        @Nullable
        private Message message;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public Message getMessage() {
            return this.message;
        }

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable Message message) {
            this.message = message;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelUpdateResponse(channel=" + this.getChannel() + ", message=" + this.getMessage() + ", members=" + this.getMembers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelUpdateResponse)) {
                return false;
            }
            ChannelUpdateResponse other = (ChannelUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="messages")
        @Nullable
        private List<Message> messages;
        @JsonProperty(value="pinned_messages")
        @Nullable
        private List<Message> pinnedMessages;
        @JsonProperty(value="pending_messages")
        @Nullable
        private List<Message> pendingMessages;
        @JsonProperty(value="watcher_count")
        @Nullable
        private Integer watcher_count;
        @JsonProperty(value="watchers")
        @Nullable
        private List<User> watchers;
        @JsonProperty(value="read")
        @Nullable
        private List<ChannelRead> read;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;
        @JsonProperty(value="membership")
        @Nullable
        private ChannelMember membership;
        @JsonProperty(value="hidden")
        @Nullable
        private Boolean hidden;
        @JsonProperty(value="hide_messages_before")
        @Nullable
        private Date hideMessagesBefore;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public List<Message> getMessages() {
            return this.messages;
        }

        @Nullable
        public List<Message> getPinnedMessages() {
            return this.pinnedMessages;
        }

        @Nullable
        public List<Message> getPendingMessages() {
            return this.pendingMessages;
        }

        @Nullable
        public Integer getWatcher_count() {
            return this.watcher_count;
        }

        @Nullable
        public List<User> getWatchers() {
            return this.watchers;
        }

        @Nullable
        public List<ChannelRead> getRead() {
            return this.read;
        }

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @Nullable
        public ChannelMember getMembership() {
            return this.membership;
        }

        @Nullable
        public Boolean getHidden() {
            return this.hidden;
        }

        @Nullable
        public Date getHideMessagesBefore() {
            return this.hideMessagesBefore;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="messages")
        public void setMessages(@Nullable List<Message> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="pinned_messages")
        public void setPinnedMessages(@Nullable List<Message> pinnedMessages) {
            this.pinnedMessages = pinnedMessages;
        }

        @JsonProperty(value="pending_messages")
        public void setPendingMessages(@Nullable List<Message> pendingMessages) {
            this.pendingMessages = pendingMessages;
        }

        @JsonProperty(value="watcher_count")
        public void setWatcher_count(@Nullable Integer watcher_count) {
            this.watcher_count = watcher_count;
        }

        @JsonProperty(value="watchers")
        public void setWatchers(@Nullable List<User> watchers) {
            this.watchers = watchers;
        }

        @JsonProperty(value="read")
        public void setRead(@Nullable List<ChannelRead> read) {
            this.read = read;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @JsonProperty(value="membership")
        public void setMembership(@Nullable ChannelMember membership) {
            this.membership = membership;
        }

        @JsonProperty(value="hidden")
        public void setHidden(@Nullable Boolean hidden) {
            this.hidden = hidden;
        }

        @JsonProperty(value="hide_messages_before")
        public void setHideMessagesBefore(@Nullable Date hideMessagesBefore) {
            this.hideMessagesBefore = hideMessagesBefore;
        }

        @Override
        public String toString() {
            return "Channel.ChannelGetResponse(channel=" + this.getChannel() + ", messages=" + this.getMessages() + ", pinnedMessages=" + this.getPinnedMessages() + ", pendingMessages=" + this.getPendingMessages() + ", watcher_count=" + this.getWatcher_count() + ", watchers=" + this.getWatchers() + ", read=" + this.getRead() + ", members=" + this.getMembers() + ", membership=" + this.getMembership() + ", hidden=" + this.getHidden() + ", hideMessagesBefore=" + this.getHideMessagesBefore() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelGetResponse)) {
                return false;
            }
            ChannelGetResponse other = (ChannelGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$watcher_count = this.getWatcher_count();
            Integer other$watcher_count = other.getWatcher_count();
            if (this$watcher_count == null ? other$watcher_count != null : !((Object)this$watcher_count).equals(other$watcher_count)) {
                return false;
            }
            Boolean this$hidden = this.getHidden();
            Boolean other$hidden = other.getHidden();
            if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            List<Message> this$pinnedMessages = this.getPinnedMessages();
            List<Message> other$pinnedMessages = other.getPinnedMessages();
            if (this$pinnedMessages == null ? other$pinnedMessages != null : !((Object)this$pinnedMessages).equals(other$pinnedMessages)) {
                return false;
            }
            List<Message> this$pendingMessages = this.getPendingMessages();
            List<Message> other$pendingMessages = other.getPendingMessages();
            if (this$pendingMessages == null ? other$pendingMessages != null : !((Object)this$pendingMessages).equals(other$pendingMessages)) {
                return false;
            }
            List<User> this$watchers = this.getWatchers();
            List<User> other$watchers = other.getWatchers();
            if (this$watchers == null ? other$watchers != null : !((Object)this$watchers).equals(other$watchers)) {
                return false;
            }
            List<ChannelRead> this$read = this.getRead();
            List<ChannelRead> other$read = other.getRead();
            if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
                return false;
            }
            ChannelMember this$membership = this.getMembership();
            ChannelMember other$membership = other.getMembership();
            if (this$membership == null ? other$membership != null : !((Object)this$membership).equals(other$membership)) {
                return false;
            }
            Date this$hideMessagesBefore = this.getHideMessagesBefore();
            Date other$hideMessagesBefore = other.getHideMessagesBefore();
            return !(this$hideMessagesBefore == null ? other$hideMessagesBefore != null : !((Object)this$hideMessagesBefore).equals(other$hideMessagesBefore));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $watcher_count = this.getWatcher_count();
            result = result * 59 + ($watcher_count == null ? 43 : ((Object)$watcher_count).hashCode());
            Boolean $hidden = this.getHidden();
            result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            List<Message> $pinnedMessages = this.getPinnedMessages();
            result = result * 59 + ($pinnedMessages == null ? 43 : ((Object)$pinnedMessages).hashCode());
            List<Message> $pendingMessages = this.getPendingMessages();
            result = result * 59 + ($pendingMessages == null ? 43 : ((Object)$pendingMessages).hashCode());
            List<User> $watchers = this.getWatchers();
            result = result * 59 + ($watchers == null ? 43 : ((Object)$watchers).hashCode());
            List<ChannelRead> $read = this.getRead();
            result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            ChannelMember $membership = this.getMembership();
            result = result * 59 + ($membership == null ? 43 : ((Object)$membership).hashCode());
            Date $hideMessagesBefore = this.getHideMessagesBefore();
            result = result * 59 + ($hideMessagesBefore == null ? 43 : ((Object)$hideMessagesBefore).hashCode());
            return result;
        }
    }

    public static class ChannelPartialUpdateRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        ChannelPartialUpdateRequestData(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.userId = userId;
            this.user = user;
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        public static class ChannelPartialUpdateRequest
        extends StreamRequest<ChannelPartialUpdateResponse> {
            private String userId;
            private User.UserRequestObject user;
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelPartialUpdateRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<ChannelPartialUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).partialUpdate(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ChannelPartialUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelPartialUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelPartialUpdateRequest setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public ChannelPartialUpdateRequest setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelPartialUpdateRequest clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public ChannelPartialUpdateRequest unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public ChannelPartialUpdateRequest unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public ChannelPartialUpdateRequest clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public ChannelPartialUpdateRequestData internalBuild() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new ChannelPartialUpdateRequestData(this.userId, this.user, setValues, unsetValues);
            }

            public String toString() {
                return "Channel.ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest(userId=" + this.userId + ", user=" + this.user + ", setValues$key=" + this.setValues$key + ", setValues$value=" + this.setValues$value + ", unsetValues=" + this.unsetValues + ")";
            }
        }
    }

    public static class ChannelUnMuteRequestData {
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="channel_cids")
        @Nullable
        private List<String> channelCids;
        @JsonProperty(value="expiration")
        @Nullable
        private Integer expiration;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelUnMuteRequestData(@Nullable String channelCid, @Nullable List<String> channelCids, @Nullable Integer expiration, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.channelCid = channelCid;
            this.channelCids = channelCids;
            this.expiration = expiration;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelUnMuteRequest
        extends StreamRequest<ChannelUnMuteResponse> {
            private String channelCid;
            private List<String> channelCids;
            private Integer expiration;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelUnMuteResponse> generateCall(Client client) {
                return client.create(ChannelService.class).unmute(this.internalBuild());
            }

            ChannelUnMuteRequest() {
            }

            @JsonProperty(value="channel_cid")
            public ChannelUnMuteRequest channelCid(@Nullable String channelCid) {
                this.channelCid = channelCid;
                return this;
            }

            @JsonProperty(value="channel_cids")
            public ChannelUnMuteRequest channelCids(@Nullable List<String> channelCids) {
                this.channelCids = channelCids;
                return this;
            }

            @JsonProperty(value="expiration")
            public ChannelUnMuteRequest expiration(@Nullable Integer expiration) {
                this.expiration = expiration;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelUnMuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelUnMuteRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelUnMuteRequestData internalBuild() {
                return new ChannelUnMuteRequestData(this.channelCid, this.channelCids, this.expiration, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelUnMuteRequestData.ChannelUnMuteRequest(channelCid=" + this.channelCid + ", channelCids=" + this.channelCids + ", expiration=" + this.expiration + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelShowRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelShowRequestData(@Nullable String userId, @Nullable User.UserRequestObject user) {
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelShowRequest
        extends StreamRequest<StreamResponseObject> {
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelShowRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).show(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ChannelShowRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelShowRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelShowRequestData internalBuild() {
                return new ChannelShowRequestData(this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelShowRequestData.ChannelShowRequest(userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelMuteRequestData {
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="channel_cids")
        @Nullable
        private List<String> channelCids;
        @JsonProperty(value="expiration")
        @Nullable
        private Long expiration;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMuteRequestData(@Nullable String channelCid, @Nullable List<String> channelCids, @Nullable Long expiration, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.channelCid = channelCid;
            this.channelCids = channelCids;
            this.expiration = expiration;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelMuteRequest
        extends StreamRequest<ChannelMuteResponse> {
            private String channelCid;
            private List<String> channelCids;
            private Long expiration;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelMuteResponse> generateCall(Client client) {
                return client.create(ChannelService.class).mute(this.internalBuild());
            }

            ChannelMuteRequest() {
            }

            @JsonProperty(value="channel_cid")
            public ChannelMuteRequest channelCid(@Nullable String channelCid) {
                this.channelCid = channelCid;
                return this;
            }

            @JsonProperty(value="channel_cids")
            public ChannelMuteRequest channelCids(@Nullable List<String> channelCids) {
                this.channelCids = channelCids;
                return this;
            }

            @JsonProperty(value="expiration")
            public ChannelMuteRequest expiration(@Nullable Long expiration) {
                this.expiration = expiration;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelMuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMuteRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMuteRequestData internalBuild() {
                return new ChannelMuteRequestData(this.channelCid, this.channelCids, this.expiration, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMuteRequestData.ChannelMuteRequest(channelCid=" + this.channelCid + ", channelCids=" + this.channelCids + ", expiration=" + this.expiration + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelMarkReadRequestData {
        @JsonProperty(value="message_id")
        @Nullable
        private String messageId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMarkReadRequestData(@Nullable String messageId, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.messageId = messageId;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelMarkReadRequest
        extends StreamRequest<ChannelMarkReadResponse> {
            private String messageId;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelMarkReadRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<ChannelMarkReadResponse> generateCall(Client client) {
                return client.create(ChannelService.class).markRead(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="message_id")
            public ChannelMarkReadRequest messageId(@Nullable String messageId) {
                this.messageId = messageId;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelMarkReadRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMarkReadRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMarkReadRequestData internalBuild() {
                return new ChannelMarkReadRequestData(this.messageId, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMarkReadRequestData.ChannelMarkReadRequest(messageId=" + this.messageId + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelMarkAllReadRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMarkAllReadRequestData(@Nullable String userId, @Nullable User.UserRequestObject user) {
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelMarkAllReadRequest
        extends StreamRequest<StreamResponseObject> {
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).markAllRead(this.internalBuild());
            }

            ChannelMarkAllReadRequest() {
            }

            @JsonProperty(value="user_id")
            public ChannelMarkAllReadRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMarkAllReadRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMarkAllReadRequestData internalBuild() {
                return new ChannelMarkAllReadRequestData(this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest(userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelHideRequestData {
        @JsonProperty(value="clear_history")
        @Nullable
        private Boolean clearHistory;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelHideRequestData(@Nullable Boolean clearHistory, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.clearHistory = clearHistory;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelHideRequest
        extends StreamRequest<StreamResponseObject> {
            private Boolean clearHistory;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelHideRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).hide(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="clear_history")
            public ChannelHideRequest clearHistory(@Nullable Boolean clearHistory) {
                this.clearHistory = clearHistory;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelHideRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelHideRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelHideRequestData internalBuild() {
                return new ChannelHideRequestData(this.clearHistory, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelHideRequestData.ChannelHideRequest(clearHistory=" + this.clearHistory + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelExportStatusRequest
    extends StreamRequest<ChannelExportStatusResponse> {
        @NotNull
        private String id;

        @Override
        protected Call<ChannelExportStatusResponse> generateCall(Client client) {
            return client.create(ChannelService.class).exportStatus(this.id);
        }

        public ChannelExportStatusRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class ChannelExportRequestData {
        @JsonProperty(value="channels")
        @Nullable
        private List<ChannelExportRequestObject> channels;
        @JsonProperty(value="version")
        @Nullable
        private String version;
        @JsonProperty(value="clear_deleted_message_text")
        @Nullable
        private Boolean clearDeletedMessageText;
        @JsonProperty(value="include_truncated_messages")
        @Nullable
        private Boolean includeTruncatedMessages;
        @JsonProperty(value="export_users")
        @Nullable
        private Boolean exportUsers;

        ChannelExportRequestData(@Nullable List<ChannelExportRequestObject> channels, @Nullable String version, @Nullable Boolean clearDeletedMessageText, @Nullable Boolean includeTruncatedMessages, @Nullable Boolean exportUsers) {
            this.channels = channels;
            this.version = version;
            this.clearDeletedMessageText = clearDeletedMessageText;
            this.includeTruncatedMessages = includeTruncatedMessages;
            this.exportUsers = exportUsers;
        }

        public static class ChannelExportRequest
        extends StreamRequest<ChannelExportResponse> {
            private ArrayList<ChannelExportRequestObject> channels;
            private String version;
            private Boolean clearDeletedMessageText;
            private Boolean includeTruncatedMessages;
            private Boolean exportUsers;

            @Override
            protected Call<ChannelExportResponse> generateCall(Client client) {
                return client.create(ChannelService.class).export(this.internalBuild());
            }

            ChannelExportRequest() {
            }

            public ChannelExportRequest channel(ChannelExportRequestObject channel) {
                if (this.channels == null) {
                    this.channels = new ArrayList();
                }
                this.channels.add(channel);
                return this;
            }

            @JsonProperty(value="channels")
            public ChannelExportRequest channels(Collection<? extends ChannelExportRequestObject> channels) {
                if (channels == null) {
                    throw new NullPointerException("channels cannot be null");
                }
                if (this.channels == null) {
                    this.channels = new ArrayList();
                }
                this.channels.addAll(channels);
                return this;
            }

            public ChannelExportRequest clearChannels() {
                if (this.channels != null) {
                    this.channels.clear();
                }
                return this;
            }

            @JsonProperty(value="version")
            public ChannelExportRequest version(@Nullable String version) {
                this.version = version;
                return this;
            }

            @JsonProperty(value="clear_deleted_message_text")
            public ChannelExportRequest clearDeletedMessageText(@Nullable Boolean clearDeletedMessageText) {
                this.clearDeletedMessageText = clearDeletedMessageText;
                return this;
            }

            @JsonProperty(value="include_truncated_messages")
            public ChannelExportRequest includeTruncatedMessages(@Nullable Boolean includeTruncatedMessages) {
                this.includeTruncatedMessages = includeTruncatedMessages;
                return this;
            }

            @JsonProperty(value="export_users")
            public ChannelExportRequest exportUsers(@Nullable Boolean exportUsers) {
                this.exportUsers = exportUsers;
                return this;
            }

            public ChannelExportRequestData internalBuild() {
                List<ChannelExportRequestObject> channels;
                switch (this.channels == null ? 0 : this.channels.size()) {
                    case 0: {
                        channels = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        channels = Collections.singletonList(this.channels.get(0));
                        break;
                    }
                    default: {
                        channels = Collections.unmodifiableList(new ArrayList<ChannelExportRequestObject>(this.channels));
                    }
                }
                return new ChannelExportRequestData(channels, this.version, this.clearDeletedMessageText, this.includeTruncatedMessages, this.exportUsers);
            }

            public String toString() {
                return "Channel.ChannelExportRequestData.ChannelExportRequest(channels=" + this.channels + ", version=" + this.version + ", clearDeletedMessageText=" + this.clearDeletedMessageText + ", includeTruncatedMessages=" + this.includeTruncatedMessages + ", exportUsers=" + this.exportUsers + ")";
            }
        }
    }

    public static class ChannelQueryMembersRequestData {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="members")
        @Nullable
        private ChannelMemberRequestObject members;
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id_gte")
        @Nullable
        private String userIdGte;
        @JsonProperty(value="user_id_gt")
        @Nullable
        private String userIdGt;
        @JsonProperty(value="user_id_lte")
        @Nullable
        private String userIdLte;
        @JsonProperty(value="user_id_lt")
        @Nullable
        private String userIdLt;
        @JsonProperty(value="created_at_after_or_equal")
        @Nullable
        private Date createdAtAfterOrEqual;
        @JsonProperty(value="created_at_after")
        @Nullable
        private Date createdAtAfter;
        @JsonProperty(value="created_at_before_or_equal")
        @Nullable
        private Date createdAtBeforeOrEqual;
        @JsonProperty(value="created_at_before")
        @Nullable
        private Date createdAtBefore;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelQueryMembersRequestData(@Nullable String type, @Nullable String id, @Nullable ChannelMemberRequestObject members, @Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userIdGte, @Nullable String userIdGt, @Nullable String userIdLte, @Nullable String userIdLt, @Nullable Date createdAtAfterOrEqual, @Nullable Date createdAtAfter, @Nullable Date createdAtBeforeOrEqual, @Nullable Date createdAtBefore, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.type = type;
            this.id = id;
            this.members = members;
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.limit = limit;
            this.offset = offset;
            this.userIdGte = userIdGte;
            this.userIdGt = userIdGt;
            this.userIdLte = userIdLte;
            this.userIdLt = userIdLt;
            this.createdAtAfterOrEqual = createdAtAfterOrEqual;
            this.createdAtAfter = createdAtAfter;
            this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
            this.createdAtBefore = createdAtBefore;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelQueryMembersRequest
        extends StreamRequest<ChannelQueryMembersResponse> {
            private String type;
            private String id;
            private ChannelMemberRequestObject members;
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Integer limit;
            private Integer offset;
            private String userIdGte;
            private String userIdGt;
            private String userIdLte;
            private String userIdLt;
            private Date createdAtAfterOrEqual;
            private Date createdAtAfter;
            private Date createdAtBeforeOrEqual;
            private Date createdAtBefore;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelQueryMembersResponse> generateCall(Client client) {
                return client.create(ChannelService.class).queryMembers(this.internalBuild());
            }

            ChannelQueryMembersRequest() {
            }

            @JsonProperty(value="type")
            public ChannelQueryMembersRequest type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="id")
            public ChannelQueryMembersRequest id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="members")
            public ChannelQueryMembersRequest members(@Nullable ChannelMemberRequestObject members) {
                this.members = members;
                return this;
            }

            public ChannelQueryMembersRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public ChannelQueryMembersRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelQueryMembersRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public ChannelQueryMembersRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public ChannelQueryMembersRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public ChannelQueryMembersRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public ChannelQueryMembersRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public ChannelQueryMembersRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id_gte")
            public ChannelQueryMembersRequest userIdGte(@Nullable String userIdGte) {
                this.userIdGte = userIdGte;
                return this;
            }

            @JsonProperty(value="user_id_gt")
            public ChannelQueryMembersRequest userIdGt(@Nullable String userIdGt) {
                this.userIdGt = userIdGt;
                return this;
            }

            @JsonProperty(value="user_id_lte")
            public ChannelQueryMembersRequest userIdLte(@Nullable String userIdLte) {
                this.userIdLte = userIdLte;
                return this;
            }

            @JsonProperty(value="user_id_lt")
            public ChannelQueryMembersRequest userIdLt(@Nullable String userIdLt) {
                this.userIdLt = userIdLt;
                return this;
            }

            @JsonProperty(value="created_at_after_or_equal")
            public ChannelQueryMembersRequest createdAtAfterOrEqual(@Nullable Date createdAtAfterOrEqual) {
                this.createdAtAfterOrEqual = createdAtAfterOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_after")
            public ChannelQueryMembersRequest createdAtAfter(@Nullable Date createdAtAfter) {
                this.createdAtAfter = createdAtAfter;
                return this;
            }

            @JsonProperty(value="created_at_before_or_equal")
            public ChannelQueryMembersRequest createdAtBeforeOrEqual(@Nullable Date createdAtBeforeOrEqual) {
                this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_before")
            public ChannelQueryMembersRequest createdAtBefore(@Nullable Date createdAtBefore) {
                this.createdAtBefore = createdAtBefore;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelQueryMembersRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelQueryMembersRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelQueryMembersRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new ChannelQueryMembersRequestData(this.type, this.id, this.members, filterConditions, sorts, this.limit, this.offset, this.userIdGte, this.userIdGt, this.userIdLte, this.userIdLt, this.createdAtAfterOrEqual, this.createdAtAfter, this.createdAtBeforeOrEqual, this.createdAtBefore, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelQueryMembersRequestData.ChannelQueryMembersRequest(type=" + this.type + ", id=" + this.id + ", members=" + this.members + ", filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", sorts=" + this.sorts + ", limit=" + this.limit + ", offset=" + this.offset + ", userIdGte=" + this.userIdGte + ", userIdGt=" + this.userIdGt + ", userIdLte=" + this.userIdLte + ", userIdLt=" + this.userIdLt + ", createdAtAfterOrEqual=" + this.createdAtAfterOrEqual + ", createdAtAfter=" + this.createdAtAfter + ", createdAtBeforeOrEqual=" + this.createdAtBeforeOrEqual + ", createdAtBefore=" + this.createdAtBefore + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelTruncateRequestData {
        @JsonProperty(value="hard_delete")
        @Nullable
        private boolean hardDelete;
        @JsonProperty(value="skip_push")
        @Nullable
        private boolean skipPush;
        @JsonProperty(value="truncated_at")
        @Nullable
        private Date truncatedAt;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelTruncateRequestData(@Nullable boolean hardDelete, @Nullable boolean skipPush, @Nullable Date truncatedAt, @Nullable Message.MessageRequestObject message, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.hardDelete = hardDelete;
            this.skipPush = skipPush;
            this.truncatedAt = truncatedAt;
            this.message = message;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelTruncateRequest
        extends StreamRequest<ChannelTruncateResponse> {
            private boolean hardDelete;
            private boolean skipPush;
            private Date truncatedAt;
            private Message.MessageRequestObject message;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelTruncateRequest(@NotNull String channelType, @Nullable String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelTruncateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).truncate(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="hard_delete")
            public ChannelTruncateRequest hardDelete(@Nullable boolean hardDelete) {
                this.hardDelete = hardDelete;
                return this;
            }

            @JsonProperty(value="skip_push")
            public ChannelTruncateRequest skipPush(@Nullable boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="truncated_at")
            public ChannelTruncateRequest truncatedAt(@Nullable Date truncatedAt) {
                this.truncatedAt = truncatedAt;
                return this;
            }

            @JsonProperty(value="message")
            public ChannelTruncateRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelTruncateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelTruncateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelTruncateRequestData internalBuild() {
                return new ChannelTruncateRequestData(this.hardDelete, this.skipPush, this.truncatedAt, this.message, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelTruncateRequestData.ChannelTruncateRequest(hardDelete=" + this.hardDelete + ", skipPush=" + this.skipPush + ", truncatedAt=" + this.truncatedAt + ", message=" + this.message + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelListRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="watch")
        @Nullable
        private Boolean watch;
        @JsonProperty(value="state")
        @Nullable
        private Boolean state;
        @JsonProperty(value="presence")
        @Nullable
        private Boolean presence;
        @JsonProperty(value="message_limit")
        @Nullable
        private Integer messageLimit;
        @JsonProperty(value="member_limit")
        @Nullable
        private Integer memberLimit;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;

        ChannelListRequestData(@Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Boolean watch, @Nullable Boolean state, @Nullable Boolean presence, @Nullable Integer messageLimit, @Nullable Integer memberLimit, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userId, @Nullable User.UserRequestObject user, @Nullable String connectionId) {
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.watch = watch;
            this.state = state;
            this.presence = presence;
            this.messageLimit = messageLimit;
            this.memberLimit = memberLimit;
            this.limit = limit;
            this.offset = offset;
            this.userId = userId;
            this.user = user;
            this.connectionId = connectionId;
        }

        public static class ChannelListRequest
        extends StreamRequest<ChannelListResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Boolean watch;
            private Boolean state;
            private Boolean presence;
            private Integer messageLimit;
            private Integer memberLimit;
            private Integer limit;
            private Integer offset;
            private String userId;
            private User.UserRequestObject user;
            private String connectionId;

            @Override
            protected Call<ChannelListResponse> generateCall(Client client) {
                return client.create(ChannelService.class).list(this.internalBuild());
            }

            ChannelListRequest() {
            }

            public ChannelListRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public ChannelListRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelListRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public ChannelListRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public ChannelListRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public ChannelListRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="watch")
            public ChannelListRequest watch(@Nullable Boolean watch) {
                this.watch = watch;
                return this;
            }

            @JsonProperty(value="state")
            public ChannelListRequest state(@Nullable Boolean state) {
                this.state = state;
                return this;
            }

            @JsonProperty(value="presence")
            public ChannelListRequest presence(@Nullable Boolean presence) {
                this.presence = presence;
                return this;
            }

            @JsonProperty(value="message_limit")
            public ChannelListRequest messageLimit(@Nullable Integer messageLimit) {
                this.messageLimit = messageLimit;
                return this;
            }

            @JsonProperty(value="member_limit")
            public ChannelListRequest memberLimit(@Nullable Integer memberLimit) {
                this.memberLimit = memberLimit;
                return this;
            }

            @JsonProperty(value="limit")
            public ChannelListRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public ChannelListRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelListRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelListRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="connection_id")
            public ChannelListRequest connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            public ChannelListRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new ChannelListRequestData(filterConditions, sorts, this.watch, this.state, this.presence, this.messageLimit, this.memberLimit, this.limit, this.offset, this.userId, this.user, this.connectionId);
            }

            public String toString() {
                return "Channel.ChannelListRequestData.ChannelListRequest(filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", sorts=" + this.sorts + ", watch=" + this.watch + ", state=" + this.state + ", presence=" + this.presence + ", messageLimit=" + this.messageLimit + ", memberLimit=" + this.memberLimit + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ", user=" + this.user + ", connectionId=" + this.connectionId + ")";
            }
        }
    }

    public static class ChannelDeleteManyRequest
    extends StreamRequest<ChannelDeleteManyResponse> {
        @JsonProperty(value="cids")
        @NotNull
        private List<String> cids;
        @JsonProperty(value="hard_delete")
        private boolean hardDelete;

        public ChannelDeleteManyRequest setDeleteStrategy(DeleteStrategy strategy) {
            this.hardDelete = strategy == DeleteStrategy.HARD;
            return this;
        }

        @Override
        protected Call<ChannelDeleteManyResponse> generateCall(Client svcFactory) throws StreamException {
            return svcFactory.create(ChannelService.class).deleteMany(this);
        }

        public ChannelDeleteManyRequest(@NotNull List<String> cids) {
            if (cids == null) {
                throw new NullPointerException("cids is marked non-null but is null");
            }
            this.cids = cids;
        }
    }

    public static class ChannelDeleteRequest
    extends StreamRequest<ChannelDeleteResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;

        @Override
        protected Call<ChannelDeleteResponse> generateCall(Client client) {
            return client.create(ChannelService.class).delete(this.channelType, this.channelId);
        }

        public ChannelDeleteRequest(@NotNull String channelType, @NotNull String channelId) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
        }
    }

    public static class AssignRoleRequestData {
        @JsonProperty(value="assign_roles")
        @Nullable
        private List<RoleAssignment> assignRoles;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;

        AssignRoleRequestData(@Nullable List<RoleAssignment> assignRoles, @Nullable Message.MessageRequestObject message) {
            this.assignRoles = assignRoles;
            this.message = message;
        }

        public static class AssignRoleRequest
        extends StreamRequest<ChannelUpdateResponse> {
            private ArrayList<RoleAssignment> assignRoles;
            private Message.MessageRequestObject message;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private AssignRoleRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).assignRoles(this.channelType, this.channelId, this.internalBuild());
            }

            public AssignRoleRequest assignRole(RoleAssignment assignRole) {
                if (this.assignRoles == null) {
                    this.assignRoles = new ArrayList();
                }
                this.assignRoles.add(assignRole);
                return this;
            }

            @JsonProperty(value="assign_roles")
            public AssignRoleRequest assignRoles(Collection<? extends RoleAssignment> assignRoles) {
                if (assignRoles == null) {
                    throw new NullPointerException("assignRoles cannot be null");
                }
                if (this.assignRoles == null) {
                    this.assignRoles = new ArrayList();
                }
                this.assignRoles.addAll(assignRoles);
                return this;
            }

            public AssignRoleRequest clearAssignRoles() {
                if (this.assignRoles != null) {
                    this.assignRoles.clear();
                }
                return this;
            }

            @JsonProperty(value="message")
            public AssignRoleRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            public AssignRoleRequestData internalBuild() {
                List<RoleAssignment> assignRoles;
                switch (this.assignRoles == null ? 0 : this.assignRoles.size()) {
                    case 0: {
                        assignRoles = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        assignRoles = Collections.singletonList(this.assignRoles.get(0));
                        break;
                    }
                    default: {
                        assignRoles = Collections.unmodifiableList(new ArrayList<RoleAssignment>(this.assignRoles));
                    }
                }
                return new AssignRoleRequestData(assignRoles, this.message);
            }

            public String toString() {
                return "Channel.AssignRoleRequestData.AssignRoleRequest(assignRoles=" + this.assignRoles + ", message=" + this.message + ")";
            }
        }
    }

    public static class ChannelUpdateRequestData {
        @JsonProperty(value="add_members")
        @Nullable
        private List<String> addMembers;
        @JsonProperty(value="remove_members")
        @Nullable
        private List<String> removeMembers;
        @JsonProperty(value="add_moderators")
        @Nullable
        private List<String> addModerators;
        @JsonProperty(value="demote_moderators")
        @Nullable
        private List<String> demoteModerators;
        @JsonProperty(value="invites")
        @Nullable
        private List<String> invites;
        @JsonProperty(value="cooldown")
        @Nullable
        private Integer cooldown;
        @JsonProperty(value="accept_invite")
        @Nullable
        private Boolean acceptInvite;
        @JsonProperty(value="reject_invite")
        @Nullable
        private Boolean rejectInvite;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;
        @JsonProperty(value="skip_push")
        @Nullable
        private Boolean skipPush;
        @JsonProperty(value="hide_history")
        @Nullable
        private Boolean hideHistory;
        @JsonProperty(value="data")
        @Nullable
        private ChannelRequestObject data;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelUpdateRequestData(@Nullable List<String> addMembers, @Nullable List<String> removeMembers, @Nullable List<String> addModerators, @Nullable List<String> demoteModerators, @Nullable List<String> invites, @Nullable Integer cooldown, @Nullable Boolean acceptInvite, @Nullable Boolean rejectInvite, @Nullable Message.MessageRequestObject message, @Nullable Boolean skipPush, @Nullable Boolean hideHistory, @Nullable ChannelRequestObject data, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.addMembers = addMembers;
            this.removeMembers = removeMembers;
            this.addModerators = addModerators;
            this.demoteModerators = demoteModerators;
            this.invites = invites;
            this.cooldown = cooldown;
            this.acceptInvite = acceptInvite;
            this.rejectInvite = rejectInvite;
            this.message = message;
            this.skipPush = skipPush;
            this.hideHistory = hideHistory;
            this.data = data;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelUpdateRequest
        extends StreamRequest<ChannelUpdateResponse> {
            private ArrayList<String> addMembers;
            private ArrayList<String> removeMembers;
            private ArrayList<String> addModerators;
            private ArrayList<String> demoteModerators;
            private ArrayList<String> invites;
            private Integer cooldown;
            private Boolean acceptInvite;
            private Boolean rejectInvite;
            private Message.MessageRequestObject message;
            private Boolean skipPush;
            private Boolean hideHistory;
            private ChannelRequestObject data;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelUpdateRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).update(this.channelType, this.channelId, this.internalBuild());
            }

            public ChannelUpdateRequest addMember(String addMember) {
                if (this.addMembers == null) {
                    this.addMembers = new ArrayList();
                }
                this.addMembers.add(addMember);
                return this;
            }

            @JsonProperty(value="add_members")
            public ChannelUpdateRequest addMembers(Collection<? extends String> addMembers) {
                if (addMembers == null) {
                    throw new NullPointerException("addMembers cannot be null");
                }
                if (this.addMembers == null) {
                    this.addMembers = new ArrayList();
                }
                this.addMembers.addAll(addMembers);
                return this;
            }

            public ChannelUpdateRequest clearAddMembers() {
                if (this.addMembers != null) {
                    this.addMembers.clear();
                }
                return this;
            }

            public ChannelUpdateRequest removeMember(String removeMember) {
                if (this.removeMembers == null) {
                    this.removeMembers = new ArrayList();
                }
                this.removeMembers.add(removeMember);
                return this;
            }

            @JsonProperty(value="remove_members")
            public ChannelUpdateRequest removeMembers(Collection<? extends String> removeMembers) {
                if (removeMembers == null) {
                    throw new NullPointerException("removeMembers cannot be null");
                }
                if (this.removeMembers == null) {
                    this.removeMembers = new ArrayList();
                }
                this.removeMembers.addAll(removeMembers);
                return this;
            }

            public ChannelUpdateRequest clearRemoveMembers() {
                if (this.removeMembers != null) {
                    this.removeMembers.clear();
                }
                return this;
            }

            public ChannelUpdateRequest addModerator(String addModerator) {
                if (this.addModerators == null) {
                    this.addModerators = new ArrayList();
                }
                this.addModerators.add(addModerator);
                return this;
            }

            @JsonProperty(value="add_moderators")
            public ChannelUpdateRequest addModerators(Collection<? extends String> addModerators) {
                if (addModerators == null) {
                    throw new NullPointerException("addModerators cannot be null");
                }
                if (this.addModerators == null) {
                    this.addModerators = new ArrayList();
                }
                this.addModerators.addAll(addModerators);
                return this;
            }

            public ChannelUpdateRequest clearAddModerators() {
                if (this.addModerators != null) {
                    this.addModerators.clear();
                }
                return this;
            }

            public ChannelUpdateRequest demoteModerator(String demoteModerator) {
                if (this.demoteModerators == null) {
                    this.demoteModerators = new ArrayList();
                }
                this.demoteModerators.add(demoteModerator);
                return this;
            }

            @JsonProperty(value="demote_moderators")
            public ChannelUpdateRequest demoteModerators(Collection<? extends String> demoteModerators) {
                if (demoteModerators == null) {
                    throw new NullPointerException("demoteModerators cannot be null");
                }
                if (this.demoteModerators == null) {
                    this.demoteModerators = new ArrayList();
                }
                this.demoteModerators.addAll(demoteModerators);
                return this;
            }

            public ChannelUpdateRequest clearDemoteModerators() {
                if (this.demoteModerators != null) {
                    this.demoteModerators.clear();
                }
                return this;
            }

            public ChannelUpdateRequest invite(String invite) {
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.add(invite);
                return this;
            }

            @JsonProperty(value="invites")
            public ChannelUpdateRequest invites(Collection<? extends String> invites) {
                if (invites == null) {
                    throw new NullPointerException("invites cannot be null");
                }
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.addAll(invites);
                return this;
            }

            public ChannelUpdateRequest clearInvites() {
                if (this.invites != null) {
                    this.invites.clear();
                }
                return this;
            }

            @JsonProperty(value="cooldown")
            public ChannelUpdateRequest cooldown(@Nullable Integer cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            @JsonProperty(value="accept_invite")
            public ChannelUpdateRequest acceptInvite(@Nullable Boolean acceptInvite) {
                this.acceptInvite = acceptInvite;
                return this;
            }

            @JsonProperty(value="reject_invite")
            public ChannelUpdateRequest rejectInvite(@Nullable Boolean rejectInvite) {
                this.rejectInvite = rejectInvite;
                return this;
            }

            @JsonProperty(value="message")
            public ChannelUpdateRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="skip_push")
            public ChannelUpdateRequest skipPush(@Nullable Boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="hide_history")
            public ChannelUpdateRequest hideHistory(@Nullable Boolean hideHistory) {
                this.hideHistory = hideHistory;
                return this;
            }

            @JsonProperty(value="data")
            public ChannelUpdateRequest data(@Nullable ChannelRequestObject data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelUpdateRequestData internalBuild() {
                List<String> invites;
                List<String> demoteModerators;
                List<String> addModerators;
                List<String> removeMembers;
                List<String> addMembers;
                switch (this.addMembers == null ? 0 : this.addMembers.size()) {
                    case 0: {
                        addMembers = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        addMembers = Collections.singletonList(this.addMembers.get(0));
                        break;
                    }
                    default: {
                        addMembers = Collections.unmodifiableList(new ArrayList<String>(this.addMembers));
                    }
                }
                switch (this.removeMembers == null ? 0 : this.removeMembers.size()) {
                    case 0: {
                        removeMembers = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        removeMembers = Collections.singletonList(this.removeMembers.get(0));
                        break;
                    }
                    default: {
                        removeMembers = Collections.unmodifiableList(new ArrayList<String>(this.removeMembers));
                    }
                }
                switch (this.addModerators == null ? 0 : this.addModerators.size()) {
                    case 0: {
                        addModerators = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        addModerators = Collections.singletonList(this.addModerators.get(0));
                        break;
                    }
                    default: {
                        addModerators = Collections.unmodifiableList(new ArrayList<String>(this.addModerators));
                    }
                }
                switch (this.demoteModerators == null ? 0 : this.demoteModerators.size()) {
                    case 0: {
                        demoteModerators = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        demoteModerators = Collections.singletonList(this.demoteModerators.get(0));
                        break;
                    }
                    default: {
                        demoteModerators = Collections.unmodifiableList(new ArrayList<String>(this.demoteModerators));
                    }
                }
                switch (this.invites == null ? 0 : this.invites.size()) {
                    case 0: {
                        invites = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        invites = Collections.singletonList(this.invites.get(0));
                        break;
                    }
                    default: {
                        invites = Collections.unmodifiableList(new ArrayList<String>(this.invites));
                    }
                }
                return new ChannelUpdateRequestData(addMembers, removeMembers, addModerators, demoteModerators, invites, this.cooldown, this.acceptInvite, this.rejectInvite, this.message, this.skipPush, this.hideHistory, this.data, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelUpdateRequestData.ChannelUpdateRequest(addMembers=" + this.addMembers + ", removeMembers=" + this.removeMembers + ", addModerators=" + this.addModerators + ", demoteModerators=" + this.demoteModerators + ", invites=" + this.invites + ", cooldown=" + this.cooldown + ", acceptInvite=" + this.acceptInvite + ", rejectInvite=" + this.rejectInvite + ", message=" + this.message + ", skipPush=" + this.skipPush + ", hideHistory=" + this.hideHistory + ", data=" + this.data + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class ChannelGetRequestData {
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;
        @JsonProperty(value="data")
        @Nullable
        private ChannelRequestObject data;
        @JsonProperty(value="watch")
        @Nullable
        private Boolean watch;
        @JsonProperty(value="state")
        @Nullable
        private Boolean state;
        @JsonProperty(value="presence")
        @Nullable
        private Boolean presence;
        @JsonProperty(value="messages")
        @Nullable
        private MessagePaginationParameters messages;
        @JsonProperty(value="members")
        @Nullable
        private PaginationParameters members;
        @JsonProperty(value="watchers")
        @Nullable
        private PaginationParameters watchers;

        ChannelGetRequestData(@Nullable String connectionId, @Nullable ChannelRequestObject data, @Nullable Boolean watch, @Nullable Boolean state, @Nullable Boolean presence, @Nullable MessagePaginationParameters messages, @Nullable PaginationParameters members, @Nullable PaginationParameters watchers) {
            this.connectionId = connectionId;
            this.data = data;
            this.watch = watch;
            this.state = state;
            this.presence = presence;
            this.messages = messages;
            this.members = members;
            this.watchers = watchers;
        }

        public static class ChannelGetRequest
        extends StreamRequest<ChannelGetResponse> {
            private String connectionId;
            private ChannelRequestObject data;
            private Boolean watch;
            private Boolean state;
            private Boolean presence;
            private MessagePaginationParameters messages;
            private PaginationParameters members;
            private PaginationParameters watchers;
            @NotNull
            private String channelType;
            @Nullable
            private String channelId;

            private ChannelGetRequest(@NotNull String channelType, @Nullable String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelGetResponse> generateCall(Client client) {
                if (this.channelId != null) {
                    return client.create(ChannelService.class).getOrCreateWithId(this.channelType, this.channelId, this.internalBuild());
                }
                return client.create(ChannelService.class).getOrCreateWithoutId(this.channelType, this.internalBuild());
            }

            @JsonProperty(value="connection_id")
            public ChannelGetRequest connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            @JsonProperty(value="data")
            public ChannelGetRequest data(@Nullable ChannelRequestObject data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="watch")
            public ChannelGetRequest watch(@Nullable Boolean watch) {
                this.watch = watch;
                return this;
            }

            @JsonProperty(value="state")
            public ChannelGetRequest state(@Nullable Boolean state) {
                this.state = state;
                return this;
            }

            @JsonProperty(value="presence")
            public ChannelGetRequest presence(@Nullable Boolean presence) {
                this.presence = presence;
                return this;
            }

            @JsonProperty(value="messages")
            public ChannelGetRequest messages(@Nullable MessagePaginationParameters messages) {
                this.messages = messages;
                return this;
            }

            @JsonProperty(value="members")
            public ChannelGetRequest members(@Nullable PaginationParameters members) {
                this.members = members;
                return this;
            }

            @JsonProperty(value="watchers")
            public ChannelGetRequest watchers(@Nullable PaginationParameters watchers) {
                this.watchers = watchers;
                return this;
            }

            public ChannelGetRequestData internalBuild() {
                return new ChannelGetRequestData(this.connectionId, this.data, this.watch, this.state, this.presence, this.messages, this.members, this.watchers);
            }

            public String toString() {
                return "Channel.ChannelGetRequestData.ChannelGetRequest(connectionId=" + this.connectionId + ", data=" + this.data + ", watch=" + this.watch + ", state=" + this.state + ", presence=" + this.presence + ", messages=" + this.messages + ", members=" + this.members + ", watchers=" + this.watchers + ")";
            }
        }
    }

    public static class ChannelExportRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="messages_since")
        @Nullable
        private Date messagesSince;
        @JsonProperty(value="messages_until")
        @Nullable
        private Date messagesUntil;

        ChannelExportRequestObject(@Nullable String type, @Nullable String id, @Nullable Date messagesSince, @Nullable Date messagesUntil) {
            this.type = type;
            this.id = id;
            this.messagesSince = messagesSince;
            this.messagesUntil = messagesUntil;
        }

        public static ChannelExportRequestObjectBuilder builder() {
            return new ChannelExportRequestObjectBuilder();
        }

        public static class ChannelExportRequestObjectBuilder {
            private String type;
            private String id;
            private Date messagesSince;
            private Date messagesUntil;

            ChannelExportRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public ChannelExportRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="id")
            public ChannelExportRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="messages_since")
            public ChannelExportRequestObjectBuilder messagesSince(@Nullable Date messagesSince) {
                this.messagesSince = messagesSince;
                return this;
            }

            @JsonProperty(value="messages_until")
            public ChannelExportRequestObjectBuilder messagesUntil(@Nullable Date messagesUntil) {
                this.messagesUntil = messagesUntil;
                return this;
            }

            public ChannelExportRequestObject build() {
                return new ChannelExportRequestObject(this.type, this.id, this.messagesSince, this.messagesUntil);
            }

            public String toString() {
                return "Channel.ChannelExportRequestObject.ChannelExportRequestObjectBuilder(type=" + this.type + ", id=" + this.id + ", messagesSince=" + this.messagesSince + ", messagesUntil=" + this.messagesUntil + ")";
            }
        }
    }

    public static class ConfigOverridesRequestObject {
        @JsonProperty(value="typing_events")
        @Nullable
        private Boolean typingEvents;
        @JsonProperty(value="reactions")
        @Nullable
        private Boolean reactions;
        @JsonProperty(value="replies")
        @Nullable
        private Boolean replies;
        @JsonProperty(value="uploads")
        @Nullable
        private Boolean uploads;
        @JsonProperty(value="url_enrichment")
        @Nullable
        private Boolean urlEnrichment;
        @JsonProperty(value="max_message_length")
        @Nullable
        private Integer maxMessageLength;
        @JsonProperty(value="blocklist")
        @Nullable
        private String blocklist;
        @JsonProperty(value="blocklist_behavior")
        @Nullable
        private ChannelType.BlocklistBehavior blocklistBehavior;
        @JsonProperty(value="commands")
        @Nullable
        private List<String> Commands;

        ConfigOverridesRequestObject(@Nullable Boolean typingEvents, @Nullable Boolean reactions, @Nullable Boolean replies, @Nullable Boolean uploads, @Nullable Boolean urlEnrichment, @Nullable Integer maxMessageLength, @Nullable String blocklist, @Nullable ChannelType.BlocklistBehavior blocklistBehavior, @Nullable List<String> Commands) {
            this.typingEvents = typingEvents;
            this.reactions = reactions;
            this.replies = replies;
            this.uploads = uploads;
            this.urlEnrichment = urlEnrichment;
            this.maxMessageLength = maxMessageLength;
            this.blocklist = blocklist;
            this.blocklistBehavior = blocklistBehavior;
            this.Commands = Commands;
        }

        public static ConfigOverridesRequestObjectBuilder builder() {
            return new ConfigOverridesRequestObjectBuilder();
        }

        public static class ConfigOverridesRequestObjectBuilder {
            private Boolean typingEvents;
            private Boolean reactions;
            private Boolean replies;
            private Boolean uploads;
            private Boolean urlEnrichment;
            private Integer maxMessageLength;
            private String blocklist;
            private ChannelType.BlocklistBehavior blocklistBehavior;
            private List<String> Commands;

            ConfigOverridesRequestObjectBuilder() {
            }

            @JsonProperty(value="typing_events")
            public ConfigOverridesRequestObjectBuilder typingEvents(@Nullable Boolean typingEvents) {
                this.typingEvents = typingEvents;
                return this;
            }

            @JsonProperty(value="reactions")
            public ConfigOverridesRequestObjectBuilder reactions(@Nullable Boolean reactions) {
                this.reactions = reactions;
                return this;
            }

            @JsonProperty(value="replies")
            public ConfigOverridesRequestObjectBuilder replies(@Nullable Boolean replies) {
                this.replies = replies;
                return this;
            }

            @JsonProperty(value="uploads")
            public ConfigOverridesRequestObjectBuilder uploads(@Nullable Boolean uploads) {
                this.uploads = uploads;
                return this;
            }

            @JsonProperty(value="url_enrichment")
            public ConfigOverridesRequestObjectBuilder urlEnrichment(@Nullable Boolean urlEnrichment) {
                this.urlEnrichment = urlEnrichment;
                return this;
            }

            @JsonProperty(value="max_message_length")
            public ConfigOverridesRequestObjectBuilder maxMessageLength(@Nullable Integer maxMessageLength) {
                this.maxMessageLength = maxMessageLength;
                return this;
            }

            @JsonProperty(value="blocklist")
            public ConfigOverridesRequestObjectBuilder blocklist(@Nullable String blocklist) {
                this.blocklist = blocklist;
                return this;
            }

            @JsonProperty(value="blocklist_behavior")
            public ConfigOverridesRequestObjectBuilder blocklistBehavior(@Nullable ChannelType.BlocklistBehavior blocklistBehavior) {
                this.blocklistBehavior = blocklistBehavior;
                return this;
            }

            @JsonProperty(value="commands")
            public ConfigOverridesRequestObjectBuilder Commands(@Nullable List<String> Commands) {
                this.Commands = Commands;
                return this;
            }

            public ConfigOverridesRequestObject build() {
                return new ConfigOverridesRequestObject(this.typingEvents, this.reactions, this.replies, this.uploads, this.urlEnrichment, this.maxMessageLength, this.blocklist, this.blocklistBehavior, this.Commands);
            }

            public String toString() {
                return "Channel.ConfigOverridesRequestObject.ConfigOverridesRequestObjectBuilder(typingEvents=" + this.typingEvents + ", reactions=" + this.reactions + ", replies=" + this.replies + ", uploads=" + this.uploads + ", urlEnrichment=" + this.urlEnrichment + ", maxMessageLength=" + this.maxMessageLength + ", blocklist=" + this.blocklist + ", blocklistBehavior=" + this.blocklistBehavior + ", Commands=" + this.Commands + ")";
            }
        }
    }

    public static class ChannelMemberRequestObject {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="is_moderator")
        @Nullable
        private Boolean isModerator;
        @JsonProperty(value="invited")
        @Nullable
        private Boolean invited;
        @JsonProperty(value="invite_accepted_at")
        @Nullable
        private Date inviteAcceptedAt;
        @JsonProperty(value="invite_rejected_at")
        @Nullable
        private Date inviteRejectedAt;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="ban_expires")
        @Nullable
        private String banExpires;
        @JsonProperty(value="shadow_banned")
        @Nullable
        private Boolean shadowBanned;

        @Nullable
        public static ChannelMemberRequestObject buildFrom(@Nullable ChannelMember channelMember) {
            return RequestObjectBuilder.build(ChannelMemberRequestObject.class, channelMember);
        }

        ChannelMemberRequestObject(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Boolean isModerator, @Nullable Boolean invited, @Nullable Date inviteAcceptedAt, @Nullable Date inviteRejectedAt, @Nullable String role, @Nullable String channelRole, @Nullable Date createdAt, @Nullable Date updatedAt, @Nullable Boolean banned, @Nullable String banExpires, @Nullable Boolean shadowBanned) {
            this.userId = userId;
            this.user = user;
            this.isModerator = isModerator;
            this.invited = invited;
            this.inviteAcceptedAt = inviteAcceptedAt;
            this.inviteRejectedAt = inviteRejectedAt;
            this.role = role;
            this.channelRole = channelRole;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.banned = banned;
            this.banExpires = banExpires;
            this.shadowBanned = shadowBanned;
        }

        public static ChannelMemberRequestObjectBuilder builder() {
            return new ChannelMemberRequestObjectBuilder();
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="is_moderator")
        public void setIsModerator(@Nullable Boolean isModerator) {
            this.isModerator = isModerator;
        }

        @JsonProperty(value="invited")
        public void setInvited(@Nullable Boolean invited) {
            this.invited = invited;
        }

        @JsonProperty(value="invite_accepted_at")
        public void setInviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
            this.inviteAcceptedAt = inviteAcceptedAt;
        }

        @JsonProperty(value="invite_rejected_at")
        public void setInviteRejectedAt(@Nullable Date inviteRejectedAt) {
            this.inviteRejectedAt = inviteRejectedAt;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="ban_expires")
        public void setBanExpires(@Nullable String banExpires) {
            this.banExpires = banExpires;
        }

        @JsonProperty(value="shadow_banned")
        public void setShadowBanned(@Nullable Boolean shadowBanned) {
            this.shadowBanned = shadowBanned;
        }

        public static class ChannelMemberRequestObjectBuilder {
            private String userId;
            private User.UserRequestObject user;
            private Boolean isModerator;
            private Boolean invited;
            private Date inviteAcceptedAt;
            private Date inviteRejectedAt;
            private String role;
            private String channelRole;
            private Date createdAt;
            private Date updatedAt;
            private Boolean banned;
            private String banExpires;
            private Boolean shadowBanned;

            ChannelMemberRequestObjectBuilder() {
            }

            @JsonProperty(value="user_id")
            public ChannelMemberRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMemberRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="is_moderator")
            public ChannelMemberRequestObjectBuilder isModerator(@Nullable Boolean isModerator) {
                this.isModerator = isModerator;
                return this;
            }

            @JsonProperty(value="invited")
            public ChannelMemberRequestObjectBuilder invited(@Nullable Boolean invited) {
                this.invited = invited;
                return this;
            }

            @JsonProperty(value="invite_accepted_at")
            public ChannelMemberRequestObjectBuilder inviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
                this.inviteAcceptedAt = inviteAcceptedAt;
                return this;
            }

            @JsonProperty(value="invite_rejected_at")
            public ChannelMemberRequestObjectBuilder inviteRejectedAt(@Nullable Date inviteRejectedAt) {
                this.inviteRejectedAt = inviteRejectedAt;
                return this;
            }

            @JsonProperty(value="role")
            public ChannelMemberRequestObjectBuilder role(@Nullable String role) {
                this.role = role;
                return this;
            }

            @JsonProperty(value="channel_role")
            public ChannelMemberRequestObjectBuilder channelRole(@Nullable String channelRole) {
                this.channelRole = channelRole;
                return this;
            }

            @JsonProperty(value="created_at")
            public ChannelMemberRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="updated_at")
            public ChannelMemberRequestObjectBuilder updatedAt(@Nullable Date updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @JsonProperty(value="banned")
            public ChannelMemberRequestObjectBuilder banned(@Nullable Boolean banned) {
                this.banned = banned;
                return this;
            }

            @JsonProperty(value="ban_expires")
            public ChannelMemberRequestObjectBuilder banExpires(@Nullable String banExpires) {
                this.banExpires = banExpires;
                return this;
            }

            @JsonProperty(value="shadow_banned")
            public ChannelMemberRequestObjectBuilder shadowBanned(@Nullable Boolean shadowBanned) {
                this.shadowBanned = shadowBanned;
                return this;
            }

            public ChannelMemberRequestObject build() {
                return new ChannelMemberRequestObject(this.userId, this.user, this.isModerator, this.invited, this.inviteAcceptedAt, this.inviteRejectedAt, this.role, this.channelRole, this.createdAt, this.updatedAt, this.banned, this.banExpires, this.shadowBanned);
            }

            public String toString() {
                return "Channel.ChannelMemberRequestObject.ChannelMemberRequestObjectBuilder(userId=" + this.userId + ", user=" + this.user + ", isModerator=" + this.isModerator + ", invited=" + this.invited + ", inviteAcceptedAt=" + this.inviteAcceptedAt + ", inviteRejectedAt=" + this.inviteRejectedAt + ", role=" + this.role + ", channelRole=" + this.channelRole + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", banned=" + this.banned + ", banExpires=" + this.banExpires + ", shadowBanned=" + this.shadowBanned + ")";
            }
        }
    }

    public static class ChannelRequestObject {
        @JsonProperty(value="created_by")
        @Nullable
        private User.UserRequestObject createdBy;
        @JsonProperty(value="team")
        @Nullable
        private String team;
        @JsonProperty(value="auto_translation_enabled")
        @Nullable
        private Boolean autoTranslationEnabled;
        @JsonProperty(value="auto_translation_language")
        @Nullable
        private Language autoTranslationLanguage;
        @JsonProperty(value="frozen")
        @Nullable
        private Boolean frozen;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMemberRequestObject> members;
        @JsonProperty(value="invites")
        @Nullable
        private List<ChannelMemberRequestObject> invites;
        @JsonProperty(value="config_overrides")
        @Nullable
        private ConfigOverridesRequestObject configOverrides;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static ChannelRequestObject buildFrom(@Nullable Channel channel) {
            return RequestObjectBuilder.build(ChannelRequestObject.class, channel);
        }

        private ChannelRequestObject(@Nullable User.UserRequestObject createdBy, @Nullable String team, @Nullable Boolean autoTranslationEnabled, @Nullable Language autoTranslationLanguage, @Nullable Boolean frozen, @Nullable List<ChannelMemberRequestObject> members, @Nullable List<ChannelMemberRequestObject> invites, @Nullable ConfigOverridesRequestObject configOverrides, Map<String, Object> additionalFields) {
            this.createdBy = createdBy;
            this.team = team;
            this.autoTranslationEnabled = autoTranslationEnabled;
            this.autoTranslationLanguage = autoTranslationLanguage;
            this.frozen = frozen;
            this.members = members;
            this.invites = invites;
            this.configOverrides = configOverrides;
            this.additionalFields = new HashMap<String, Object>(additionalFields);
        }

        public static ChannelRequestObjectBuilder builder() {
            return new ChannelRequestObjectBuilder();
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(@Nullable User.UserRequestObject createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="team")
        public void setTeam(@Nullable String team) {
            this.team = team;
        }

        @JsonProperty(value="auto_translation_enabled")
        public void setAutoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
            this.autoTranslationEnabled = autoTranslationEnabled;
        }

        @JsonProperty(value="auto_translation_language")
        public void setAutoTranslationLanguage(@Nullable Language autoTranslationLanguage) {
            this.autoTranslationLanguage = autoTranslationLanguage;
        }

        @JsonProperty(value="frozen")
        public void setFrozen(@Nullable Boolean frozen) {
            this.frozen = frozen;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMemberRequestObject> members) {
            this.members = members;
        }

        @JsonProperty(value="invites")
        public void setInvites(@Nullable List<ChannelMemberRequestObject> invites) {
            this.invites = invites;
        }

        @JsonProperty(value="config_overrides")
        public void setConfigOverrides(@Nullable ConfigOverridesRequestObject configOverrides) {
            this.configOverrides = configOverrides;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class ChannelRequestObjectBuilder {
            private User.UserRequestObject createdBy;
            private String team;
            private Boolean autoTranslationEnabled;
            private Language autoTranslationLanguage;
            private Boolean frozen;
            private ArrayList<ChannelMemberRequestObject> members;
            private ArrayList<ChannelMemberRequestObject> invites;
            private ConfigOverridesRequestObject configOverrides;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            ChannelRequestObjectBuilder() {
            }

            @JsonProperty(value="created_by")
            public ChannelRequestObjectBuilder createdBy(@Nullable User.UserRequestObject createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="team")
            public ChannelRequestObjectBuilder team(@Nullable String team) {
                this.team = team;
                return this;
            }

            @JsonProperty(value="auto_translation_enabled")
            public ChannelRequestObjectBuilder autoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
                this.autoTranslationEnabled = autoTranslationEnabled;
                return this;
            }

            @JsonProperty(value="auto_translation_language")
            public ChannelRequestObjectBuilder autoTranslationLanguage(@Nullable Language autoTranslationLanguage) {
                this.autoTranslationLanguage = autoTranslationLanguage;
                return this;
            }

            @JsonProperty(value="frozen")
            public ChannelRequestObjectBuilder frozen(@Nullable Boolean frozen) {
                this.frozen = frozen;
                return this;
            }

            public ChannelRequestObjectBuilder member(ChannelMemberRequestObject member) {
                if (this.members == null) {
                    this.members = new ArrayList();
                }
                this.members.add(member);
                return this;
            }

            @JsonProperty(value="members")
            public ChannelRequestObjectBuilder members(Collection<? extends ChannelMemberRequestObject> members) {
                if (members == null) {
                    throw new NullPointerException("members cannot be null");
                }
                if (this.members == null) {
                    this.members = new ArrayList();
                }
                this.members.addAll(members);
                return this;
            }

            public ChannelRequestObjectBuilder clearMembers() {
                if (this.members != null) {
                    this.members.clear();
                }
                return this;
            }

            public ChannelRequestObjectBuilder invite(ChannelMemberRequestObject invite) {
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.add(invite);
                return this;
            }

            @JsonProperty(value="invites")
            public ChannelRequestObjectBuilder invites(Collection<? extends ChannelMemberRequestObject> invites) {
                if (invites == null) {
                    throw new NullPointerException("invites cannot be null");
                }
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.addAll(invites);
                return this;
            }

            public ChannelRequestObjectBuilder clearInvites() {
                if (this.invites != null) {
                    this.invites.clear();
                }
                return this;
            }

            @JsonProperty(value="config_overrides")
            public ChannelRequestObjectBuilder configOverrides(@Nullable ConfigOverridesRequestObject configOverrides) {
                this.configOverrides = configOverrides;
                return this;
            }

            public ChannelRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public ChannelRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public ChannelRequestObject build() {
                Map<String, Object> additionalFields;
                List<ChannelMemberRequestObject> invites;
                List<ChannelMemberRequestObject> members;
                switch (this.members == null ? 0 : this.members.size()) {
                    case 0: {
                        members = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        members = Collections.singletonList(this.members.get(0));
                        break;
                    }
                    default: {
                        members = Collections.unmodifiableList(new ArrayList<ChannelMemberRequestObject>(this.members));
                    }
                }
                switch (this.invites == null ? 0 : this.invites.size()) {
                    case 0: {
                        invites = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        invites = Collections.singletonList(this.invites.get(0));
                        break;
                    }
                    default: {
                        invites = Collections.unmodifiableList(new ArrayList<ChannelMemberRequestObject>(this.invites));
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new ChannelRequestObject(this.createdBy, this.team, this.autoTranslationEnabled, this.autoTranslationLanguage, this.frozen, members, invites, this.configOverrides, additionalFields);
            }

            public String toString() {
                return "Channel.ChannelRequestObject.ChannelRequestObjectBuilder(createdBy=" + this.createdBy + ", team=" + this.team + ", autoTranslationEnabled=" + this.autoTranslationEnabled + ", autoTranslationLanguage=" + this.autoTranslationLanguage + ", frozen=" + this.frozen + ", members=" + this.members + ", invites=" + this.invites + ", configOverrides=" + this.configOverrides + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class RoleAssignment {
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        @Nullable
        public String getChannelRole() {
            return this.channelRole;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleAssignment)) {
                return false;
            }
            RoleAssignment other = (RoleAssignment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelRole = this.getChannelRole();
            String other$channelRole = other.getChannelRole();
            if (this$channelRole == null ? other$channelRole != null : !this$channelRole.equals(other$channelRole)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoleAssignment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelRole = this.getChannelRole();
            result = result * 59 + ($channelRole == null ? 43 : $channelRole.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public String toString() {
            return "Channel.RoleAssignment(channelRole=" + this.getChannelRole() + ", userId=" + this.getUserId() + ")";
        }
    }

    public static class ChannelMember {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="is_moderator")
        @Nullable
        private Boolean isModerator;
        @JsonProperty(value="invited")
        @Nullable
        private Boolean invited;
        @JsonProperty(value="invite_accepted_at")
        @Nullable
        private Date inviteAcceptedAt;
        @JsonProperty(value="invite_rejected_at")
        @Nullable
        private Date inviteRejectedAt;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="ban_expires")
        @Nullable
        private String banExpires;
        @JsonProperty(value="shadow_banned")
        @Nullable
        private Boolean shadowBanned;

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Boolean getIsModerator() {
            return this.isModerator;
        }

        @Nullable
        public Boolean getInvited() {
            return this.invited;
        }

        @Nullable
        public Date getInviteAcceptedAt() {
            return this.inviteAcceptedAt;
        }

        @Nullable
        public Date getInviteRejectedAt() {
            return this.inviteRejectedAt;
        }

        @Nullable
        public String getRole() {
            return this.role;
        }

        @Nullable
        public String getChannelRole() {
            return this.channelRole;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public Boolean getBanned() {
            return this.banned;
        }

        @Nullable
        public String getBanExpires() {
            return this.banExpires;
        }

        @Nullable
        public Boolean getShadowBanned() {
            return this.shadowBanned;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="is_moderator")
        public void setIsModerator(@Nullable Boolean isModerator) {
            this.isModerator = isModerator;
        }

        @JsonProperty(value="invited")
        public void setInvited(@Nullable Boolean invited) {
            this.invited = invited;
        }

        @JsonProperty(value="invite_accepted_at")
        public void setInviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
            this.inviteAcceptedAt = inviteAcceptedAt;
        }

        @JsonProperty(value="invite_rejected_at")
        public void setInviteRejectedAt(@Nullable Date inviteRejectedAt) {
            this.inviteRejectedAt = inviteRejectedAt;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="ban_expires")
        public void setBanExpires(@Nullable String banExpires) {
            this.banExpires = banExpires;
        }

        @JsonProperty(value="shadow_banned")
        public void setShadowBanned(@Nullable Boolean shadowBanned) {
            this.shadowBanned = shadowBanned;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMember)) {
                return false;
            }
            ChannelMember other = (ChannelMember)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isModerator = this.getIsModerator();
            Boolean other$isModerator = other.getIsModerator();
            if (this$isModerator == null ? other$isModerator != null : !((Object)this$isModerator).equals(other$isModerator)) {
                return false;
            }
            Boolean this$invited = this.getInvited();
            Boolean other$invited = other.getInvited();
            if (this$invited == null ? other$invited != null : !((Object)this$invited).equals(other$invited)) {
                return false;
            }
            Boolean this$banned = this.getBanned();
            Boolean other$banned = other.getBanned();
            if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
                return false;
            }
            Boolean this$shadowBanned = this.getShadowBanned();
            Boolean other$shadowBanned = other.getShadowBanned();
            if (this$shadowBanned == null ? other$shadowBanned != null : !((Object)this$shadowBanned).equals(other$shadowBanned)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$inviteAcceptedAt = this.getInviteAcceptedAt();
            Date other$inviteAcceptedAt = other.getInviteAcceptedAt();
            if (this$inviteAcceptedAt == null ? other$inviteAcceptedAt != null : !((Object)this$inviteAcceptedAt).equals(other$inviteAcceptedAt)) {
                return false;
            }
            Date this$inviteRejectedAt = this.getInviteRejectedAt();
            Date other$inviteRejectedAt = other.getInviteRejectedAt();
            if (this$inviteRejectedAt == null ? other$inviteRejectedAt != null : !((Object)this$inviteRejectedAt).equals(other$inviteRejectedAt)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$channelRole = this.getChannelRole();
            String other$channelRole = other.getChannelRole();
            if (this$channelRole == null ? other$channelRole != null : !this$channelRole.equals(other$channelRole)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            String this$banExpires = this.getBanExpires();
            String other$banExpires = other.getBanExpires();
            return !(this$banExpires == null ? other$banExpires != null : !this$banExpires.equals(other$banExpires));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMember;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isModerator = this.getIsModerator();
            result = result * 59 + ($isModerator == null ? 43 : ((Object)$isModerator).hashCode());
            Boolean $invited = this.getInvited();
            result = result * 59 + ($invited == null ? 43 : ((Object)$invited).hashCode());
            Boolean $banned = this.getBanned();
            result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
            Boolean $shadowBanned = this.getShadowBanned();
            result = result * 59 + ($shadowBanned == null ? 43 : ((Object)$shadowBanned).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $inviteAcceptedAt = this.getInviteAcceptedAt();
            result = result * 59 + ($inviteAcceptedAt == null ? 43 : ((Object)$inviteAcceptedAt).hashCode());
            Date $inviteRejectedAt = this.getInviteRejectedAt();
            result = result * 59 + ($inviteRejectedAt == null ? 43 : ((Object)$inviteRejectedAt).hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $channelRole = this.getChannelRole();
            result = result * 59 + ($channelRole == null ? 43 : $channelRole.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            String $banExpires = this.getBanExpires();
            result = result * 59 + ($banExpires == null ? 43 : $banExpires.hashCode());
            return result;
        }

        public String toString() {
            return "Channel.ChannelMember(userId=" + this.getUserId() + ", user=" + this.getUser() + ", isModerator=" + this.getIsModerator() + ", invited=" + this.getInvited() + ", inviteAcceptedAt=" + this.getInviteAcceptedAt() + ", inviteRejectedAt=" + this.getInviteRejectedAt() + ", role=" + this.getRole() + ", channelRole=" + this.getChannelRole() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", banned=" + this.getBanned() + ", banExpires=" + this.getBanExpires() + ", shadowBanned=" + this.getShadowBanned() + ")";
        }
    }

    public static class ChannelRead {
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="last_read")
        @Nullable
        private Date lastRead;
        @JsonProperty(value="unread_messages")
        @Nullable
        private Integer unreadMessages;

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Date getLastRead() {
            return this.lastRead;
        }

        @Nullable
        public Integer getUnreadMessages() {
            return this.unreadMessages;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="last_read")
        public void setLastRead(@Nullable Date lastRead) {
            this.lastRead = lastRead;
        }

        @JsonProperty(value="unread_messages")
        public void setUnreadMessages(@Nullable Integer unreadMessages) {
            this.unreadMessages = unreadMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelRead)) {
                return false;
            }
            ChannelRead other = (ChannelRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$unreadMessages = this.getUnreadMessages();
            Integer other$unreadMessages = other.getUnreadMessages();
            if (this$unreadMessages == null ? other$unreadMessages != null : !((Object)this$unreadMessages).equals(other$unreadMessages)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$lastRead = this.getLastRead();
            Date other$lastRead = other.getLastRead();
            return !(this$lastRead == null ? other$lastRead != null : !((Object)this$lastRead).equals(other$lastRead));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelRead;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $unreadMessages = this.getUnreadMessages();
            result = result * 59 + ($unreadMessages == null ? 43 : ((Object)$unreadMessages).hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $lastRead = this.getLastRead();
            result = result * 59 + ($lastRead == null ? 43 : ((Object)$lastRead).hashCode());
            return result;
        }

        public String toString() {
            return "Channel.ChannelRead(user=" + this.getUser() + ", lastRead=" + this.getLastRead() + ", unreadMessages=" + this.getUnreadMessages() + ")";
        }
    }
}

