/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services;

import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.framework.ToJson;
import java.util.Date;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface MessageService {
    @POST(value="channels/{type}/{id}/message")
    public Call<Message.MessageSendResponse> send(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Message.MessageSendRequestData var3);

    @POST(value="messages/{id}")
    public Call<Message.MessageUpdateResponse> update(@Path(value="id") @NotNull String var1, @Body @NotNull Message.MessageUpdateRequestData var2);

    @GET(value="search")
    public Call<Message.MessageSearchResponse> search(@ToJson @Query(value="payload") @NotNull Message.MessageSearchRequestData var1);

    @POST(value="messages/{id}/commit")
    public Call<Message.MessageCommitResponse> commit(@Path(value="id") @NotNull String var1);

    @Multipart
    @Headers(value={"X-Stream-LogRequestBody: false"})
    @POST(value="channels/{type}/{id}/file")
    public Call<Message.MessageUploadFileResponse> uploadFile(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Part(value="user") @NotNull RequestBody var3, @Part @NotNull MultipartBody.Part var4);

    @Multipart
    @Headers(value={"X-Stream-LogRequestBody: false"})
    @POST(value="channels/{type}/{id}/image")
    public Call<Message.MessageUploadImageResponse> uploadImage(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Part(value="user") @NotNull RequestBody var3, @Part @NotNull MultipartBody.Part var4, @Part(value="upload_sizes") @NotNull RequestBody var5);

    @DELETE(value="channels/{type}/{id}/file")
    public Call<StreamResponseObject> deleteFile(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Query(value="url") @NotNull String var3);

    @DELETE(value="channels/{type}/{id}/image")
    public Call<StreamResponseObject> deleteImage(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Query(value="url") @NotNull String var3);

    @DELETE(value="messages/{id}")
    public Call<Message.MessageDeleteResponse> delete(@Path(value="id") @NotNull String var1, @Query(value="hard") @Nullable Boolean var2);

    @GET(value="messages/{id}")
    public Call<Message.MessageGetResponse> get(@Path(value="id") @NotNull String var1, @Query(value="show_deleted_message") @Nullable Boolean var2);

    @GET(value="channels/{type}/{id}/messages")
    public Call<Message.MessageGetManyResponse> getMany(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Query(value="ids") @NotNull String var3);

    @GET(value="messages/{parent_id}/replies")
    public Call<Message.MessageGetRepliesResponse> getReplies(@Path(value="parent_id") @NotNull String var1, @Query(value="id_gte") @Nullable String var2, @Query(value="id_gt") @Nullable String var3, @Query(value="id_lte") @Nullable String var4, @Query(value="id_lt") @Nullable String var5, @Query(value="created_at_after_or_equal") @Nullable Date var6, @Query(value="created_at_after") @Nullable Date var7, @Query(value="created_at_before_or_equal") @Nullable Date var8, @Query(value="created_at_before") @Nullable Date var9);

    @POST(value="messages/{id}/action")
    public Call<Message.MessageRunCommandActionResponse> runCommandAction(@Path(value="id") @NotNull String var1, @Body @NotNull Message.MessageRunCommandActionRequestData var2);

    @POST(value="messages/{id}/translate")
    public Call<Message.MessageTranslateResponse> translate(@Path(value="id") @NotNull String var1, @Body @NotNull Message.MessageTranslateRequestData var2);

    @PUT(value="messages/{id}")
    public Call<Message.MessagePartialUpdateResponse> partialUpdate(@Path(value="id") @NotNull String var1, @Body @NotNull Message.MessagePartialUpdateRequestData var2);

    @POST(value="moderation/unblock_message")
    public Call<StreamResponseObject> unblockMessage(@Body @NotNull Message.MessageUnblockRequestData var1);
}

