/*
 * Copyright (c) 2014-2022 Stream.io Inc. All rights reserved.
 *
 * Licensed under the Stream License;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://github.com/GetStream/stream-chat-android/blob/main/LICENSE
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.getstream.chat.android.uiutils.model

/**
 * Represents MIME types of attachments.
 */
public object MimeType {
    public const val MIME_TYPE_VND: String = "application/vnd"
    public const val MIME_TYPE_7Z: String = "application/x-7z-compressed"
    public const val MIME_TYPE_CSV: String = "text/comma-separated-values"
    public const val MIME_TYPE_DOC: String = "application/msword"
    public const val MIME_TYPE_DOCX: String = "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
    public const val MIME_TYPE_HTML: String = "text/html"
    public const val MIME_TYPE_MD: String = "text/markdown"
    public const val MIME_TYPE_ODT: String = "application/vnd.oasis.opendocument.text"
    public const val MIME_TYPE_PDF: String = "application/pdf"
    public const val MIME_TYPE_PPT: String = "application/vnd.ms-powerpoint"
    public const val MIME_TYPE_PPTX: String =
        "application/vnd.openxmlformats-officedocument.presentationml.presentation"
    public const val MIME_TYPE_RAR: String = "application/vnd.rar"
    public const val MIME_TYPE_RTF: String = "application/rtf"
    public const val MIME_TYPE_TAR: String = "application/tar"
    public const val MIME_TYPE_TXT: String = "text/plain"
    public const val MIME_TYPE_XLS: String = "application/vnd.ms-excel"
    public const val MIME_TYPE_XLSX: String = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    public const val MIME_TYPE_ZIP: String = "application/zip"
    public const val MIME_TYPE_MOV: String = "video/mov"
    public const val MIME_TYPE_QUICKTIME: String = "quicktime"
    public const val MIME_TYPE_VIDEO_QUICKTIME: String = "video/quicktime"
    public const val MIME_TYPE_MP4: String = "mp4"
    public const val MIME_TYPE_VIDEO_MP4: String = "video/mp4"
    public const val MIME_TYPE_AUDIO_MP4: String = "audio/mp4"
    public const val MIME_TYPE_MP3: String = "audio/mp3"
    public const val MIME_TYPE_AAC: String = "audio/aac"
    public const val MIME_TYPE_M4A: String = "audio/m4a"
    public const val MIME_TYPE_GIF: String = "image/gif"
}
