package io.getstream.chat.android.offline.repository.domain.user.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserDao_Impl implements UserDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;

  private final DateConverter __dateConverter = new DateConverter();

  private final ListConverter __listConverter = new ListConverter();

  private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public UserDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_chat_user` (`id`,`originalId`,`name`,`image`,`role`,`createdAt`,`updatedAt`,`lastActive`,`invisible`,`banned`,`mutes`,`extraData`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getId());
        }
        if (value.getOriginalId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getOriginalId());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getImage() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getImage());
        }
        if (value.getRole() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getRole());
        }
        final Long _tmp = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindLong(6, _tmp);
        }
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_1 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindLong(7, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getLastActive());
        if (_tmp_2 == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, _tmp_2);
        }
        final int _tmp_3 = value.getInvisible() ? 1 : 0;
        stmt.bindLong(9, _tmp_3);
        final int _tmp_4 = value.getBanned() ? 1 : 0;
        stmt.bindLong(10, _tmp_4);
        final String _tmp_5 = __listConverter.stringListToString(value.getMutes());
        if (_tmp_5 == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, _tmp_5);
        }
        final String _tmp_6 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_6 == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, _tmp_6);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_chat_user";
        return _query;
      }
    };
  }

  @Override
  public Object insertMany(final List<UserEntity> users,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserEntity.insert(users);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insert(final UserEntity userEntity, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserEntity.insert(userEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final List<String> ids,
      final Continuation<? super List<UserEntity>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM stream_chat_user WHERE stream_chat_user.id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : ids) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserEntity>>() {
      @Override
      public List<UserEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow(_cursor, "originalId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActive");
          final int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow(_cursor, "invisible");
          final int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow(_cursor, "banned");
          final int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow(_cursor, "mutes");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final List<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UserEntity _item_1;
            final String _tmpId;
            if (_cursor.isNull(_cursorIndexOfId)) {
              _tmpId = null;
            } else {
              _tmpId = _cursor.getString(_cursorIndexOfId);
            }
            final String _tmpOriginalId;
            if (_cursor.isNull(_cursorIndexOfOriginalId)) {
              _tmpOriginalId = null;
            } else {
              _tmpOriginalId = _cursor.getString(_cursorIndexOfOriginalId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final String _tmpRole;
            if (_cursor.isNull(_cursorIndexOfRole)) {
              _tmpRole = null;
            } else {
              _tmpRole = _cursor.getString(_cursorIndexOfRole);
            }
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpUpdatedAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpLastActive;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfLastActive)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfLastActive);
            }
            _tmpLastActive = __dateConverter.fromTimestamp(_tmp_2);
            final boolean _tmpInvisible;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
            _tmpInvisible = _tmp_3 != 0;
            final boolean _tmpBanned;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
            _tmpBanned = _tmp_4 != 0;
            final List<String> _tmpMutes;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMutes)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfMutes);
            }
            final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpMutes = _tmp_6;
            }
            final Map<String, Object> _tmpExtraData;
            final String _tmp_7;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_7 = null;
            } else {
              _tmp_7 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_8 = __extraDataConverter.stringToMap(_tmp_7);
            if(_tmp_8 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_8;
            }
            _item_1 = new UserEntity(_tmpId,_tmpOriginalId,_tmpName,_tmpImage,_tmpRole,_tmpCreatedAt,_tmpUpdatedAt,_tmpLastActive,_tmpInvisible,_tmpBanned,_tmpMutes,_tmpExtraData);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final String id, final Continuation<? super UserEntity> continuation) {
    final String _sql = "SELECT * FROM stream_chat_user WHERE stream_chat_user.id IN (?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<UserEntity>() {
      @Override
      public UserEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow(_cursor, "originalId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActive");
          final int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow(_cursor, "invisible");
          final int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow(_cursor, "banned");
          final int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow(_cursor, "mutes");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final UserEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpId;
            if (_cursor.isNull(_cursorIndexOfId)) {
              _tmpId = null;
            } else {
              _tmpId = _cursor.getString(_cursorIndexOfId);
            }
            final String _tmpOriginalId;
            if (_cursor.isNull(_cursorIndexOfOriginalId)) {
              _tmpOriginalId = null;
            } else {
              _tmpOriginalId = _cursor.getString(_cursorIndexOfOriginalId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final String _tmpRole;
            if (_cursor.isNull(_cursorIndexOfRole)) {
              _tmpRole = null;
            } else {
              _tmpRole = _cursor.getString(_cursorIndexOfRole);
            }
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpUpdatedAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpLastActive;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfLastActive)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfLastActive);
            }
            _tmpLastActive = __dateConverter.fromTimestamp(_tmp_2);
            final boolean _tmpInvisible;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
            _tmpInvisible = _tmp_3 != 0;
            final boolean _tmpBanned;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
            _tmpBanned = _tmp_4 != 0;
            final List<String> _tmpMutes;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMutes)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfMutes);
            }
            final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpMutes = _tmp_6;
            }
            final Map<String, Object> _tmpExtraData;
            final String _tmp_7;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_7 = null;
            } else {
              _tmp_7 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_8 = __extraDataConverter.stringToMap(_tmp_7);
            if(_tmp_8 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_8;
            }
            _result = new UserEntity(_tmpId,_tmpOriginalId,_tmpName,_tmpImage,_tmpRole,_tmpCreatedAt,_tmpUpdatedAt,_tmpLastActive,_tmpInvisible,_tmpBanned,_tmpMutes,_tmpExtraData);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<UserEntity> selectAllUser(final int limit, final int offset) {
    final String _sql = "SELECT * FROM stream_chat_user ORDER BY name ASC LIMIT ? OFFSET ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    _argIndex = 2;
    _statement.bindLong(_argIndex, offset);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow(_cursor, "originalId");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
      final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
      final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
      final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
      final int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActive");
      final int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow(_cursor, "invisible");
      final int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow(_cursor, "banned");
      final int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow(_cursor, "mutes");
      final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
      final List<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final UserEntity _item;
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpOriginalId;
        if (_cursor.isNull(_cursorIndexOfOriginalId)) {
          _tmpOriginalId = null;
        } else {
          _tmpOriginalId = _cursor.getString(_cursorIndexOfOriginalId);
        }
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpImage;
        if (_cursor.isNull(_cursorIndexOfImage)) {
          _tmpImage = null;
        } else {
          _tmpImage = _cursor.getString(_cursorIndexOfImage);
        }
        final String _tmpRole;
        if (_cursor.isNull(_cursorIndexOfRole)) {
          _tmpRole = null;
        } else {
          _tmpRole = _cursor.getString(_cursorIndexOfRole);
        }
        final Date _tmpCreatedAt;
        final Long _tmp;
        if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
        }
        _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
        final Date _tmpUpdatedAt;
        final Long _tmp_1;
        if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getLong(_cursorIndexOfUpdatedAt);
        }
        _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_1);
        final Date _tmpLastActive;
        final Long _tmp_2;
        if (_cursor.isNull(_cursorIndexOfLastActive)) {
          _tmp_2 = null;
        } else {
          _tmp_2 = _cursor.getLong(_cursorIndexOfLastActive);
        }
        _tmpLastActive = __dateConverter.fromTimestamp(_tmp_2);
        final boolean _tmpInvisible;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
        _tmpInvisible = _tmp_3 != 0;
        final boolean _tmpBanned;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
        _tmpBanned = _tmp_4 != 0;
        final List<String> _tmpMutes;
        final String _tmp_5;
        if (_cursor.isNull(_cursorIndexOfMutes)) {
          _tmp_5 = null;
        } else {
          _tmp_5 = _cursor.getString(_cursorIndexOfMutes);
        }
        final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
        if(_tmp_6 == null) {
          throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
        } else {
          _tmpMutes = _tmp_6;
        }
        final Map<String, Object> _tmpExtraData;
        final String _tmp_7;
        if (_cursor.isNull(_cursorIndexOfExtraData)) {
          _tmp_7 = null;
        } else {
          _tmp_7 = _cursor.getString(_cursorIndexOfExtraData);
        }
        final Map<String, Object> _tmp_8 = __extraDataConverter.stringToMap(_tmp_7);
        if(_tmp_8 == null) {
          throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
        } else {
          _tmpExtraData = _tmp_8;
        }
        _item = new UserEntity(_tmpId,_tmpOriginalId,_tmpName,_tmpImage,_tmpRole,_tmpCreatedAt,_tmpUpdatedAt,_tmpLastActive,_tmpInvisible,_tmpBanned,_tmpMutes,_tmpExtraData);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<UserEntity> selectUsersLikeName(final String searchString, final int limit,
      final int offset) {
    final String _sql = "SELECT * FROM stream_chat_user WHERE name LIKE ? ORDER BY name ASC LIMIT ? OFFSET ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    if (searchString == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchString);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    _argIndex = 3;
    _statement.bindLong(_argIndex, offset);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow(_cursor, "originalId");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
      final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
      final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
      final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
      final int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActive");
      final int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow(_cursor, "invisible");
      final int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow(_cursor, "banned");
      final int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow(_cursor, "mutes");
      final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
      final List<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final UserEntity _item;
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpOriginalId;
        if (_cursor.isNull(_cursorIndexOfOriginalId)) {
          _tmpOriginalId = null;
        } else {
          _tmpOriginalId = _cursor.getString(_cursorIndexOfOriginalId);
        }
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpImage;
        if (_cursor.isNull(_cursorIndexOfImage)) {
          _tmpImage = null;
        } else {
          _tmpImage = _cursor.getString(_cursorIndexOfImage);
        }
        final String _tmpRole;
        if (_cursor.isNull(_cursorIndexOfRole)) {
          _tmpRole = null;
        } else {
          _tmpRole = _cursor.getString(_cursorIndexOfRole);
        }
        final Date _tmpCreatedAt;
        final Long _tmp;
        if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
        }
        _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
        final Date _tmpUpdatedAt;
        final Long _tmp_1;
        if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getLong(_cursorIndexOfUpdatedAt);
        }
        _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_1);
        final Date _tmpLastActive;
        final Long _tmp_2;
        if (_cursor.isNull(_cursorIndexOfLastActive)) {
          _tmp_2 = null;
        } else {
          _tmp_2 = _cursor.getLong(_cursorIndexOfLastActive);
        }
        _tmpLastActive = __dateConverter.fromTimestamp(_tmp_2);
        final boolean _tmpInvisible;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
        _tmpInvisible = _tmp_3 != 0;
        final boolean _tmpBanned;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
        _tmpBanned = _tmp_4 != 0;
        final List<String> _tmpMutes;
        final String _tmp_5;
        if (_cursor.isNull(_cursorIndexOfMutes)) {
          _tmp_5 = null;
        } else {
          _tmp_5 = _cursor.getString(_cursorIndexOfMutes);
        }
        final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
        if(_tmp_6 == null) {
          throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
        } else {
          _tmpMutes = _tmp_6;
        }
        final Map<String, Object> _tmpExtraData;
        final String _tmp_7;
        if (_cursor.isNull(_cursorIndexOfExtraData)) {
          _tmp_7 = null;
        } else {
          _tmp_7 = _cursor.getString(_cursorIndexOfExtraData);
        }
        final Map<String, Object> _tmp_8 = __extraDataConverter.stringToMap(_tmp_7);
        if(_tmp_8 == null) {
          throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
        } else {
          _tmpExtraData = _tmp_8;
        }
        _item = new UserEntity(_tmpId,_tmpOriginalId,_tmpName,_tmpImage,_tmpRole,_tmpCreatedAt,_tmpUpdatedAt,_tmpLastActive,_tmpInvisible,_tmpBanned,_tmpMutes,_tmpExtraData);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
