package io.getstream.chat.android.offline.repository.domain.reaction.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SyncStatusConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ReactionDao_Impl implements ReactionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;

  private final DateConverter __dateConverter = new DateConverter();

  private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();

  private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();

  private final EntityDeletionOrUpdateAdapter<ReactionEntity> __deletionAdapterOfReactionEntity;

  private final SharedSQLiteStatement __preparedStmtOfSetDeleteAt;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public ReactionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_chat_reaction` (`messageId`,`userId`,`type`,`score`,`createdAt`,`createdLocallyAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
        if (value.getMessageId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getMessageId());
        }
        if (value.getUserId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUserId());
        }
        if (value.getType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getType());
        }
        stmt.bindLong(4, value.getScore());
        final Long _tmp = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindLong(5, _tmp);
        }
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
        if (_tmp_1 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindLong(6, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_2 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindLong(7, _tmp_2);
        }
        final Long _tmp_3 = __dateConverter.dateToTimestamp(value.getDeletedAt());
        if (_tmp_3 == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, _tmp_3);
        }
        final int _tmp_4 = value.getEnforceUnique() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        final String _tmp_5 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_5 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, _tmp_5);
        }
        final int _tmp_6 = __syncStatusConverter.syncStatusToString(value.getSyncStatus());
        stmt.bindLong(11, _tmp_6);
        stmt.bindLong(12, value.getId());
      }
    };
    this.__deletionAdapterOfReactionEntity = new EntityDeletionOrUpdateAdapter<ReactionEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `stream_chat_reaction` WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
        stmt.bindLong(1, value.getId());
      }
    };
    this.__preparedStmtOfSetDeleteAt = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE stream_chat_reaction SET deletedAt = ? WHERE userId = ? AND messageId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_chat_reaction";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final ReactionEntity reactionEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfReactionEntity.insert(reactionEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object delete(final ReactionEntity reactionEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfReactionEntity.handle(reactionEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object setDeleteAt(final String userId, final String messageId, final Date deletedAt,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetDeleteAt.acquire();
        int _argIndex = 1;
        final Long _tmp = __dateConverter.dateToTimestamp(deletedAt);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindLong(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (userId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 3;
        if (messageId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, messageId);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetDeleteAt.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object selectReactionById(final int id,
      final Continuation<? super ReactionEntity> continuation) {
    final String _sql = "SELECT * FROM stream_chat_reaction WHERE id = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ReactionEntity>() {
      @Override
      public ReactionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow(_cursor, "score");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow(_cursor, "enforceUnique");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final ReactionEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final int _tmpScore;
            _tmpScore = _cursor.getInt(_cursorIndexOfScore);
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpCreatedLocallyAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
            }
            _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpUpdatedAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_2);
            final Date _tmpDeletedAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_3);
            final boolean _tmpEnforceUnique;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
            _tmpEnforceUnique = _tmp_4 != 0;
            final Map<String, Object> _tmpExtraData;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_6 = __extraDataConverter.stringToMap(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_6;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_7);
            _result = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            _result.setId(_tmpId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectReactionsByIds(final List<Integer> ids,
      final Continuation<? super List<ReactionEntity>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM stream_chat_reaction WHERE id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (int _item : ids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ReactionEntity>>() {
      @Override
      public List<ReactionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow(_cursor, "score");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow(_cursor, "enforceUnique");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final List<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ReactionEntity _item_1;
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final int _tmpScore;
            _tmpScore = _cursor.getInt(_cursorIndexOfScore);
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpCreatedLocallyAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
            }
            _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpUpdatedAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_2);
            final Date _tmpDeletedAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_3);
            final boolean _tmpEnforceUnique;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
            _tmpEnforceUnique = _tmp_4 != 0;
            final Map<String, Object> _tmpExtraData;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_6 = __extraDataConverter.stringToMap(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_6;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_7);
            _item_1 = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            _item_1.setId(_tmpId);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectIdsSyncStatus(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<Integer>> continuation) {
    final String _sql = "SELECT id FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Integer>>() {
      @Override
      public List<Integer> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Integer> _result = new ArrayList<Integer>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Integer _item;
            _item = _cursor.getInt(0);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectSyncStatus(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<ReactionEntity>> continuation) {
    final String _sql = "SELECT * FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ReactionEntity>>() {
      @Override
      public List<ReactionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow(_cursor, "score");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow(_cursor, "enforceUnique");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final List<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ReactionEntity _item;
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final int _tmpScore;
            _tmpScore = _cursor.getInt(_cursorIndexOfScore);
            final Date _tmpCreatedAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpCreatedLocallyAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
            }
            _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_2);
            final Date _tmpUpdatedAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_3);
            final Date _tmpDeletedAt;
            final Long _tmp_4;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_4);
            final boolean _tmpEnforceUnique;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfEnforceUnique);
            _tmpEnforceUnique = _tmp_5 != 0;
            final Map<String, Object> _tmpExtraData;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_7 = __extraDataConverter.stringToMap(_tmp_6);
            if(_tmp_7 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_7;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_8;
            _tmp_8 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_8);
            _item = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            _item.setId(_tmpId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectUserReactionToMessage(final String reactionType, final String messageId,
      final String userId, final Continuation<? super ReactionEntity> continuation) {
    final String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.type = ? AND stream_chat_reaction.messageid = ? AND userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    if (reactionType == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, reactionType);
    }
    _argIndex = 2;
    if (messageId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, messageId);
    }
    _argIndex = 3;
    if (userId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, userId);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ReactionEntity>() {
      @Override
      public ReactionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow(_cursor, "score");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow(_cursor, "enforceUnique");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final ReactionEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final int _tmpScore;
            _tmpScore = _cursor.getInt(_cursorIndexOfScore);
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpCreatedLocallyAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
            }
            _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpUpdatedAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_2);
            final Date _tmpDeletedAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_3);
            final boolean _tmpEnforceUnique;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
            _tmpEnforceUnique = _tmp_4 != 0;
            final Map<String, Object> _tmpExtraData;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_6 = __extraDataConverter.stringToMap(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_6;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_7);
            _result = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            _result.setId(_tmpId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectUserReactionsToMessage(final String messageId, final String userId,
      final Continuation<? super List<ReactionEntity>> continuation) {
    final String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.messageid = ? AND userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (messageId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, messageId);
    }
    _argIndex = 2;
    if (userId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, userId);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ReactionEntity>>() {
      @Override
      public List<ReactionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow(_cursor, "score");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow(_cursor, "enforceUnique");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final List<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ReactionEntity _item;
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final int _tmpScore;
            _tmpScore = _cursor.getInt(_cursorIndexOfScore);
            final Date _tmpCreatedAt;
            final Long _tmp;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
            final Date _tmpCreatedLocallyAt;
            final Long _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
            }
            _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_1);
            final Date _tmpUpdatedAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_2);
            final Date _tmpDeletedAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_3);
            final boolean _tmpEnforceUnique;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
            _tmpEnforceUnique = _tmp_4 != 0;
            final Map<String, Object> _tmpExtraData;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_6 = __extraDataConverter.stringToMap(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_6;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_7);
            _item = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            _item.setId(_tmpId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
