package io.getstream.chat.android.offline.repository.domain.queryChannels.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.querysort.QuerySorter;
import io.getstream.chat.android.offline.repository.database.converter.internal.FilterObjectConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.QuerySortConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class QueryChannelsDao_Impl implements QueryChannelsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<QueryChannelsEntity> __insertionAdapterOfQueryChannelsEntity;

  private final FilterObjectConverter __filterObjectConverter = new FilterObjectConverter();

  private final QuerySortConverter __querySortConverter = new QuerySortConverter();

  private final ListConverter __listConverter = new ListConverter();

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public QueryChannelsDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfQueryChannelsEntity = new EntityInsertionAdapter<QueryChannelsEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_channel_query` (`id`,`filter`,`querySort`,`cids`) VALUES (?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, QueryChannelsEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getId());
        }
        final String _tmp = __filterObjectConverter.objectToString(value.getFilter());
        if (_tmp == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp);
        }
        final String _tmp_1 = __querySortConverter.objectToString(value.getQuerySort());
        if (_tmp_1 == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, _tmp_1);
        }
        final String _tmp_2 = __listConverter.stringListToString(value.getCids());
        if (_tmp_2 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_2);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_channel_query";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final QueryChannelsEntity queryChannelsEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfQueryChannelsEntity.insert(queryChannelsEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final String id,
      final Continuation<? super QueryChannelsEntity> continuation) {
    final String _sql = "SELECT * FROM stream_channel_query WHERE stream_channel_query.id=?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<QueryChannelsEntity>() {
      @Override
      public QueryChannelsEntity call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfFilter = CursorUtil.getColumnIndexOrThrow(_cursor, "filter");
            final int _cursorIndexOfQuerySort = CursorUtil.getColumnIndexOrThrow(_cursor, "querySort");
            final int _cursorIndexOfCids = CursorUtil.getColumnIndexOrThrow(_cursor, "cids");
            final QueryChannelsEntity _result;
            if(_cursor.moveToFirst()) {
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final FilterObject _tmpFilter;
              final String _tmp;
              if (_cursor.isNull(_cursorIndexOfFilter)) {
                _tmp = null;
              } else {
                _tmp = _cursor.getString(_cursorIndexOfFilter);
              }
              final FilterObject _tmp_1 = __filterObjectConverter.stringToObject(_tmp);
              if(_tmp_1 == null) {
                throw new IllegalStateException("Expected non-null io.getstream.chat.android.models.FilterObject, but it was null.");
              } else {
                _tmpFilter = _tmp_1;
              }
              final QuerySorter<Channel> _tmpQuerySort;
              final String _tmp_2;
              if (_cursor.isNull(_cursorIndexOfQuerySort)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getString(_cursorIndexOfQuerySort);
              }
              _tmpQuerySort = __querySortConverter.stringToObject(_tmp_2);
              final List<String> _tmpCids;
              final String _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCids)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getString(_cursorIndexOfCids);
              }
              final List<String> _tmp_4 = __listConverter.stringToStringList(_tmp_3);
              if(_tmp_4 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpCids = _tmp_4;
              }
              _result = new QueryChannelsEntity(_tmpId,_tmpFilter,_tmpQuerySort,_tmpCids);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
