package io.getstream.chat.android.offline.repository.domain.message.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MapConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ModerationDetailsConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SyncStatusConverter;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentEntity;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.UploadStateEntity;
import io.getstream.chat.android.offline.repository.domain.message.channelinfo.internal.ChannelInfoEntity;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MessageDao_Impl implements MessageDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<MessageInnerEntity> __insertionAdapterOfMessageInnerEntity;

  private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();

  private final DateConverter __dateConverter = new DateConverter();

  private final ListConverter __listConverter = new ListConverter();

  private final MapConverter __mapConverter = new MapConverter();

  private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();

  private final ModerationDetailsConverter __moderationDetailsConverter = new ModerationDetailsConverter();

  private final EntityInsertionAdapter<AttachmentEntity> __insertionAdapterOfAttachmentEntity;

  private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;

  private final EntityDeletionOrUpdateAdapter<MessageInnerEntity> __updateAdapterOfMessageInnerEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteChannelMessagesBefore;

  private final SharedSQLiteStatement __preparedStmtOfDeleteMessage;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public MessageDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMessageInnerEntity = new EntityInsertionAdapter<MessageInnerEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `stream_chat_message` (`id`,`cid`,`userId`,`text`,`html`,`type`,`syncStatus`,`replyCount`,`deletedReplyCount`,`createdAt`,`createdLocallyAt`,`updatedAt`,`updatedLocallyAt`,`deletedAt`,`remoteMentionedUserIds`,`mentionedUsersId`,`reactionCounts`,`reactionScores`,`parentId`,`command`,`shadowed`,`i18n`,`showInChannel`,`silent`,`extraData`,`replyToId`,`pinned`,`pinnedAt`,`pinExpires`,`pinnedByUserId`,`threadParticipantsIds`,`skipPushNotification`,`skipEnrichUrl`,`moderationDetails`,`channel_infocid`,`channel_infoid`,`channel_infotype`,`channel_infomemberCount`,`channel_infoname`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, MessageInnerEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getId());
        }
        if (value.getCid() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCid());
        }
        if (value.getUserId() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getUserId());
        }
        if (value.getText() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getText());
        }
        if (value.getHtml() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getHtml());
        }
        if (value.getType() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getType());
        }
        final int _tmp = __syncStatusConverter.syncStatusToString(value.getSyncStatus());
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getReplyCount());
        stmt.bindLong(9, value.getDeletedReplyCount());
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp_1 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
        if (_tmp_2 == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, _tmp_2);
        }
        final Long _tmp_3 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_3 == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, _tmp_3);
        }
        final Long _tmp_4 = __dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
        if (_tmp_4 == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindLong(13, _tmp_4);
        }
        final Long _tmp_5 = __dateConverter.dateToTimestamp(value.getDeletedAt());
        if (_tmp_5 == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindLong(14, _tmp_5);
        }
        final String _tmp_6 = __listConverter.stringListToString(value.getRemoteMentionedUserIds());
        if (_tmp_6 == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindString(15, _tmp_6);
        }
        final String _tmp_7 = __listConverter.stringListToString(value.getMentionedUsersId());
        if (_tmp_7 == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, _tmp_7);
        }
        final String _tmp_8 = __mapConverter.mapToString(value.getReactionCounts());
        if (_tmp_8 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, _tmp_8);
        }
        final String _tmp_9 = __mapConverter.mapToString(value.getReactionScores());
        if (_tmp_9 == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindString(18, _tmp_9);
        }
        if (value.getParentId() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getParentId());
        }
        if (value.getCommand() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, value.getCommand());
        }
        final int _tmp_10 = value.getShadowed() ? 1 : 0;
        stmt.bindLong(21, _tmp_10);
        final String _tmp_11 = __mapConverter.stringMapToString(value.getI18n());
        if (_tmp_11 == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindString(22, _tmp_11);
        }
        final int _tmp_12 = value.getShowInChannel() ? 1 : 0;
        stmt.bindLong(23, _tmp_12);
        final int _tmp_13 = value.getSilent() ? 1 : 0;
        stmt.bindLong(24, _tmp_13);
        final String _tmp_14 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_14 == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, _tmp_14);
        }
        if (value.getReplyToId() == null) {
          stmt.bindNull(26);
        } else {
          stmt.bindString(26, value.getReplyToId());
        }
        final int _tmp_15 = value.getPinned() ? 1 : 0;
        stmt.bindLong(27, _tmp_15);
        final Long _tmp_16 = __dateConverter.dateToTimestamp(value.getPinnedAt());
        if (_tmp_16 == null) {
          stmt.bindNull(28);
        } else {
          stmt.bindLong(28, _tmp_16);
        }
        final Long _tmp_17 = __dateConverter.dateToTimestamp(value.getPinExpires());
        if (_tmp_17 == null) {
          stmt.bindNull(29);
        } else {
          stmt.bindLong(29, _tmp_17);
        }
        if (value.getPinnedByUserId() == null) {
          stmt.bindNull(30);
        } else {
          stmt.bindString(30, value.getPinnedByUserId());
        }
        final String _tmp_18 = __listConverter.stringListToString(value.getThreadParticipantsIds());
        if (_tmp_18 == null) {
          stmt.bindNull(31);
        } else {
          stmt.bindString(31, _tmp_18);
        }
        final int _tmp_19 = value.getSkipPushNotification() ? 1 : 0;
        stmt.bindLong(32, _tmp_19);
        final int _tmp_20 = value.getSkipEnrichUrl() ? 1 : 0;
        stmt.bindLong(33, _tmp_20);
        final String _tmp_21 = __moderationDetailsConverter.moderationDetailsToString(value.getModerationDetails());
        if (_tmp_21 == null) {
          stmt.bindNull(34);
        } else {
          stmt.bindString(34, _tmp_21);
        }
        final ChannelInfoEntity _tmpChannelInfo = value.getChannelInfo();
        if (_tmpChannelInfo != null) {
          if (_tmpChannelInfo.getCid() == null) {
            stmt.bindNull(35);
          } else {
            stmt.bindString(35, _tmpChannelInfo.getCid());
          }
          if (_tmpChannelInfo.getId() == null) {
            stmt.bindNull(36);
          } else {
            stmt.bindString(36, _tmpChannelInfo.getId());
          }
          if (_tmpChannelInfo.getType() == null) {
            stmt.bindNull(37);
          } else {
            stmt.bindString(37, _tmpChannelInfo.getType());
          }
          if (_tmpChannelInfo.getMemberCount() == null) {
            stmt.bindNull(38);
          } else {
            stmt.bindLong(38, _tmpChannelInfo.getMemberCount());
          }
          if (_tmpChannelInfo.getName() == null) {
            stmt.bindNull(39);
          } else {
            stmt.bindString(39, _tmpChannelInfo.getName());
          }
        } else {
          stmt.bindNull(35);
          stmt.bindNull(36);
          stmt.bindNull(37);
          stmt.bindNull(38);
          stmt.bindNull(39);
        }
      }
    };
    this.__insertionAdapterOfAttachmentEntity = new EntityInsertionAdapter<AttachmentEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `attachment_inner_entity` (`id`,`messageId`,`authorName`,`titleLink`,`authorLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`originalHeight`,`originalWidth`,`extraData`,`statusCode`,`errorMessage`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AttachmentEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getId());
        }
        if (value.getMessageId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getMessageId());
        }
        if (value.getAuthorName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getAuthorName());
        }
        if (value.getTitleLink() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getTitleLink());
        }
        if (value.getAuthorLink() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAuthorLink());
        }
        if (value.getThumbUrl() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getThumbUrl());
        }
        if (value.getImageUrl() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getImageUrl());
        }
        if (value.getAssetUrl() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getAssetUrl());
        }
        if (value.getOgUrl() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getOgUrl());
        }
        if (value.getMimeType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getMimeType());
        }
        stmt.bindLong(11, value.getFileSize());
        if (value.getTitle() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getTitle());
        }
        if (value.getText() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getText());
        }
        if (value.getType() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getType());
        }
        if (value.getImage() == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindString(15, value.getImage());
        }
        if (value.getUrl() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getUrl());
        }
        if (value.getName() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, value.getName());
        }
        if (value.getFallback() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindString(18, value.getFallback());
        }
        if (value.getUploadFilePath() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getUploadFilePath());
        }
        if (value.getOriginalHeight() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getOriginalHeight());
        }
        if (value.getOriginalWidth() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getOriginalWidth());
        }
        final String _tmp = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindString(22, _tmp);
        }
        final UploadStateEntity _tmpUploadState = value.getUploadState();
        if (_tmpUploadState != null) {
          stmt.bindLong(23, _tmpUploadState.getStatusCode());
          if (_tmpUploadState.getErrorMessage() == null) {
            stmt.bindNull(24);
          } else {
            stmt.bindString(24, _tmpUploadState.getErrorMessage());
          }
        } else {
          stmt.bindNull(23);
          stmt.bindNull(24);
        }
      }
    };
    this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_chat_reaction` (`messageId`,`userId`,`type`,`score`,`createdAt`,`createdLocallyAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
        if (value.getMessageId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getMessageId());
        }
        if (value.getUserId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUserId());
        }
        if (value.getType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getType());
        }
        stmt.bindLong(4, value.getScore());
        final Long _tmp = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindLong(5, _tmp);
        }
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
        if (_tmp_1 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindLong(6, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_2 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindLong(7, _tmp_2);
        }
        final Long _tmp_3 = __dateConverter.dateToTimestamp(value.getDeletedAt());
        if (_tmp_3 == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, _tmp_3);
        }
        final int _tmp_4 = value.getEnforceUnique() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        final String _tmp_5 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_5 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, _tmp_5);
        }
        final int _tmp_6 = __syncStatusConverter.syncStatusToString(value.getSyncStatus());
        stmt.bindLong(11, _tmp_6);
        stmt.bindLong(12, value.getId());
      }
    };
    this.__updateAdapterOfMessageInnerEntity = new EntityDeletionOrUpdateAdapter<MessageInnerEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR REPLACE `stream_chat_message` SET `id` = ?,`cid` = ?,`userId` = ?,`text` = ?,`html` = ?,`type` = ?,`syncStatus` = ?,`replyCount` = ?,`deletedReplyCount` = ?,`createdAt` = ?,`createdLocallyAt` = ?,`updatedAt` = ?,`updatedLocallyAt` = ?,`deletedAt` = ?,`remoteMentionedUserIds` = ?,`mentionedUsersId` = ?,`reactionCounts` = ?,`reactionScores` = ?,`parentId` = ?,`command` = ?,`shadowed` = ?,`i18n` = ?,`showInChannel` = ?,`silent` = ?,`extraData` = ?,`replyToId` = ?,`pinned` = ?,`pinnedAt` = ?,`pinExpires` = ?,`pinnedByUserId` = ?,`threadParticipantsIds` = ?,`skipPushNotification` = ?,`skipEnrichUrl` = ?,`moderationDetails` = ?,`channel_infocid` = ?,`channel_infoid` = ?,`channel_infotype` = ?,`channel_infomemberCount` = ?,`channel_infoname` = ? WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, MessageInnerEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getId());
        }
        if (value.getCid() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCid());
        }
        if (value.getUserId() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getUserId());
        }
        if (value.getText() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getText());
        }
        if (value.getHtml() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getHtml());
        }
        if (value.getType() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getType());
        }
        final int _tmp = __syncStatusConverter.syncStatusToString(value.getSyncStatus());
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getReplyCount());
        stmt.bindLong(9, value.getDeletedReplyCount());
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp_1 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
        if (_tmp_2 == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, _tmp_2);
        }
        final Long _tmp_3 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_3 == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, _tmp_3);
        }
        final Long _tmp_4 = __dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
        if (_tmp_4 == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindLong(13, _tmp_4);
        }
        final Long _tmp_5 = __dateConverter.dateToTimestamp(value.getDeletedAt());
        if (_tmp_5 == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindLong(14, _tmp_5);
        }
        final String _tmp_6 = __listConverter.stringListToString(value.getRemoteMentionedUserIds());
        if (_tmp_6 == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindString(15, _tmp_6);
        }
        final String _tmp_7 = __listConverter.stringListToString(value.getMentionedUsersId());
        if (_tmp_7 == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, _tmp_7);
        }
        final String _tmp_8 = __mapConverter.mapToString(value.getReactionCounts());
        if (_tmp_8 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, _tmp_8);
        }
        final String _tmp_9 = __mapConverter.mapToString(value.getReactionScores());
        if (_tmp_9 == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindString(18, _tmp_9);
        }
        if (value.getParentId() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getParentId());
        }
        if (value.getCommand() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, value.getCommand());
        }
        final int _tmp_10 = value.getShadowed() ? 1 : 0;
        stmt.bindLong(21, _tmp_10);
        final String _tmp_11 = __mapConverter.stringMapToString(value.getI18n());
        if (_tmp_11 == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindString(22, _tmp_11);
        }
        final int _tmp_12 = value.getShowInChannel() ? 1 : 0;
        stmt.bindLong(23, _tmp_12);
        final int _tmp_13 = value.getSilent() ? 1 : 0;
        stmt.bindLong(24, _tmp_13);
        final String _tmp_14 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_14 == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, _tmp_14);
        }
        if (value.getReplyToId() == null) {
          stmt.bindNull(26);
        } else {
          stmt.bindString(26, value.getReplyToId());
        }
        final int _tmp_15 = value.getPinned() ? 1 : 0;
        stmt.bindLong(27, _tmp_15);
        final Long _tmp_16 = __dateConverter.dateToTimestamp(value.getPinnedAt());
        if (_tmp_16 == null) {
          stmt.bindNull(28);
        } else {
          stmt.bindLong(28, _tmp_16);
        }
        final Long _tmp_17 = __dateConverter.dateToTimestamp(value.getPinExpires());
        if (_tmp_17 == null) {
          stmt.bindNull(29);
        } else {
          stmt.bindLong(29, _tmp_17);
        }
        if (value.getPinnedByUserId() == null) {
          stmt.bindNull(30);
        } else {
          stmt.bindString(30, value.getPinnedByUserId());
        }
        final String _tmp_18 = __listConverter.stringListToString(value.getThreadParticipantsIds());
        if (_tmp_18 == null) {
          stmt.bindNull(31);
        } else {
          stmt.bindString(31, _tmp_18);
        }
        final int _tmp_19 = value.getSkipPushNotification() ? 1 : 0;
        stmt.bindLong(32, _tmp_19);
        final int _tmp_20 = value.getSkipEnrichUrl() ? 1 : 0;
        stmt.bindLong(33, _tmp_20);
        final String _tmp_21 = __moderationDetailsConverter.moderationDetailsToString(value.getModerationDetails());
        if (_tmp_21 == null) {
          stmt.bindNull(34);
        } else {
          stmt.bindString(34, _tmp_21);
        }
        final ChannelInfoEntity _tmpChannelInfo = value.getChannelInfo();
        if (_tmpChannelInfo != null) {
          if (_tmpChannelInfo.getCid() == null) {
            stmt.bindNull(35);
          } else {
            stmt.bindString(35, _tmpChannelInfo.getCid());
          }
          if (_tmpChannelInfo.getId() == null) {
            stmt.bindNull(36);
          } else {
            stmt.bindString(36, _tmpChannelInfo.getId());
          }
          if (_tmpChannelInfo.getType() == null) {
            stmt.bindNull(37);
          } else {
            stmt.bindString(37, _tmpChannelInfo.getType());
          }
          if (_tmpChannelInfo.getMemberCount() == null) {
            stmt.bindNull(38);
          } else {
            stmt.bindLong(38, _tmpChannelInfo.getMemberCount());
          }
          if (_tmpChannelInfo.getName() == null) {
            stmt.bindNull(39);
          } else {
            stmt.bindString(39, _tmpChannelInfo.getName());
          }
        } else {
          stmt.bindNull(35);
          stmt.bindNull(36);
          stmt.bindNull(37);
          stmt.bindNull(38);
          stmt.bindNull(39);
        }
        if (value.getId() == null) {
          stmt.bindNull(40);
        } else {
          stmt.bindString(40, value.getId());
        }
      }
    };
    this.__preparedStmtOfDeleteChannelMessagesBefore = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteMessage = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_chat_message";
        return _query;
      }
    };
  }

  @Override
  public Object insertMessageInnerEntity(final MessageInnerEntity messageInnerEntity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfMessageInnerEntity.insertAndReturnId(messageInnerEntity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertMessageInnerEntities(final List<MessageInnerEntity> messageInnerEntities,
      final Continuation<? super List<Long>> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        __db.beginTransaction();
        try {
          List<Long> _result = __insertionAdapterOfMessageInnerEntity.insertAndReturnIdsList(messageInnerEntities);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertAttachments(final List<AttachmentEntity> attachmentEntities,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAttachmentEntity.insert(attachmentEntities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertReactions(final List<ReactionEntity> reactions,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfReactionEntity.insert(reactions);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateMessageInnerEntity(final MessageInnerEntity messageInnerEntity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfMessageInnerEntity.handle(messageInnerEntity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insert(final List<MessageEntity> messageEntities,
      final Continuation<? super Unit> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.insert(MessageDao_Impl.this, messageEntities, __cont), continuation);
  }

  @Override
  public Object insert(final MessageEntity messageEntity,
      final Continuation<? super Unit> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.insert(MessageDao_Impl.this, messageEntity, __cont), continuation);
  }

  @Override
  public void deleteAttachments(final List<String> messageIds) {
    __db.beginTransaction();
    try {
      MessageDao.DefaultImpls.deleteAttachments(MessageDao_Impl.this, messageIds);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertMessageInnerEntity(final MessageInnerEntity messageInnerEntity,
      final Continuation<? super Unit> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.upsertMessageInnerEntity(MessageDao_Impl.this, messageInnerEntity, __cont), continuation);
  }

  @Override
  public Object upsertMessageInnerEntities(final List<MessageInnerEntity> messageInnerEntities,
      final Continuation<? super Unit> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.upsertMessageInnerEntities(MessageDao_Impl.this, messageInnerEntities, __cont), continuation);
  }

  @Override
  public Object select(final List<String> ids,
      final Continuation<? super List<MessageEntity>> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.select(MessageDao_Impl.this, ids, __cont), continuation);
  }

  @Override
  public Object selectWaitForAttachments(
      final Continuation<? super List<MessageEntity>> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MessageDao.DefaultImpls.selectWaitForAttachments(MessageDao_Impl.this, __cont), continuation);
  }

  @Override
  public Object deleteChannelMessagesBefore(final String cid, final Date deleteMessagesBefore,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteChannelMessagesBefore.acquire();
        int _argIndex = 1;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        final Long _tmp = __dateConverter.dateToTimestamp(deleteMessagesBefore);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindLong(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteChannelMessagesBefore.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteMessage(final String cid, final String messageId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteMessage.acquire();
        int _argIndex = 1;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        if (messageId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, messageId);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteMessage.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForChannelNewerThan(final String cid, final int limit,
      final Date dateFilter, final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt > ? OR createdLocallyAt > ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    _argIndex = 2;
    final Long _tmp = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp);
    }
    _argIndex = 3;
    final Long _tmp_1 = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp_1);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_2);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpUpdatedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_5);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_6;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_6);
              final Date _tmpDeletedAt;
              final Long _tmp_7;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_7 = null;
              } else {
                _tmp_7 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_7);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_9;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_11 = __listConverter.stringToStringList(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_13;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_14;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_14 = null;
              } else {
                _tmp_14 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_15 = __mapConverter.stringToMap(_tmp_14);
              if(_tmp_15 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_15;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_16;
              _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_16 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_17;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_17 = null;
              } else {
                _tmp_17 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_18 = __mapConverter.stringToStringMap(_tmp_17);
              if(_tmp_18 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_18;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_19;
              _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_19 != 0;
              final boolean _tmpSilent;
              final int _tmp_20;
              _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_20 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_21;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_21 = null;
              } else {
                _tmp_21 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_22 = __extraDataConverter.stringToMap(_tmp_21);
              if(_tmp_22 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_22;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_23;
              _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_23 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_24;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_24);
              final Date _tmpPinExpires;
              final Long _tmp_25;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_25 = null;
              } else {
                _tmp_25 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_25);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_26;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_26 = null;
              } else {
                _tmp_26 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_27 = __listConverter.stringToStringList(_tmp_26);
              if(_tmp_27 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_27;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_28;
              _tmp_28 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_28 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_29;
              _tmp_29 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_29 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_30;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_30 = null;
              } else {
                _tmp_30 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_30);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForChannelEqualOrNewerThan(final String cid, final int limit,
      final Date dateFilter, final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt >= ? OR createdLocallyAt >= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    _argIndex = 2;
    final Long _tmp = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp);
    }
    _argIndex = 3;
    final Long _tmp_1 = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp_1);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_2);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpUpdatedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_5);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_6;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_6);
              final Date _tmpDeletedAt;
              final Long _tmp_7;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_7 = null;
              } else {
                _tmp_7 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_7);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_9;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_11 = __listConverter.stringToStringList(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_13;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_14;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_14 = null;
              } else {
                _tmp_14 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_15 = __mapConverter.stringToMap(_tmp_14);
              if(_tmp_15 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_15;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_16;
              _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_16 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_17;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_17 = null;
              } else {
                _tmp_17 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_18 = __mapConverter.stringToStringMap(_tmp_17);
              if(_tmp_18 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_18;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_19;
              _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_19 != 0;
              final boolean _tmpSilent;
              final int _tmp_20;
              _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_20 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_21;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_21 = null;
              } else {
                _tmp_21 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_22 = __extraDataConverter.stringToMap(_tmp_21);
              if(_tmp_22 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_22;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_23;
              _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_23 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_24;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_24);
              final Date _tmpPinExpires;
              final Long _tmp_25;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_25 = null;
              } else {
                _tmp_25 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_25);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_26;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_26 = null;
              } else {
                _tmp_26 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_27 = __listConverter.stringToStringList(_tmp_26);
              if(_tmp_27 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_27;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_28;
              _tmp_28 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_28 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_29;
              _tmp_29 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_29 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_30;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_30 = null;
              } else {
                _tmp_30 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_30);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForChannelOlderThan(final String cid, final int limit,
      final Date dateFilter, final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt < ? OR createdLocallyAt < ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    _argIndex = 2;
    final Long _tmp = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp);
    }
    _argIndex = 3;
    final Long _tmp_1 = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp_1);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_2);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpUpdatedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_5);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_6;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_6);
              final Date _tmpDeletedAt;
              final Long _tmp_7;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_7 = null;
              } else {
                _tmp_7 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_7);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_9;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_11 = __listConverter.stringToStringList(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_13;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_14;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_14 = null;
              } else {
                _tmp_14 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_15 = __mapConverter.stringToMap(_tmp_14);
              if(_tmp_15 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_15;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_16;
              _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_16 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_17;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_17 = null;
              } else {
                _tmp_17 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_18 = __mapConverter.stringToStringMap(_tmp_17);
              if(_tmp_18 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_18;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_19;
              _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_19 != 0;
              final boolean _tmpSilent;
              final int _tmp_20;
              _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_20 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_21;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_21 = null;
              } else {
                _tmp_21 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_22 = __extraDataConverter.stringToMap(_tmp_21);
              if(_tmp_22 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_22;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_23;
              _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_23 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_24;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_24);
              final Date _tmpPinExpires;
              final Long _tmp_25;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_25 = null;
              } else {
                _tmp_25 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_25);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_26;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_26 = null;
              } else {
                _tmp_26 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_27 = __listConverter.stringToStringList(_tmp_26);
              if(_tmp_27 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_27;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_28;
              _tmp_28 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_28 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_29;
              _tmp_29 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_29 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_30;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_30 = null;
              } else {
                _tmp_30 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_30);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForChannelEqualOrOlderThan(final String cid, final int limit,
      final Date dateFilter, final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt <= ? OR createdLocallyAt <= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    _argIndex = 2;
    final Long _tmp = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp);
    }
    _argIndex = 3;
    final Long _tmp_1 = __dateConverter.dateToTimestamp(dateFilter);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, _tmp_1);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_2);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpUpdatedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_5);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_6;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_6);
              final Date _tmpDeletedAt;
              final Long _tmp_7;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_7 = null;
              } else {
                _tmp_7 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_7);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_9;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_11 = __listConverter.stringToStringList(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_13;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_14;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_14 = null;
              } else {
                _tmp_14 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_15 = __mapConverter.stringToMap(_tmp_14);
              if(_tmp_15 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_15;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_16;
              _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_16 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_17;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_17 = null;
              } else {
                _tmp_17 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_18 = __mapConverter.stringToStringMap(_tmp_17);
              if(_tmp_18 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_18;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_19;
              _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_19 != 0;
              final boolean _tmpSilent;
              final int _tmp_20;
              _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_20 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_21;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_21 = null;
              } else {
                _tmp_21 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_22 = __extraDataConverter.stringToMap(_tmp_21);
              if(_tmp_22 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_22;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_23;
              _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_23 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_24;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_24);
              final Date _tmpPinExpires;
              final Long _tmp_25;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_25 = null;
              } else {
                _tmp_25 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_25);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_26;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_26 = null;
              } else {
                _tmp_26 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_27 = __listConverter.stringToStringList(_tmp_26);
              if(_tmp_27 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_27;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_28;
              _tmp_28 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_28 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_29;
              _tmp_29 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_29 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_30;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_30 = null;
              } else {
                _tmp_30 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_30);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForChannel(final String cid, final int limit,
      final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE cid = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_1;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_1);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_2;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_2);
              final Date _tmpUpdatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpDeletedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_5);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_6;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_7 = __listConverter.stringToStringList(_tmp_6);
              if(_tmp_7 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_7;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_9;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_11 = __mapConverter.stringToMap(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_13;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_14;
              _tmp_14 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_14 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_15;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_15 = null;
              } else {
                _tmp_15 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_16 = __mapConverter.stringToStringMap(_tmp_15);
              if(_tmp_16 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_16;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_17;
              _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_17 != 0;
              final boolean _tmpSilent;
              final int _tmp_18;
              _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_18 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_19;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_19 = null;
              } else {
                _tmp_19 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_20 = __extraDataConverter.stringToMap(_tmp_19);
              if(_tmp_20 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_20;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_21;
              _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_21 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_22;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_22 = null;
              } else {
                _tmp_22 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_22);
              final Date _tmpPinExpires;
              final Long _tmp_23;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_23 = null;
              } else {
                _tmp_23 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_23);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_24;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_25 = __listConverter.stringToStringList(_tmp_24);
              if(_tmp_25 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_25;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_26;
              _tmp_26 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_26 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_27;
              _tmp_27 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_27 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_28;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_28 = null;
              } else {
                _tmp_28 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_28);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object messagesForThread(final String messageId, final int limit,
      final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * from stream_chat_message WHERE parentId = ? OR id = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    if (messageId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, messageId);
    }
    _argIndex = 2;
    if (messageId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, messageId);
    }
    _argIndex = 3;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_1;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_1);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_2;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_2);
              final Date _tmpUpdatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpDeletedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_5);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_6;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_7 = __listConverter.stringToStringList(_tmp_6);
              if(_tmp_7 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_7;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_9;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_11 = __mapConverter.stringToMap(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_13;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_14;
              _tmp_14 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_14 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_15;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_15 = null;
              } else {
                _tmp_15 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_16 = __mapConverter.stringToStringMap(_tmp_15);
              if(_tmp_16 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_16;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_17;
              _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_17 != 0;
              final boolean _tmpSilent;
              final int _tmp_18;
              _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_18 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_19;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_19 = null;
              } else {
                _tmp_19 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_20 = __extraDataConverter.stringToMap(_tmp_19);
              if(_tmp_20 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_20;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_21;
              _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_21 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_22;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_22 = null;
              } else {
                _tmp_22 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_22);
              final Date _tmpPinExpires;
              final Long _tmp_23;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_23 = null;
              } else {
                _tmp_23 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_23);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_24;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_25 = __listConverter.stringToStringList(_tmp_24);
              if(_tmp_25 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_25;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_26;
              _tmp_26 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_26 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_27;
              _tmp_27 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_27 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_28;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_28 = null;
              } else {
                _tmp_28 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_28);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final String id, final Continuation<? super MessageEntity> continuation) {
    final String _sql = "SELECT * FROM stream_chat_message WHERE id IN (?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<MessageEntity>() {
      @Override
      public MessageEntity call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final MessageEntity _result;
            if(_cursor.moveToFirst()) {
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_1;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_1);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_2;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_2);
              final Date _tmpUpdatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpDeletedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_5);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_6;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_7 = __listConverter.stringToStringList(_tmp_6);
              if(_tmp_7 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_7;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_9;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_11 = __mapConverter.stringToMap(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_13;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_14;
              _tmp_14 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_14 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_15;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_15 = null;
              } else {
                _tmp_15 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_16 = __mapConverter.stringToStringMap(_tmp_15);
              if(_tmp_16 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_16;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_17;
              _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_17 != 0;
              final boolean _tmpSilent;
              final int _tmp_18;
              _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_18 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_19;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_19 = null;
              } else {
                _tmp_19 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_20 = __extraDataConverter.stringToMap(_tmp_19);
              if(_tmp_20 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_20;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_21;
              _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_21 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_22;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_22 = null;
              } else {
                _tmp_22 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_22);
              final Date _tmpPinExpires;
              final Long _tmp_23;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_23 = null;
              } else {
                _tmp_23 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_23);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_24;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_25 = __listConverter.stringToStringList(_tmp_24);
              if(_tmp_25 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_25;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_26;
              _tmp_26 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_26 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_27;
              _tmp_27 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_27 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_28;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_28 = null;
              } else {
                _tmp_28 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_28);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _result = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectChunked(final List<String> ids,
      final Continuation<? super List<MessageEntity>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM stream_chat_message WHERE id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : ids) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item_1;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_1;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_1);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_2;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_2);
              final Date _tmpUpdatedAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpDeletedAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_5);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_6;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_7 = __listConverter.stringToStringList(_tmp_6);
              if(_tmp_7 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_7;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_8;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_8 = null;
              } else {
                _tmp_8 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_9 = __listConverter.stringToStringList(_tmp_8);
              if(_tmp_9 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_9;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_10;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_10 = null;
              } else {
                _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_11 = __mapConverter.stringToMap(_tmp_10);
              if(_tmp_11 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_11;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_12;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_12 = null;
              } else {
                _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_13 = __mapConverter.stringToMap(_tmp_12);
              if(_tmp_13 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_13;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_14;
              _tmp_14 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_14 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_15;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_15 = null;
              } else {
                _tmp_15 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_16 = __mapConverter.stringToStringMap(_tmp_15);
              if(_tmp_16 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_16;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_17;
              _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_17 != 0;
              final boolean _tmpSilent;
              final int _tmp_18;
              _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_18 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_19;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_19 = null;
              } else {
                _tmp_19 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_20 = __extraDataConverter.stringToMap(_tmp_19);
              if(_tmp_20 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_20;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_21;
              _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_21 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_22;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_22 = null;
              } else {
                _tmp_22 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_22);
              final Date _tmpPinExpires;
              final Long _tmp_23;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_23 = null;
              } else {
                _tmp_23 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_23);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_24;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_25 = __listConverter.stringToStringList(_tmp_24);
              if(_tmp_25 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_25;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_26;
              _tmp_26 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_26 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_27;
              _tmp_27 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_27 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_28;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_28 = null;
              } else {
                _tmp_28 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_28);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item_1 = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item_1);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectBySyncStatus(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<MessageEntity>> continuation) {
    final String _sql = "SELECT * FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<MessageEntity>>() {
      @Override
      public List<MessageEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
            final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
            final int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow(_cursor, "html");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
            final int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "replyCount");
            final int _cursorIndexOfDeletedReplyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedReplyCount");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdLocallyAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedLocallyAt");
            final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
            final int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow(_cursor, "remoteMentionedUserIds");
            final int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow(_cursor, "mentionedUsersId");
            final int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionCounts");
            final int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow(_cursor, "reactionScores");
            final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
            final int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow(_cursor, "command");
            final int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow(_cursor, "shadowed");
            final int _cursorIndexOfI18n = CursorUtil.getColumnIndexOrThrow(_cursor, "i18n");
            final int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow(_cursor, "showInChannel");
            final int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow(_cursor, "silent");
            final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
            final int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow(_cursor, "replyToId");
            final int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow(_cursor, "pinned");
            final int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedAt");
            final int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow(_cursor, "pinExpires");
            final int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "pinnedByUserId");
            final int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow(_cursor, "threadParticipantsIds");
            final int _cursorIndexOfSkipPushNotification = CursorUtil.getColumnIndexOrThrow(_cursor, "skipPushNotification");
            final int _cursorIndexOfSkipEnrichUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "skipEnrichUrl");
            final int _cursorIndexOfModerationDetails = CursorUtil.getColumnIndexOrThrow(_cursor, "moderationDetails");
            final int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infocid");
            final int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoid");
            final int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infotype");
            final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infomemberCount");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "channel_infoname");
            final ArrayMap<String, ArrayList<AttachmentEntity>> _collectionAttachments = new ArrayMap<String, ArrayList<AttachmentEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionOwnReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            final ArrayMap<String, ArrayList<ReactionEntity>> _collectionLatestReactions = new ArrayMap<String, ArrayList<ReactionEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfId);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection = _collectionAttachments.get(_tmpKey);
              if (_tmpAttachmentsCollection == null) {
                _tmpAttachmentsCollection = new ArrayList<AttachmentEntity>();
                _collectionAttachments.put(_tmpKey, _tmpAttachmentsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection = _collectionOwnReactions.get(_tmpKey_1);
              if (_tmpOwnReactionsCollection == null) {
                _tmpOwnReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionOwnReactions.put(_tmpKey_1, _tmpOwnReactionsCollection);
              }
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfId);
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection = _collectionLatestReactions.get(_tmpKey_2);
              if (_tmpLatestReactionsCollection == null) {
                _tmpLatestReactionsCollection = new ArrayList<ReactionEntity>();
                _collectionLatestReactions.put(_tmpKey_2, _tmpLatestReactionsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_collectionAttachments);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionOwnReactions);
            __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_collectionLatestReactions);
            final List<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final MessageEntity _item;
              final MessageInnerEntity _tmpMessageInnerEntity;
              final String _tmpId;
              if (_cursor.isNull(_cursorIndexOfId)) {
                _tmpId = null;
              } else {
                _tmpId = _cursor.getString(_cursorIndexOfId);
              }
              final String _tmpCid;
              if (_cursor.isNull(_cursorIndexOfCid)) {
                _tmpCid = null;
              } else {
                _tmpCid = _cursor.getString(_cursorIndexOfCid);
              }
              final String _tmpUserId;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmpUserId = null;
              } else {
                _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
              }
              final String _tmpText;
              if (_cursor.isNull(_cursorIndexOfText)) {
                _tmpText = null;
              } else {
                _tmpText = _cursor.getString(_cursorIndexOfText);
              }
              final String _tmpHtml;
              if (_cursor.isNull(_cursorIndexOfHtml)) {
                _tmpHtml = null;
              } else {
                _tmpHtml = _cursor.getString(_cursorIndexOfHtml);
              }
              final String _tmpType;
              if (_cursor.isNull(_cursorIndexOfType)) {
                _tmpType = null;
              } else {
                _tmpType = _cursor.getString(_cursorIndexOfType);
              }
              final SyncStatus _tmpSyncStatus;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
              _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_1);
              final int _tmpReplyCount;
              _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
              final int _tmpDeletedReplyCount;
              _tmpDeletedReplyCount = _cursor.getInt(_cursorIndexOfDeletedReplyCount);
              final Date _tmpCreatedAt;
              final Long _tmp_2;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_2);
              final Date _tmpCreatedLocallyAt;
              final Long _tmp_3;
              if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
              }
              _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_3);
              final Date _tmpUpdatedAt;
              final Long _tmp_4;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_4);
              final Date _tmpUpdatedLocallyAt;
              final Long _tmp_5;
              if (_cursor.isNull(_cursorIndexOfUpdatedLocallyAt)) {
                _tmp_5 = null;
              } else {
                _tmp_5 = _cursor.getLong(_cursorIndexOfUpdatedLocallyAt);
              }
              _tmpUpdatedLocallyAt = __dateConverter.fromTimestamp(_tmp_5);
              final Date _tmpDeletedAt;
              final Long _tmp_6;
              if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
                _tmp_6 = null;
              } else {
                _tmp_6 = _cursor.getLong(_cursorIndexOfDeletedAt);
              }
              _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_6);
              final List<String> _tmpRemoteMentionedUserIds;
              final String _tmp_7;
              if (_cursor.isNull(_cursorIndexOfRemoteMentionedUserIds)) {
                _tmp_7 = null;
              } else {
                _tmp_7 = _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
              }
              final List<String> _tmp_8 = __listConverter.stringToStringList(_tmp_7);
              if(_tmp_8 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpRemoteMentionedUserIds = _tmp_8;
              }
              final List<String> _tmpMentionedUsersId;
              final String _tmp_9;
              if (_cursor.isNull(_cursorIndexOfMentionedUsersId)) {
                _tmp_9 = null;
              } else {
                _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
              }
              final List<String> _tmp_10 = __listConverter.stringToStringList(_tmp_9);
              if(_tmp_10 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpMentionedUsersId = _tmp_10;
              }
              final Map<String, Integer> _tmpReactionCounts;
              final String _tmp_11;
              if (_cursor.isNull(_cursorIndexOfReactionCounts)) {
                _tmp_11 = null;
              } else {
                _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
              }
              final Map<String, Integer> _tmp_12 = __mapConverter.stringToMap(_tmp_11);
              if(_tmp_12 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionCounts = _tmp_12;
              }
              final Map<String, Integer> _tmpReactionScores;
              final String _tmp_13;
              if (_cursor.isNull(_cursorIndexOfReactionScores)) {
                _tmp_13 = null;
              } else {
                _tmp_13 = _cursor.getString(_cursorIndexOfReactionScores);
              }
              final Map<String, Integer> _tmp_14 = __mapConverter.stringToMap(_tmp_13);
              if(_tmp_14 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
              } else {
                _tmpReactionScores = _tmp_14;
              }
              final String _tmpParentId;
              if (_cursor.isNull(_cursorIndexOfParentId)) {
                _tmpParentId = null;
              } else {
                _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
              }
              final String _tmpCommand;
              if (_cursor.isNull(_cursorIndexOfCommand)) {
                _tmpCommand = null;
              } else {
                _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
              }
              final boolean _tmpShadowed;
              final int _tmp_15;
              _tmp_15 = _cursor.getInt(_cursorIndexOfShadowed);
              _tmpShadowed = _tmp_15 != 0;
              final Map<String, String> _tmpI18n;
              final String _tmp_16;
              if (_cursor.isNull(_cursorIndexOfI18n)) {
                _tmp_16 = null;
              } else {
                _tmp_16 = _cursor.getString(_cursorIndexOfI18n);
              }
              final Map<String, String> _tmp_17 = __mapConverter.stringToStringMap(_tmp_16);
              if(_tmp_17 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
              } else {
                _tmpI18n = _tmp_17;
              }
              final boolean _tmpShowInChannel;
              final int _tmp_18;
              _tmp_18 = _cursor.getInt(_cursorIndexOfShowInChannel);
              _tmpShowInChannel = _tmp_18 != 0;
              final boolean _tmpSilent;
              final int _tmp_19;
              _tmp_19 = _cursor.getInt(_cursorIndexOfSilent);
              _tmpSilent = _tmp_19 != 0;
              final Map<String, Object> _tmpExtraData;
              final String _tmp_20;
              if (_cursor.isNull(_cursorIndexOfExtraData)) {
                _tmp_20 = null;
              } else {
                _tmp_20 = _cursor.getString(_cursorIndexOfExtraData);
              }
              final Map<String, Object> _tmp_21 = __extraDataConverter.stringToMap(_tmp_20);
              if(_tmp_21 == null) {
                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
              } else {
                _tmpExtraData = _tmp_21;
              }
              final String _tmpReplyToId;
              if (_cursor.isNull(_cursorIndexOfReplyToId)) {
                _tmpReplyToId = null;
              } else {
                _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
              }
              final boolean _tmpPinned;
              final int _tmp_22;
              _tmp_22 = _cursor.getInt(_cursorIndexOfPinned);
              _tmpPinned = _tmp_22 != 0;
              final Date _tmpPinnedAt;
              final Long _tmp_23;
              if (_cursor.isNull(_cursorIndexOfPinnedAt)) {
                _tmp_23 = null;
              } else {
                _tmp_23 = _cursor.getLong(_cursorIndexOfPinnedAt);
              }
              _tmpPinnedAt = __dateConverter.fromTimestamp(_tmp_23);
              final Date _tmpPinExpires;
              final Long _tmp_24;
              if (_cursor.isNull(_cursorIndexOfPinExpires)) {
                _tmp_24 = null;
              } else {
                _tmp_24 = _cursor.getLong(_cursorIndexOfPinExpires);
              }
              _tmpPinExpires = __dateConverter.fromTimestamp(_tmp_24);
              final String _tmpPinnedByUserId;
              if (_cursor.isNull(_cursorIndexOfPinnedByUserId)) {
                _tmpPinnedByUserId = null;
              } else {
                _tmpPinnedByUserId = _cursor.getString(_cursorIndexOfPinnedByUserId);
              }
              final List<String> _tmpThreadParticipantsIds;
              final String _tmp_25;
              if (_cursor.isNull(_cursorIndexOfThreadParticipantsIds)) {
                _tmp_25 = null;
              } else {
                _tmp_25 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
              }
              final List<String> _tmp_26 = __listConverter.stringToStringList(_tmp_25);
              if(_tmp_26 == null) {
                throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
              } else {
                _tmpThreadParticipantsIds = _tmp_26;
              }
              final boolean _tmpSkipPushNotification;
              final int _tmp_27;
              _tmp_27 = _cursor.getInt(_cursorIndexOfSkipPushNotification);
              _tmpSkipPushNotification = _tmp_27 != 0;
              final boolean _tmpSkipEnrichUrl;
              final int _tmp_28;
              _tmp_28 = _cursor.getInt(_cursorIndexOfSkipEnrichUrl);
              _tmpSkipEnrichUrl = _tmp_28 != 0;
              final ModerationDetailsEntity _tmpModerationDetails;
              final String _tmp_29;
              if (_cursor.isNull(_cursorIndexOfModerationDetails)) {
                _tmp_29 = null;
              } else {
                _tmp_29 = _cursor.getString(_cursorIndexOfModerationDetails);
              }
              _tmpModerationDetails = __moderationDetailsConverter.stringToModerationDetails(_tmp_29);
              final ChannelInfoEntity _tmpChannelInfo;
              if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                final String _tmpCid_1;
                if (_cursor.isNull(_cursorIndexOfCid_1)) {
                  _tmpCid_1 = null;
                } else {
                  _tmpCid_1 = _cursor.getString(_cursorIndexOfCid_1);
                }
                final String _tmpId_1;
                if (_cursor.isNull(_cursorIndexOfId_1)) {
                  _tmpId_1 = null;
                } else {
                  _tmpId_1 = _cursor.getString(_cursorIndexOfId_1);
                }
                final String _tmpType_1;
                if (_cursor.isNull(_cursorIndexOfType_1)) {
                  _tmpType_1 = null;
                } else {
                  _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                }
                final Integer _tmpMemberCount;
                if (_cursor.isNull(_cursorIndexOfMemberCount)) {
                  _tmpMemberCount = null;
                } else {
                  _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1,_tmpId_1,_tmpType_1,_tmpMemberCount,_tmpName);
              } else {
                _tmpChannelInfo = null;
              }
              _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId,_tmpCid,_tmpUserId,_tmpText,_tmpHtml,_tmpType,_tmpSyncStatus,_tmpReplyCount,_tmpDeletedReplyCount,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpUpdatedLocallyAt,_tmpDeletedAt,_tmpRemoteMentionedUserIds,_tmpMentionedUsersId,_tmpReactionCounts,_tmpReactionScores,_tmpParentId,_tmpCommand,_tmpShadowed,_tmpI18n,_tmpShowInChannel,_tmpChannelInfo,_tmpSilent,_tmpExtraData,_tmpReplyToId,_tmpPinned,_tmpPinnedAt,_tmpPinExpires,_tmpPinnedByUserId,_tmpThreadParticipantsIds,_tmpSkipPushNotification,_tmpSkipEnrichUrl,_tmpModerationDetails);
              ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
              _tmpAttachmentsCollection_1 = _collectionAttachments.get(_tmpKey_3);
              if (_tmpAttachmentsCollection_1 == null) {
                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
              }
              ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
              final String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
              _tmpOwnReactionsCollection_1 = _collectionOwnReactions.get(_tmpKey_4);
              if (_tmpOwnReactionsCollection_1 == null) {
                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
              final String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
              _tmpLatestReactionsCollection_1 = _collectionLatestReactions.get(_tmpKey_5);
              if (_tmpLatestReactionsCollection_1 == null) {
                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
              }
              _item = new MessageEntity(_tmpMessageInnerEntity,_tmpAttachmentsCollection_1,_tmpOwnReactionsCollection_1,_tmpLatestReactionsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectIdsBySyncStatus(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<String>> continuation) {
    final String _sql = "SELECT id FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final String _item;
            if (_cursor.isNull(0)) {
              _item = null;
            } else {
              _item = _cursor.getString(0);
            }
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public void deleteAttachmentsChunked(final List<String> messageIds) {
    __db.assertNotSuspendingTransaction();
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("DELETE FROM attachment_inner_entity WHERE messageId in (");
    final int _inputSize = messageIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (String _item : messageIds) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(
      final ArrayMap<String, ArrayList<AttachmentEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<AttachmentEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<AttachmentEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<AttachmentEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `id`,`messageId`,`authorName`,`titleLink`,`authorLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`originalHeight`,`originalWidth`,`extraData`,`statusCode`,`errorMessage` FROM `attachment_inner_entity` WHERE `messageId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "messageId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfId = 0;
      final int _cursorIndexOfMessageId = 1;
      final int _cursorIndexOfAuthorName = 2;
      final int _cursorIndexOfTitleLink = 3;
      final int _cursorIndexOfAuthorLink = 4;
      final int _cursorIndexOfThumbUrl = 5;
      final int _cursorIndexOfImageUrl = 6;
      final int _cursorIndexOfAssetUrl = 7;
      final int _cursorIndexOfOgUrl = 8;
      final int _cursorIndexOfMimeType = 9;
      final int _cursorIndexOfFileSize = 10;
      final int _cursorIndexOfTitle = 11;
      final int _cursorIndexOfText = 12;
      final int _cursorIndexOfType = 13;
      final int _cursorIndexOfImage = 14;
      final int _cursorIndexOfUrl = 15;
      final int _cursorIndexOfName = 16;
      final int _cursorIndexOfFallback = 17;
      final int _cursorIndexOfUploadFilePath = 18;
      final int _cursorIndexOfOriginalHeight = 19;
      final int _cursorIndexOfOriginalWidth = 20;
      final int _cursorIndexOfExtraData = 21;
      final int _cursorIndexOfStatusCode = 22;
      final int _cursorIndexOfErrorMessage = 23;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<AttachmentEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final AttachmentEntity _item_1;
          final String _tmpId;
          if (_cursor.isNull(_cursorIndexOfId)) {
            _tmpId = null;
          } else {
            _tmpId = _cursor.getString(_cursorIndexOfId);
          }
          final String _tmpMessageId;
          if (_cursor.isNull(_cursorIndexOfMessageId)) {
            _tmpMessageId = null;
          } else {
            _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
          }
          final String _tmpAuthorName;
          if (_cursor.isNull(_cursorIndexOfAuthorName)) {
            _tmpAuthorName = null;
          } else {
            _tmpAuthorName = _cursor.getString(_cursorIndexOfAuthorName);
          }
          final String _tmpTitleLink;
          if (_cursor.isNull(_cursorIndexOfTitleLink)) {
            _tmpTitleLink = null;
          } else {
            _tmpTitleLink = _cursor.getString(_cursorIndexOfTitleLink);
          }
          final String _tmpAuthorLink;
          if (_cursor.isNull(_cursorIndexOfAuthorLink)) {
            _tmpAuthorLink = null;
          } else {
            _tmpAuthorLink = _cursor.getString(_cursorIndexOfAuthorLink);
          }
          final String _tmpThumbUrl;
          if (_cursor.isNull(_cursorIndexOfThumbUrl)) {
            _tmpThumbUrl = null;
          } else {
            _tmpThumbUrl = _cursor.getString(_cursorIndexOfThumbUrl);
          }
          final String _tmpImageUrl;
          if (_cursor.isNull(_cursorIndexOfImageUrl)) {
            _tmpImageUrl = null;
          } else {
            _tmpImageUrl = _cursor.getString(_cursorIndexOfImageUrl);
          }
          final String _tmpAssetUrl;
          if (_cursor.isNull(_cursorIndexOfAssetUrl)) {
            _tmpAssetUrl = null;
          } else {
            _tmpAssetUrl = _cursor.getString(_cursorIndexOfAssetUrl);
          }
          final String _tmpOgUrl;
          if (_cursor.isNull(_cursorIndexOfOgUrl)) {
            _tmpOgUrl = null;
          } else {
            _tmpOgUrl = _cursor.getString(_cursorIndexOfOgUrl);
          }
          final String _tmpMimeType;
          if (_cursor.isNull(_cursorIndexOfMimeType)) {
            _tmpMimeType = null;
          } else {
            _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
          }
          final int _tmpFileSize;
          _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
          final String _tmpTitle;
          if (_cursor.isNull(_cursorIndexOfTitle)) {
            _tmpTitle = null;
          } else {
            _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
          }
          final String _tmpText;
          if (_cursor.isNull(_cursorIndexOfText)) {
            _tmpText = null;
          } else {
            _tmpText = _cursor.getString(_cursorIndexOfText);
          }
          final String _tmpType;
          if (_cursor.isNull(_cursorIndexOfType)) {
            _tmpType = null;
          } else {
            _tmpType = _cursor.getString(_cursorIndexOfType);
          }
          final String _tmpImage;
          if (_cursor.isNull(_cursorIndexOfImage)) {
            _tmpImage = null;
          } else {
            _tmpImage = _cursor.getString(_cursorIndexOfImage);
          }
          final String _tmpUrl;
          if (_cursor.isNull(_cursorIndexOfUrl)) {
            _tmpUrl = null;
          } else {
            _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
          }
          final String _tmpName;
          if (_cursor.isNull(_cursorIndexOfName)) {
            _tmpName = null;
          } else {
            _tmpName = _cursor.getString(_cursorIndexOfName);
          }
          final String _tmpFallback;
          if (_cursor.isNull(_cursorIndexOfFallback)) {
            _tmpFallback = null;
          } else {
            _tmpFallback = _cursor.getString(_cursorIndexOfFallback);
          }
          final String _tmpUploadFilePath;
          if (_cursor.isNull(_cursorIndexOfUploadFilePath)) {
            _tmpUploadFilePath = null;
          } else {
            _tmpUploadFilePath = _cursor.getString(_cursorIndexOfUploadFilePath);
          }
          final Integer _tmpOriginalHeight;
          if (_cursor.isNull(_cursorIndexOfOriginalHeight)) {
            _tmpOriginalHeight = null;
          } else {
            _tmpOriginalHeight = _cursor.getInt(_cursorIndexOfOriginalHeight);
          }
          final Integer _tmpOriginalWidth;
          if (_cursor.isNull(_cursorIndexOfOriginalWidth)) {
            _tmpOriginalWidth = null;
          } else {
            _tmpOriginalWidth = _cursor.getInt(_cursorIndexOfOriginalWidth);
          }
          final Map<String, Object> _tmpExtraData;
          final String _tmp;
          if (_cursor.isNull(_cursorIndexOfExtraData)) {
            _tmp = null;
          } else {
            _tmp = _cursor.getString(_cursorIndexOfExtraData);
          }
          final Map<String, Object> _tmp_1 = __extraDataConverter.stringToMap(_tmp);
          if(_tmp_1 == null) {
            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
          } else {
            _tmpExtraData = _tmp_1;
          }
          final UploadStateEntity _tmpUploadState;
          if (!(_cursor.isNull(_cursorIndexOfStatusCode) && _cursor.isNull(_cursorIndexOfErrorMessage))) {
            final int _tmpStatusCode;
            _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
            final String _tmpErrorMessage;
            if (_cursor.isNull(_cursorIndexOfErrorMessage)) {
              _tmpErrorMessage = null;
            } else {
              _tmpErrorMessage = _cursor.getString(_cursorIndexOfErrorMessage);
            }
            _tmpUploadState = new UploadStateEntity(_tmpStatusCode,_tmpErrorMessage);
          } else {
            _tmpUploadState = null;
          }
          _item_1 = new AttachmentEntity(_tmpId,_tmpMessageId,_tmpAuthorName,_tmpTitleLink,_tmpAuthorLink,_tmpThumbUrl,_tmpImageUrl,_tmpAssetUrl,_tmpOgUrl,_tmpMimeType,_tmpFileSize,_tmpTitle,_tmpText,_tmpType,_tmpImage,_tmpUrl,_tmpName,_tmpFallback,_tmpUploadFilePath,_tmpOriginalHeight,_tmpOriginalWidth,_tmpUploadState,_tmpExtraData);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }

  private void __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(
      final ArrayMap<String, ArrayList<ReactionEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<ReactionEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<ReactionEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<ReactionEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `messageId`,`userId`,`type`,`score`,`createdAt`,`createdLocallyAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id` FROM `stream_chat_reaction` WHERE `messageId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "messageId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfMessageId = 0;
      final int _cursorIndexOfUserId = 1;
      final int _cursorIndexOfType = 2;
      final int _cursorIndexOfScore = 3;
      final int _cursorIndexOfCreatedAt = 4;
      final int _cursorIndexOfCreatedLocallyAt = 5;
      final int _cursorIndexOfUpdatedAt = 6;
      final int _cursorIndexOfDeletedAt = 7;
      final int _cursorIndexOfEnforceUnique = 8;
      final int _cursorIndexOfExtraData = 9;
      final int _cursorIndexOfSyncStatus = 10;
      final int _cursorIndexOfId = 11;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<ReactionEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final ReactionEntity _item_1;
          final String _tmpMessageId;
          if (_cursor.isNull(_cursorIndexOfMessageId)) {
            _tmpMessageId = null;
          } else {
            _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
          }
          final String _tmpUserId;
          if (_cursor.isNull(_cursorIndexOfUserId)) {
            _tmpUserId = null;
          } else {
            _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
          }
          final String _tmpType;
          if (_cursor.isNull(_cursorIndexOfType)) {
            _tmpType = null;
          } else {
            _tmpType = _cursor.getString(_cursorIndexOfType);
          }
          final int _tmpScore;
          _tmpScore = _cursor.getInt(_cursorIndexOfScore);
          final Date _tmpCreatedAt;
          final Long _tmp;
          if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
            _tmp = null;
          } else {
            _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
          }
          _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
          final Date _tmpCreatedLocallyAt;
          final Long _tmp_1;
          if (_cursor.isNull(_cursorIndexOfCreatedLocallyAt)) {
            _tmp_1 = null;
          } else {
            _tmp_1 = _cursor.getLong(_cursorIndexOfCreatedLocallyAt);
          }
          _tmpCreatedLocallyAt = __dateConverter.fromTimestamp(_tmp_1);
          final Date _tmpUpdatedAt;
          final Long _tmp_2;
          if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
            _tmp_2 = null;
          } else {
            _tmp_2 = _cursor.getLong(_cursorIndexOfUpdatedAt);
          }
          _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_2);
          final Date _tmpDeletedAt;
          final Long _tmp_3;
          if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
            _tmp_3 = null;
          } else {
            _tmp_3 = _cursor.getLong(_cursorIndexOfDeletedAt);
          }
          _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_3);
          final boolean _tmpEnforceUnique;
          final int _tmp_4;
          _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
          _tmpEnforceUnique = _tmp_4 != 0;
          final Map<String, Object> _tmpExtraData;
          final String _tmp_5;
          if (_cursor.isNull(_cursorIndexOfExtraData)) {
            _tmp_5 = null;
          } else {
            _tmp_5 = _cursor.getString(_cursorIndexOfExtraData);
          }
          final Map<String, Object> _tmp_6 = __extraDataConverter.stringToMap(_tmp_5);
          if(_tmp_6 == null) {
            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
          } else {
            _tmpExtraData = _tmp_6;
          }
          final SyncStatus _tmpSyncStatus;
          final int _tmp_7;
          _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
          _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_7);
          _item_1 = new ReactionEntity(_tmpMessageId,_tmpUserId,_tmpType,_tmpScore,_tmpCreatedAt,_tmpCreatedLocallyAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpEnforceUnique,_tmpExtraData,_tmpSyncStatus);
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          _item_1.setId(_tmpId);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
