package io.getstream.chat.android.offline.repository.domain.message.attachment.internal;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AttachmentDao_Impl implements AttachmentDao {
  private final RoomDatabase __db;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();

  public AttachmentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM attachment_inner_entity";
        return _query;
      }
    };
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public Flow<List<AttachmentEntity>> observeAttachmentsForMessage(final String messageId) {
    final String _sql = "SELECT * FROM attachment_inner_entity WHERE messageId == ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (messageId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, messageId);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"attachment_inner_entity"}, new Callable<List<AttachmentEntity>>() {
      @Override
      public List<AttachmentEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "messageId");
          final int _cursorIndexOfAuthorName = CursorUtil.getColumnIndexOrThrow(_cursor, "authorName");
          final int _cursorIndexOfTitleLink = CursorUtil.getColumnIndexOrThrow(_cursor, "titleLink");
          final int _cursorIndexOfAuthorLink = CursorUtil.getColumnIndexOrThrow(_cursor, "authorLink");
          final int _cursorIndexOfThumbUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbUrl");
          final int _cursorIndexOfImageUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "imageUrl");
          final int _cursorIndexOfAssetUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "assetUrl");
          final int _cursorIndexOfOgUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "ogUrl");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow(_cursor, "text");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfFallback = CursorUtil.getColumnIndexOrThrow(_cursor, "fallback");
          final int _cursorIndexOfUploadFilePath = CursorUtil.getColumnIndexOrThrow(_cursor, "uploadFilePath");
          final int _cursorIndexOfOriginalHeight = CursorUtil.getColumnIndexOrThrow(_cursor, "originalHeight");
          final int _cursorIndexOfOriginalWidth = CursorUtil.getColumnIndexOrThrow(_cursor, "originalWidth");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow(_cursor, "statusCode");
          final int _cursorIndexOfErrorMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "errorMessage");
          final List<AttachmentEntity> _result = new ArrayList<AttachmentEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final AttachmentEntity _item;
            final String _tmpId;
            if (_cursor.isNull(_cursorIndexOfId)) {
              _tmpId = null;
            } else {
              _tmpId = _cursor.getString(_cursorIndexOfId);
            }
            final String _tmpMessageId;
            if (_cursor.isNull(_cursorIndexOfMessageId)) {
              _tmpMessageId = null;
            } else {
              _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
            }
            final String _tmpAuthorName;
            if (_cursor.isNull(_cursorIndexOfAuthorName)) {
              _tmpAuthorName = null;
            } else {
              _tmpAuthorName = _cursor.getString(_cursorIndexOfAuthorName);
            }
            final String _tmpTitleLink;
            if (_cursor.isNull(_cursorIndexOfTitleLink)) {
              _tmpTitleLink = null;
            } else {
              _tmpTitleLink = _cursor.getString(_cursorIndexOfTitleLink);
            }
            final String _tmpAuthorLink;
            if (_cursor.isNull(_cursorIndexOfAuthorLink)) {
              _tmpAuthorLink = null;
            } else {
              _tmpAuthorLink = _cursor.getString(_cursorIndexOfAuthorLink);
            }
            final String _tmpThumbUrl;
            if (_cursor.isNull(_cursorIndexOfThumbUrl)) {
              _tmpThumbUrl = null;
            } else {
              _tmpThumbUrl = _cursor.getString(_cursorIndexOfThumbUrl);
            }
            final String _tmpImageUrl;
            if (_cursor.isNull(_cursorIndexOfImageUrl)) {
              _tmpImageUrl = null;
            } else {
              _tmpImageUrl = _cursor.getString(_cursorIndexOfImageUrl);
            }
            final String _tmpAssetUrl;
            if (_cursor.isNull(_cursorIndexOfAssetUrl)) {
              _tmpAssetUrl = null;
            } else {
              _tmpAssetUrl = _cursor.getString(_cursorIndexOfAssetUrl);
            }
            final String _tmpOgUrl;
            if (_cursor.isNull(_cursorIndexOfOgUrl)) {
              _tmpOgUrl = null;
            } else {
              _tmpOgUrl = _cursor.getString(_cursorIndexOfOgUrl);
            }
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            final String _tmpText;
            if (_cursor.isNull(_cursorIndexOfText)) {
              _tmpText = null;
            } else {
              _tmpText = _cursor.getString(_cursorIndexOfText);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final String _tmpUrl;
            if (_cursor.isNull(_cursorIndexOfUrl)) {
              _tmpUrl = null;
            } else {
              _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpFallback;
            if (_cursor.isNull(_cursorIndexOfFallback)) {
              _tmpFallback = null;
            } else {
              _tmpFallback = _cursor.getString(_cursorIndexOfFallback);
            }
            final String _tmpUploadFilePath;
            if (_cursor.isNull(_cursorIndexOfUploadFilePath)) {
              _tmpUploadFilePath = null;
            } else {
              _tmpUploadFilePath = _cursor.getString(_cursorIndexOfUploadFilePath);
            }
            final Integer _tmpOriginalHeight;
            if (_cursor.isNull(_cursorIndexOfOriginalHeight)) {
              _tmpOriginalHeight = null;
            } else {
              _tmpOriginalHeight = _cursor.getInt(_cursorIndexOfOriginalHeight);
            }
            final Integer _tmpOriginalWidth;
            if (_cursor.isNull(_cursorIndexOfOriginalWidth)) {
              _tmpOriginalWidth = null;
            } else {
              _tmpOriginalWidth = _cursor.getInt(_cursorIndexOfOriginalWidth);
            }
            final Map<String, Object> _tmpExtraData;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_1 = __extraDataConverter.stringToMap(_tmp);
            if(_tmp_1 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_1;
            }
            final UploadStateEntity _tmpUploadState;
            if (!(_cursor.isNull(_cursorIndexOfStatusCode) && _cursor.isNull(_cursorIndexOfErrorMessage))) {
              final int _tmpStatusCode;
              _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
              final String _tmpErrorMessage;
              if (_cursor.isNull(_cursorIndexOfErrorMessage)) {
                _tmpErrorMessage = null;
              } else {
                _tmpErrorMessage = _cursor.getString(_cursorIndexOfErrorMessage);
              }
              _tmpUploadState = new UploadStateEntity(_tmpStatusCode,_tmpErrorMessage);
            } else {
              _tmpUploadState = null;
            }
            _item = new AttachmentEntity(_tmpId,_tmpMessageId,_tmpAuthorName,_tmpTitleLink,_tmpAuthorLink,_tmpThumbUrl,_tmpImageUrl,_tmpAssetUrl,_tmpOgUrl,_tmpMimeType,_tmpFileSize,_tmpTitle,_tmpText,_tmpType,_tmpImage,_tmpUrl,_tmpName,_tmpFallback,_tmpUploadFilePath,_tmpOriginalHeight,_tmpOriginalWidth,_tmpUploadState,_tmpExtraData);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
