package io.getstream.chat.android.offline.repository.domain.channelconfig.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ChannelConfigDao_Impl implements ChannelConfigDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ChannelConfigInnerEntity> __insertionAdapterOfChannelConfigInnerEntity;

  private final DateConverter __dateConverter = new DateConverter();

  private final EntityInsertionAdapter<CommandInnerEntity> __insertionAdapterOfCommandInnerEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteCommands;

  private final SharedSQLiteStatement __preparedStmtOfDeleteConfigs;

  public ChannelConfigDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfChannelConfigInnerEntity = new EntityInsertionAdapter<ChannelConfigInnerEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_chat_channel_config` (`channelType`,`createdAt`,`updatedAt`,`name`,`isTypingEvents`,`isReadEvents`,`isConnectEvents`,`isSearch`,`isReactionsEnabled`,`isThreadEnabled`,`isMutes`,`uploadsEnabled`,`urlEnrichmentEnabled`,`customEventsEnabled`,`pushNotificationsEnabled`,`messageRetention`,`maxMessageLength`,`automod`,`automodBehavior`,`blocklistBehavior`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChannelConfigInnerEntity value) {
        if (value.getChannelType() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getChannelType());
        }
        final Long _tmp = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindLong(2, _tmp);
        }
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_1 == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindLong(3, _tmp_1);
        }
        if (value.getName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getName());
        }
        final int _tmp_2 = value.isTypingEvents() ? 1 : 0;
        stmt.bindLong(5, _tmp_2);
        final int _tmp_3 = value.isReadEvents() ? 1 : 0;
        stmt.bindLong(6, _tmp_3);
        final int _tmp_4 = value.isConnectEvents() ? 1 : 0;
        stmt.bindLong(7, _tmp_4);
        final int _tmp_5 = value.isSearch() ? 1 : 0;
        stmt.bindLong(8, _tmp_5);
        final int _tmp_6 = value.isReactionsEnabled() ? 1 : 0;
        stmt.bindLong(9, _tmp_6);
        final int _tmp_7 = value.isThreadEnabled() ? 1 : 0;
        stmt.bindLong(10, _tmp_7);
        final int _tmp_8 = value.isMutes() ? 1 : 0;
        stmt.bindLong(11, _tmp_8);
        final int _tmp_9 = value.getUploadsEnabled() ? 1 : 0;
        stmt.bindLong(12, _tmp_9);
        final int _tmp_10 = value.getUrlEnrichmentEnabled() ? 1 : 0;
        stmt.bindLong(13, _tmp_10);
        final int _tmp_11 = value.getCustomEventsEnabled() ? 1 : 0;
        stmt.bindLong(14, _tmp_11);
        final int _tmp_12 = value.getPushNotificationsEnabled() ? 1 : 0;
        stmt.bindLong(15, _tmp_12);
        if (value.getMessageRetention() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getMessageRetention());
        }
        stmt.bindLong(17, value.getMaxMessageLength());
        if (value.getAutomod() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindString(18, value.getAutomod());
        }
        if (value.getAutomodBehavior() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getAutomodBehavior());
        }
        if (value.getBlocklistBehavior() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, value.getBlocklistBehavior());
        }
      }
    };
    this.__insertionAdapterOfCommandInnerEntity = new EntityInsertionAdapter<CommandInnerEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `command_inner_entity` (`name`,`description`,`args`,`set`,`channelType`,`id`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CommandInnerEntity value) {
        if (value.getName() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getName());
        }
        if (value.getDescription() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDescription());
        }
        if (value.getArgs() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getArgs());
        }
        if (value.getSet() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getSet());
        }
        if (value.getChannelType() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getChannelType());
        }
        stmt.bindLong(6, value.getId());
      }
    };
    this.__preparedStmtOfDeleteCommands = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM command_inner_entity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteConfigs = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_chat_channel_config";
        return _query;
      }
    };
  }

  @Override
  public Object insertConfig(final ChannelConfigInnerEntity channelConfigInnerEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfChannelConfigInnerEntity.insert(channelConfigInnerEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertConfigs(final List<ChannelConfigInnerEntity> channelConfigInnerEntities,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfChannelConfigInnerEntity.insert(channelConfigInnerEntities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertCommands(final List<CommandInnerEntity> commands,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCommandInnerEntity.insert(commands);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insert(final ChannelConfigEntity channelConfigEntity,
      final Continuation<? super Unit> continuation) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ChannelConfigDao.DefaultImpls.insert(ChannelConfigDao_Impl.this, channelConfigEntity, __cont), continuation);
  }

  @Override
  public Object deleteCommands(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteCommands.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteCommands.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteConfigs(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteConfigs.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteConfigs.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object selectAll(final Continuation<? super List<ChannelConfigEntity>> continuation) {
    final String _sql = "SELECT * FROM stream_chat_channel_config LIMIT 100";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<ChannelConfigEntity>>() {
      @Override
      public List<ChannelConfigEntity> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow(_cursor, "channelType");
            final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
            final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfIsTypingEvents = CursorUtil.getColumnIndexOrThrow(_cursor, "isTypingEvents");
            final int _cursorIndexOfIsReadEvents = CursorUtil.getColumnIndexOrThrow(_cursor, "isReadEvents");
            final int _cursorIndexOfIsConnectEvents = CursorUtil.getColumnIndexOrThrow(_cursor, "isConnectEvents");
            final int _cursorIndexOfIsSearch = CursorUtil.getColumnIndexOrThrow(_cursor, "isSearch");
            final int _cursorIndexOfIsReactionsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "isReactionsEnabled");
            final int _cursorIndexOfIsThreadEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "isThreadEnabled");
            final int _cursorIndexOfIsMutes = CursorUtil.getColumnIndexOrThrow(_cursor, "isMutes");
            final int _cursorIndexOfUploadsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "uploadsEnabled");
            final int _cursorIndexOfUrlEnrichmentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "urlEnrichmentEnabled");
            final int _cursorIndexOfCustomEventsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "customEventsEnabled");
            final int _cursorIndexOfPushNotificationsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "pushNotificationsEnabled");
            final int _cursorIndexOfMessageRetention = CursorUtil.getColumnIndexOrThrow(_cursor, "messageRetention");
            final int _cursorIndexOfMaxMessageLength = CursorUtil.getColumnIndexOrThrow(_cursor, "maxMessageLength");
            final int _cursorIndexOfAutomod = CursorUtil.getColumnIndexOrThrow(_cursor, "automod");
            final int _cursorIndexOfAutomodBehavior = CursorUtil.getColumnIndexOrThrow(_cursor, "automodBehavior");
            final int _cursorIndexOfBlocklistBehavior = CursorUtil.getColumnIndexOrThrow(_cursor, "blocklistBehavior");
            final ArrayMap<String, ArrayList<CommandInnerEntity>> _collectionCommands = new ArrayMap<String, ArrayList<CommandInnerEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfChannelType);
              ArrayList<CommandInnerEntity> _tmpCommandsCollection = _collectionCommands.get(_tmpKey);
              if (_tmpCommandsCollection == null) {
                _tmpCommandsCollection = new ArrayList<CommandInnerEntity>();
                _collectionCommands.put(_tmpKey, _tmpCommandsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipcommandInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainChannelconfigInternalCommandInnerEntity(_collectionCommands);
            final List<ChannelConfigEntity> _result = new ArrayList<ChannelConfigEntity>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final ChannelConfigEntity _item;
              final ChannelConfigInnerEntity _tmpChannelConfigInnerEntity;
              final String _tmpChannelType;
              if (_cursor.isNull(_cursorIndexOfChannelType)) {
                _tmpChannelType = null;
              } else {
                _tmpChannelType = _cursor.getString(_cursorIndexOfChannelType);
              }
              final Date _tmpCreatedAt;
              final Long _tmp;
              if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
                _tmp = null;
              } else {
                _tmp = _cursor.getLong(_cursorIndexOfCreatedAt);
              }
              _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp);
              final Date _tmpUpdatedAt;
              final Long _tmp_1;
              if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getLong(_cursorIndexOfUpdatedAt);
              }
              _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_1);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              final boolean _tmpIsTypingEvents;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfIsTypingEvents);
              _tmpIsTypingEvents = _tmp_2 != 0;
              final boolean _tmpIsReadEvents;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfIsReadEvents);
              _tmpIsReadEvents = _tmp_3 != 0;
              final boolean _tmpIsConnectEvents;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfIsConnectEvents);
              _tmpIsConnectEvents = _tmp_4 != 0;
              final boolean _tmpIsSearch;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfIsSearch);
              _tmpIsSearch = _tmp_5 != 0;
              final boolean _tmpIsReactionsEnabled;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfIsReactionsEnabled);
              _tmpIsReactionsEnabled = _tmp_6 != 0;
              final boolean _tmpIsThreadEnabled;
              final int _tmp_7;
              _tmp_7 = _cursor.getInt(_cursorIndexOfIsThreadEnabled);
              _tmpIsThreadEnabled = _tmp_7 != 0;
              final boolean _tmpIsMutes;
              final int _tmp_8;
              _tmp_8 = _cursor.getInt(_cursorIndexOfIsMutes);
              _tmpIsMutes = _tmp_8 != 0;
              final boolean _tmpUploadsEnabled;
              final int _tmp_9;
              _tmp_9 = _cursor.getInt(_cursorIndexOfUploadsEnabled);
              _tmpUploadsEnabled = _tmp_9 != 0;
              final boolean _tmpUrlEnrichmentEnabled;
              final int _tmp_10;
              _tmp_10 = _cursor.getInt(_cursorIndexOfUrlEnrichmentEnabled);
              _tmpUrlEnrichmentEnabled = _tmp_10 != 0;
              final boolean _tmpCustomEventsEnabled;
              final int _tmp_11;
              _tmp_11 = _cursor.getInt(_cursorIndexOfCustomEventsEnabled);
              _tmpCustomEventsEnabled = _tmp_11 != 0;
              final boolean _tmpPushNotificationsEnabled;
              final int _tmp_12;
              _tmp_12 = _cursor.getInt(_cursorIndexOfPushNotificationsEnabled);
              _tmpPushNotificationsEnabled = _tmp_12 != 0;
              final String _tmpMessageRetention;
              if (_cursor.isNull(_cursorIndexOfMessageRetention)) {
                _tmpMessageRetention = null;
              } else {
                _tmpMessageRetention = _cursor.getString(_cursorIndexOfMessageRetention);
              }
              final int _tmpMaxMessageLength;
              _tmpMaxMessageLength = _cursor.getInt(_cursorIndexOfMaxMessageLength);
              final String _tmpAutomod;
              if (_cursor.isNull(_cursorIndexOfAutomod)) {
                _tmpAutomod = null;
              } else {
                _tmpAutomod = _cursor.getString(_cursorIndexOfAutomod);
              }
              final String _tmpAutomodBehavior;
              if (_cursor.isNull(_cursorIndexOfAutomodBehavior)) {
                _tmpAutomodBehavior = null;
              } else {
                _tmpAutomodBehavior = _cursor.getString(_cursorIndexOfAutomodBehavior);
              }
              final String _tmpBlocklistBehavior;
              if (_cursor.isNull(_cursorIndexOfBlocklistBehavior)) {
                _tmpBlocklistBehavior = null;
              } else {
                _tmpBlocklistBehavior = _cursor.getString(_cursorIndexOfBlocklistBehavior);
              }
              _tmpChannelConfigInnerEntity = new ChannelConfigInnerEntity(_tmpChannelType,_tmpCreatedAt,_tmpUpdatedAt,_tmpName,_tmpIsTypingEvents,_tmpIsReadEvents,_tmpIsConnectEvents,_tmpIsSearch,_tmpIsReactionsEnabled,_tmpIsThreadEnabled,_tmpIsMutes,_tmpUploadsEnabled,_tmpUrlEnrichmentEnabled,_tmpCustomEventsEnabled,_tmpPushNotificationsEnabled,_tmpMessageRetention,_tmpMaxMessageLength,_tmpAutomod,_tmpAutomodBehavior,_tmpBlocklistBehavior);
              ArrayList<CommandInnerEntity> _tmpCommandsCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfChannelType);
              _tmpCommandsCollection_1 = _collectionCommands.get(_tmpKey_1);
              if (_tmpCommandsCollection_1 == null) {
                _tmpCommandsCollection_1 = new ArrayList<CommandInnerEntity>();
              }
              _item = new ChannelConfigEntity(_tmpChannelConfigInnerEntity,_tmpCommandsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insert(final List<ChannelConfigEntity> channelConfigEntities,
      final Continuation<? super Unit> continuation) {
    return ChannelConfigDao.DefaultImpls.insert(ChannelConfigDao_Impl.this, channelConfigEntities, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return ChannelConfigDao.DefaultImpls.deleteAll(ChannelConfigDao_Impl.this, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipcommandInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainChannelconfigInternalCommandInnerEntity(
      final ArrayMap<String, ArrayList<CommandInnerEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<CommandInnerEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<CommandInnerEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipcommandInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainChannelconfigInternalCommandInnerEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<CommandInnerEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipcommandInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainChannelconfigInternalCommandInnerEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `name`,`description`,`args`,`set`,`channelType`,`id` FROM `command_inner_entity` WHERE `channelType` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "channelType");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfName = 0;
      final int _cursorIndexOfDescription = 1;
      final int _cursorIndexOfArgs = 2;
      final int _cursorIndexOfSet = 3;
      final int _cursorIndexOfChannelType = 4;
      final int _cursorIndexOfId = 5;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<CommandInnerEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final CommandInnerEntity _item_1;
          final String _tmpName;
          if (_cursor.isNull(_cursorIndexOfName)) {
            _tmpName = null;
          } else {
            _tmpName = _cursor.getString(_cursorIndexOfName);
          }
          final String _tmpDescription;
          if (_cursor.isNull(_cursorIndexOfDescription)) {
            _tmpDescription = null;
          } else {
            _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
          }
          final String _tmpArgs;
          if (_cursor.isNull(_cursorIndexOfArgs)) {
            _tmpArgs = null;
          } else {
            _tmpArgs = _cursor.getString(_cursorIndexOfArgs);
          }
          final String _tmpSet;
          if (_cursor.isNull(_cursorIndexOfSet)) {
            _tmpSet = null;
          } else {
            _tmpSet = _cursor.getString(_cursorIndexOfSet);
          }
          final String _tmpChannelType;
          if (_cursor.isNull(_cursorIndexOfChannelType)) {
            _tmpChannelType = null;
          } else {
            _tmpChannelType = _cursor.getString(_cursorIndexOfChannelType);
          }
          _item_1 = new CommandInnerEntity(_tmpName,_tmpDescription,_tmpArgs,_tmpSet,_tmpChannelType);
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          _item_1.setId(_tmpId);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
