package io.getstream.chat.android.offline.repository.database.internal;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomOpenHelper;
import androidx.room.RoomOpenHelper.Delegate;
import androidx.room.RoomOpenHelper.ValidationResult;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.room.util.TableInfo.Column;
import androidx.room.util.TableInfo.ForeignKey;
import androidx.room.util.TableInfo.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Callback;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Configuration;
import io.getstream.chat.android.offline.repository.domain.channel.internal.ChannelDao;
import io.getstream.chat.android.offline.repository.domain.channel.internal.ChannelDao_Impl;
import io.getstream.chat.android.offline.repository.domain.channelconfig.internal.ChannelConfigDao;
import io.getstream.chat.android.offline.repository.domain.channelconfig.internal.ChannelConfigDao_Impl;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentDao;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentDao_Impl;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageDao;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageDao_Impl;
import io.getstream.chat.android.offline.repository.domain.message.internal.ReplyMessageDao;
import io.getstream.chat.android.offline.repository.domain.message.internal.ReplyMessageDao_Impl;
import io.getstream.chat.android.offline.repository.domain.queryChannels.internal.QueryChannelsDao;
import io.getstream.chat.android.offline.repository.domain.queryChannels.internal.QueryChannelsDao_Impl;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionDao;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionDao_Impl;
import io.getstream.chat.android.offline.repository.domain.syncState.internal.SyncStateDao;
import io.getstream.chat.android.offline.repository.domain.syncState.internal.SyncStateDao_Impl;
import io.getstream.chat.android.offline.repository.domain.user.internal.UserDao;
import io.getstream.chat.android.offline.repository.domain.user.internal.UserDao_Impl;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ChatDatabase_Impl extends ChatDatabase {
  private volatile QueryChannelsDao _queryChannelsDao;

  private volatile UserDao _userDao;

  private volatile ReactionDao _reactionDao;

  private volatile MessageDao _messageDao;

  private volatile ReplyMessageDao _replyMessageDao;

  private volatile ChannelDao _channelDao;

  private volatile ChannelConfigDao _channelConfigDao;

  private volatile SyncStateDao _syncStateDao;

  private volatile AttachmentDao _attachmentDao;

  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(69) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_channel_query` (`id` TEXT NOT NULL, `filter` TEXT NOT NULL, `querySort` TEXT NOT NULL, `cids` TEXT NOT NULL, PRIMARY KEY(`id`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_message` (`id` TEXT NOT NULL, `cid` TEXT NOT NULL, `userId` TEXT NOT NULL, `text` TEXT NOT NULL, `html` TEXT NOT NULL, `type` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `replyCount` INTEGER NOT NULL, `deletedReplyCount` INTEGER NOT NULL, `createdAt` INTEGER, `createdLocallyAt` INTEGER, `updatedAt` INTEGER, `updatedLocallyAt` INTEGER, `deletedAt` INTEGER, `remoteMentionedUserIds` TEXT NOT NULL, `mentionedUsersId` TEXT NOT NULL, `reactionCounts` TEXT NOT NULL, `reactionScores` TEXT NOT NULL, `parentId` TEXT, `command` TEXT, `shadowed` INTEGER NOT NULL, `i18n` TEXT NOT NULL, `showInChannel` INTEGER NOT NULL, `silent` INTEGER NOT NULL, `extraData` TEXT NOT NULL, `replyToId` TEXT, `pinned` INTEGER NOT NULL, `pinnedAt` INTEGER, `pinExpires` INTEGER, `pinnedByUserId` TEXT, `threadParticipantsIds` TEXT NOT NULL, `skipPushNotification` INTEGER NOT NULL, `skipEnrichUrl` INTEGER NOT NULL, `moderationDetails` TEXT, `channel_infocid` TEXT, `channel_infoid` TEXT, `channel_infotype` TEXT, `channel_infomemberCount` INTEGER, `channel_infoname` TEXT, PRIMARY KEY(`id`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_message_cid_createdAt` ON `stream_chat_message` (`cid`, `createdAt`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_message_syncStatus` ON `stream_chat_message` (`syncStatus`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_reply_message` (`id` TEXT NOT NULL, `cid` TEXT NOT NULL, `userId` TEXT NOT NULL, `text` TEXT NOT NULL, `html` TEXT NOT NULL, `type` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `replyCount` INTEGER NOT NULL, `deletedReplyCount` INTEGER NOT NULL, `createdAt` INTEGER, `createdLocallyAt` INTEGER, `updatedAt` INTEGER, `updatedLocallyAt` INTEGER, `deletedAt` INTEGER, `remoteMentionedUserIds` TEXT NOT NULL, `mentionedUsersId` TEXT NOT NULL, `parentId` TEXT, `command` TEXT, `shadowed` INTEGER NOT NULL, `i18n` TEXT NOT NULL, `showInChannel` INTEGER NOT NULL, `silent` INTEGER NOT NULL, `extraData` TEXT NOT NULL, `pinned` INTEGER NOT NULL, `pinnedAt` INTEGER, `pinExpires` INTEGER, `pinnedByUserId` TEXT, `threadParticipantsIds` TEXT NOT NULL, `moderationDetails` TEXT, `channel_infocid` TEXT, `channel_infoid` TEXT, `channel_infotype` TEXT, `channel_infomemberCount` INTEGER, `channel_infoname` TEXT, PRIMARY KEY(`id`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reply_message_cid_createdAt` ON `stream_chat_reply_message` (`cid`, `createdAt`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reply_message_syncStatus` ON `stream_chat_reply_message` (`syncStatus`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `attachment_inner_entity` (`id` TEXT NOT NULL, `messageId` TEXT NOT NULL, `authorName` TEXT, `titleLink` TEXT, `authorLink` TEXT, `thumbUrl` TEXT, `imageUrl` TEXT, `assetUrl` TEXT, `ogUrl` TEXT, `mimeType` TEXT, `fileSize` INTEGER NOT NULL, `title` TEXT, `text` TEXT, `type` TEXT, `image` TEXT, `url` TEXT, `name` TEXT, `fallback` TEXT, `uploadFilePath` TEXT, `originalHeight` INTEGER, `originalWidth` INTEGER, `extraData` TEXT NOT NULL, `statusCode` INTEGER, `errorMessage` TEXT, PRIMARY KEY(`id`), FOREIGN KEY(`messageId`) REFERENCES `stream_chat_message`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_attachment_inner_entity_messageId` ON `attachment_inner_entity` (`messageId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_attachment_inner_entity_id` ON `attachment_inner_entity` (`id`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `reply_attachment_inner_entity` (`id` TEXT NOT NULL, `messageId` TEXT NOT NULL, `authorName` TEXT, `titleLink` TEXT, `authorLink` TEXT, `thumbUrl` TEXT, `imageUrl` TEXT, `assetUrl` TEXT, `ogUrl` TEXT, `mimeType` TEXT, `fileSize` INTEGER NOT NULL, `title` TEXT, `text` TEXT, `type` TEXT, `image` TEXT, `url` TEXT, `name` TEXT, `fallback` TEXT, `uploadFilePath` TEXT, `originalHeight` INTEGER, `originalWidth` INTEGER, `extraData` TEXT NOT NULL, `statusCode` INTEGER, `errorMessage` TEXT, PRIMARY KEY(`id`), FOREIGN KEY(`messageId`) REFERENCES `stream_chat_reply_message`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_reply_attachment_inner_entity_messageId` ON `reply_attachment_inner_entity` (`messageId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_reply_attachment_inner_entity_id` ON `reply_attachment_inner_entity` (`id`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_user` (`id` TEXT NOT NULL, `originalId` TEXT NOT NULL, `name` TEXT NOT NULL, `image` TEXT NOT NULL, `role` TEXT NOT NULL, `createdAt` INTEGER, `updatedAt` INTEGER, `lastActive` INTEGER, `invisible` INTEGER NOT NULL, `banned` INTEGER NOT NULL, `mutes` TEXT NOT NULL, `extraData` TEXT NOT NULL, PRIMARY KEY(`id`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_user_name` ON `stream_chat_user` (`name`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_reaction` (`messageId` TEXT NOT NULL, `userId` TEXT NOT NULL, `type` TEXT NOT NULL, `score` INTEGER NOT NULL, `createdAt` INTEGER, `createdLocallyAt` INTEGER, `updatedAt` INTEGER, `deletedAt` INTEGER, `enforceUnique` INTEGER NOT NULL, `extraData` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `id` INTEGER NOT NULL, PRIMARY KEY(`id`), FOREIGN KEY(`messageId`) REFERENCES `stream_chat_message`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED)");
        _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_stream_chat_reaction_messageId_userId_type` ON `stream_chat_reaction` (`messageId`, `userId`, `type`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reaction_syncStatus` ON `stream_chat_reaction` (`syncStatus`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reaction_messageId` ON `stream_chat_reaction` (`messageId`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_channel_state` (`type` TEXT NOT NULL, `channelId` TEXT NOT NULL, `name` TEXT NOT NULL, `image` TEXT NOT NULL, `cooldown` INTEGER NOT NULL, `createdByUserId` TEXT NOT NULL, `frozen` INTEGER NOT NULL, `hidden` INTEGER, `hideMessagesBefore` INTEGER, `members` TEXT NOT NULL, `memberCount` INTEGER NOT NULL, `watcherIds` TEXT NOT NULL, `watcherCount` INTEGER NOT NULL, `reads` TEXT NOT NULL, `lastMessageAt` INTEGER, `lastMessageId` TEXT, `createdAt` INTEGER, `updatedAt` INTEGER, `deletedAt` INTEGER, `extraData` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `team` TEXT NOT NULL, `ownCapabilities` TEXT NOT NULL, `membership` TEXT, `cid` TEXT NOT NULL, PRIMARY KEY(`cid`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_channel_state_syncStatus` ON `stream_chat_channel_state` (`syncStatus`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_channel_config` (`channelType` TEXT NOT NULL, `createdAt` INTEGER, `updatedAt` INTEGER, `name` TEXT NOT NULL, `isTypingEvents` INTEGER NOT NULL, `isReadEvents` INTEGER NOT NULL, `isConnectEvents` INTEGER NOT NULL, `isSearch` INTEGER NOT NULL, `isReactionsEnabled` INTEGER NOT NULL, `isThreadEnabled` INTEGER NOT NULL, `isMutes` INTEGER NOT NULL, `uploadsEnabled` INTEGER NOT NULL, `urlEnrichmentEnabled` INTEGER NOT NULL, `customEventsEnabled` INTEGER NOT NULL, `pushNotificationsEnabled` INTEGER NOT NULL, `messageRetention` TEXT NOT NULL, `maxMessageLength` INTEGER NOT NULL, `automod` TEXT NOT NULL, `automodBehavior` TEXT NOT NULL, `blocklistBehavior` TEXT NOT NULL, PRIMARY KEY(`channelType`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `command_inner_entity` (`name` TEXT NOT NULL, `description` TEXT NOT NULL, `args` TEXT NOT NULL, `set` TEXT NOT NULL, `channelType` TEXT NOT NULL, `id` INTEGER NOT NULL, PRIMARY KEY(`id`), FOREIGN KEY(`channelType`) REFERENCES `stream_chat_channel_config`(`channelType`) ON UPDATE CASCADE ON DELETE CASCADE )");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_command_inner_entity_channelType` ON `command_inner_entity` (`channelType`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_sync_state` (`userId` TEXT NOT NULL, `activeChannelIds` TEXT NOT NULL, `lastSyncedAt` INTEGER, `rawLastSyncedAt` TEXT, `markedAllReadAt` INTEGER, PRIMARY KEY(`userId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'fb003d1b750d6fb9c9e419224201c0b3')");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `stream_channel_query`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_message`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_reply_message`");
        _db.execSQL("DROP TABLE IF EXISTS `attachment_inner_entity`");
        _db.execSQL("DROP TABLE IF EXISTS `reply_attachment_inner_entity`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_user`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_reaction`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_channel_state`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_chat_channel_config`");
        _db.execSQL("DROP TABLE IF EXISTS `command_inner_entity`");
        _db.execSQL("DROP TABLE IF EXISTS `stream_sync_state`");
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onDestructiveMigration(_db);
          }
        }
      }

      @Override
      public void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        _db.execSQL("PRAGMA foreign_keys = ON");
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      public void onPreMigrate(SupportSQLiteDatabase _db) {
        DBUtil.dropFtsSyncTriggers(_db);
      }

      @Override
      public void onPostMigrate(SupportSQLiteDatabase _db) {
      }

      @Override
      public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsStreamChannelQuery = new HashMap<String, TableInfo.Column>(4);
        _columnsStreamChannelQuery.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChannelQuery.put("filter", new TableInfo.Column("filter", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChannelQuery.put("querySort", new TableInfo.Column("querySort", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChannelQuery.put("cids", new TableInfo.Column("cids", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChannelQuery = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChannelQuery = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoStreamChannelQuery = new TableInfo("stream_channel_query", _columnsStreamChannelQuery, _foreignKeysStreamChannelQuery, _indicesStreamChannelQuery);
        final TableInfo _existingStreamChannelQuery = TableInfo.read(_db, "stream_channel_query");
        if (! _infoStreamChannelQuery.equals(_existingStreamChannelQuery)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_channel_query(io.getstream.chat.android.offline.repository.domain.queryChannels.internal.QueryChannelsEntity).\n"
                  + " Expected:\n" + _infoStreamChannelQuery + "\n"
                  + " Found:\n" + _existingStreamChannelQuery);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatMessage = new HashMap<String, TableInfo.Column>(39);
        _columnsStreamChatMessage.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("cid", new TableInfo.Column("cid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("text", new TableInfo.Column("text", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("html", new TableInfo.Column("html", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("replyCount", new TableInfo.Column("replyCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("deletedReplyCount", new TableInfo.Column("deletedReplyCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("createdLocallyAt", new TableInfo.Column("createdLocallyAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("updatedLocallyAt", new TableInfo.Column("updatedLocallyAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("remoteMentionedUserIds", new TableInfo.Column("remoteMentionedUserIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("mentionedUsersId", new TableInfo.Column("mentionedUsersId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("reactionCounts", new TableInfo.Column("reactionCounts", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("reactionScores", new TableInfo.Column("reactionScores", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("command", new TableInfo.Column("command", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("shadowed", new TableInfo.Column("shadowed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("i18n", new TableInfo.Column("i18n", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("showInChannel", new TableInfo.Column("showInChannel", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("silent", new TableInfo.Column("silent", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("replyToId", new TableInfo.Column("replyToId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("pinned", new TableInfo.Column("pinned", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("pinnedAt", new TableInfo.Column("pinnedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("pinExpires", new TableInfo.Column("pinExpires", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("pinnedByUserId", new TableInfo.Column("pinnedByUserId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("threadParticipantsIds", new TableInfo.Column("threadParticipantsIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("skipPushNotification", new TableInfo.Column("skipPushNotification", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("skipEnrichUrl", new TableInfo.Column("skipEnrichUrl", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("moderationDetails", new TableInfo.Column("moderationDetails", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("channel_infocid", new TableInfo.Column("channel_infocid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("channel_infoid", new TableInfo.Column("channel_infoid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("channel_infotype", new TableInfo.Column("channel_infotype", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("channel_infomemberCount", new TableInfo.Column("channel_infomemberCount", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatMessage.put("channel_infoname", new TableInfo.Column("channel_infoname", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatMessage = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChatMessage = new HashSet<TableInfo.Index>(2);
        _indicesStreamChatMessage.add(new TableInfo.Index("index_stream_chat_message_cid_createdAt", false, Arrays.asList("cid","createdAt"), Arrays.asList("ASC","ASC")));
        _indicesStreamChatMessage.add(new TableInfo.Index("index_stream_chat_message_syncStatus", false, Arrays.asList("syncStatus"), Arrays.asList("ASC")));
        final TableInfo _infoStreamChatMessage = new TableInfo("stream_chat_message", _columnsStreamChatMessage, _foreignKeysStreamChatMessage, _indicesStreamChatMessage);
        final TableInfo _existingStreamChatMessage = TableInfo.read(_db, "stream_chat_message");
        if (! _infoStreamChatMessage.equals(_existingStreamChatMessage)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_message(io.getstream.chat.android.offline.repository.domain.message.internal.MessageInnerEntity).\n"
                  + " Expected:\n" + _infoStreamChatMessage + "\n"
                  + " Found:\n" + _existingStreamChatMessage);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatReplyMessage = new HashMap<String, TableInfo.Column>(34);
        _columnsStreamChatReplyMessage.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("cid", new TableInfo.Column("cid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("text", new TableInfo.Column("text", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("html", new TableInfo.Column("html", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("replyCount", new TableInfo.Column("replyCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("deletedReplyCount", new TableInfo.Column("deletedReplyCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("createdLocallyAt", new TableInfo.Column("createdLocallyAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("updatedLocallyAt", new TableInfo.Column("updatedLocallyAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("remoteMentionedUserIds", new TableInfo.Column("remoteMentionedUserIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("mentionedUsersId", new TableInfo.Column("mentionedUsersId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("command", new TableInfo.Column("command", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("shadowed", new TableInfo.Column("shadowed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("i18n", new TableInfo.Column("i18n", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("showInChannel", new TableInfo.Column("showInChannel", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("silent", new TableInfo.Column("silent", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("pinned", new TableInfo.Column("pinned", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("pinnedAt", new TableInfo.Column("pinnedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("pinExpires", new TableInfo.Column("pinExpires", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("pinnedByUserId", new TableInfo.Column("pinnedByUserId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("threadParticipantsIds", new TableInfo.Column("threadParticipantsIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("moderationDetails", new TableInfo.Column("moderationDetails", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("channel_infocid", new TableInfo.Column("channel_infocid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("channel_infoid", new TableInfo.Column("channel_infoid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("channel_infotype", new TableInfo.Column("channel_infotype", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("channel_infomemberCount", new TableInfo.Column("channel_infomemberCount", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReplyMessage.put("channel_infoname", new TableInfo.Column("channel_infoname", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatReplyMessage = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChatReplyMessage = new HashSet<TableInfo.Index>(2);
        _indicesStreamChatReplyMessage.add(new TableInfo.Index("index_stream_chat_reply_message_cid_createdAt", false, Arrays.asList("cid","createdAt"), Arrays.asList("ASC","ASC")));
        _indicesStreamChatReplyMessage.add(new TableInfo.Index("index_stream_chat_reply_message_syncStatus", false, Arrays.asList("syncStatus"), Arrays.asList("ASC")));
        final TableInfo _infoStreamChatReplyMessage = new TableInfo("stream_chat_reply_message", _columnsStreamChatReplyMessage, _foreignKeysStreamChatReplyMessage, _indicesStreamChatReplyMessage);
        final TableInfo _existingStreamChatReplyMessage = TableInfo.read(_db, "stream_chat_reply_message");
        if (! _infoStreamChatReplyMessage.equals(_existingStreamChatReplyMessage)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_reply_message(io.getstream.chat.android.offline.repository.domain.message.internal.ReplyMessageInnerEntity).\n"
                  + " Expected:\n" + _infoStreamChatReplyMessage + "\n"
                  + " Found:\n" + _existingStreamChatReplyMessage);
        }
        final HashMap<String, TableInfo.Column> _columnsAttachmentInnerEntity = new HashMap<String, TableInfo.Column>(24);
        _columnsAttachmentInnerEntity.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("authorName", new TableInfo.Column("authorName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("titleLink", new TableInfo.Column("titleLink", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("authorLink", new TableInfo.Column("authorLink", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("thumbUrl", new TableInfo.Column("thumbUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("imageUrl", new TableInfo.Column("imageUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("assetUrl", new TableInfo.Column("assetUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("ogUrl", new TableInfo.Column("ogUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("fileSize", new TableInfo.Column("fileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("text", new TableInfo.Column("text", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("type", new TableInfo.Column("type", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("image", new TableInfo.Column("image", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("url", new TableInfo.Column("url", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("fallback", new TableInfo.Column("fallback", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("uploadFilePath", new TableInfo.Column("uploadFilePath", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("originalHeight", new TableInfo.Column("originalHeight", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("originalWidth", new TableInfo.Column("originalWidth", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("statusCode", new TableInfo.Column("statusCode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttachmentInnerEntity.put("errorMessage", new TableInfo.Column("errorMessage", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAttachmentInnerEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAttachmentInnerEntity.add(new TableInfo.ForeignKey("stream_chat_message", "CASCADE", "NO ACTION",Arrays.asList("messageId"), Arrays.asList("id")));
        final HashSet<TableInfo.Index> _indicesAttachmentInnerEntity = new HashSet<TableInfo.Index>(2);
        _indicesAttachmentInnerEntity.add(new TableInfo.Index("index_attachment_inner_entity_messageId", false, Arrays.asList("messageId"), Arrays.asList("ASC")));
        _indicesAttachmentInnerEntity.add(new TableInfo.Index("index_attachment_inner_entity_id", false, Arrays.asList("id"), Arrays.asList("ASC")));
        final TableInfo _infoAttachmentInnerEntity = new TableInfo("attachment_inner_entity", _columnsAttachmentInnerEntity, _foreignKeysAttachmentInnerEntity, _indicesAttachmentInnerEntity);
        final TableInfo _existingAttachmentInnerEntity = TableInfo.read(_db, "attachment_inner_entity");
        if (! _infoAttachmentInnerEntity.equals(_existingAttachmentInnerEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "attachment_inner_entity(io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentEntity).\n"
                  + " Expected:\n" + _infoAttachmentInnerEntity + "\n"
                  + " Found:\n" + _existingAttachmentInnerEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsReplyAttachmentInnerEntity = new HashMap<String, TableInfo.Column>(24);
        _columnsReplyAttachmentInnerEntity.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("authorName", new TableInfo.Column("authorName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("titleLink", new TableInfo.Column("titleLink", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("authorLink", new TableInfo.Column("authorLink", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("thumbUrl", new TableInfo.Column("thumbUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("imageUrl", new TableInfo.Column("imageUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("assetUrl", new TableInfo.Column("assetUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("ogUrl", new TableInfo.Column("ogUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("fileSize", new TableInfo.Column("fileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("text", new TableInfo.Column("text", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("type", new TableInfo.Column("type", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("image", new TableInfo.Column("image", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("url", new TableInfo.Column("url", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("fallback", new TableInfo.Column("fallback", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("uploadFilePath", new TableInfo.Column("uploadFilePath", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("originalHeight", new TableInfo.Column("originalHeight", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("originalWidth", new TableInfo.Column("originalWidth", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("statusCode", new TableInfo.Column("statusCode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplyAttachmentInnerEntity.put("errorMessage", new TableInfo.Column("errorMessage", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysReplyAttachmentInnerEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysReplyAttachmentInnerEntity.add(new TableInfo.ForeignKey("stream_chat_reply_message", "CASCADE", "NO ACTION",Arrays.asList("messageId"), Arrays.asList("id")));
        final HashSet<TableInfo.Index> _indicesReplyAttachmentInnerEntity = new HashSet<TableInfo.Index>(2);
        _indicesReplyAttachmentInnerEntity.add(new TableInfo.Index("index_reply_attachment_inner_entity_messageId", false, Arrays.asList("messageId"), Arrays.asList("ASC")));
        _indicesReplyAttachmentInnerEntity.add(new TableInfo.Index("index_reply_attachment_inner_entity_id", false, Arrays.asList("id"), Arrays.asList("ASC")));
        final TableInfo _infoReplyAttachmentInnerEntity = new TableInfo("reply_attachment_inner_entity", _columnsReplyAttachmentInnerEntity, _foreignKeysReplyAttachmentInnerEntity, _indicesReplyAttachmentInnerEntity);
        final TableInfo _existingReplyAttachmentInnerEntity = TableInfo.read(_db, "reply_attachment_inner_entity");
        if (! _infoReplyAttachmentInnerEntity.equals(_existingReplyAttachmentInnerEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "reply_attachment_inner_entity(io.getstream.chat.android.offline.repository.domain.message.attachment.internal.ReplyAttachmentEntity).\n"
                  + " Expected:\n" + _infoReplyAttachmentInnerEntity + "\n"
                  + " Found:\n" + _existingReplyAttachmentInnerEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatUser = new HashMap<String, TableInfo.Column>(12);
        _columnsStreamChatUser.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("originalId", new TableInfo.Column("originalId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("image", new TableInfo.Column("image", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("role", new TableInfo.Column("role", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("lastActive", new TableInfo.Column("lastActive", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("invisible", new TableInfo.Column("invisible", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("banned", new TableInfo.Column("banned", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("mutes", new TableInfo.Column("mutes", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatUser.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatUser = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChatUser = new HashSet<TableInfo.Index>(1);
        _indicesStreamChatUser.add(new TableInfo.Index("index_stream_chat_user_name", false, Arrays.asList("name"), Arrays.asList("ASC")));
        final TableInfo _infoStreamChatUser = new TableInfo("stream_chat_user", _columnsStreamChatUser, _foreignKeysStreamChatUser, _indicesStreamChatUser);
        final TableInfo _existingStreamChatUser = TableInfo.read(_db, "stream_chat_user");
        if (! _infoStreamChatUser.equals(_existingStreamChatUser)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_user(io.getstream.chat.android.offline.repository.domain.user.internal.UserEntity).\n"
                  + " Expected:\n" + _infoStreamChatUser + "\n"
                  + " Found:\n" + _existingStreamChatUser);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatReaction = new HashMap<String, TableInfo.Column>(12);
        _columnsStreamChatReaction.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("score", new TableInfo.Column("score", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("createdLocallyAt", new TableInfo.Column("createdLocallyAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("enforceUnique", new TableInfo.Column("enforceUnique", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatReaction.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatReaction = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysStreamChatReaction.add(new TableInfo.ForeignKey("stream_chat_message", "CASCADE", "NO ACTION",Arrays.asList("messageId"), Arrays.asList("id")));
        final HashSet<TableInfo.Index> _indicesStreamChatReaction = new HashSet<TableInfo.Index>(3);
        _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_messageId_userId_type", true, Arrays.asList("messageId","userId","type"), Arrays.asList("ASC","ASC","ASC")));
        _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_syncStatus", false, Arrays.asList("syncStatus"), Arrays.asList("ASC")));
        _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_messageId", false, Arrays.asList("messageId"), Arrays.asList("ASC")));
        final TableInfo _infoStreamChatReaction = new TableInfo("stream_chat_reaction", _columnsStreamChatReaction, _foreignKeysStreamChatReaction, _indicesStreamChatReaction);
        final TableInfo _existingStreamChatReaction = TableInfo.read(_db, "stream_chat_reaction");
        if (! _infoStreamChatReaction.equals(_existingStreamChatReaction)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_reaction(io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionEntity).\n"
                  + " Expected:\n" + _infoStreamChatReaction + "\n"
                  + " Found:\n" + _existingStreamChatReaction);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatChannelState = new HashMap<String, TableInfo.Column>(25);
        _columnsStreamChatChannelState.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("image", new TableInfo.Column("image", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("cooldown", new TableInfo.Column("cooldown", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("createdByUserId", new TableInfo.Column("createdByUserId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("frozen", new TableInfo.Column("frozen", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("hidden", new TableInfo.Column("hidden", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("hideMessagesBefore", new TableInfo.Column("hideMessagesBefore", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("members", new TableInfo.Column("members", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("memberCount", new TableInfo.Column("memberCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("watcherIds", new TableInfo.Column("watcherIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("watcherCount", new TableInfo.Column("watcherCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("reads", new TableInfo.Column("reads", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("lastMessageAt", new TableInfo.Column("lastMessageAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("lastMessageId", new TableInfo.Column("lastMessageId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("team", new TableInfo.Column("team", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("ownCapabilities", new TableInfo.Column("ownCapabilities", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("membership", new TableInfo.Column("membership", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelState.put("cid", new TableInfo.Column("cid", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatChannelState = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChatChannelState = new HashSet<TableInfo.Index>(1);
        _indicesStreamChatChannelState.add(new TableInfo.Index("index_stream_chat_channel_state_syncStatus", false, Arrays.asList("syncStatus"), Arrays.asList("ASC")));
        final TableInfo _infoStreamChatChannelState = new TableInfo("stream_chat_channel_state", _columnsStreamChatChannelState, _foreignKeysStreamChatChannelState, _indicesStreamChatChannelState);
        final TableInfo _existingStreamChatChannelState = TableInfo.read(_db, "stream_chat_channel_state");
        if (! _infoStreamChatChannelState.equals(_existingStreamChatChannelState)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_channel_state(io.getstream.chat.android.offline.repository.domain.channel.internal.ChannelEntity).\n"
                  + " Expected:\n" + _infoStreamChatChannelState + "\n"
                  + " Found:\n" + _existingStreamChatChannelState);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamChatChannelConfig = new HashMap<String, TableInfo.Column>(20);
        _columnsStreamChatChannelConfig.put("channelType", new TableInfo.Column("channelType", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isTypingEvents", new TableInfo.Column("isTypingEvents", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isReadEvents", new TableInfo.Column("isReadEvents", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isConnectEvents", new TableInfo.Column("isConnectEvents", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isSearch", new TableInfo.Column("isSearch", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isReactionsEnabled", new TableInfo.Column("isReactionsEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isThreadEnabled", new TableInfo.Column("isThreadEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("isMutes", new TableInfo.Column("isMutes", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("uploadsEnabled", new TableInfo.Column("uploadsEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("urlEnrichmentEnabled", new TableInfo.Column("urlEnrichmentEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("customEventsEnabled", new TableInfo.Column("customEventsEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("pushNotificationsEnabled", new TableInfo.Column("pushNotificationsEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("messageRetention", new TableInfo.Column("messageRetention", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("maxMessageLength", new TableInfo.Column("maxMessageLength", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("automod", new TableInfo.Column("automod", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("automodBehavior", new TableInfo.Column("automodBehavior", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamChatChannelConfig.put("blocklistBehavior", new TableInfo.Column("blocklistBehavior", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatChannelConfig = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamChatChannelConfig = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoStreamChatChannelConfig = new TableInfo("stream_chat_channel_config", _columnsStreamChatChannelConfig, _foreignKeysStreamChatChannelConfig, _indicesStreamChatChannelConfig);
        final TableInfo _existingStreamChatChannelConfig = TableInfo.read(_db, "stream_chat_channel_config");
        if (! _infoStreamChatChannelConfig.equals(_existingStreamChatChannelConfig)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_chat_channel_config(io.getstream.chat.android.offline.repository.domain.channelconfig.internal.ChannelConfigInnerEntity).\n"
                  + " Expected:\n" + _infoStreamChatChannelConfig + "\n"
                  + " Found:\n" + _existingStreamChatChannelConfig);
        }
        final HashMap<String, TableInfo.Column> _columnsCommandInnerEntity = new HashMap<String, TableInfo.Column>(6);
        _columnsCommandInnerEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommandInnerEntity.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommandInnerEntity.put("args", new TableInfo.Column("args", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommandInnerEntity.put("set", new TableInfo.Column("set", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommandInnerEntity.put("channelType", new TableInfo.Column("channelType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommandInnerEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCommandInnerEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysCommandInnerEntity.add(new TableInfo.ForeignKey("stream_chat_channel_config", "CASCADE", "CASCADE",Arrays.asList("channelType"), Arrays.asList("channelType")));
        final HashSet<TableInfo.Index> _indicesCommandInnerEntity = new HashSet<TableInfo.Index>(1);
        _indicesCommandInnerEntity.add(new TableInfo.Index("index_command_inner_entity_channelType", false, Arrays.asList("channelType"), Arrays.asList("ASC")));
        final TableInfo _infoCommandInnerEntity = new TableInfo("command_inner_entity", _columnsCommandInnerEntity, _foreignKeysCommandInnerEntity, _indicesCommandInnerEntity);
        final TableInfo _existingCommandInnerEntity = TableInfo.read(_db, "command_inner_entity");
        if (! _infoCommandInnerEntity.equals(_existingCommandInnerEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "command_inner_entity(io.getstream.chat.android.offline.repository.domain.channelconfig.internal.CommandInnerEntity).\n"
                  + " Expected:\n" + _infoCommandInnerEntity + "\n"
                  + " Found:\n" + _existingCommandInnerEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsStreamSyncState = new HashMap<String, TableInfo.Column>(5);
        _columnsStreamSyncState.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamSyncState.put("activeChannelIds", new TableInfo.Column("activeChannelIds", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamSyncState.put("lastSyncedAt", new TableInfo.Column("lastSyncedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamSyncState.put("rawLastSyncedAt", new TableInfo.Column("rawLastSyncedAt", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStreamSyncState.put("markedAllReadAt", new TableInfo.Column("markedAllReadAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStreamSyncState = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStreamSyncState = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoStreamSyncState = new TableInfo("stream_sync_state", _columnsStreamSyncState, _foreignKeysStreamSyncState, _indicesStreamSyncState);
        final TableInfo _existingStreamSyncState = TableInfo.read(_db, "stream_sync_state");
        if (! _infoStreamSyncState.equals(_existingStreamSyncState)) {
          return new RoomOpenHelper.ValidationResult(false, "stream_sync_state(io.getstream.chat.android.offline.repository.domain.syncState.internal.SyncStateEntity).\n"
                  + " Expected:\n" + _infoStreamSyncState + "\n"
                  + " Found:\n" + _existingStreamSyncState);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "fb003d1b750d6fb9c9e419224201c0b3", "77847763c8224af456f4e14120cf169b");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "stream_channel_query","stream_chat_message","stream_chat_reply_message","attachment_inner_entity","reply_attachment_inner_entity","stream_chat_user","stream_chat_reaction","stream_chat_channel_state","stream_chat_channel_config","command_inner_entity","stream_sync_state");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    boolean _supportsDeferForeignKeys = android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP;
    try {
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = FALSE");
      }
      super.beginTransaction();
      if (_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
      }
      _db.execSQL("DELETE FROM `stream_channel_query`");
      _db.execSQL("DELETE FROM `stream_chat_message`");
      _db.execSQL("DELETE FROM `stream_chat_reply_message`");
      _db.execSQL("DELETE FROM `attachment_inner_entity`");
      _db.execSQL("DELETE FROM `reply_attachment_inner_entity`");
      _db.execSQL("DELETE FROM `stream_chat_user`");
      _db.execSQL("DELETE FROM `stream_chat_reaction`");
      _db.execSQL("DELETE FROM `stream_chat_channel_state`");
      _db.execSQL("DELETE FROM `stream_chat_channel_config`");
      _db.execSQL("DELETE FROM `command_inner_entity`");
      _db.execSQL("DELETE FROM `stream_sync_state`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = TRUE");
      }
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(QueryChannelsDao.class, QueryChannelsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserDao.class, UserDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ReactionDao.class, ReactionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(MessageDao.class, MessageDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ReplyMessageDao.class, ReplyMessageDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ChannelDao.class, ChannelDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ChannelConfigDao.class, ChannelConfigDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SyncStateDao.class, SyncStateDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AttachmentDao.class, AttachmentDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  public List<Migration> getAutoMigrations(
      @NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
    return Arrays.asList();
  }

  @Override
  public QueryChannelsDao queryChannelsDao() {
    if (_queryChannelsDao != null) {
      return _queryChannelsDao;
    } else {
      synchronized(this) {
        if(_queryChannelsDao == null) {
          _queryChannelsDao = new QueryChannelsDao_Impl(this);
        }
        return _queryChannelsDao;
      }
    }
  }

  @Override
  public UserDao userDao() {
    if (_userDao != null) {
      return _userDao;
    } else {
      synchronized(this) {
        if(_userDao == null) {
          _userDao = new UserDao_Impl(this);
        }
        return _userDao;
      }
    }
  }

  @Override
  public ReactionDao reactionDao() {
    if (_reactionDao != null) {
      return _reactionDao;
    } else {
      synchronized(this) {
        if(_reactionDao == null) {
          _reactionDao = new ReactionDao_Impl(this);
        }
        return _reactionDao;
      }
    }
  }

  @Override
  public MessageDao messageDao() {
    if (_messageDao != null) {
      return _messageDao;
    } else {
      synchronized(this) {
        if(_messageDao == null) {
          _messageDao = new MessageDao_Impl(this);
        }
        return _messageDao;
      }
    }
  }

  @Override
  public ReplyMessageDao replyMessageDao() {
    if (_replyMessageDao != null) {
      return _replyMessageDao;
    } else {
      synchronized(this) {
        if(_replyMessageDao == null) {
          _replyMessageDao = new ReplyMessageDao_Impl(this);
        }
        return _replyMessageDao;
      }
    }
  }

  @Override
  public ChannelDao channelStateDao() {
    if (_channelDao != null) {
      return _channelDao;
    } else {
      synchronized(this) {
        if(_channelDao == null) {
          _channelDao = new ChannelDao_Impl(this);
        }
        return _channelDao;
      }
    }
  }

  @Override
  public ChannelConfigDao channelConfigDao() {
    if (_channelConfigDao != null) {
      return _channelConfigDao;
    } else {
      synchronized(this) {
        if(_channelConfigDao == null) {
          _channelConfigDao = new ChannelConfigDao_Impl(this);
        }
        return _channelConfigDao;
      }
    }
  }

  @Override
  public SyncStateDao syncStateDao() {
    if (_syncStateDao != null) {
      return _syncStateDao;
    } else {
      synchronized(this) {
        if(_syncStateDao == null) {
          _syncStateDao = new SyncStateDao_Impl(this);
        }
        return _syncStateDao;
      }
    }
  }

  @Override
  public AttachmentDao attachmentDao() {
    if (_attachmentDao != null) {
      return _attachmentDao;
    } else {
      synchronized(this) {
        if(_attachmentDao == null) {
          _attachmentDao = new AttachmentDao_Impl(this);
        }
        return _attachmentDao;
      }
    }
  }
}
