package io.getstream.chat.android.offline.repository.domain.syncState.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SyncStateDao_Impl implements SyncStateDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SyncStateEntity> __insertionAdapterOfSyncStateEntity;

  private final ListConverter __listConverter = new ListConverter();

  private final DateConverter __dateConverter = new DateConverter();

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public SyncStateDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSyncStateEntity = new EntityInsertionAdapter<SyncStateEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_sync_state` (`userId`,`activeChannelIds`,`lastSyncedAt`,`rawLastSyncedAt`,`markedAllReadAt`) VALUES (?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SyncStateEntity value) {
        if (value.getUserId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getUserId());
        }
        final String _tmp = __listConverter.stringListToString(value.getActiveChannelIds());
        if (_tmp == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp);
        }
        final Long _tmp_1 = __dateConverter.dateToTimestamp(value.getLastSyncedAt());
        if (_tmp_1 == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindLong(3, _tmp_1);
        }
        if (value.getRawLastSyncedAt() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getRawLastSyncedAt());
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getMarkedAllReadAt());
        if (_tmp_2 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindLong(5, _tmp_2);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_sync_state";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final SyncStateEntity syncStateEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSyncStateEntity.insert(syncStateEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final String userId,
      final Continuation<? super SyncStateEntity> continuation) {
    final String _sql = "SELECT * FROM stream_sync_state WHERE stream_sync_state.userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (userId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, userId);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SyncStateEntity>() {
      @Override
      public SyncStateEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfActiveChannelIds = CursorUtil.getColumnIndexOrThrow(_cursor, "activeChannelIds");
          final int _cursorIndexOfLastSyncedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "lastSyncedAt");
          final int _cursorIndexOfRawLastSyncedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "rawLastSyncedAt");
          final int _cursorIndexOfMarkedAllReadAt = CursorUtil.getColumnIndexOrThrow(_cursor, "markedAllReadAt");
          final SyncStateEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpUserId;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmpUserId = null;
            } else {
              _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
            }
            final List<String> _tmpActiveChannelIds;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfActiveChannelIds)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfActiveChannelIds);
            }
            final List<String> _tmp_1 = __listConverter.stringToStringList(_tmp);
            if(_tmp_1 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpActiveChannelIds = _tmp_1;
            }
            final Date _tmpLastSyncedAt;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfLastSyncedAt)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfLastSyncedAt);
            }
            _tmpLastSyncedAt = __dateConverter.fromTimestamp(_tmp_2);
            final String _tmpRawLastSyncedAt;
            if (_cursor.isNull(_cursorIndexOfRawLastSyncedAt)) {
              _tmpRawLastSyncedAt = null;
            } else {
              _tmpRawLastSyncedAt = _cursor.getString(_cursorIndexOfRawLastSyncedAt);
            }
            final Date _tmpMarkedAllReadAt;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMarkedAllReadAt)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfMarkedAllReadAt);
            }
            _tmpMarkedAllReadAt = __dateConverter.fromTimestamp(_tmp_3);
            _result = new SyncStateEntity(_tmpUserId,_tmpActiveChannelIds,_tmpLastSyncedAt,_tmpRawLastSyncedAt,_tmpMarkedAllReadAt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
