package io.getstream.chat.android.offline.repository.domain.channel.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MapConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MemberConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SetConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SyncStatusConverter;
import io.getstream.chat.android.offline.repository.domain.channel.member.internal.MemberEntity;
import io.getstream.chat.android.offline.repository.domain.channel.userread.internal.ChannelUserReadEntity;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ChannelDao_Impl implements ChannelDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ChannelEntity> __insertionAdapterOfChannelEntity;

  private final DateConverter __dateConverter = new DateConverter();

  private final MapConverter __mapConverter = new MapConverter();

  private final ListConverter __listConverter = new ListConverter();

  private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();

  private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();

  private final SetConverter __setConverter = new SetConverter();

  private final MemberConverter __memberConverter = new MemberConverter();

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfSetDeletedAt;

  private final SharedSQLiteStatement __preparedStmtOfSetHidden;

  private final SharedSQLiteStatement __preparedStmtOfSetHidden_1;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public ChannelDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfChannelEntity = new EntityInsertionAdapter<ChannelEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `stream_chat_channel_state` (`type`,`channelId`,`name`,`image`,`cooldown`,`createdByUserId`,`frozen`,`hidden`,`hideMessagesBefore`,`members`,`memberCount`,`watcherIds`,`watcherCount`,`reads`,`lastMessageAt`,`lastMessageId`,`createdAt`,`updatedAt`,`deletedAt`,`extraData`,`syncStatus`,`team`,`ownCapabilities`,`membership`,`cid`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChannelEntity value) {
        if (value.getType() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getType());
        }
        if (value.getChannelId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getChannelId());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getImage() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getImage());
        }
        stmt.bindLong(5, value.getCooldown());
        if (value.getCreatedByUserId() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCreatedByUserId());
        }
        final int _tmp = value.getFrozen() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        final Integer _tmp_1 = value.getHidden() == null ? null : (value.getHidden() ? 1 : 0);
        if (_tmp_1 == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, _tmp_1);
        }
        final Long _tmp_2 = __dateConverter.dateToTimestamp(value.getHideMessagesBefore());
        if (_tmp_2 == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindLong(9, _tmp_2);
        }
        final String _tmp_3 = __mapConverter.memberMapToString(value.getMembers());
        if (_tmp_3 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, _tmp_3);
        }
        stmt.bindLong(11, value.getMemberCount());
        final String _tmp_4 = __listConverter.stringListToString(value.getWatcherIds());
        if (_tmp_4 == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, _tmp_4);
        }
        stmt.bindLong(13, value.getWatcherCount());
        final String _tmp_5 = __mapConverter.readMapToString(value.getReads());
        if (_tmp_5 == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, _tmp_5);
        }
        final Long _tmp_6 = __dateConverter.dateToTimestamp(value.getLastMessageAt());
        if (_tmp_6 == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindLong(15, _tmp_6);
        }
        if (value.getLastMessageId() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getLastMessageId());
        }
        final Long _tmp_7 = __dateConverter.dateToTimestamp(value.getCreatedAt());
        if (_tmp_7 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindLong(17, _tmp_7);
        }
        final Long _tmp_8 = __dateConverter.dateToTimestamp(value.getUpdatedAt());
        if (_tmp_8 == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, _tmp_8);
        }
        final Long _tmp_9 = __dateConverter.dateToTimestamp(value.getDeletedAt());
        if (_tmp_9 == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, _tmp_9);
        }
        final String _tmp_10 = __extraDataConverter.mapToString(value.getExtraData());
        if (_tmp_10 == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, _tmp_10);
        }
        final int _tmp_11 = __syncStatusConverter.syncStatusToString(value.getSyncStatus());
        stmt.bindLong(21, _tmp_11);
        if (value.getTeam() == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindString(22, value.getTeam());
        }
        final String _tmp_12 = __setConverter.sortedSetToString(value.getOwnCapabilities());
        if (_tmp_12 == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, _tmp_12);
        }
        final String _tmp_13 = __memberConverter.memberToString(value.getMembership());
        if (_tmp_13 == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindString(24, _tmp_13);
        }
        if (value.getCid() == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, value.getCid());
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE from stream_chat_channel_state WHERE cid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetDeletedAt = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE stream_chat_channel_state SET deletedAt = ? WHERE cid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetHidden = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE stream_chat_channel_state SET hidden = ?, hideMessagesBefore = ? WHERE cid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetHidden_1 = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE stream_chat_channel_state SET hidden = ? WHERE cid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM stream_chat_channel_state";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final ChannelEntity channelEntity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfChannelEntity.insert(channelEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertMany(final List<ChannelEntity> channelEntities,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfChannelEntity.insert(channelEntities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object delete(final String cid, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object setDeletedAt(final String cid, final Date deletedAt,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetDeletedAt.acquire();
        int _argIndex = 1;
        final Long _tmp = __dateConverter.dateToTimestamp(deletedAt);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindLong(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetDeletedAt.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object setHidden(final String cid, final boolean hidden, final Date hideMessagesBefore,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetHidden.acquire();
        int _argIndex = 1;
        final int _tmp = hidden ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        final Long _tmp_1 = __dateConverter.dateToTimestamp(hideMessagesBefore);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindLong(_argIndex, _tmp_1);
        }
        _argIndex = 3;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetHidden.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object setHidden(final String cid, final boolean hidden,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetHidden_1.acquire();
        int _argIndex = 1;
        final int _tmp = hidden ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        if (cid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, cid);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetHidden_1.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object selectAllCids(final Continuation<? super List<String>> continuation) {
    final String _sql = "SELECT cid FROM stream_chat_channel_state";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<String>>() {
      @Override
      public List<String> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
          try {
            final List<String> _result = new ArrayList<String>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final String _item;
              if (_cursor.isNull(0)) {
                _item = null;
              } else {
                _item = _cursor.getString(0);
              }
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectCidsBySyncNeeded(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<String>> continuation) {
    final String _sql = "SELECT cid FROM stream_chat_channel_state WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final String _item;
            if (_cursor.isNull(0)) {
              _item = null;
            } else {
              _item = _cursor.getString(0);
            }
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectSyncNeeded(final SyncStatus syncStatus, final int limit,
      final Continuation<? super List<ChannelEntity>> continuation) {
    final String _sql = "SELECT * FROM stream_chat_channel_state WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = __syncStatusConverter.syncStatusToString(syncStatus);
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ChannelEntity>>() {
      @Override
      public List<ChannelEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow(_cursor, "channelId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow(_cursor, "cooldown");
          final int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "createdByUserId");
          final int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow(_cursor, "frozen");
          final int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "hidden");
          final int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow(_cursor, "hideMessagesBefore");
          final int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "members");
          final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "memberCount");
          final int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherIds");
          final int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherCount");
          final int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow(_cursor, "reads");
          final int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageAt");
          final int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageId");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow(_cursor, "team");
          final int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow(_cursor, "ownCapabilities");
          final int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow(_cursor, "membership");
          final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
          final List<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ChannelEntity _item;
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final String _tmpChannelId;
            if (_cursor.isNull(_cursorIndexOfChannelId)) {
              _tmpChannelId = null;
            } else {
              _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final int _tmpCooldown;
            _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
            final String _tmpCreatedByUserId;
            if (_cursor.isNull(_cursorIndexOfCreatedByUserId)) {
              _tmpCreatedByUserId = null;
            } else {
              _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
            }
            final boolean _tmpFrozen;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfFrozen);
            _tmpFrozen = _tmp_1 != 0;
            final Boolean _tmpHidden;
            final Integer _tmp_2;
            if (_cursor.isNull(_cursorIndexOfHidden)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getInt(_cursorIndexOfHidden);
            }
            _tmpHidden = _tmp_2 == null ? null : _tmp_2 != 0;
            final Date _tmpHideMessagesBefore;
            final Long _tmp_3;
            if (_cursor.isNull(_cursorIndexOfHideMessagesBefore)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getLong(_cursorIndexOfHideMessagesBefore);
            }
            _tmpHideMessagesBefore = __dateConverter.fromTimestamp(_tmp_3);
            final Map<String, MemberEntity> _tmpMembers;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfMembers)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfMembers);
            }
            final Map<String, MemberEntity> _tmp_5 = __mapConverter.stringToMemberMap(_tmp_4);
            if(_tmp_5 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.member.internal.MemberEntity>, but it was null.");
            } else {
              _tmpMembers = _tmp_5;
            }
            final int _tmpMemberCount;
            _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
            final List<String> _tmpWatcherIds;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfWatcherIds)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfWatcherIds);
            }
            final List<String> _tmp_7 = __listConverter.stringToStringList(_tmp_6);
            if(_tmp_7 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpWatcherIds = _tmp_7;
            }
            final int _tmpWatcherCount;
            _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
            final Map<String, ChannelUserReadEntity> _tmpReads;
            final String _tmp_8;
            if (_cursor.isNull(_cursorIndexOfReads)) {
              _tmp_8 = null;
            } else {
              _tmp_8 = _cursor.getString(_cursorIndexOfReads);
            }
            final Map<String, ChannelUserReadEntity> _tmp_9 = __mapConverter.stringToReadMap(_tmp_8);
            if(_tmp_9 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.userread.internal.ChannelUserReadEntity>, but it was null.");
            } else {
              _tmpReads = _tmp_9;
            }
            final Date _tmpLastMessageAt;
            final Long _tmp_10;
            if (_cursor.isNull(_cursorIndexOfLastMessageAt)) {
              _tmp_10 = null;
            } else {
              _tmp_10 = _cursor.getLong(_cursorIndexOfLastMessageAt);
            }
            _tmpLastMessageAt = __dateConverter.fromTimestamp(_tmp_10);
            final String _tmpLastMessageId;
            if (_cursor.isNull(_cursorIndexOfLastMessageId)) {
              _tmpLastMessageId = null;
            } else {
              _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
            }
            final Date _tmpCreatedAt;
            final Long _tmp_11;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp_11 = null;
            } else {
              _tmp_11 = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_11);
            final Date _tmpUpdatedAt;
            final Long _tmp_12;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_12 = null;
            } else {
              _tmp_12 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_12);
            final Date _tmpDeletedAt;
            final Long _tmp_13;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_13 = null;
            } else {
              _tmp_13 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_13);
            final Map<String, Object> _tmpExtraData;
            final String _tmp_14;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_14 = null;
            } else {
              _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_15 = __extraDataConverter.stringToMap(_tmp_14);
            if(_tmp_15 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_15;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_16;
            _tmp_16 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_16);
            final String _tmpTeam;
            if (_cursor.isNull(_cursorIndexOfTeam)) {
              _tmpTeam = null;
            } else {
              _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
            }
            final Set<String> _tmpOwnCapabilities;
            final String _tmp_17;
            if (_cursor.isNull(_cursorIndexOfOwnCapabilities)) {
              _tmp_17 = null;
            } else {
              _tmp_17 = _cursor.getString(_cursorIndexOfOwnCapabilities);
            }
            _tmpOwnCapabilities = __setConverter.stringToSortedSet(_tmp_17);
            final MemberEntity _tmpMembership;
            final String _tmp_18;
            if (_cursor.isNull(_cursorIndexOfMembership)) {
              _tmp_18 = null;
            } else {
              _tmp_18 = _cursor.getString(_cursorIndexOfMembership);
            }
            _tmpMembership = __memberConverter.stringToMemberMap(_tmp_18);
            _item = new ChannelEntity(_tmpType,_tmpChannelId,_tmpName,_tmpImage,_tmpCooldown,_tmpCreatedByUserId,_tmpFrozen,_tmpHidden,_tmpHideMessagesBefore,_tmpMembers,_tmpMemberCount,_tmpWatcherIds,_tmpWatcherCount,_tmpReads,_tmpLastMessageAt,_tmpLastMessageId,_tmpCreatedAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpExtraData,_tmpSyncStatus,_tmpTeam,_tmpOwnCapabilities,_tmpMembership);
            final String _tmpCid;
            if (_cursor.isNull(_cursorIndexOfCid)) {
              _tmpCid = null;
            } else {
              _tmpCid = _cursor.getString(_cursorIndexOfCid);
            }
            _item.setCid(_tmpCid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final List<String> cids,
      final Continuation<? super List<ChannelEntity>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (");
    final int _inputSize = cids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : cids) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ChannelEntity>>() {
      @Override
      public List<ChannelEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow(_cursor, "channelId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow(_cursor, "cooldown");
          final int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "createdByUserId");
          final int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow(_cursor, "frozen");
          final int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "hidden");
          final int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow(_cursor, "hideMessagesBefore");
          final int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "members");
          final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "memberCount");
          final int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherIds");
          final int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherCount");
          final int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow(_cursor, "reads");
          final int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageAt");
          final int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageId");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow(_cursor, "team");
          final int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow(_cursor, "ownCapabilities");
          final int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow(_cursor, "membership");
          final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
          final List<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ChannelEntity _item_1;
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final String _tmpChannelId;
            if (_cursor.isNull(_cursorIndexOfChannelId)) {
              _tmpChannelId = null;
            } else {
              _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final int _tmpCooldown;
            _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
            final String _tmpCreatedByUserId;
            if (_cursor.isNull(_cursorIndexOfCreatedByUserId)) {
              _tmpCreatedByUserId = null;
            } else {
              _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
            }
            final boolean _tmpFrozen;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFrozen);
            _tmpFrozen = _tmp != 0;
            final Boolean _tmpHidden;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfHidden)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfHidden);
            }
            _tmpHidden = _tmp_1 == null ? null : _tmp_1 != 0;
            final Date _tmpHideMessagesBefore;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfHideMessagesBefore)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfHideMessagesBefore);
            }
            _tmpHideMessagesBefore = __dateConverter.fromTimestamp(_tmp_2);
            final Map<String, MemberEntity> _tmpMembers;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMembers)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMembers);
            }
            final Map<String, MemberEntity> _tmp_4 = __mapConverter.stringToMemberMap(_tmp_3);
            if(_tmp_4 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.member.internal.MemberEntity>, but it was null.");
            } else {
              _tmpMembers = _tmp_4;
            }
            final int _tmpMemberCount;
            _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
            final List<String> _tmpWatcherIds;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfWatcherIds)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfWatcherIds);
            }
            final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpWatcherIds = _tmp_6;
            }
            final int _tmpWatcherCount;
            _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
            final Map<String, ChannelUserReadEntity> _tmpReads;
            final String _tmp_7;
            if (_cursor.isNull(_cursorIndexOfReads)) {
              _tmp_7 = null;
            } else {
              _tmp_7 = _cursor.getString(_cursorIndexOfReads);
            }
            final Map<String, ChannelUserReadEntity> _tmp_8 = __mapConverter.stringToReadMap(_tmp_7);
            if(_tmp_8 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.userread.internal.ChannelUserReadEntity>, but it was null.");
            } else {
              _tmpReads = _tmp_8;
            }
            final Date _tmpLastMessageAt;
            final Long _tmp_9;
            if (_cursor.isNull(_cursorIndexOfLastMessageAt)) {
              _tmp_9 = null;
            } else {
              _tmp_9 = _cursor.getLong(_cursorIndexOfLastMessageAt);
            }
            _tmpLastMessageAt = __dateConverter.fromTimestamp(_tmp_9);
            final String _tmpLastMessageId;
            if (_cursor.isNull(_cursorIndexOfLastMessageId)) {
              _tmpLastMessageId = null;
            } else {
              _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
            }
            final Date _tmpCreatedAt;
            final Long _tmp_10;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp_10 = null;
            } else {
              _tmp_10 = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_10);
            final Date _tmpUpdatedAt;
            final Long _tmp_11;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_11 = null;
            } else {
              _tmp_11 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_11);
            final Date _tmpDeletedAt;
            final Long _tmp_12;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_12 = null;
            } else {
              _tmp_12 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_12);
            final Map<String, Object> _tmpExtraData;
            final String _tmp_13;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_13 = null;
            } else {
              _tmp_13 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_14 = __extraDataConverter.stringToMap(_tmp_13);
            if(_tmp_14 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_14;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_15;
            _tmp_15 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_15);
            final String _tmpTeam;
            if (_cursor.isNull(_cursorIndexOfTeam)) {
              _tmpTeam = null;
            } else {
              _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
            }
            final Set<String> _tmpOwnCapabilities;
            final String _tmp_16;
            if (_cursor.isNull(_cursorIndexOfOwnCapabilities)) {
              _tmp_16 = null;
            } else {
              _tmp_16 = _cursor.getString(_cursorIndexOfOwnCapabilities);
            }
            _tmpOwnCapabilities = __setConverter.stringToSortedSet(_tmp_16);
            final MemberEntity _tmpMembership;
            final String _tmp_17;
            if (_cursor.isNull(_cursorIndexOfMembership)) {
              _tmp_17 = null;
            } else {
              _tmp_17 = _cursor.getString(_cursorIndexOfMembership);
            }
            _tmpMembership = __memberConverter.stringToMemberMap(_tmp_17);
            _item_1 = new ChannelEntity(_tmpType,_tmpChannelId,_tmpName,_tmpImage,_tmpCooldown,_tmpCreatedByUserId,_tmpFrozen,_tmpHidden,_tmpHideMessagesBefore,_tmpMembers,_tmpMemberCount,_tmpWatcherIds,_tmpWatcherCount,_tmpReads,_tmpLastMessageAt,_tmpLastMessageId,_tmpCreatedAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpExtraData,_tmpSyncStatus,_tmpTeam,_tmpOwnCapabilities,_tmpMembership);
            final String _tmpCid;
            if (_cursor.isNull(_cursorIndexOfCid)) {
              _tmpCid = null;
            } else {
              _tmpCid = _cursor.getString(_cursorIndexOfCid);
            }
            _item_1.setCid(_tmpCid);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object select(final String cid, final Continuation<? super ChannelEntity> continuation) {
    final String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (cid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, cid);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ChannelEntity>() {
      @Override
      public ChannelEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow(_cursor, "channelId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow(_cursor, "image");
          final int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow(_cursor, "cooldown");
          final int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "createdByUserId");
          final int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow(_cursor, "frozen");
          final int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "hidden");
          final int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow(_cursor, "hideMessagesBefore");
          final int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "members");
          final int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow(_cursor, "memberCount");
          final int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherIds");
          final int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow(_cursor, "watcherCount");
          final int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow(_cursor, "reads");
          final int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageAt");
          final int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow(_cursor, "lastMessageId");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "deletedAt");
          final int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow(_cursor, "extraData");
          final int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "syncStatus");
          final int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow(_cursor, "team");
          final int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow(_cursor, "ownCapabilities");
          final int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow(_cursor, "membership");
          final int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow(_cursor, "cid");
          final ChannelEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            final String _tmpChannelId;
            if (_cursor.isNull(_cursorIndexOfChannelId)) {
              _tmpChannelId = null;
            } else {
              _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpImage;
            if (_cursor.isNull(_cursorIndexOfImage)) {
              _tmpImage = null;
            } else {
              _tmpImage = _cursor.getString(_cursorIndexOfImage);
            }
            final int _tmpCooldown;
            _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
            final String _tmpCreatedByUserId;
            if (_cursor.isNull(_cursorIndexOfCreatedByUserId)) {
              _tmpCreatedByUserId = null;
            } else {
              _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
            }
            final boolean _tmpFrozen;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFrozen);
            _tmpFrozen = _tmp != 0;
            final Boolean _tmpHidden;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfHidden)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfHidden);
            }
            _tmpHidden = _tmp_1 == null ? null : _tmp_1 != 0;
            final Date _tmpHideMessagesBefore;
            final Long _tmp_2;
            if (_cursor.isNull(_cursorIndexOfHideMessagesBefore)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getLong(_cursorIndexOfHideMessagesBefore);
            }
            _tmpHideMessagesBefore = __dateConverter.fromTimestamp(_tmp_2);
            final Map<String, MemberEntity> _tmpMembers;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMembers)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMembers);
            }
            final Map<String, MemberEntity> _tmp_4 = __mapConverter.stringToMemberMap(_tmp_3);
            if(_tmp_4 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.member.internal.MemberEntity>, but it was null.");
            } else {
              _tmpMembers = _tmp_4;
            }
            final int _tmpMemberCount;
            _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
            final List<String> _tmpWatcherIds;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfWatcherIds)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfWatcherIds);
            }
            final List<String> _tmp_6 = __listConverter.stringToStringList(_tmp_5);
            if(_tmp_6 == null) {
              throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
            } else {
              _tmpWatcherIds = _tmp_6;
            }
            final int _tmpWatcherCount;
            _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
            final Map<String, ChannelUserReadEntity> _tmpReads;
            final String _tmp_7;
            if (_cursor.isNull(_cursorIndexOfReads)) {
              _tmp_7 = null;
            } else {
              _tmp_7 = _cursor.getString(_cursorIndexOfReads);
            }
            final Map<String, ChannelUserReadEntity> _tmp_8 = __mapConverter.stringToReadMap(_tmp_7);
            if(_tmp_8 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, io.getstream.chat.android.offline.repository.domain.channel.userread.internal.ChannelUserReadEntity>, but it was null.");
            } else {
              _tmpReads = _tmp_8;
            }
            final Date _tmpLastMessageAt;
            final Long _tmp_9;
            if (_cursor.isNull(_cursorIndexOfLastMessageAt)) {
              _tmp_9 = null;
            } else {
              _tmp_9 = _cursor.getLong(_cursorIndexOfLastMessageAt);
            }
            _tmpLastMessageAt = __dateConverter.fromTimestamp(_tmp_9);
            final String _tmpLastMessageId;
            if (_cursor.isNull(_cursorIndexOfLastMessageId)) {
              _tmpLastMessageId = null;
            } else {
              _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
            }
            final Date _tmpCreatedAt;
            final Long _tmp_10;
            if (_cursor.isNull(_cursorIndexOfCreatedAt)) {
              _tmp_10 = null;
            } else {
              _tmp_10 = _cursor.getLong(_cursorIndexOfCreatedAt);
            }
            _tmpCreatedAt = __dateConverter.fromTimestamp(_tmp_10);
            final Date _tmpUpdatedAt;
            final Long _tmp_11;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmp_11 = null;
            } else {
              _tmp_11 = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            _tmpUpdatedAt = __dateConverter.fromTimestamp(_tmp_11);
            final Date _tmpDeletedAt;
            final Long _tmp_12;
            if (_cursor.isNull(_cursorIndexOfDeletedAt)) {
              _tmp_12 = null;
            } else {
              _tmp_12 = _cursor.getLong(_cursorIndexOfDeletedAt);
            }
            _tmpDeletedAt = __dateConverter.fromTimestamp(_tmp_12);
            final Map<String, Object> _tmpExtraData;
            final String _tmp_13;
            if (_cursor.isNull(_cursorIndexOfExtraData)) {
              _tmp_13 = null;
            } else {
              _tmp_13 = _cursor.getString(_cursorIndexOfExtraData);
            }
            final Map<String, Object> _tmp_14 = __extraDataConverter.stringToMap(_tmp_13);
            if(_tmp_14 == null) {
              throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
            } else {
              _tmpExtraData = _tmp_14;
            }
            final SyncStatus _tmpSyncStatus;
            final int _tmp_15;
            _tmp_15 = _cursor.getInt(_cursorIndexOfSyncStatus);
            _tmpSyncStatus = __syncStatusConverter.stringToSyncStatus(_tmp_15);
            final String _tmpTeam;
            if (_cursor.isNull(_cursorIndexOfTeam)) {
              _tmpTeam = null;
            } else {
              _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
            }
            final Set<String> _tmpOwnCapabilities;
            final String _tmp_16;
            if (_cursor.isNull(_cursorIndexOfOwnCapabilities)) {
              _tmp_16 = null;
            } else {
              _tmp_16 = _cursor.getString(_cursorIndexOfOwnCapabilities);
            }
            _tmpOwnCapabilities = __setConverter.stringToSortedSet(_tmp_16);
            final MemberEntity _tmpMembership;
            final String _tmp_17;
            if (_cursor.isNull(_cursorIndexOfMembership)) {
              _tmp_17 = null;
            } else {
              _tmp_17 = _cursor.getString(_cursorIndexOfMembership);
            }
            _tmpMembership = __memberConverter.stringToMemberMap(_tmp_17);
            _result = new ChannelEntity(_tmpType,_tmpChannelId,_tmpName,_tmpImage,_tmpCooldown,_tmpCreatedByUserId,_tmpFrozen,_tmpHidden,_tmpHideMessagesBefore,_tmpMembers,_tmpMemberCount,_tmpWatcherIds,_tmpWatcherCount,_tmpReads,_tmpLastMessageAt,_tmpLastMessageId,_tmpCreatedAt,_tmpUpdatedAt,_tmpDeletedAt,_tmpExtraData,_tmpSyncStatus,_tmpTeam,_tmpOwnCapabilities,_tmpMembership);
            final String _tmpCid;
            if (_cursor.isNull(_cursorIndexOfCid)) {
              _tmpCid = null;
            } else {
              _tmpCid = _cursor.getString(_cursorIndexOfCid);
            }
            _result.setCid(_tmpCid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
