/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.ConvertSmallBalance;
import io.gate.gateapi.models.CurrencyChain;
import io.gate.gateapi.models.DepositAddress;
import io.gate.gateapi.models.DepositRecord;
import io.gate.gateapi.models.SavedAddress;
import io.gate.gateapi.models.SmallBalance;
import io.gate.gateapi.models.SmallBalanceHistory;
import io.gate.gateapi.models.SubAccountBalance;
import io.gate.gateapi.models.SubAccountCrossMarginBalance;
import io.gate.gateapi.models.SubAccountFuturesBalance;
import io.gate.gateapi.models.SubAccountMarginBalance;
import io.gate.gateapi.models.SubAccountToSubAccount;
import io.gate.gateapi.models.SubAccountTransfer;
import io.gate.gateapi.models.SubAccountTransferRecordItem;
import io.gate.gateapi.models.TotalBalance;
import io.gate.gateapi.models.TradeFee;
import io.gate.gateapi.models.TransactionID;
import io.gate.gateapi.models.Transfer;
import io.gate.gateapi.models.TransferOrderStatus;
import io.gate.gateapi.models.UidPushOrder;
import io.gate.gateapi.models.WithdrawStatus;
import io.gate.gateapi.models.WithdrawalRecord;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class WalletApi {
    private ApiClient localVarApiClient;

    public WalletApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listCurrencyChainsCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/currency_chains";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrencyChainsValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listCurrencyChains(Async)");
        }
        Call localVarCall = this.listCurrencyChainsCall(currency, _callback);
        return localVarCall;
    }

    public List<CurrencyChain> listCurrencyChains(String currency) throws ApiException {
        ApiResponse<List<CurrencyChain>> localVarResp = this.listCurrencyChainsWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<List<CurrencyChain>> listCurrencyChainsWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listCurrencyChainsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<CurrencyChain>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrencyChainsAsync(String currency, ApiCallback<List<CurrencyChain>> _callback) throws ApiException {
        Call localVarCall = this.listCurrencyChainsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<CurrencyChain>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDepositAddressCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/deposit_address";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDepositAddressValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getDepositAddress(Async)");
        }
        Call localVarCall = this.getDepositAddressCall(currency, _callback);
        return localVarCall;
    }

    public DepositAddress getDepositAddress(String currency) throws ApiException {
        ApiResponse<DepositAddress> localVarResp = this.getDepositAddressWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<DepositAddress> getDepositAddressWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getDepositAddressValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDepositAddressAsync(String currency, ApiCallback<DepositAddress> _callback) throws ApiException {
        Call localVarCall = this.getDepositAddressValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listWithdrawalsCall(String currency, String withdrawId, String assetClass, String withdrawOrderId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/withdrawals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (withdrawId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withdraw_id", withdrawId));
        }
        if (assetClass != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset_class", assetClass));
        }
        if (withdrawOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withdraw_order_id", withdrawOrderId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWithdrawalsValidateBeforeCall(String currency, String withdrawId, String assetClass, String withdrawOrderId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listWithdrawalsCall(currency, withdrawId, assetClass, withdrawOrderId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<WithdrawalRecord>> listWithdrawalsWithHttpInfo(String currency, String withdrawId, String assetClass, String withdrawOrderId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listWithdrawalsValidateBeforeCall(currency, withdrawId, assetClass, withdrawOrderId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<WithdrawalRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listWithdrawalsAsync(String currency, String withdrawId, String assetClass, String withdrawOrderId, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<WithdrawalRecord>> _callback) throws ApiException {
        Call localVarCall = this.listWithdrawalsValidateBeforeCall(currency, withdrawId, assetClass, withdrawOrderId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<WithdrawalRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistWithdrawalsRequest listWithdrawals() {
        return new APIlistWithdrawalsRequest();
    }

    private Call listDepositsCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/deposits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDepositsValidateBeforeCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listDepositsCall(currency, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<DepositRecord>> listDepositsWithHttpInfo(String currency, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listDepositsValidateBeforeCall(currency, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<DepositRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDepositsAsync(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<DepositRecord>> _callback) throws ApiException {
        Call localVarCall = this.listDepositsValidateBeforeCall(currency, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<DepositRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDepositsRequest listDeposits() {
        return new APIlistDepositsRequest();
    }

    public Call transferCall(Transfer transfer, ApiCallback _callback) throws ApiException {
        Transfer localVarPostBody = transfer;
        String localVarPath = "/wallet/transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferValidateBeforeCall(Transfer transfer, ApiCallback _callback) throws ApiException {
        if (transfer == null) {
            throw new ApiException("Missing the required parameter 'transfer' when calling transfer(Async)");
        }
        Call localVarCall = this.transferCall(transfer, _callback);
        return localVarCall;
    }

    public TransactionID transfer(Transfer transfer) throws ApiException {
        ApiResponse<TransactionID> localVarResp = this.transferWithHttpInfo(transfer);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionID> transferWithHttpInfo(Transfer transfer) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(transfer, null);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transferAsync(Transfer transfer, ApiCallback<TransactionID> _callback) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(transfer, _callback);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listSubAccountTransfersCall(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountTransfersValidateBeforeCall(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersCall(subUid, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountTransferRecordItem>> listSubAccountTransfersWithHttpInfo(String subUid, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<SubAccountTransferRecordItem>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountTransfersAsync(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<SubAccountTransferRecordItem>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountTransferRecordItem>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountTransfersRequest listSubAccountTransfers() {
        return new APIlistSubAccountTransfersRequest();
    }

    public Call transferWithSubAccountCall(SubAccountTransfer subAccountTransfer, ApiCallback _callback) throws ApiException {
        SubAccountTransfer localVarPostBody = subAccountTransfer;
        String localVarPath = "/wallet/sub_account_transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferWithSubAccountValidateBeforeCall(SubAccountTransfer subAccountTransfer, ApiCallback _callback) throws ApiException {
        if (subAccountTransfer == null) {
            throw new ApiException("Missing the required parameter 'subAccountTransfer' when calling transferWithSubAccount(Async)");
        }
        Call localVarCall = this.transferWithSubAccountCall(subAccountTransfer, _callback);
        return localVarCall;
    }

    public TransactionID transferWithSubAccount(SubAccountTransfer subAccountTransfer) throws ApiException {
        ApiResponse<TransactionID> localVarResp = this.transferWithSubAccountWithHttpInfo(subAccountTransfer);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionID> transferWithSubAccountWithHttpInfo(SubAccountTransfer subAccountTransfer) throws ApiException {
        Call localVarCall = this.transferWithSubAccountValidateBeforeCall(subAccountTransfer, null);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transferWithSubAccountAsync(SubAccountTransfer subAccountTransfer, ApiCallback<TransactionID> _callback) throws ApiException {
        Call localVarCall = this.transferWithSubAccountValidateBeforeCall(subAccountTransfer, _callback);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subAccountToSubAccountCall(SubAccountToSubAccount subAccountToSubAccount, ApiCallback _callback) throws ApiException {
        SubAccountToSubAccount localVarPostBody = subAccountToSubAccount;
        String localVarPath = "/wallet/sub_account_to_sub_account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subAccountToSubAccountValidateBeforeCall(SubAccountToSubAccount subAccountToSubAccount, ApiCallback _callback) throws ApiException {
        if (subAccountToSubAccount == null) {
            throw new ApiException("Missing the required parameter 'subAccountToSubAccount' when calling subAccountToSubAccount(Async)");
        }
        Call localVarCall = this.subAccountToSubAccountCall(subAccountToSubAccount, _callback);
        return localVarCall;
    }

    public TransactionID subAccountToSubAccount(SubAccountToSubAccount subAccountToSubAccount) throws ApiException {
        ApiResponse<TransactionID> localVarResp = this.subAccountToSubAccountWithHttpInfo(subAccountToSubAccount);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionID> subAccountToSubAccountWithHttpInfo(SubAccountToSubAccount subAccountToSubAccount) throws ApiException {
        Call localVarCall = this.subAccountToSubAccountValidateBeforeCall(subAccountToSubAccount, null);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subAccountToSubAccountAsync(SubAccountToSubAccount subAccountToSubAccount, ApiCallback<TransactionID> _callback) throws ApiException {
        Call localVarCall = this.subAccountToSubAccountValidateBeforeCall(subAccountToSubAccount, _callback);
        Type localVarReturnType = new TypeToken<TransactionID>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getTransferOrderStatusCall(String clientOrderId, String txId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/order_status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_order_id", clientOrderId));
        }
        if (txId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tx_id", txId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTransferOrderStatusValidateBeforeCall(String clientOrderId, String txId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTransferOrderStatusCall(clientOrderId, txId, _callback);
        return localVarCall;
    }

    private ApiResponse<TransferOrderStatus> getTransferOrderStatusWithHttpInfo(String clientOrderId, String txId) throws ApiException {
        Call localVarCall = this.getTransferOrderStatusValidateBeforeCall(clientOrderId, txId, null);
        Type localVarReturnType = new TypeToken<TransferOrderStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTransferOrderStatusAsync(String clientOrderId, String txId, ApiCallback<TransferOrderStatus> _callback) throws ApiException {
        Call localVarCall = this.getTransferOrderStatusValidateBeforeCall(clientOrderId, txId, _callback);
        Type localVarReturnType = new TypeToken<TransferOrderStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTransferOrderStatusRequest getTransferOrderStatus() {
        return new APIgetTransferOrderStatusRequest();
    }

    private Call listWithdrawStatusCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/withdraw_status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWithdrawStatusValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listWithdrawStatusCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<WithdrawStatus>> listWithdrawStatusWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listWithdrawStatusValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listWithdrawStatusAsync(String currency, ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
        Call localVarCall = this.listWithdrawStatusValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistWithdrawStatusRequest listWithdrawStatus() {
        return new APIlistWithdrawStatusRequest();
    }

    private Call listSubAccountBalancesCall(String subUid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_balances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountBalancesValidateBeforeCall(String subUid, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesCall(subUid, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountBalance>> listSubAccountBalancesWithHttpInfo(String subUid) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountBalancesAsync(String subUid, ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountBalancesRequest listSubAccountBalances() {
        return new APIlistSubAccountBalancesRequest();
    }

    private Call listSubAccountMarginBalancesCall(String subUid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_margin_balances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountMarginBalancesValidateBeforeCall(String subUid, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountMarginBalancesCall(subUid, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountMarginBalance>> listSubAccountMarginBalancesWithHttpInfo(String subUid) throws ApiException {
        Call localVarCall = this.listSubAccountMarginBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountMarginBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountMarginBalancesAsync(String subUid, ApiCallback<List<SubAccountMarginBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountMarginBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountMarginBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountMarginBalancesRequest listSubAccountMarginBalances() {
        return new APIlistSubAccountMarginBalancesRequest();
    }

    private Call listSubAccountFuturesBalancesCall(String subUid, String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_futures_balances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        if (settle != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("settle", settle));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountFuturesBalancesValidateBeforeCall(String subUid, String settle, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountFuturesBalancesCall(subUid, settle, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountFuturesBalance>> listSubAccountFuturesBalancesWithHttpInfo(String subUid, String settle) throws ApiException {
        Call localVarCall = this.listSubAccountFuturesBalancesValidateBeforeCall(subUid, settle, null);
        Type localVarReturnType = new TypeToken<List<SubAccountFuturesBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountFuturesBalancesAsync(String subUid, String settle, ApiCallback<List<SubAccountFuturesBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountFuturesBalancesValidateBeforeCall(subUid, settle, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountFuturesBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountFuturesBalancesRequest listSubAccountFuturesBalances() {
        return new APIlistSubAccountFuturesBalancesRequest();
    }

    private Call listSubAccountCrossMarginBalancesCall(String subUid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_cross_margin_balances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountCrossMarginBalancesValidateBeforeCall(String subUid, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountCrossMarginBalancesCall(subUid, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountCrossMarginBalance>> listSubAccountCrossMarginBalancesWithHttpInfo(String subUid) throws ApiException {
        Call localVarCall = this.listSubAccountCrossMarginBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountCrossMarginBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountCrossMarginBalancesAsync(String subUid, ApiCallback<List<SubAccountCrossMarginBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountCrossMarginBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountCrossMarginBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountCrossMarginBalancesRequest listSubAccountCrossMarginBalances() {
        return new APIlistSubAccountCrossMarginBalancesRequest();
    }

    private Call listSavedAddressCall(String currency, String chain, String limit, Integer page, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/saved_address";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (chain != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("chain", chain));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSavedAddressValidateBeforeCall(String currency, String chain, String limit, Integer page, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listSavedAddress(Async)");
        }
        Call localVarCall = this.listSavedAddressCall(currency, chain, limit, page, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SavedAddress>> listSavedAddressWithHttpInfo(String currency, String chain, String limit, Integer page) throws ApiException {
        Call localVarCall = this.listSavedAddressValidateBeforeCall(currency, chain, limit, page, null);
        Type localVarReturnType = new TypeToken<List<SavedAddress>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSavedAddressAsync(String currency, String chain, String limit, Integer page, ApiCallback<List<SavedAddress>> _callback) throws ApiException {
        Call localVarCall = this.listSavedAddressValidateBeforeCall(currency, chain, limit, page, _callback);
        Type localVarReturnType = new TypeToken<List<SavedAddress>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSavedAddressRequest listSavedAddress(String currency) {
        return new APIlistSavedAddressRequest(currency);
    }

    private Call getTradeFeeCall(String currencyPair, String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (settle != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("settle", settle));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTradeFeeValidateBeforeCall(String currencyPair, String settle, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTradeFeeCall(currencyPair, settle, _callback);
        return localVarCall;
    }

    private ApiResponse<TradeFee> getTradeFeeWithHttpInfo(String currencyPair, String settle) throws ApiException {
        Call localVarCall = this.getTradeFeeValidateBeforeCall(currencyPair, settle, null);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTradeFeeAsync(String currencyPair, String settle, ApiCallback<TradeFee> _callback) throws ApiException {
        Call localVarCall = this.getTradeFeeValidateBeforeCall(currencyPair, settle, _callback);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTradeFeeRequest getTradeFee() {
        return new APIgetTradeFeeRequest();
    }

    private Call getTotalBalanceCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/total_balance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTotalBalanceValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTotalBalanceCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<TotalBalance> getTotalBalanceWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getTotalBalanceValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTotalBalanceAsync(String currency, ApiCallback<TotalBalance> _callback) throws ApiException {
        Call localVarCall = this.getTotalBalanceValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTotalBalanceRequest getTotalBalance() {
        return new APIgetTotalBalanceRequest();
    }

    public Call listSmallBalanceCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/small_balance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSmallBalanceValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSmallBalanceCall(_callback);
        return localVarCall;
    }

    public List<SmallBalance> listSmallBalance() throws ApiException {
        ApiResponse<List<SmallBalance>> localVarResp = this.listSmallBalanceWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<SmallBalance>> listSmallBalanceWithHttpInfo() throws ApiException {
        Call localVarCall = this.listSmallBalanceValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<SmallBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSmallBalanceAsync(ApiCallback<List<SmallBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSmallBalanceValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<SmallBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call convertSmallBalanceCall(ConvertSmallBalance convertSmallBalance, ApiCallback _callback) throws ApiException {
        ConvertSmallBalance localVarPostBody = convertSmallBalance;
        String localVarPath = "/wallet/small_balance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call convertSmallBalanceValidateBeforeCall(ConvertSmallBalance convertSmallBalance, ApiCallback _callback) throws ApiException {
        if (convertSmallBalance == null) {
            throw new ApiException("Missing the required parameter 'convertSmallBalance' when calling convertSmallBalance(Async)");
        }
        Call localVarCall = this.convertSmallBalanceCall(convertSmallBalance, _callback);
        return localVarCall;
    }

    public void convertSmallBalance(ConvertSmallBalance convertSmallBalance) throws ApiException {
        this.convertSmallBalanceWithHttpInfo(convertSmallBalance);
    }

    public ApiResponse<Void> convertSmallBalanceWithHttpInfo(ConvertSmallBalance convertSmallBalance) throws ApiException {
        Call localVarCall = this.convertSmallBalanceValidateBeforeCall(convertSmallBalance, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call convertSmallBalanceAsync(ConvertSmallBalance convertSmallBalance, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.convertSmallBalanceValidateBeforeCall(convertSmallBalance, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listSmallBalanceHistoryCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/small_balance_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSmallBalanceHistoryValidateBeforeCall(String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSmallBalanceHistoryCall(currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SmallBalanceHistory>> listSmallBalanceHistoryWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listSmallBalanceHistoryValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<SmallBalanceHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSmallBalanceHistoryAsync(String currency, Integer page, Integer limit, ApiCallback<List<SmallBalanceHistory>> _callback) throws ApiException {
        Call localVarCall = this.listSmallBalanceHistoryValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<SmallBalanceHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSmallBalanceHistoryRequest listSmallBalanceHistory() {
        return new APIlistSmallBalanceHistoryRequest();
    }

    private Call listPushOrdersCall(Integer id, Integer from, Integer to, Integer limit, Integer offset, String transactionType, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/push";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (transactionType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("transaction_type", transactionType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPushOrdersValidateBeforeCall(Integer id, Integer from, Integer to, Integer limit, Integer offset, String transactionType, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listPushOrdersCall(id, from, to, limit, offset, transactionType, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UidPushOrder>> listPushOrdersWithHttpInfo(Integer id, Integer from, Integer to, Integer limit, Integer offset, String transactionType) throws ApiException {
        Call localVarCall = this.listPushOrdersValidateBeforeCall(id, from, to, limit, offset, transactionType, null);
        Type localVarReturnType = new TypeToken<List<UidPushOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPushOrdersAsync(Integer id, Integer from, Integer to, Integer limit, Integer offset, String transactionType, ApiCallback<List<UidPushOrder>> _callback) throws ApiException {
        Call localVarCall = this.listPushOrdersValidateBeforeCall(id, from, to, limit, offset, transactionType, _callback);
        Type localVarReturnType = new TypeToken<List<UidPushOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPushOrdersRequest listPushOrders() {
        return new APIlistPushOrdersRequest();
    }

    public class APIlistPushOrdersRequest {
        private Integer id;
        private Integer from;
        private Integer to;
        private Integer limit;
        private Integer offset;
        private String transactionType;

        private APIlistPushOrdersRequest() {
        }

        public APIlistPushOrdersRequest id(Integer id) {
            this.id = id;
            return this;
        }

        public APIlistPushOrdersRequest from(Integer from) {
            this.from = from;
            return this;
        }

        public APIlistPushOrdersRequest to(Integer to) {
            this.to = to;
            return this;
        }

        public APIlistPushOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPushOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistPushOrdersRequest transactionType(String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listPushOrdersCall(this.id, this.from, this.to, this.limit, this.offset, this.transactionType, _callback);
        }

        public List<UidPushOrder> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listPushOrdersWithHttpInfo(this.id, this.from, this.to, this.limit, this.offset, this.transactionType);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UidPushOrder>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listPushOrdersWithHttpInfo(this.id, this.from, this.to, this.limit, this.offset, this.transactionType);
        }

        public Call executeAsync(ApiCallback<List<UidPushOrder>> _callback) throws ApiException {
            return WalletApi.this.listPushOrdersAsync(this.id, this.from, this.to, this.limit, this.offset, this.transactionType, _callback);
        }
    }

    public class APIlistSmallBalanceHistoryRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistSmallBalanceHistoryRequest() {
        }

        public APIlistSmallBalanceHistoryRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistSmallBalanceHistoryRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistSmallBalanceHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSmallBalanceHistoryCall(this.currency, this.page, this.limit, _callback);
        }

        public List<SmallBalanceHistory> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSmallBalanceHistoryWithHttpInfo(this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SmallBalanceHistory>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSmallBalanceHistoryWithHttpInfo(this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<SmallBalanceHistory>> _callback) throws ApiException {
            return WalletApi.this.listSmallBalanceHistoryAsync(this.currency, this.page, this.limit, _callback);
        }
    }

    public class APIgetTotalBalanceRequest {
        private String currency;

        private APIgetTotalBalanceRequest() {
        }

        public APIgetTotalBalanceRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.getTotalBalanceCall(this.currency, _callback);
        }

        public TotalBalance execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.getTotalBalanceWithHttpInfo(this.currency);
            return (TotalBalance)localVarResp.getData();
        }

        public ApiResponse<TotalBalance> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.getTotalBalanceWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<TotalBalance> _callback) throws ApiException {
            return WalletApi.this.getTotalBalanceAsync(this.currency, _callback);
        }
    }

    public class APIgetTradeFeeRequest {
        private String currencyPair;
        private String settle;

        private APIgetTradeFeeRequest() {
        }

        public APIgetTradeFeeRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIgetTradeFeeRequest settle(String settle) {
            this.settle = settle;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.getTradeFeeCall(this.currencyPair, this.settle, _callback);
        }

        public TradeFee execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.getTradeFeeWithHttpInfo(this.currencyPair, this.settle);
            return (TradeFee)localVarResp.getData();
        }

        public ApiResponse<TradeFee> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.getTradeFeeWithHttpInfo(this.currencyPair, this.settle);
        }

        public Call executeAsync(ApiCallback<TradeFee> _callback) throws ApiException {
            return WalletApi.this.getTradeFeeAsync(this.currencyPair, this.settle, _callback);
        }
    }

    public class APIlistSavedAddressRequest {
        private final String currency;
        private String chain;
        private String limit;
        private Integer page;

        private APIlistSavedAddressRequest(String currency) {
            this.currency = currency;
        }

        public APIlistSavedAddressRequest chain(String chain) {
            this.chain = chain;
            return this;
        }

        public APIlistSavedAddressRequest limit(String limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSavedAddressRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSavedAddressCall(this.currency, this.chain, this.limit, this.page, _callback);
        }

        public List<SavedAddress> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSavedAddressWithHttpInfo(this.currency, this.chain, this.limit, this.page);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SavedAddress>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSavedAddressWithHttpInfo(this.currency, this.chain, this.limit, this.page);
        }

        public Call executeAsync(ApiCallback<List<SavedAddress>> _callback) throws ApiException {
            return WalletApi.this.listSavedAddressAsync(this.currency, this.chain, this.limit, this.page, _callback);
        }
    }

    public class APIlistSubAccountCrossMarginBalancesRequest {
        private String subUid;

        private APIlistSubAccountCrossMarginBalancesRequest() {
        }

        public APIlistSubAccountCrossMarginBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountCrossMarginBalancesCall(this.subUid, _callback);
        }

        public List<SubAccountCrossMarginBalance> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountCrossMarginBalancesWithHttpInfo(this.subUid);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountCrossMarginBalance>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountCrossMarginBalancesWithHttpInfo(this.subUid);
        }

        public Call executeAsync(ApiCallback<List<SubAccountCrossMarginBalance>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountCrossMarginBalancesAsync(this.subUid, _callback);
        }
    }

    public class APIlistSubAccountFuturesBalancesRequest {
        private String subUid;
        private String settle;

        private APIlistSubAccountFuturesBalancesRequest() {
        }

        public APIlistSubAccountFuturesBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public APIlistSubAccountFuturesBalancesRequest settle(String settle) {
            this.settle = settle;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountFuturesBalancesCall(this.subUid, this.settle, _callback);
        }

        public List<SubAccountFuturesBalance> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountFuturesBalancesWithHttpInfo(this.subUid, this.settle);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountFuturesBalance>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountFuturesBalancesWithHttpInfo(this.subUid, this.settle);
        }

        public Call executeAsync(ApiCallback<List<SubAccountFuturesBalance>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountFuturesBalancesAsync(this.subUid, this.settle, _callback);
        }
    }

    public class APIlistSubAccountMarginBalancesRequest {
        private String subUid;

        private APIlistSubAccountMarginBalancesRequest() {
        }

        public APIlistSubAccountMarginBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountMarginBalancesCall(this.subUid, _callback);
        }

        public List<SubAccountMarginBalance> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountMarginBalancesWithHttpInfo(this.subUid);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountMarginBalance>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountMarginBalancesWithHttpInfo(this.subUid);
        }

        public Call executeAsync(ApiCallback<List<SubAccountMarginBalance>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountMarginBalancesAsync(this.subUid, _callback);
        }
    }

    public class APIlistSubAccountBalancesRequest {
        private String subUid;

        private APIlistSubAccountBalancesRequest() {
        }

        public APIlistSubAccountBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountBalancesCall(this.subUid, _callback);
        }

        public List<SubAccountBalance> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountBalancesWithHttpInfo(this.subUid);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountBalance>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountBalancesWithHttpInfo(this.subUid);
        }

        public Call executeAsync(ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountBalancesAsync(this.subUid, _callback);
        }
    }

    public class APIlistWithdrawStatusRequest {
        private String currency;

        private APIlistWithdrawStatusRequest() {
        }

        public APIlistWithdrawStatusRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listWithdrawStatusCall(this.currency, _callback);
        }

        public List<WithdrawStatus> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listWithdrawStatusWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<WithdrawStatus>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listWithdrawStatusWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
            return WalletApi.this.listWithdrawStatusAsync(this.currency, _callback);
        }
    }

    public class APIgetTransferOrderStatusRequest {
        private String clientOrderId;
        private String txId;

        private APIgetTransferOrderStatusRequest() {
        }

        public APIgetTransferOrderStatusRequest clientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
            return this;
        }

        public APIgetTransferOrderStatusRequest txId(String txId) {
            this.txId = txId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.getTransferOrderStatusCall(this.clientOrderId, this.txId, _callback);
        }

        public TransferOrderStatus execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.getTransferOrderStatusWithHttpInfo(this.clientOrderId, this.txId);
            return (TransferOrderStatus)localVarResp.getData();
        }

        public ApiResponse<TransferOrderStatus> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.getTransferOrderStatusWithHttpInfo(this.clientOrderId, this.txId);
        }

        public Call executeAsync(ApiCallback<TransferOrderStatus> _callback) throws ApiException {
            return WalletApi.this.getTransferOrderStatusAsync(this.clientOrderId, this.txId, _callback);
        }
    }

    public class APIlistSubAccountTransfersRequest {
        private String subUid;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistSubAccountTransfersRequest() {
        }

        public APIlistSubAccountTransfersRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public APIlistSubAccountTransfersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistSubAccountTransfersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistSubAccountTransfersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSubAccountTransfersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountTransfersCall(this.subUid, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<SubAccountTransferRecordItem> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountTransfersWithHttpInfo(this.subUid, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountTransferRecordItem>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountTransfersWithHttpInfo(this.subUid, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<SubAccountTransferRecordItem>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountTransfersAsync(this.subUid, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIlistDepositsRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistDepositsRequest() {
        }

        public APIlistDepositsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistDepositsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDepositsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistDepositsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDepositsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listDepositsCall(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<DepositRecord> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listDepositsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<DepositRecord>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listDepositsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<DepositRecord>> _callback) throws ApiException {
            return WalletApi.this.listDepositsAsync(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIlistWithdrawalsRequest {
        private String currency;
        private String withdrawId;
        private String assetClass;
        private String withdrawOrderId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistWithdrawalsRequest() {
        }

        public APIlistWithdrawalsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistWithdrawalsRequest withdrawId(String withdrawId) {
            this.withdrawId = withdrawId;
            return this;
        }

        public APIlistWithdrawalsRequest assetClass(String assetClass) {
            this.assetClass = assetClass;
            return this;
        }

        public APIlistWithdrawalsRequest withdrawOrderId(String withdrawOrderId) {
            this.withdrawOrderId = withdrawOrderId;
            return this;
        }

        public APIlistWithdrawalsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistWithdrawalsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistWithdrawalsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistWithdrawalsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listWithdrawalsCall(this.currency, this.withdrawId, this.assetClass, this.withdrawOrderId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<WithdrawalRecord> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listWithdrawalsWithHttpInfo(this.currency, this.withdrawId, this.assetClass, this.withdrawOrderId, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<WithdrawalRecord>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listWithdrawalsWithHttpInfo(this.currency, this.withdrawId, this.assetClass, this.withdrawOrderId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<WithdrawalRecord>> _callback) throws ApiException {
            return WalletApi.this.listWithdrawalsAsync(this.currency, this.withdrawId, this.assetClass, this.withdrawOrderId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }
}

