/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.TransferablesResult;
import io.gate.gateapi.models.UniLoan;
import io.gate.gateapi.models.UniLoanInterestRecord;
import io.gate.gateapi.models.UnifiedAccount;
import io.gate.gateapi.models.UnifiedBorrowable;
import io.gate.gateapi.models.UnifiedBorrowable1;
import io.gate.gateapi.models.UnifiedCollateralReq;
import io.gate.gateapi.models.UnifiedCollateralRes;
import io.gate.gateapi.models.UnifiedCurrency;
import io.gate.gateapi.models.UnifiedDiscount;
import io.gate.gateapi.models.UnifiedHistoryLoanRate;
import io.gate.gateapi.models.UnifiedLeverageConfig;
import io.gate.gateapi.models.UnifiedLeverageSetting;
import io.gate.gateapi.models.UnifiedLoan;
import io.gate.gateapi.models.UnifiedLoanRecord;
import io.gate.gateapi.models.UnifiedLoanResult;
import io.gate.gateapi.models.UnifiedMarginTiers;
import io.gate.gateapi.models.UnifiedModeSet;
import io.gate.gateapi.models.UnifiedPortfolioInput;
import io.gate.gateapi.models.UnifiedPortfolioOutput;
import io.gate.gateapi.models.UnifiedRiskUnits;
import io.gate.gateapi.models.UnifiedTransferable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class UnifiedApi {
    private ApiClient localVarApiClient;

    public UnifiedApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UnifiedApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listUnifiedAccountsCall(String currency, String subUid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnifiedAccountsValidateBeforeCall(String currency, String subUid, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUnifiedAccountsCall(currency, subUid, _callback);
        return localVarCall;
    }

    private ApiResponse<UnifiedAccount> listUnifiedAccountsWithHttpInfo(String currency, String subUid) throws ApiException {
        Call localVarCall = this.listUnifiedAccountsValidateBeforeCall(currency, subUid, null);
        Type localVarReturnType = new TypeToken<UnifiedAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUnifiedAccountsAsync(String currency, String subUid, ApiCallback<UnifiedAccount> _callback) throws ApiException {
        Call localVarCall = this.listUnifiedAccountsValidateBeforeCall(currency, subUid, _callback);
        Type localVarReturnType = new TypeToken<UnifiedAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUnifiedAccountsRequest listUnifiedAccounts() {
        return new APIlistUnifiedAccountsRequest();
    }

    public Call getUnifiedBorrowableCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/borrowable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedBorrowableValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUnifiedBorrowable(Async)");
        }
        Call localVarCall = this.getUnifiedBorrowableCall(currency, _callback);
        return localVarCall;
    }

    public UnifiedBorrowable getUnifiedBorrowable(String currency) throws ApiException {
        ApiResponse<UnifiedBorrowable> localVarResp = this.getUnifiedBorrowableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedBorrowable> getUnifiedBorrowableWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUnifiedBorrowableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UnifiedBorrowable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedBorrowableAsync(String currency, ApiCallback<UnifiedBorrowable> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedBorrowableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UnifiedBorrowable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnifiedTransferableCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/transferable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedTransferableValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUnifiedTransferable(Async)");
        }
        Call localVarCall = this.getUnifiedTransferableCall(currency, _callback);
        return localVarCall;
    }

    public UnifiedTransferable getUnifiedTransferable(String currency) throws ApiException {
        ApiResponse<UnifiedTransferable> localVarResp = this.getUnifiedTransferableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedTransferable> getUnifiedTransferableWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUnifiedTransferableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UnifiedTransferable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedTransferableAsync(String currency, ApiCallback<UnifiedTransferable> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedTransferableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UnifiedTransferable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnifiedTransferablesCall(String currencies, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/transferables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencies != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currencies", currencies));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedTransferablesValidateBeforeCall(String currencies, ApiCallback _callback) throws ApiException {
        if (currencies == null) {
            throw new ApiException("Missing the required parameter 'currencies' when calling getUnifiedTransferables(Async)");
        }
        Call localVarCall = this.getUnifiedTransferablesCall(currencies, _callback);
        return localVarCall;
    }

    public List<TransferablesResult> getUnifiedTransferables(String currencies) throws ApiException {
        ApiResponse<List<TransferablesResult>> localVarResp = this.getUnifiedTransferablesWithHttpInfo(currencies);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransferablesResult>> getUnifiedTransferablesWithHttpInfo(String currencies) throws ApiException {
        Call localVarCall = this.getUnifiedTransferablesValidateBeforeCall(currencies, null);
        Type localVarReturnType = new TypeToken<List<TransferablesResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedTransferablesAsync(String currencies, ApiCallback<List<TransferablesResult>> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedTransferablesValidateBeforeCall(currencies, _callback);
        Type localVarReturnType = new TypeToken<List<TransferablesResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnifiedBorrowableListCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/batch_borrowable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencies != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "currencies", currencies));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedBorrowableListValidateBeforeCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        if (currencies == null) {
            throw new ApiException("Missing the required parameter 'currencies' when calling getUnifiedBorrowableList(Async)");
        }
        Call localVarCall = this.getUnifiedBorrowableListCall(currencies, _callback);
        return localVarCall;
    }

    public List<UnifiedBorrowable1> getUnifiedBorrowableList(List<String> currencies) throws ApiException {
        ApiResponse<List<UnifiedBorrowable1>> localVarResp = this.getUnifiedBorrowableListWithHttpInfo(currencies);
        return localVarResp.getData();
    }

    public ApiResponse<List<UnifiedBorrowable1>> getUnifiedBorrowableListWithHttpInfo(List<String> currencies) throws ApiException {
        Call localVarCall = this.getUnifiedBorrowableListValidateBeforeCall(currencies, null);
        Type localVarReturnType = new TypeToken<List<UnifiedBorrowable1>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedBorrowableListAsync(List<String> currencies, ApiCallback<List<UnifiedBorrowable1>> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedBorrowableListValidateBeforeCall(currencies, _callback);
        Type localVarReturnType = new TypeToken<List<UnifiedBorrowable1>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listUnifiedLoansCall(String currency, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnifiedLoansValidateBeforeCall(String currency, Integer page, Integer limit, String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoansCall(currency, page, limit, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoan>> listUnifiedLoansWithHttpInfo(String currency, Integer page, Integer limit, String type) throws ApiException {
        Call localVarCall = this.listUnifiedLoansValidateBeforeCall(currency, page, limit, type, null);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUnifiedLoansAsync(String currency, Integer page, Integer limit, String type, ApiCallback<List<UniLoan>> _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoansValidateBeforeCall(currency, page, limit, type, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUnifiedLoansRequest listUnifiedLoans() {
        return new APIlistUnifiedLoansRequest();
    }

    public Call createUnifiedLoanCall(UnifiedLoan unifiedLoan, ApiCallback _callback) throws ApiException {
        UnifiedLoan localVarPostBody = unifiedLoan;
        String localVarPath = "/unified/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUnifiedLoanValidateBeforeCall(UnifiedLoan unifiedLoan, ApiCallback _callback) throws ApiException {
        if (unifiedLoan == null) {
            throw new ApiException("Missing the required parameter 'unifiedLoan' when calling createUnifiedLoan(Async)");
        }
        Call localVarCall = this.createUnifiedLoanCall(unifiedLoan, _callback);
        return localVarCall;
    }

    public UnifiedLoanResult createUnifiedLoan(UnifiedLoan unifiedLoan) throws ApiException {
        ApiResponse<UnifiedLoanResult> localVarResp = this.createUnifiedLoanWithHttpInfo(unifiedLoan);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedLoanResult> createUnifiedLoanWithHttpInfo(UnifiedLoan unifiedLoan) throws ApiException {
        Call localVarCall = this.createUnifiedLoanValidateBeforeCall(unifiedLoan, null);
        Type localVarReturnType = new TypeToken<UnifiedLoanResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createUnifiedLoanAsync(UnifiedLoan unifiedLoan, ApiCallback<UnifiedLoanResult> _callback) throws ApiException {
        Call localVarCall = this.createUnifiedLoanValidateBeforeCall(unifiedLoan, _callback);
        Type localVarReturnType = new TypeToken<UnifiedLoanResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listUnifiedLoanRecordsCall(String type, String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/loan_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnifiedLoanRecordsValidateBeforeCall(String type, String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoanRecordsCall(type, currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UnifiedLoanRecord>> listUnifiedLoanRecordsWithHttpInfo(String type, String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listUnifiedLoanRecordsValidateBeforeCall(type, currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UnifiedLoanRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUnifiedLoanRecordsAsync(String type, String currency, Integer page, Integer limit, ApiCallback<List<UnifiedLoanRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoanRecordsValidateBeforeCall(type, currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UnifiedLoanRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUnifiedLoanRecordsRequest listUnifiedLoanRecords() {
        return new APIlistUnifiedLoanRecordsRequest();
    }

    private Call listUnifiedLoanInterestRecordsCall(String currency, Integer page, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/interest_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnifiedLoanInterestRecordsValidateBeforeCall(String currency, Integer page, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoanInterestRecordsCall(currency, page, limit, from, to, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoanInterestRecord>> listUnifiedLoanInterestRecordsWithHttpInfo(String currency, Integer page, Integer limit, Long from, Long to, String type) throws ApiException {
        Call localVarCall = this.listUnifiedLoanInterestRecordsValidateBeforeCall(currency, page, limit, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUnifiedLoanInterestRecordsAsync(String currency, Integer page, Integer limit, Long from, Long to, String type, ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUnifiedLoanInterestRecordsValidateBeforeCall(currency, page, limit, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUnifiedLoanInterestRecordsRequest listUnifiedLoanInterestRecords() {
        return new APIlistUnifiedLoanInterestRecordsRequest();
    }

    public Call getUnifiedRiskUnitsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/risk_units";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedRiskUnitsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUnifiedRiskUnitsCall(_callback);
        return localVarCall;
    }

    public UnifiedRiskUnits getUnifiedRiskUnits() throws ApiException {
        ApiResponse<UnifiedRiskUnits> localVarResp = this.getUnifiedRiskUnitsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedRiskUnits> getUnifiedRiskUnitsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUnifiedRiskUnitsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UnifiedRiskUnits>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedRiskUnitsAsync(ApiCallback<UnifiedRiskUnits> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedRiskUnitsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UnifiedRiskUnits>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnifiedModeCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/unified_mode";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedModeValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUnifiedModeCall(_callback);
        return localVarCall;
    }

    public UnifiedModeSet getUnifiedMode() throws ApiException {
        ApiResponse<UnifiedModeSet> localVarResp = this.getUnifiedModeWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedModeSet> getUnifiedModeWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUnifiedModeValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UnifiedModeSet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedModeAsync(ApiCallback<UnifiedModeSet> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedModeValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UnifiedModeSet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setUnifiedModeCall(UnifiedModeSet unifiedModeSet, ApiCallback _callback) throws ApiException {
        UnifiedModeSet localVarPostBody = unifiedModeSet;
        String localVarPath = "/unified/unified_mode";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setUnifiedModeValidateBeforeCall(UnifiedModeSet unifiedModeSet, ApiCallback _callback) throws ApiException {
        if (unifiedModeSet == null) {
            throw new ApiException("Missing the required parameter 'unifiedModeSet' when calling setUnifiedMode(Async)");
        }
        Call localVarCall = this.setUnifiedModeCall(unifiedModeSet, _callback);
        return localVarCall;
    }

    public void setUnifiedMode(UnifiedModeSet unifiedModeSet) throws ApiException {
        this.setUnifiedModeWithHttpInfo(unifiedModeSet);
    }

    public ApiResponse<Void> setUnifiedModeWithHttpInfo(UnifiedModeSet unifiedModeSet) throws ApiException {
        Call localVarCall = this.setUnifiedModeValidateBeforeCall(unifiedModeSet, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setUnifiedModeAsync(UnifiedModeSet unifiedModeSet, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setUnifiedModeValidateBeforeCall(unifiedModeSet, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getUnifiedEstimateRateCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/estimate_rate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencies != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "currencies", currencies));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnifiedEstimateRateValidateBeforeCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        if (currencies == null) {
            throw new ApiException("Missing the required parameter 'currencies' when calling getUnifiedEstimateRate(Async)");
        }
        Call localVarCall = this.getUnifiedEstimateRateCall(currencies, _callback);
        return localVarCall;
    }

    public Map<String, String> getUnifiedEstimateRate(List<String> currencies) throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.getUnifiedEstimateRateWithHttpInfo(currencies);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, String>> getUnifiedEstimateRateWithHttpInfo(List<String> currencies) throws ApiException {
        Call localVarCall = this.getUnifiedEstimateRateValidateBeforeCall(currencies, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnifiedEstimateRateAsync(List<String> currencies, ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.getUnifiedEstimateRateValidateBeforeCall(currencies, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCurrencyDiscountTiersCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/currency_discount_tiers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrencyDiscountTiersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCurrencyDiscountTiersCall(_callback);
        return localVarCall;
    }

    public List<UnifiedDiscount> listCurrencyDiscountTiers() throws ApiException {
        ApiResponse<List<UnifiedDiscount>> localVarResp = this.listCurrencyDiscountTiersWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<UnifiedDiscount>> listCurrencyDiscountTiersWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrencyDiscountTiersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UnifiedDiscount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrencyDiscountTiersAsync(ApiCallback<List<UnifiedDiscount>> _callback) throws ApiException {
        Call localVarCall = this.listCurrencyDiscountTiersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UnifiedDiscount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listLoanMarginTiersCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/loan_margin_tiers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLoanMarginTiersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listLoanMarginTiersCall(_callback);
        return localVarCall;
    }

    public List<UnifiedMarginTiers> listLoanMarginTiers() throws ApiException {
        ApiResponse<List<UnifiedMarginTiers>> localVarResp = this.listLoanMarginTiersWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<UnifiedMarginTiers>> listLoanMarginTiersWithHttpInfo() throws ApiException {
        Call localVarCall = this.listLoanMarginTiersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UnifiedMarginTiers>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listLoanMarginTiersAsync(ApiCallback<List<UnifiedMarginTiers>> _callback) throws ApiException {
        Call localVarCall = this.listLoanMarginTiersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UnifiedMarginTiers>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call calculatePortfolioMarginCall(UnifiedPortfolioInput unifiedPortfolioInput, ApiCallback _callback) throws ApiException {
        UnifiedPortfolioInput localVarPostBody = unifiedPortfolioInput;
        String localVarPath = "/unified/portfolio_calculator";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call calculatePortfolioMarginValidateBeforeCall(UnifiedPortfolioInput unifiedPortfolioInput, ApiCallback _callback) throws ApiException {
        if (unifiedPortfolioInput == null) {
            throw new ApiException("Missing the required parameter 'unifiedPortfolioInput' when calling calculatePortfolioMargin(Async)");
        }
        Call localVarCall = this.calculatePortfolioMarginCall(unifiedPortfolioInput, _callback);
        return localVarCall;
    }

    public UnifiedPortfolioOutput calculatePortfolioMargin(UnifiedPortfolioInput unifiedPortfolioInput) throws ApiException {
        ApiResponse<UnifiedPortfolioOutput> localVarResp = this.calculatePortfolioMarginWithHttpInfo(unifiedPortfolioInput);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedPortfolioOutput> calculatePortfolioMarginWithHttpInfo(UnifiedPortfolioInput unifiedPortfolioInput) throws ApiException {
        Call localVarCall = this.calculatePortfolioMarginValidateBeforeCall(unifiedPortfolioInput, null);
        Type localVarReturnType = new TypeToken<UnifiedPortfolioOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call calculatePortfolioMarginAsync(UnifiedPortfolioInput unifiedPortfolioInput, ApiCallback<UnifiedPortfolioOutput> _callback) throws ApiException {
        Call localVarCall = this.calculatePortfolioMarginValidateBeforeCall(unifiedPortfolioInput, _callback);
        Type localVarReturnType = new TypeToken<UnifiedPortfolioOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserLeverageCurrencyConfigCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/leverage/user_currency_config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserLeverageCurrencyConfigValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUserLeverageCurrencyConfig(Async)");
        }
        Call localVarCall = this.getUserLeverageCurrencyConfigCall(currency, _callback);
        return localVarCall;
    }

    public UnifiedLeverageConfig getUserLeverageCurrencyConfig(String currency) throws ApiException {
        ApiResponse<UnifiedLeverageConfig> localVarResp = this.getUserLeverageCurrencyConfigWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedLeverageConfig> getUserLeverageCurrencyConfigWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUserLeverageCurrencyConfigValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UnifiedLeverageConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserLeverageCurrencyConfigAsync(String currency, ApiCallback<UnifiedLeverageConfig> _callback) throws ApiException {
        Call localVarCall = this.getUserLeverageCurrencyConfigValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UnifiedLeverageConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getUserLeverageCurrencySettingCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/leverage/user_currency_setting";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserLeverageCurrencySettingValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUserLeverageCurrencySettingCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UnifiedLeverageSetting>> getUserLeverageCurrencySettingWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getUserLeverageCurrencySettingValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<UnifiedLeverageSetting>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getUserLeverageCurrencySettingAsync(String currency, ApiCallback<List<UnifiedLeverageSetting>> _callback) throws ApiException {
        Call localVarCall = this.getUserLeverageCurrencySettingValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<UnifiedLeverageSetting>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUserLeverageCurrencySettingRequest getUserLeverageCurrencySetting() {
        return new APIgetUserLeverageCurrencySettingRequest();
    }

    public Call setUserLeverageCurrencySettingCall(UnifiedLeverageSetting unifiedLeverageSetting, ApiCallback _callback) throws ApiException {
        UnifiedLeverageSetting localVarPostBody = unifiedLeverageSetting;
        String localVarPath = "/unified/leverage/user_currency_setting";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setUserLeverageCurrencySettingValidateBeforeCall(UnifiedLeverageSetting unifiedLeverageSetting, ApiCallback _callback) throws ApiException {
        if (unifiedLeverageSetting == null) {
            throw new ApiException("Missing the required parameter 'unifiedLeverageSetting' when calling setUserLeverageCurrencySetting(Async)");
        }
        Call localVarCall = this.setUserLeverageCurrencySettingCall(unifiedLeverageSetting, _callback);
        return localVarCall;
    }

    public void setUserLeverageCurrencySetting(UnifiedLeverageSetting unifiedLeverageSetting) throws ApiException {
        this.setUserLeverageCurrencySettingWithHttpInfo(unifiedLeverageSetting);
    }

    public ApiResponse<Void> setUserLeverageCurrencySettingWithHttpInfo(UnifiedLeverageSetting unifiedLeverageSetting) throws ApiException {
        Call localVarCall = this.setUserLeverageCurrencySettingValidateBeforeCall(unifiedLeverageSetting, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setUserLeverageCurrencySettingAsync(UnifiedLeverageSetting unifiedLeverageSetting, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setUserLeverageCurrencySettingValidateBeforeCall(unifiedLeverageSetting, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listUnifiedCurrenciesCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnifiedCurrenciesValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUnifiedCurrenciesCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UnifiedCurrency>> listUnifiedCurrenciesWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listUnifiedCurrenciesValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<UnifiedCurrency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUnifiedCurrenciesAsync(String currency, ApiCallback<List<UnifiedCurrency>> _callback) throws ApiException {
        Call localVarCall = this.listUnifiedCurrenciesValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<UnifiedCurrency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUnifiedCurrenciesRequest listUnifiedCurrencies() {
        return new APIlistUnifiedCurrenciesRequest();
    }

    private Call getHistoryLoanRateCall(String currency, String tier, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/unified/history_loan_rate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tier != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tier", tier));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoryLoanRateValidateBeforeCall(String currency, String tier, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getHistoryLoanRate(Async)");
        }
        Call localVarCall = this.getHistoryLoanRateCall(currency, tier, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<UnifiedHistoryLoanRate> getHistoryLoanRateWithHttpInfo(String currency, String tier, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.getHistoryLoanRateValidateBeforeCall(currency, tier, page, limit, null);
        Type localVarReturnType = new TypeToken<UnifiedHistoryLoanRate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getHistoryLoanRateAsync(String currency, String tier, Integer page, Integer limit, ApiCallback<UnifiedHistoryLoanRate> _callback) throws ApiException {
        Call localVarCall = this.getHistoryLoanRateValidateBeforeCall(currency, tier, page, limit, _callback);
        Type localVarReturnType = new TypeToken<UnifiedHistoryLoanRate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetHistoryLoanRateRequest getHistoryLoanRate(String currency) {
        return new APIgetHistoryLoanRateRequest(currency);
    }

    public Call setUnifiedCollateralCall(UnifiedCollateralReq unifiedCollateralReq, ApiCallback _callback) throws ApiException {
        UnifiedCollateralReq localVarPostBody = unifiedCollateralReq;
        String localVarPath = "/unified/collateral_currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setUnifiedCollateralValidateBeforeCall(UnifiedCollateralReq unifiedCollateralReq, ApiCallback _callback) throws ApiException {
        if (unifiedCollateralReq == null) {
            throw new ApiException("Missing the required parameter 'unifiedCollateralReq' when calling setUnifiedCollateral(Async)");
        }
        Call localVarCall = this.setUnifiedCollateralCall(unifiedCollateralReq, _callback);
        return localVarCall;
    }

    public UnifiedCollateralRes setUnifiedCollateral(UnifiedCollateralReq unifiedCollateralReq) throws ApiException {
        ApiResponse<UnifiedCollateralRes> localVarResp = this.setUnifiedCollateralWithHttpInfo(unifiedCollateralReq);
        return localVarResp.getData();
    }

    public ApiResponse<UnifiedCollateralRes> setUnifiedCollateralWithHttpInfo(UnifiedCollateralReq unifiedCollateralReq) throws ApiException {
        Call localVarCall = this.setUnifiedCollateralValidateBeforeCall(unifiedCollateralReq, null);
        Type localVarReturnType = new TypeToken<UnifiedCollateralRes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setUnifiedCollateralAsync(UnifiedCollateralReq unifiedCollateralReq, ApiCallback<UnifiedCollateralRes> _callback) throws ApiException {
        Call localVarCall = this.setUnifiedCollateralValidateBeforeCall(unifiedCollateralReq, _callback);
        Type localVarReturnType = new TypeToken<UnifiedCollateralRes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetHistoryLoanRateRequest {
        private final String currency;
        private String tier;
        private Integer page;
        private Integer limit;

        private APIgetHistoryLoanRateRequest(String currency) {
            this.currency = currency;
        }

        public APIgetHistoryLoanRateRequest tier(String tier) {
            this.tier = tier;
            return this;
        }

        public APIgetHistoryLoanRateRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIgetHistoryLoanRateRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.getHistoryLoanRateCall(this.currency, this.tier, this.page, this.limit, _callback);
        }

        public UnifiedHistoryLoanRate execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.getHistoryLoanRateWithHttpInfo(this.currency, this.tier, this.page, this.limit);
            return (UnifiedHistoryLoanRate)localVarResp.getData();
        }

        public ApiResponse<UnifiedHistoryLoanRate> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.getHistoryLoanRateWithHttpInfo(this.currency, this.tier, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<UnifiedHistoryLoanRate> _callback) throws ApiException {
            return UnifiedApi.this.getHistoryLoanRateAsync(this.currency, this.tier, this.page, this.limit, _callback);
        }
    }

    public class APIlistUnifiedCurrenciesRequest {
        private String currency;

        private APIlistUnifiedCurrenciesRequest() {
        }

        public APIlistUnifiedCurrenciesRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedCurrenciesCall(this.currency, _callback);
        }

        public List<UnifiedCurrency> execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.listUnifiedCurrenciesWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UnifiedCurrency>> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.listUnifiedCurrenciesWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<UnifiedCurrency>> _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedCurrenciesAsync(this.currency, _callback);
        }
    }

    public class APIgetUserLeverageCurrencySettingRequest {
        private String currency;

        private APIgetUserLeverageCurrencySettingRequest() {
        }

        public APIgetUserLeverageCurrencySettingRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.getUserLeverageCurrencySettingCall(this.currency, _callback);
        }

        public List<UnifiedLeverageSetting> execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.getUserLeverageCurrencySettingWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UnifiedLeverageSetting>> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.getUserLeverageCurrencySettingWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<UnifiedLeverageSetting>> _callback) throws ApiException {
            return UnifiedApi.this.getUserLeverageCurrencySettingAsync(this.currency, _callback);
        }
    }

    public class APIlistUnifiedLoanInterestRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;
        private String type;

        private APIlistUnifiedLoanInterestRecordsRequest() {
        }

        public APIlistUnifiedLoanInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUnifiedLoanInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUnifiedLoanInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistUnifiedLoanInterestRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistUnifiedLoanInterestRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistUnifiedLoanInterestRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoanInterestRecordsCall(this.currency, this.page, this.limit, this.from, this.to, this.type, _callback);
        }

        public List<UniLoanInterestRecord> execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.listUnifiedLoanInterestRecordsWithHttpInfo(this.currency, this.page, this.limit, this.from, this.to, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoanInterestRecord>> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.listUnifiedLoanInterestRecordsWithHttpInfo(this.currency, this.page, this.limit, this.from, this.to, this.type);
        }

        public Call executeAsync(ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoanInterestRecordsAsync(this.currency, this.page, this.limit, this.from, this.to, this.type, _callback);
        }
    }

    public class APIlistUnifiedLoanRecordsRequest {
        private String type;
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUnifiedLoanRecordsRequest() {
        }

        public APIlistUnifiedLoanRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistUnifiedLoanRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUnifiedLoanRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUnifiedLoanRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoanRecordsCall(this.type, this.currency, this.page, this.limit, _callback);
        }

        public List<UnifiedLoanRecord> execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.listUnifiedLoanRecordsWithHttpInfo(this.type, this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UnifiedLoanRecord>> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.listUnifiedLoanRecordsWithHttpInfo(this.type, this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UnifiedLoanRecord>> _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoanRecordsAsync(this.type, this.currency, this.page, this.limit, _callback);
        }
    }

    public class APIlistUnifiedLoansRequest {
        private String currency;
        private Integer page;
        private Integer limit;
        private String type;

        private APIlistUnifiedLoansRequest() {
        }

        public APIlistUnifiedLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUnifiedLoansRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUnifiedLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistUnifiedLoansRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoansCall(this.currency, this.page, this.limit, this.type, _callback);
        }

        public List<UniLoan> execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.listUnifiedLoansWithHttpInfo(this.currency, this.page, this.limit, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoan>> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.listUnifiedLoansWithHttpInfo(this.currency, this.page, this.limit, this.type);
        }

        public Call executeAsync(ApiCallback<List<UniLoan>> _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedLoansAsync(this.currency, this.page, this.limit, this.type, _callback);
        }
    }

    public class APIlistUnifiedAccountsRequest {
        private String currency;
        private String subUid;

        private APIlistUnifiedAccountsRequest() {
        }

        public APIlistUnifiedAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUnifiedAccountsRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedAccountsCall(this.currency, this.subUid, _callback);
        }

        public UnifiedAccount execute() throws ApiException {
            ApiResponse localVarResp = UnifiedApi.this.listUnifiedAccountsWithHttpInfo(this.currency, this.subUid);
            return (UnifiedAccount)localVarResp.getData();
        }

        public ApiResponse<UnifiedAccount> executeWithHttpInfo() throws ApiException {
            return UnifiedApi.this.listUnifiedAccountsWithHttpInfo(this.currency, this.subUid);
        }

        public Call executeAsync(ApiCallback<UnifiedAccount> _callback) throws ApiException {
            return UnifiedApi.this.listUnifiedAccountsAsync(this.currency, this.subUid, _callback);
        }
    }
}

