/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.BatchAmendItem;
import io.gate.gateapi.models.BatchOrder;
import io.gate.gateapi.models.CancelBatchOrder;
import io.gate.gateapi.models.CancelOrderResult;
import io.gate.gateapi.models.CountdownCancelAllSpotTask;
import io.gate.gateapi.models.Currency;
import io.gate.gateapi.models.CurrencyPair;
import io.gate.gateapi.models.LiquidateOrder;
import io.gate.gateapi.models.OpenOrders;
import io.gate.gateapi.models.Order;
import io.gate.gateapi.models.OrderBook;
import io.gate.gateapi.models.OrderCancel;
import io.gate.gateapi.models.OrderPatch;
import io.gate.gateapi.models.SpotAccount;
import io.gate.gateapi.models.SpotAccountBook;
import io.gate.gateapi.models.SpotFee;
import io.gate.gateapi.models.SpotInsuranceHistory;
import io.gate.gateapi.models.SpotPriceTriggeredOrder;
import io.gate.gateapi.models.SystemTime;
import io.gate.gateapi.models.Ticker;
import io.gate.gateapi.models.Trade;
import io.gate.gateapi.models.TriggerOrderResponse;
import io.gate.gateapi.models.TriggerTime;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class SpotApi {
    private ApiClient localVarApiClient;

    public SpotApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SpotApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCurrenciesCall(_callback);
        return localVarCall;
    }

    public List<Currency> listCurrencies() throws ApiException {
        ApiResponse<List<Currency>> localVarResp = this.listCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Currency>> listCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Currency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrenciesAsync(ApiCallback<List<Currency>> _callback) throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Currency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrencyCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currencies/{currency}".replaceAll("\\{currency\\}", this.localVarApiClient.escapeString(currency));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrencyValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCurrency(Async)");
        }
        Call localVarCall = this.getCurrencyCall(currency, _callback);
        return localVarCall;
    }

    public Currency getCurrency(String currency) throws ApiException {
        ApiResponse<Currency> localVarResp = this.getCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<Currency> getCurrencyWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<Currency>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrencyAsync(String currency, ApiCallback<Currency> _callback) throws ApiException {
        Call localVarCall = this.getCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<Currency>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCurrencyPairsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currency_pairs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrencyPairsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCurrencyPairsCall(_callback);
        return localVarCall;
    }

    public List<CurrencyPair> listCurrencyPairs() throws ApiException {
        ApiResponse<List<CurrencyPair>> localVarResp = this.listCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<CurrencyPair>> listCurrencyPairsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CurrencyPair>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrencyPairsAsync(ApiCallback<List<CurrencyPair>> _callback) throws ApiException {
        Call localVarCall = this.listCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CurrencyPair>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrencyPairCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currency_pairs/{currency_pair}".replaceAll("\\{currency_pair\\}", this.localVarApiClient.escapeString(currencyPair));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrencyPairValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getCurrencyPair(Async)");
        }
        Call localVarCall = this.getCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    public CurrencyPair getCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<CurrencyPair> localVarResp = this.getCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<CurrencyPair> getCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<CurrencyPair>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrencyPairAsync(String currencyPair, ApiCallback<CurrencyPair> _callback) throws ApiException {
        Call localVarCall = this.getCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<CurrencyPair>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listTickersCall(String currencyPair, String timezone, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/tickers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (timezone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timezone", timezone));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTickersValidateBeforeCall(String currencyPair, String timezone, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listTickersCall(currencyPair, timezone, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Ticker>> listTickersWithHttpInfo(String currencyPair, String timezone) throws ApiException {
        Call localVarCall = this.listTickersValidateBeforeCall(currencyPair, timezone, null);
        Type localVarReturnType = new TypeToken<List<Ticker>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listTickersAsync(String currencyPair, String timezone, ApiCallback<List<Ticker>> _callback) throws ApiException {
        Call localVarCall = this.listTickersValidateBeforeCall(currencyPair, timezone, _callback);
        Type localVarReturnType = new TypeToken<List<Ticker>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistTickersRequest listTickers() {
        return new APIlistTickersRequest();
    }

    private Call listOrderBookCall(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/order_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (withId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("with_id", withId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOrderBookValidateBeforeCall(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listOrderBook(Async)");
        }
        Call localVarCall = this.listOrderBookCall(currencyPair, interval, limit, withId, _callback);
        return localVarCall;
    }

    private ApiResponse<OrderBook> listOrderBookWithHttpInfo(String currencyPair, String interval, Integer limit, Boolean withId) throws ApiException {
        Call localVarCall = this.listOrderBookValidateBeforeCall(currencyPair, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<OrderBook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOrderBookAsync(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback<OrderBook> _callback) throws ApiException {
        Call localVarCall = this.listOrderBookValidateBeforeCall(currencyPair, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<OrderBook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOrderBookRequest listOrderBook(String currencyPair) {
        return new APIlistOrderBookRequest(currencyPair);
    }

    private Call listTradesCall(String currencyPair, Integer limit, String lastId, Boolean reverse, Long from, Long to, Integer page, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTradesValidateBeforeCall(String currencyPair, Integer limit, String lastId, Boolean reverse, Long from, Long to, Integer page, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listTrades(Async)");
        }
        Call localVarCall = this.listTradesCall(currencyPair, limit, lastId, reverse, from, to, page, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Trade>> listTradesWithHttpInfo(String currencyPair, Integer limit, String lastId, Boolean reverse, Long from, Long to, Integer page) throws ApiException {
        Call localVarCall = this.listTradesValidateBeforeCall(currencyPair, limit, lastId, reverse, from, to, page, null);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listTradesAsync(String currencyPair, Integer limit, String lastId, Boolean reverse, Long from, Long to, Integer page, ApiCallback<List<Trade>> _callback) throws ApiException {
        Call localVarCall = this.listTradesValidateBeforeCall(currencyPair, limit, lastId, reverse, from, to, page, _callback);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistTradesRequest listTrades(String currencyPair) {
        return new APIlistTradesRequest(currencyPair);
    }

    private Call listCandlesticksCall(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/candlesticks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCandlesticksValidateBeforeCall(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listCandlesticks(Async)");
        }
        Call localVarCall = this.listCandlesticksCall(currencyPair, limit, from, to, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<List<String>>> listCandlesticksWithHttpInfo(String currencyPair, Integer limit, Long from, Long to, String interval) throws ApiException {
        Call localVarCall = this.listCandlesticksValidateBeforeCall(currencyPair, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<List<String>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCandlesticksAsync(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback<List<List<String>>> _callback) throws ApiException {
        Call localVarCall = this.listCandlesticksValidateBeforeCall(currencyPair, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<List<String>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCandlesticksRequest listCandlesticks(String currencyPair) {
        return new APIlistCandlesticksRequest(currencyPair);
    }

    private Call getFeeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getFeeValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getFeeCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<SpotFee> getFeeWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getFeeValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<SpotFee>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getFeeAsync(String currencyPair, ApiCallback<SpotFee> _callback) throws ApiException {
        Call localVarCall = this.getFeeValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<SpotFee>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIgetFeeRequest getFee() {
        return new APIgetFeeRequest();
    }

    public Call getBatchSpotFeeCall(String currencyPairs, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/batch_fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPairs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pairs", currencyPairs));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchSpotFeeValidateBeforeCall(String currencyPairs, ApiCallback _callback) throws ApiException {
        if (currencyPairs == null) {
            throw new ApiException("Missing the required parameter 'currencyPairs' when calling getBatchSpotFee(Async)");
        }
        Call localVarCall = this.getBatchSpotFeeCall(currencyPairs, _callback);
        return localVarCall;
    }

    public Map<String, SpotFee> getBatchSpotFee(String currencyPairs) throws ApiException {
        ApiResponse<Map<String, SpotFee>> localVarResp = this.getBatchSpotFeeWithHttpInfo(currencyPairs);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, SpotFee>> getBatchSpotFeeWithHttpInfo(String currencyPairs) throws ApiException {
        Call localVarCall = this.getBatchSpotFeeValidateBeforeCall(currencyPairs, null);
        Type localVarReturnType = new TypeToken<Map<String, SpotFee>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchSpotFeeAsync(String currencyPairs, ApiCallback<Map<String, SpotFee>> _callback) throws ApiException {
        Call localVarCall = this.getBatchSpotFeeValidateBeforeCall(currencyPairs, _callback);
        Type localVarReturnType = new TypeToken<Map<String, SpotFee>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listSpotAccountsCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSpotAccountsValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountsCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotAccount>> listSpotAccountsWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listSpotAccountsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<SpotAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSpotAccountsAsync(String currency, ApiCallback<List<SpotAccount>> _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<SpotAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSpotAccountsRequest listSpotAccounts() {
        return new APIlistSpotAccountsRequest();
    }

    private Call listSpotAccountBookCall(String currency, Long from, Long to, Integer page, Integer limit, String type, String code, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/account_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (code != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("code", code));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSpotAccountBookValidateBeforeCall(String currency, Long from, Long to, Integer page, Integer limit, String type, String code, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountBookCall(currency, from, to, page, limit, type, code, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotAccountBook>> listSpotAccountBookWithHttpInfo(String currency, Long from, Long to, Integer page, Integer limit, String type, String code) throws ApiException {
        Call localVarCall = this.listSpotAccountBookValidateBeforeCall(currency, from, to, page, limit, type, code, null);
        Type localVarReturnType = new TypeToken<List<SpotAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSpotAccountBookAsync(String currency, Long from, Long to, Integer page, Integer limit, String type, String code, ApiCallback<List<SpotAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountBookValidateBeforeCall(currency, from, to, page, limit, type, code, _callback);
        Type localVarReturnType = new TypeToken<List<SpotAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSpotAccountBookRequest listSpotAccountBook() {
        return new APIlistSpotAccountBookRequest();
    }

    public Call createBatchOrdersCall(List<Order> order, String xGateExptime, ApiCallback _callback) throws ApiException {
        List<Order> localVarPostBody = order;
        String localVarPath = "/spot/batch_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBatchOrdersValidateBeforeCall(List<Order> order, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling createBatchOrders(Async)");
        }
        Call localVarCall = this.createBatchOrdersCall(order, xGateExptime, _callback);
        return localVarCall;
    }

    public List<BatchOrder> createBatchOrders(List<Order> order, String xGateExptime) throws ApiException {
        ApiResponse<List<BatchOrder>> localVarResp = this.createBatchOrdersWithHttpInfo(order, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<List<BatchOrder>> createBatchOrdersWithHttpInfo(List<Order> order, String xGateExptime) throws ApiException {
        Call localVarCall = this.createBatchOrdersValidateBeforeCall(order, xGateExptime, null);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBatchOrdersAsync(List<Order> order, String xGateExptime, ApiCallback<List<BatchOrder>> _callback) throws ApiException {
        Call localVarCall = this.createBatchOrdersValidateBeforeCall(order, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listAllOpenOrdersCall(Integer page, Integer limit, String account, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/open_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAllOpenOrdersValidateBeforeCall(Integer page, Integer limit, String account, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersCall(page, limit, account, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OpenOrders>> listAllOpenOrdersWithHttpInfo(Integer page, Integer limit, String account) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersValidateBeforeCall(page, limit, account, null);
        Type localVarReturnType = new TypeToken<List<OpenOrders>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAllOpenOrdersAsync(Integer page, Integer limit, String account, ApiCallback<List<OpenOrders>> _callback) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersValidateBeforeCall(page, limit, account, _callback);
        Type localVarReturnType = new TypeToken<List<OpenOrders>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistAllOpenOrdersRequest listAllOpenOrders() {
        return new APIlistAllOpenOrdersRequest();
    }

    public Call createCrossLiquidateOrderCall(LiquidateOrder liquidateOrder, ApiCallback _callback) throws ApiException {
        LiquidateOrder localVarPostBody = liquidateOrder;
        String localVarPath = "/spot/cross_liquidate_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCrossLiquidateOrderValidateBeforeCall(LiquidateOrder liquidateOrder, ApiCallback _callback) throws ApiException {
        if (liquidateOrder == null) {
            throw new ApiException("Missing the required parameter 'liquidateOrder' when calling createCrossLiquidateOrder(Async)");
        }
        Call localVarCall = this.createCrossLiquidateOrderCall(liquidateOrder, _callback);
        return localVarCall;
    }

    public Order createCrossLiquidateOrder(LiquidateOrder liquidateOrder) throws ApiException {
        ApiResponse<Order> localVarResp = this.createCrossLiquidateOrderWithHttpInfo(liquidateOrder);
        return localVarResp.getData();
    }

    public ApiResponse<Order> createCrossLiquidateOrderWithHttpInfo(LiquidateOrder liquidateOrder) throws ApiException {
        Call localVarCall = this.createCrossLiquidateOrderValidateBeforeCall(liquidateOrder, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCrossLiquidateOrderAsync(LiquidateOrder liquidateOrder, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.createCrossLiquidateOrderValidateBeforeCall(liquidateOrder, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOrdersCall(String currencyPair, String status, Integer page, Integer limit, String account, Long from, Long to, String side, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOrdersValidateBeforeCall(String currencyPair, String status, Integer page, Integer limit, String account, Long from, Long to, String side, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listOrders(Async)");
        }
        Call localVarCall = this.listOrdersCall(currencyPair, status, page, limit, account, from, to, side, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Order>> listOrdersWithHttpInfo(String currencyPair, String status, Integer page, Integer limit, String account, Long from, Long to, String side) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(currencyPair, status, page, limit, account, from, to, side, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOrdersAsync(String currencyPair, String status, Integer page, Integer limit, String account, Long from, Long to, String side, ApiCallback<List<Order>> _callback) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(currencyPair, status, page, limit, account, from, to, side, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOrdersRequest listOrders(String currencyPair, String status) {
        return new APIlistOrdersRequest(currencyPair, status);
    }

    public Call createOrderCall(Order order, String xGateExptime, ApiCallback _callback) throws ApiException {
        Order localVarPostBody = order;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderValidateBeforeCall(Order order, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling createOrder(Async)");
        }
        Call localVarCall = this.createOrderCall(order, xGateExptime, _callback);
        return localVarCall;
    }

    public Order createOrder(Order order, String xGateExptime) throws ApiException {
        ApiResponse<Order> localVarResp = this.createOrderWithHttpInfo(order, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<Order> createOrderWithHttpInfo(Order order, String xGateExptime) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(order, xGateExptime, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOrderAsync(Order order, String xGateExptime, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(order, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOrdersCall(String currencyPair, String side, String account, String actionMode, String xGateExptime, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (actionMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("action_mode", actionMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrdersValidateBeforeCall(String currencyPair, String side, String account, String actionMode, String xGateExptime, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.cancelOrdersCall(currencyPair, side, account, actionMode, xGateExptime, _callback);
        return localVarCall;
    }

    public List<OrderCancel> cancelOrders(String currencyPair, String side, String account, String actionMode, String xGateExptime) throws ApiException {
        ApiResponse<List<OrderCancel>> localVarResp = this.cancelOrdersWithHttpInfo(currencyPair, side, account, actionMode, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<List<OrderCancel>> cancelOrdersWithHttpInfo(String currencyPair, String side, String account, String actionMode, String xGateExptime) throws ApiException {
        Call localVarCall = this.cancelOrdersValidateBeforeCall(currencyPair, side, account, actionMode, xGateExptime, null);
        Type localVarReturnType = new TypeToken<List<OrderCancel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOrdersAsync(String currencyPair, String side, String account, String actionMode, String xGateExptime, ApiCallback<List<OrderCancel>> _callback) throws ApiException {
        Call localVarCall = this.cancelOrdersValidateBeforeCall(currencyPair, side, account, actionMode, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<List<OrderCancel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelBatchOrdersCall(List<CancelBatchOrder> cancelBatchOrder, String xGateExptime, ApiCallback _callback) throws ApiException {
        List<CancelBatchOrder> localVarPostBody = cancelBatchOrder;
        String localVarPath = "/spot/cancel_batch_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelBatchOrdersValidateBeforeCall(List<CancelBatchOrder> cancelBatchOrder, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (cancelBatchOrder == null) {
            throw new ApiException("Missing the required parameter 'cancelBatchOrder' when calling cancelBatchOrders(Async)");
        }
        Call localVarCall = this.cancelBatchOrdersCall(cancelBatchOrder, xGateExptime, _callback);
        return localVarCall;
    }

    public List<CancelOrderResult> cancelBatchOrders(List<CancelBatchOrder> cancelBatchOrder, String xGateExptime) throws ApiException {
        ApiResponse<List<CancelOrderResult>> localVarResp = this.cancelBatchOrdersWithHttpInfo(cancelBatchOrder, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<List<CancelOrderResult>> cancelBatchOrdersWithHttpInfo(List<CancelBatchOrder> cancelBatchOrder, String xGateExptime) throws ApiException {
        Call localVarCall = this.cancelBatchOrdersValidateBeforeCall(cancelBatchOrder, xGateExptime, null);
        Type localVarReturnType = new TypeToken<List<CancelOrderResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelBatchOrdersAsync(List<CancelBatchOrder> cancelBatchOrder, String xGateExptime, ApiCallback<List<CancelOrderResult>> _callback) throws ApiException {
        Call localVarCall = this.cancelBatchOrdersValidateBeforeCall(cancelBatchOrder, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<List<CancelOrderResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrderCall(String orderId, String currencyPair, String account, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderValidateBeforeCall(String orderId, String currencyPair, String account, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getOrder(Async)");
        }
        Call localVarCall = this.getOrderCall(orderId, currencyPair, account, _callback);
        return localVarCall;
    }

    public Order getOrder(String orderId, String currencyPair, String account) throws ApiException {
        ApiResponse<Order> localVarResp = this.getOrderWithHttpInfo(orderId, currencyPair, account);
        return localVarResp.getData();
    }

    public ApiResponse<Order> getOrderWithHttpInfo(String orderId, String currencyPair, String account) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, currencyPair, account, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrderAsync(String orderId, String currencyPair, String account, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, currencyPair, account, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOrderCall(String orderId, String currencyPair, String account, String actionMode, String xGateExptime, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (actionMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("action_mode", actionMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrderValidateBeforeCall(String orderId, String currencyPair, String account, String actionMode, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrder(Async)");
        }
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling cancelOrder(Async)");
        }
        Call localVarCall = this.cancelOrderCall(orderId, currencyPair, account, actionMode, xGateExptime, _callback);
        return localVarCall;
    }

    public Order cancelOrder(String orderId, String currencyPair, String account, String actionMode, String xGateExptime) throws ApiException {
        ApiResponse<Order> localVarResp = this.cancelOrderWithHttpInfo(orderId, currencyPair, account, actionMode, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<Order> cancelOrderWithHttpInfo(String orderId, String currencyPair, String account, String actionMode, String xGateExptime) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, currencyPair, account, actionMode, xGateExptime, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOrderAsync(String orderId, String currencyPair, String account, String actionMode, String xGateExptime, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, currencyPair, account, actionMode, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call amendOrderCall(String orderId, OrderPatch orderPatch, String currencyPair, String account, String xGateExptime, ApiCallback _callback) throws ApiException {
        OrderPatch localVarPostBody = orderPatch;
        String localVarPath = "/spot/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call amendOrderValidateBeforeCall(String orderId, OrderPatch orderPatch, String currencyPair, String account, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling amendOrder(Async)");
        }
        if (orderPatch == null) {
            throw new ApiException("Missing the required parameter 'orderPatch' when calling amendOrder(Async)");
        }
        Call localVarCall = this.amendOrderCall(orderId, orderPatch, currencyPair, account, xGateExptime, _callback);
        return localVarCall;
    }

    public Order amendOrder(String orderId, OrderPatch orderPatch, String currencyPair, String account, String xGateExptime) throws ApiException {
        ApiResponse<Order> localVarResp = this.amendOrderWithHttpInfo(orderId, orderPatch, currencyPair, account, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<Order> amendOrderWithHttpInfo(String orderId, OrderPatch orderPatch, String currencyPair, String account, String xGateExptime) throws ApiException {
        Call localVarCall = this.amendOrderValidateBeforeCall(orderId, orderPatch, currencyPair, account, xGateExptime, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call amendOrderAsync(String orderId, OrderPatch orderPatch, String currencyPair, String account, String xGateExptime, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.amendOrderValidateBeforeCall(orderId, orderPatch, currencyPair, account, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMyTradesCall(String currencyPair, Integer limit, Integer page, String orderId, String account, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/my_trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_id", orderId));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMyTradesValidateBeforeCall(String currencyPair, Integer limit, Integer page, String orderId, String account, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMyTradesCall(currencyPair, limit, page, orderId, account, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Trade>> listMyTradesWithHttpInfo(String currencyPair, Integer limit, Integer page, String orderId, String account, Long from, Long to) throws ApiException {
        Call localVarCall = this.listMyTradesValidateBeforeCall(currencyPair, limit, page, orderId, account, from, to, null);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMyTradesAsync(String currencyPair, Integer limit, Integer page, String orderId, String account, Long from, Long to, ApiCallback<List<Trade>> _callback) throws ApiException {
        Call localVarCall = this.listMyTradesValidateBeforeCall(currencyPair, limit, page, orderId, account, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMyTradesRequest listMyTrades() {
        return new APIlistMyTradesRequest();
    }

    public Call getSystemTimeCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSystemTimeValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getSystemTimeCall(_callback);
        return localVarCall;
    }

    public SystemTime getSystemTime() throws ApiException {
        ApiResponse<SystemTime> localVarResp = this.getSystemTimeWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<SystemTime> getSystemTimeWithHttpInfo() throws ApiException {
        Call localVarCall = this.getSystemTimeValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemTime>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSystemTimeAsync(ApiCallback<SystemTime> _callback) throws ApiException {
        Call localVarCall = this.getSystemTimeValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemTime>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call countdownCancelAllSpotCall(CountdownCancelAllSpotTask countdownCancelAllSpotTask, ApiCallback _callback) throws ApiException {
        CountdownCancelAllSpotTask localVarPostBody = countdownCancelAllSpotTask;
        String localVarPath = "/spot/countdown_cancel_all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call countdownCancelAllSpotValidateBeforeCall(CountdownCancelAllSpotTask countdownCancelAllSpotTask, ApiCallback _callback) throws ApiException {
        if (countdownCancelAllSpotTask == null) {
            throw new ApiException("Missing the required parameter 'countdownCancelAllSpotTask' when calling countdownCancelAllSpot(Async)");
        }
        Call localVarCall = this.countdownCancelAllSpotCall(countdownCancelAllSpotTask, _callback);
        return localVarCall;
    }

    public TriggerTime countdownCancelAllSpot(CountdownCancelAllSpotTask countdownCancelAllSpotTask) throws ApiException {
        ApiResponse<TriggerTime> localVarResp = this.countdownCancelAllSpotWithHttpInfo(countdownCancelAllSpotTask);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerTime> countdownCancelAllSpotWithHttpInfo(CountdownCancelAllSpotTask countdownCancelAllSpotTask) throws ApiException {
        Call localVarCall = this.countdownCancelAllSpotValidateBeforeCall(countdownCancelAllSpotTask, null);
        Type localVarReturnType = new TypeToken<TriggerTime>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call countdownCancelAllSpotAsync(CountdownCancelAllSpotTask countdownCancelAllSpotTask, ApiCallback<TriggerTime> _callback) throws ApiException {
        Call localVarCall = this.countdownCancelAllSpotValidateBeforeCall(countdownCancelAllSpotTask, _callback);
        Type localVarReturnType = new TypeToken<TriggerTime>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call amendBatchOrdersCall(List<BatchAmendItem> batchAmendItem, String xGateExptime, ApiCallback _callback) throws ApiException {
        List<BatchAmendItem> localVarPostBody = batchAmendItem;
        String localVarPath = "/spot/amend_batch_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xGateExptime != null) {
            localVarHeaderParams.put("x-gate-exptime", this.localVarApiClient.parameterToString(xGateExptime));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call amendBatchOrdersValidateBeforeCall(List<BatchAmendItem> batchAmendItem, String xGateExptime, ApiCallback _callback) throws ApiException {
        if (batchAmendItem == null) {
            throw new ApiException("Missing the required parameter 'batchAmendItem' when calling amendBatchOrders(Async)");
        }
        Call localVarCall = this.amendBatchOrdersCall(batchAmendItem, xGateExptime, _callback);
        return localVarCall;
    }

    public List<BatchOrder> amendBatchOrders(List<BatchAmendItem> batchAmendItem, String xGateExptime) throws ApiException {
        ApiResponse<List<BatchOrder>> localVarResp = this.amendBatchOrdersWithHttpInfo(batchAmendItem, xGateExptime);
        return localVarResp.getData();
    }

    public ApiResponse<List<BatchOrder>> amendBatchOrdersWithHttpInfo(List<BatchAmendItem> batchAmendItem, String xGateExptime) throws ApiException {
        Call localVarCall = this.amendBatchOrdersValidateBeforeCall(batchAmendItem, xGateExptime, null);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call amendBatchOrdersAsync(List<BatchAmendItem> batchAmendItem, String xGateExptime, ApiCallback<List<BatchOrder>> _callback) throws ApiException {
        Call localVarCall = this.amendBatchOrdersValidateBeforeCall(batchAmendItem, xGateExptime, _callback);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getSpotInsuranceHistoryCall(String business, String currency, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/insurance_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (business != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("business", business));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSpotInsuranceHistoryValidateBeforeCall(String business, String currency, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (business == null) {
            throw new ApiException("Missing the required parameter 'business' when calling getSpotInsuranceHistory(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getSpotInsuranceHistory(Async)");
        }
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getSpotInsuranceHistory(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling getSpotInsuranceHistory(Async)");
        }
        Call localVarCall = this.getSpotInsuranceHistoryCall(business, currency, from, to, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotInsuranceHistory>> getSpotInsuranceHistoryWithHttpInfo(String business, String currency, Long from, Long to, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.getSpotInsuranceHistoryValidateBeforeCall(business, currency, from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<SpotInsuranceHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSpotInsuranceHistoryAsync(String business, String currency, Long from, Long to, Integer page, Integer limit, ApiCallback<List<SpotInsuranceHistory>> _callback) throws ApiException {
        Call localVarCall = this.getSpotInsuranceHistoryValidateBeforeCall(business, currency, from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<SpotInsuranceHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetSpotInsuranceHistoryRequest getSpotInsuranceHistory(String business, String currency, Long from, Long to) {
        return new APIgetSpotInsuranceHistoryRequest(business, currency, from, to);
    }

    private Call listSpotPriceTriggeredOrdersCall(String status, String market, String account, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (market != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("market", market));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSpotPriceTriggeredOrdersValidateBeforeCall(String status, String market, String account, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listSpotPriceTriggeredOrders(Async)");
        }
        Call localVarCall = this.listSpotPriceTriggeredOrdersCall(status, market, account, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotPriceTriggeredOrder>> listSpotPriceTriggeredOrdersWithHttpInfo(String status, String market, String account, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listSpotPriceTriggeredOrdersValidateBeforeCall(status, market, account, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSpotPriceTriggeredOrdersAsync(String status, String market, String account, Integer limit, Integer offset, ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.listSpotPriceTriggeredOrdersValidateBeforeCall(status, market, account, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSpotPriceTriggeredOrdersRequest listSpotPriceTriggeredOrders(String status) {
        return new APIlistSpotPriceTriggeredOrdersRequest(status);
    }

    public Call createSpotPriceTriggeredOrderCall(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        SpotPriceTriggeredOrder localVarPostBody = spotPriceTriggeredOrder;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSpotPriceTriggeredOrderValidateBeforeCall(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        if (spotPriceTriggeredOrder == null) {
            throw new ApiException("Missing the required parameter 'spotPriceTriggeredOrder' when calling createSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.createSpotPriceTriggeredOrderCall(spotPriceTriggeredOrder, _callback);
        return localVarCall;
    }

    public TriggerOrderResponse createSpotPriceTriggeredOrder(SpotPriceTriggeredOrder spotPriceTriggeredOrder) throws ApiException {
        ApiResponse<TriggerOrderResponse> localVarResp = this.createSpotPriceTriggeredOrderWithHttpInfo(spotPriceTriggeredOrder);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerOrderResponse> createSpotPriceTriggeredOrderWithHttpInfo(SpotPriceTriggeredOrder spotPriceTriggeredOrder) throws ApiException {
        Call localVarCall = this.createSpotPriceTriggeredOrderValidateBeforeCall(spotPriceTriggeredOrder, null);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSpotPriceTriggeredOrderAsync(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback<TriggerOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.createSpotPriceTriggeredOrderValidateBeforeCall(spotPriceTriggeredOrder, _callback);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelSpotPriceTriggeredOrderListCall(String market, String account, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (market != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("market", market));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSpotPriceTriggeredOrderListValidateBeforeCall(String market, String account, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListCall(market, account, _callback);
        return localVarCall;
    }

    public List<SpotPriceTriggeredOrder> cancelSpotPriceTriggeredOrderList(String market, String account) throws ApiException {
        ApiResponse<List<SpotPriceTriggeredOrder>> localVarResp = this.cancelSpotPriceTriggeredOrderListWithHttpInfo(market, account);
        return localVarResp.getData();
    }

    public ApiResponse<List<SpotPriceTriggeredOrder>> cancelSpotPriceTriggeredOrderListWithHttpInfo(String market, String account) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListValidateBeforeCall(market, account, null);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelSpotPriceTriggeredOrderListAsync(String market, String account, ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListValidateBeforeCall(market, account, _callback);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSpotPriceTriggeredOrderCall(String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSpotPriceTriggeredOrderValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.getSpotPriceTriggeredOrderCall(orderId, _callback);
        return localVarCall;
    }

    public SpotPriceTriggeredOrder getSpotPriceTriggeredOrder(String orderId) throws ApiException {
        ApiResponse<SpotPriceTriggeredOrder> localVarResp = this.getSpotPriceTriggeredOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<SpotPriceTriggeredOrder> getSpotPriceTriggeredOrderWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.getSpotPriceTriggeredOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSpotPriceTriggeredOrderAsync(String orderId, ApiCallback<SpotPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.getSpotPriceTriggeredOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelSpotPriceTriggeredOrderCall(String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSpotPriceTriggeredOrderValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.cancelSpotPriceTriggeredOrderCall(orderId, _callback);
        return localVarCall;
    }

    public SpotPriceTriggeredOrder cancelSpotPriceTriggeredOrder(String orderId) throws ApiException {
        ApiResponse<SpotPriceTriggeredOrder> localVarResp = this.cancelSpotPriceTriggeredOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<SpotPriceTriggeredOrder> cancelSpotPriceTriggeredOrderWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelSpotPriceTriggeredOrderAsync(String orderId, ApiCallback<SpotPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSpotPriceTriggeredOrdersRequest {
        private final String status;
        private String market;
        private String account;
        private Integer limit;
        private Integer offset;

        private APIlistSpotPriceTriggeredOrdersRequest(String status) {
            this.status = status;
        }

        public APIlistSpotPriceTriggeredOrdersRequest market(String market) {
            this.market = market;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest account(String account) {
            this.account = account;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersCall(this.status, this.market, this.account, this.limit, this.offset, _callback);
        }

        public List<SpotPriceTriggeredOrder> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listSpotPriceTriggeredOrdersWithHttpInfo(this.status, this.market, this.account, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotPriceTriggeredOrder>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersWithHttpInfo(this.status, this.market, this.account, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersAsync(this.status, this.market, this.account, this.limit, this.offset, _callback);
        }
    }

    public class APIgetSpotInsuranceHistoryRequest {
        private final String business;
        private final String currency;
        private final Long from;
        private final Long to;
        private Integer page;
        private Integer limit;

        private APIgetSpotInsuranceHistoryRequest(String business, String currency, Long from, Long to) {
            this.business = business;
            this.currency = currency;
            this.from = from;
            this.to = to;
        }

        public APIgetSpotInsuranceHistoryRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIgetSpotInsuranceHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.getSpotInsuranceHistoryCall(this.business, this.currency, this.from, this.to, this.page, this.limit, _callback);
        }

        public List<SpotInsuranceHistory> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.getSpotInsuranceHistoryWithHttpInfo(this.business, this.currency, this.from, this.to, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotInsuranceHistory>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.getSpotInsuranceHistoryWithHttpInfo(this.business, this.currency, this.from, this.to, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<SpotInsuranceHistory>> _callback) throws ApiException {
            return SpotApi.this.getSpotInsuranceHistoryAsync(this.business, this.currency, this.from, this.to, this.page, this.limit, _callback);
        }
    }

    public class APIlistMyTradesRequest {
        private String currencyPair;
        private Integer limit;
        private Integer page;
        private String orderId;
        private String account;
        private Long from;
        private Long to;

        private APIlistMyTradesRequest() {
        }

        public APIlistMyTradesRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistMyTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMyTradesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMyTradesRequest orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public APIlistMyTradesRequest account(String account) {
            this.account = account;
            return this;
        }

        public APIlistMyTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMyTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listMyTradesCall(this.currencyPair, this.limit, this.page, this.orderId, this.account, this.from, this.to, _callback);
        }

        public List<Trade> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listMyTradesWithHttpInfo(this.currencyPair, this.limit, this.page, this.orderId, this.account, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Trade>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listMyTradesWithHttpInfo(this.currencyPair, this.limit, this.page, this.orderId, this.account, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<Trade>> _callback) throws ApiException {
            return SpotApi.this.listMyTradesAsync(this.currencyPair, this.limit, this.page, this.orderId, this.account, this.from, this.to, _callback);
        }
    }

    public class APIlistOrdersRequest {
        private final String currencyPair;
        private final String status;
        private Integer page;
        private Integer limit;
        private String account;
        private Long from;
        private Long to;
        private String side;

        private APIlistOrdersRequest(String currencyPair, String status) {
            this.currencyPair = currencyPair;
            this.status = status;
        }

        public APIlistOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOrdersRequest account(String account) {
            this.account = account;
            return this;
        }

        public APIlistOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistOrdersRequest side(String side) {
            this.side = side;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listOrdersCall(this.currencyPair, this.status, this.page, this.limit, this.account, this.from, this.to, this.side, _callback);
        }

        public List<Order> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listOrdersWithHttpInfo(this.currencyPair, this.status, this.page, this.limit, this.account, this.from, this.to, this.side);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Order>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listOrdersWithHttpInfo(this.currencyPair, this.status, this.page, this.limit, this.account, this.from, this.to, this.side);
        }

        public Call executeAsync(ApiCallback<List<Order>> _callback) throws ApiException {
            return SpotApi.this.listOrdersAsync(this.currencyPair, this.status, this.page, this.limit, this.account, this.from, this.to, this.side, _callback);
        }
    }

    public class APIlistAllOpenOrdersRequest {
        private Integer page;
        private Integer limit;
        private String account;

        private APIlistAllOpenOrdersRequest() {
        }

        public APIlistAllOpenOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistAllOpenOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistAllOpenOrdersRequest account(String account) {
            this.account = account;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listAllOpenOrdersCall(this.page, this.limit, this.account, _callback);
        }

        public List<OpenOrders> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listAllOpenOrdersWithHttpInfo(this.page, this.limit, this.account);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OpenOrders>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listAllOpenOrdersWithHttpInfo(this.page, this.limit, this.account);
        }

        public Call executeAsync(ApiCallback<List<OpenOrders>> _callback) throws ApiException {
            return SpotApi.this.listAllOpenOrdersAsync(this.page, this.limit, this.account, _callback);
        }
    }

    public class APIlistSpotAccountBookRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;
        private String type;
        private String code;

        private APIlistSpotAccountBookRequest() {
        }

        public APIlistSpotAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistSpotAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistSpotAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistSpotAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistSpotAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSpotAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistSpotAccountBookRequest code(String code) {
            this.code = code;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listSpotAccountBookCall(this.currency, this.from, this.to, this.page, this.limit, this.type, this.code, _callback);
        }

        public List<SpotAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listSpotAccountBookWithHttpInfo(this.currency, this.from, this.to, this.page, this.limit, this.type, this.code);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotAccountBook>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listSpotAccountBookWithHttpInfo(this.currency, this.from, this.to, this.page, this.limit, this.type, this.code);
        }

        public Call executeAsync(ApiCallback<List<SpotAccountBook>> _callback) throws ApiException {
            return SpotApi.this.listSpotAccountBookAsync(this.currency, this.from, this.to, this.page, this.limit, this.type, this.code, _callback);
        }
    }

    public class APIlistSpotAccountsRequest {
        private String currency;

        private APIlistSpotAccountsRequest() {
        }

        public APIlistSpotAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listSpotAccountsCall(this.currency, _callback);
        }

        public List<SpotAccount> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listSpotAccountsWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotAccount>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listSpotAccountsWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<SpotAccount>> _callback) throws ApiException {
            return SpotApi.this.listSpotAccountsAsync(this.currency, _callback);
        }
    }

    public class APIgetFeeRequest {
        private String currencyPair;

        private APIgetFeeRequest() {
        }

        public APIgetFeeRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.getFeeCall(this.currencyPair, _callback);
        }

        @Deprecated
        public SpotFee execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.getFeeWithHttpInfo(this.currencyPair);
            return (SpotFee)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<SpotFee> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.getFeeWithHttpInfo(this.currencyPair);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<SpotFee> _callback) throws ApiException {
            return SpotApi.this.getFeeAsync(this.currencyPair, _callback);
        }
    }

    public class APIlistCandlesticksRequest {
        private final String currencyPair;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistCandlesticksRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listCandlesticksCall(this.currencyPair, this.limit, this.from, this.to, this.interval, _callback);
        }

        public List<List<String>> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listCandlesticksWithHttpInfo(this.currencyPair, this.limit, this.from, this.to, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<List<String>>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listCandlesticksWithHttpInfo(this.currencyPair, this.limit, this.from, this.to, this.interval);
        }

        public Call executeAsync(ApiCallback<List<List<String>>> _callback) throws ApiException {
            return SpotApi.this.listCandlesticksAsync(this.currencyPair, this.limit, this.from, this.to, this.interval, _callback);
        }
    }

    public class APIlistTradesRequest {
        private final String currencyPair;
        private Integer limit;
        private String lastId;
        private Boolean reverse;
        private Long from;
        private Long to;
        private Integer page;

        private APIlistTradesRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistTradesRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public APIlistTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistTradesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listTradesCall(this.currencyPair, this.limit, this.lastId, this.reverse, this.from, this.to, this.page, _callback);
        }

        public List<Trade> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listTradesWithHttpInfo(this.currencyPair, this.limit, this.lastId, this.reverse, this.from, this.to, this.page);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Trade>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listTradesWithHttpInfo(this.currencyPair, this.limit, this.lastId, this.reverse, this.from, this.to, this.page);
        }

        public Call executeAsync(ApiCallback<List<Trade>> _callback) throws ApiException {
            return SpotApi.this.listTradesAsync(this.currencyPair, this.limit, this.lastId, this.reverse, this.from, this.to, this.page, _callback);
        }
    }

    public class APIlistOrderBookRequest {
        private final String currencyPair;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistOrderBookRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listOrderBookCall(this.currencyPair, this.interval, this.limit, this.withId, _callback);
        }

        public OrderBook execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listOrderBookWithHttpInfo(this.currencyPair, this.interval, this.limit, this.withId);
            return (OrderBook)localVarResp.getData();
        }

        public ApiResponse<OrderBook> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listOrderBookWithHttpInfo(this.currencyPair, this.interval, this.limit, this.withId);
        }

        public Call executeAsync(ApiCallback<OrderBook> _callback) throws ApiException {
            return SpotApi.this.listOrderBookAsync(this.currencyPair, this.interval, this.limit, this.withId, _callback);
        }
    }

    public class APIlistTickersRequest {
        private String currencyPair;
        private String timezone;

        private APIlistTickersRequest() {
        }

        public APIlistTickersRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistTickersRequest timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listTickersCall(this.currencyPair, this.timezone, _callback);
        }

        public List<Ticker> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listTickersWithHttpInfo(this.currencyPair, this.timezone);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Ticker>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listTickersWithHttpInfo(this.currencyPair, this.timezone);
        }

        public Call executeAsync(ApiCallback<List<Ticker>> _callback) throws ApiException {
            return SpotApi.this.listTickersAsync(this.currencyPair, this.timezone, _callback);
        }
    }
}

