/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.AgencyCommissionHistory;
import io.gate.gateapi.models.AgencyTransactionHistory;
import io.gate.gateapi.models.BrokerCommission;
import io.gate.gateapi.models.BrokerTransaction;
import io.gate.gateapi.models.PartnerCommissionHistory;
import io.gate.gateapi.models.PartnerSubList;
import io.gate.gateapi.models.PartnerTransactionHistory;
import io.gate.gateapi.models.RebateUserInfo;
import io.gate.gateapi.models.UserSubRelation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RebateApi {
    private ApiClient localVarApiClient;

    public RebateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RebateApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call agencyTransactionHistoryCall(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/agency/transaction_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call agencyTransactionHistoryValidateBeforeCall(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryCall(currencyPair, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<AgencyTransactionHistory>> agencyTransactionHistoryWithHttpInfo(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call agencyTransactionHistoryAsync(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
        Call localVarCall = this.agencyTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyTransactionHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIagencyTransactionHistoryRequest agencyTransactionHistory() {
        return new APIagencyTransactionHistoryRequest();
    }

    private Call agencyCommissionsHistoryCall(String currency, Integer commissionType, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/agency/commission_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (commissionType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("commission_type", commissionType));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call agencyCommissionsHistoryValidateBeforeCall(String currency, Integer commissionType, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryCall(currency, commissionType, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<AgencyCommissionHistory>> agencyCommissionsHistoryWithHttpInfo(String currency, Integer commissionType, Long userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryValidateBeforeCall(currency, commissionType, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call agencyCommissionsHistoryAsync(String currency, Integer commissionType, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
        Call localVarCall = this.agencyCommissionsHistoryValidateBeforeCall(currency, commissionType, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<AgencyCommissionHistory>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIagencyCommissionsHistoryRequest agencyCommissionsHistory() {
        return new APIagencyCommissionsHistoryRequest();
    }

    private Call partnerTransactionHistoryCall(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/partner/transaction_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call partnerTransactionHistoryValidateBeforeCall(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.partnerTransactionHistoryCall(currencyPair, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<PartnerTransactionHistory> partnerTransactionHistoryWithHttpInfo(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.partnerTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<PartnerTransactionHistory>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call partnerTransactionHistoryAsync(String currencyPair, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<PartnerTransactionHistory> _callback) throws ApiException {
        Call localVarCall = this.partnerTransactionHistoryValidateBeforeCall(currencyPair, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<PartnerTransactionHistory>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpartnerTransactionHistoryRequest partnerTransactionHistory() {
        return new APIpartnerTransactionHistoryRequest();
    }

    private Call partnerCommissionsHistoryCall(String currency, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/partner/commission_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call partnerCommissionsHistoryValidateBeforeCall(String currency, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.partnerCommissionsHistoryCall(currency, userId, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<PartnerCommissionHistory> partnerCommissionsHistoryWithHttpInfo(String currency, Long userId, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.partnerCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<PartnerCommissionHistory>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call partnerCommissionsHistoryAsync(String currency, Long userId, Long from, Long to, Integer limit, Integer offset, ApiCallback<PartnerCommissionHistory> _callback) throws ApiException {
        Call localVarCall = this.partnerCommissionsHistoryValidateBeforeCall(currency, userId, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<PartnerCommissionHistory>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpartnerCommissionsHistoryRequest partnerCommissionsHistory() {
        return new APIpartnerCommissionsHistoryRequest();
    }

    private Call partnerSubListCall(Long userId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/partner/sub_list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call partnerSubListValidateBeforeCall(Long userId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.partnerSubListCall(userId, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<PartnerSubList> partnerSubListWithHttpInfo(Long userId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.partnerSubListValidateBeforeCall(userId, limit, offset, null);
        Type localVarReturnType = new TypeToken<PartnerSubList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call partnerSubListAsync(Long userId, Integer limit, Integer offset, ApiCallback<PartnerSubList> _callback) throws ApiException {
        Call localVarCall = this.partnerSubListValidateBeforeCall(userId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<PartnerSubList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpartnerSubListRequest partnerSubList() {
        return new APIpartnerSubListRequest();
    }

    private Call rebateBrokerCommissionHistoryCall(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/broker/commission_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rebateBrokerCommissionHistoryValidateBeforeCall(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.rebateBrokerCommissionHistoryCall(limit, offset, userId, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<BrokerCommission>> rebateBrokerCommissionHistoryWithHttpInfo(Integer limit, Integer offset, Long userId, Long from, Long to) throws ApiException {
        Call localVarCall = this.rebateBrokerCommissionHistoryValidateBeforeCall(limit, offset, userId, from, to, null);
        Type localVarReturnType = new TypeToken<List<BrokerCommission>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call rebateBrokerCommissionHistoryAsync(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback<List<BrokerCommission>> _callback) throws ApiException {
        Call localVarCall = this.rebateBrokerCommissionHistoryValidateBeforeCall(limit, offset, userId, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<BrokerCommission>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIrebateBrokerCommissionHistoryRequest rebateBrokerCommissionHistory() {
        return new APIrebateBrokerCommissionHistoryRequest();
    }

    private Call rebateBrokerTransactionHistoryCall(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/broker/transaction_history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rebateBrokerTransactionHistoryValidateBeforeCall(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.rebateBrokerTransactionHistoryCall(limit, offset, userId, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<BrokerTransaction>> rebateBrokerTransactionHistoryWithHttpInfo(Integer limit, Integer offset, Long userId, Long from, Long to) throws ApiException {
        Call localVarCall = this.rebateBrokerTransactionHistoryValidateBeforeCall(limit, offset, userId, from, to, null);
        Type localVarReturnType = new TypeToken<List<BrokerTransaction>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call rebateBrokerTransactionHistoryAsync(Integer limit, Integer offset, Long userId, Long from, Long to, ApiCallback<List<BrokerTransaction>> _callback) throws ApiException {
        Call localVarCall = this.rebateBrokerTransactionHistoryValidateBeforeCall(limit, offset, userId, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<BrokerTransaction>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIrebateBrokerTransactionHistoryRequest rebateBrokerTransactionHistory() {
        return new APIrebateBrokerTransactionHistoryRequest();
    }

    public Call rebateUserInfoCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/user/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rebateUserInfoValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.rebateUserInfoCall(_callback);
        return localVarCall;
    }

    public List<RebateUserInfo> rebateUserInfo() throws ApiException {
        ApiResponse<List<RebateUserInfo>> localVarResp = this.rebateUserInfoWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<RebateUserInfo>> rebateUserInfoWithHttpInfo() throws ApiException {
        Call localVarCall = this.rebateUserInfoValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<RebateUserInfo>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rebateUserInfoAsync(ApiCallback<List<RebateUserInfo>> _callback) throws ApiException {
        Call localVarCall = this.rebateUserInfoValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<RebateUserInfo>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call userSubRelationCall(String userIdList, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rebate/user/sub_relation";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userIdList != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id_list", userIdList));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call userSubRelationValidateBeforeCall(String userIdList, ApiCallback _callback) throws ApiException {
        if (userIdList == null) {
            throw new ApiException("Missing the required parameter 'userIdList' when calling userSubRelation(Async)");
        }
        Call localVarCall = this.userSubRelationCall(userIdList, _callback);
        return localVarCall;
    }

    public UserSubRelation userSubRelation(String userIdList) throws ApiException {
        ApiResponse<UserSubRelation> localVarResp = this.userSubRelationWithHttpInfo(userIdList);
        return localVarResp.getData();
    }

    public ApiResponse<UserSubRelation> userSubRelationWithHttpInfo(String userIdList) throws ApiException {
        Call localVarCall = this.userSubRelationValidateBeforeCall(userIdList, null);
        Type localVarReturnType = new TypeToken<UserSubRelation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call userSubRelationAsync(String userIdList, ApiCallback<UserSubRelation> _callback) throws ApiException {
        Call localVarCall = this.userSubRelationValidateBeforeCall(userIdList, _callback);
        Type localVarReturnType = new TypeToken<UserSubRelation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIrebateBrokerTransactionHistoryRequest {
        private Integer limit;
        private Integer offset;
        private Long userId;
        private Long from;
        private Long to;

        private APIrebateBrokerTransactionHistoryRequest() {
        }

        public APIrebateBrokerTransactionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIrebateBrokerTransactionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIrebateBrokerTransactionHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIrebateBrokerTransactionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIrebateBrokerTransactionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.rebateBrokerTransactionHistoryCall(this.limit, this.offset, this.userId, this.from, this.to, _callback);
        }

        public List<BrokerTransaction> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.rebateBrokerTransactionHistoryWithHttpInfo(this.limit, this.offset, this.userId, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<BrokerTransaction>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.rebateBrokerTransactionHistoryWithHttpInfo(this.limit, this.offset, this.userId, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<BrokerTransaction>> _callback) throws ApiException {
            return RebateApi.this.rebateBrokerTransactionHistoryAsync(this.limit, this.offset, this.userId, this.from, this.to, _callback);
        }
    }

    public class APIrebateBrokerCommissionHistoryRequest {
        private Integer limit;
        private Integer offset;
        private Long userId;
        private Long from;
        private Long to;

        private APIrebateBrokerCommissionHistoryRequest() {
        }

        public APIrebateBrokerCommissionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIrebateBrokerCommissionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIrebateBrokerCommissionHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIrebateBrokerCommissionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIrebateBrokerCommissionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.rebateBrokerCommissionHistoryCall(this.limit, this.offset, this.userId, this.from, this.to, _callback);
        }

        public List<BrokerCommission> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.rebateBrokerCommissionHistoryWithHttpInfo(this.limit, this.offset, this.userId, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<BrokerCommission>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.rebateBrokerCommissionHistoryWithHttpInfo(this.limit, this.offset, this.userId, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<BrokerCommission>> _callback) throws ApiException {
            return RebateApi.this.rebateBrokerCommissionHistoryAsync(this.limit, this.offset, this.userId, this.from, this.to, _callback);
        }
    }

    public class APIpartnerSubListRequest {
        private Long userId;
        private Integer limit;
        private Integer offset;

        private APIpartnerSubListRequest() {
        }

        public APIpartnerSubListRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIpartnerSubListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIpartnerSubListRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.partnerSubListCall(this.userId, this.limit, this.offset, _callback);
        }

        public PartnerSubList execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.partnerSubListWithHttpInfo(this.userId, this.limit, this.offset);
            return (PartnerSubList)localVarResp.getData();
        }

        public ApiResponse<PartnerSubList> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.partnerSubListWithHttpInfo(this.userId, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<PartnerSubList> _callback) throws ApiException {
            return RebateApi.this.partnerSubListAsync(this.userId, this.limit, this.offset, _callback);
        }
    }

    public class APIpartnerCommissionsHistoryRequest {
        private String currency;
        private Long userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIpartnerCommissionsHistoryRequest() {
        }

        public APIpartnerCommissionsHistoryRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIpartnerCommissionsHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIpartnerCommissionsHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIpartnerCommissionsHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIpartnerCommissionsHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIpartnerCommissionsHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.partnerCommissionsHistoryCall(this.currency, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public PartnerCommissionHistory execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.partnerCommissionsHistoryWithHttpInfo(this.currency, this.userId, this.from, this.to, this.limit, this.offset);
            return (PartnerCommissionHistory)localVarResp.getData();
        }

        public ApiResponse<PartnerCommissionHistory> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.partnerCommissionsHistoryWithHttpInfo(this.currency, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<PartnerCommissionHistory> _callback) throws ApiException {
            return RebateApi.this.partnerCommissionsHistoryAsync(this.currency, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIpartnerTransactionHistoryRequest {
        private String currencyPair;
        private Long userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIpartnerTransactionHistoryRequest() {
        }

        public APIpartnerTransactionHistoryRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIpartnerTransactionHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIpartnerTransactionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIpartnerTransactionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIpartnerTransactionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIpartnerTransactionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.partnerTransactionHistoryCall(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public PartnerTransactionHistory execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.partnerTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
            return (PartnerTransactionHistory)localVarResp.getData();
        }

        public ApiResponse<PartnerTransactionHistory> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.partnerTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<PartnerTransactionHistory> _callback) throws ApiException {
            return RebateApi.this.partnerTransactionHistoryAsync(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIagencyCommissionsHistoryRequest {
        private String currency;
        private Integer commissionType;
        private Long userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyCommissionsHistoryRequest() {
        }

        public APIagencyCommissionsHistoryRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIagencyCommissionsHistoryRequest commissionType(Integer commissionType) {
            this.commissionType = commissionType;
            return this;
        }

        public APIagencyCommissionsHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIagencyCommissionsHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIagencyCommissionsHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIagencyCommissionsHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIagencyCommissionsHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryCall(this.currency, this.commissionType, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<AgencyCommissionHistory> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.agencyCommissionsHistoryWithHttpInfo(this.currency, this.commissionType, this.userId, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<AgencyCommissionHistory>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryWithHttpInfo(this.currency, this.commissionType, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<AgencyCommissionHistory>> _callback) throws ApiException {
            return RebateApi.this.agencyCommissionsHistoryAsync(this.currency, this.commissionType, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIagencyTransactionHistoryRequest {
        private String currencyPair;
        private Long userId;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIagencyTransactionHistoryRequest() {
        }

        public APIagencyTransactionHistoryRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIagencyTransactionHistoryRequest userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public APIagencyTransactionHistoryRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIagencyTransactionHistoryRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIagencyTransactionHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIagencyTransactionHistoryRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RebateApi.this.agencyTransactionHistoryCall(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<AgencyTransactionHistory> execute() throws ApiException {
            ApiResponse localVarResp = RebateApi.this.agencyTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<AgencyTransactionHistory>> executeWithHttpInfo() throws ApiException {
            return RebateApi.this.agencyTransactionHistoryWithHttpInfo(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<AgencyTransactionHistory>> _callback) throws ApiException {
            return RebateApi.this.agencyTransactionHistoryAsync(this.currencyPair, this.userId, this.from, this.to, this.limit, this.offset, _callback);
        }
    }
}

