/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.CountdownCancelAllOptionsTask;
import io.gate.gateapi.models.FuturesCandlestick;
import io.gate.gateapi.models.FuturesOrderBook;
import io.gate.gateapi.models.FuturesTrade;
import io.gate.gateapi.models.OptionsAccount;
import io.gate.gateapi.models.OptionsAccountBook;
import io.gate.gateapi.models.OptionsCandlestick;
import io.gate.gateapi.models.OptionsContract;
import io.gate.gateapi.models.OptionsMMP;
import io.gate.gateapi.models.OptionsMMPReset;
import io.gate.gateapi.models.OptionsMySettlements;
import io.gate.gateapi.models.OptionsMyTrade;
import io.gate.gateapi.models.OptionsOrder;
import io.gate.gateapi.models.OptionsPosition;
import io.gate.gateapi.models.OptionsPositionClose;
import io.gate.gateapi.models.OptionsSettlement;
import io.gate.gateapi.models.OptionsTicker;
import io.gate.gateapi.models.OptionsUnderlying;
import io.gate.gateapi.models.OptionsUnderlyingTicker;
import io.gate.gateapi.models.TriggerTime;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class OptionsApi {
    private ApiClient localVarApiClient;

    public OptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listOptionsUnderlyingsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/underlyings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsUnderlyingsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingsCall(_callback);
        return localVarCall;
    }

    public List<OptionsUnderlying> listOptionsUnderlyings() throws ApiException {
        ApiResponse<List<OptionsUnderlying>> localVarResp = this.listOptionsUnderlyingsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<OptionsUnderlying>> listOptionsUnderlyingsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<OptionsUnderlying>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOptionsUnderlyingsAsync(ApiCallback<List<OptionsUnderlying>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<OptionsUnderlying>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listOptionsExpirationsCall(String underlying, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/expirations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsExpirationsValidateBeforeCall(String underlying, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsExpirations(Async)");
        }
        Call localVarCall = this.listOptionsExpirationsCall(underlying, _callback);
        return localVarCall;
    }

    public List<Long> listOptionsExpirations(String underlying) throws ApiException {
        ApiResponse<List<Long>> localVarResp = this.listOptionsExpirationsWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    public ApiResponse<List<Long>> listOptionsExpirationsWithHttpInfo(String underlying) throws ApiException {
        Call localVarCall = this.listOptionsExpirationsValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOptionsExpirationsAsync(String underlying, ApiCallback<List<Long>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsExpirationsValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOptionsContractsCall(String underlying, Long expiration, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/contracts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (expiration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiration", expiration));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsContractsValidateBeforeCall(String underlying, Long expiration, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsContracts(Async)");
        }
        Call localVarCall = this.listOptionsContractsCall(underlying, expiration, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsContract>> listOptionsContractsWithHttpInfo(String underlying, Long expiration) throws ApiException {
        Call localVarCall = this.listOptionsContractsValidateBeforeCall(underlying, expiration, null);
        Type localVarReturnType = new TypeToken<List<OptionsContract>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsContractsAsync(String underlying, Long expiration, ApiCallback<List<OptionsContract>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsContractsValidateBeforeCall(underlying, expiration, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsContract>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsContractsRequest listOptionsContracts(String underlying) {
        return new APIlistOptionsContractsRequest(underlying);
    }

    public Call getOptionsContractCall(String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/contracts/{contract}".replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsContractValidateBeforeCall(String contract, ApiCallback _callback) throws ApiException {
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsContract(Async)");
        }
        Call localVarCall = this.getOptionsContractCall(contract, _callback);
        return localVarCall;
    }

    public OptionsContract getOptionsContract(String contract) throws ApiException {
        ApiResponse<OptionsContract> localVarResp = this.getOptionsContractWithHttpInfo(contract);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsContract> getOptionsContractWithHttpInfo(String contract) throws ApiException {
        Call localVarCall = this.getOptionsContractValidateBeforeCall(contract, null);
        Type localVarReturnType = new TypeToken<OptionsContract>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOptionsContractAsync(String contract, ApiCallback<OptionsContract> _callback) throws ApiException {
        Call localVarCall = this.getOptionsContractValidateBeforeCall(contract, _callback);
        Type localVarReturnType = new TypeToken<OptionsContract>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOptionsSettlementsCall(String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/settlements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsSettlementsValidateBeforeCall(String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsSettlements(Async)");
        }
        Call localVarCall = this.listOptionsSettlementsCall(underlying, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsSettlement>> listOptionsSettlementsWithHttpInfo(String underlying, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listOptionsSettlementsValidateBeforeCall(underlying, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsSettlement>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsSettlementsAsync(String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<OptionsSettlement>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsSettlementsValidateBeforeCall(underlying, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsSettlement>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsSettlementsRequest listOptionsSettlements(String underlying) {
        return new APIlistOptionsSettlementsRequest(underlying);
    }

    public Call getOptionsSettlementCall(String contract, String underlying, Long at, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/settlements/{contract}".replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (at != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("at", at));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsSettlementValidateBeforeCall(String contract, String underlying, Long at, ApiCallback _callback) throws ApiException {
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsSettlement(Async)");
        }
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling getOptionsSettlement(Async)");
        }
        if (at == null) {
            throw new ApiException("Missing the required parameter 'at' when calling getOptionsSettlement(Async)");
        }
        Call localVarCall = this.getOptionsSettlementCall(contract, underlying, at, _callback);
        return localVarCall;
    }

    public OptionsSettlement getOptionsSettlement(String contract, String underlying, Long at) throws ApiException {
        ApiResponse<OptionsSettlement> localVarResp = this.getOptionsSettlementWithHttpInfo(contract, underlying, at);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsSettlement> getOptionsSettlementWithHttpInfo(String contract, String underlying, Long at) throws ApiException {
        Call localVarCall = this.getOptionsSettlementValidateBeforeCall(contract, underlying, at, null);
        Type localVarReturnType = new TypeToken<OptionsSettlement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOptionsSettlementAsync(String contract, String underlying, Long at, ApiCallback<OptionsSettlement> _callback) throws ApiException {
        Call localVarCall = this.getOptionsSettlementValidateBeforeCall(contract, underlying, at, _callback);
        Type localVarReturnType = new TypeToken<OptionsSettlement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMyOptionsSettlementsCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/my_settlements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMyOptionsSettlementsValidateBeforeCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listMyOptionsSettlements(Async)");
        }
        Call localVarCall = this.listMyOptionsSettlementsCall(underlying, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsMySettlements>> listMyOptionsSettlementsWithHttpInfo(String underlying, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listMyOptionsSettlementsValidateBeforeCall(underlying, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsMySettlements>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMyOptionsSettlementsAsync(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<OptionsMySettlements>> _callback) throws ApiException {
        Call localVarCall = this.listMyOptionsSettlementsValidateBeforeCall(underlying, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsMySettlements>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMyOptionsSettlementsRequest listMyOptionsSettlements(String underlying) {
        return new APIlistMyOptionsSettlementsRequest(underlying);
    }

    private Call listOptionsOrderBookCall(String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/order_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (withId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("with_id", withId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsOrderBookValidateBeforeCall(String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listOptionsOrderBook(Async)");
        }
        Call localVarCall = this.listOptionsOrderBookCall(contract, interval, limit, withId, _callback);
        return localVarCall;
    }

    private ApiResponse<FuturesOrderBook> listOptionsOrderBookWithHttpInfo(String contract, String interval, Integer limit, Boolean withId) throws ApiException {
        Call localVarCall = this.listOptionsOrderBookValidateBeforeCall(contract, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsOrderBookAsync(String contract, String interval, Integer limit, Boolean withId, ApiCallback<FuturesOrderBook> _callback) throws ApiException {
        Call localVarCall = this.listOptionsOrderBookValidateBeforeCall(contract, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsOrderBookRequest listOptionsOrderBook(String contract) {
        return new APIlistOptionsOrderBookRequest(contract);
    }

    public Call listOptionsTickersCall(String underlying, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/tickers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsTickersValidateBeforeCall(String underlying, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsTickers(Async)");
        }
        Call localVarCall = this.listOptionsTickersCall(underlying, _callback);
        return localVarCall;
    }

    public List<OptionsTicker> listOptionsTickers(String underlying) throws ApiException {
        ApiResponse<List<OptionsTicker>> localVarResp = this.listOptionsTickersWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    public ApiResponse<List<OptionsTicker>> listOptionsTickersWithHttpInfo(String underlying) throws ApiException {
        Call localVarCall = this.listOptionsTickersValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<OptionsTicker>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOptionsTickersAsync(String underlying, ApiCallback<List<OptionsTicker>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsTickersValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsTicker>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listOptionsUnderlyingTickersCall(String underlying, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/underlying/tickers/{underlying}".replaceAll("\\{underlying\\}", this.localVarApiClient.escapeString(underlying));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsUnderlyingTickersValidateBeforeCall(String underlying, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsUnderlyingTickers(Async)");
        }
        Call localVarCall = this.listOptionsUnderlyingTickersCall(underlying, _callback);
        return localVarCall;
    }

    public OptionsUnderlyingTicker listOptionsUnderlyingTickers(String underlying) throws ApiException {
        ApiResponse<OptionsUnderlyingTicker> localVarResp = this.listOptionsUnderlyingTickersWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsUnderlyingTicker> listOptionsUnderlyingTickersWithHttpInfo(String underlying) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingTickersValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<OptionsUnderlyingTicker>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOptionsUnderlyingTickersAsync(String underlying, ApiCallback<OptionsUnderlyingTicker> _callback) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingTickersValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<OptionsUnderlyingTicker>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOptionsCandlesticksCall(String contract, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/candlesticks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsCandlesticksValidateBeforeCall(String contract, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listOptionsCandlesticks(Async)");
        }
        Call localVarCall = this.listOptionsCandlesticksCall(contract, limit, from, to, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsCandlestick>> listOptionsCandlesticksWithHttpInfo(String contract, Integer limit, Long from, Long to, String interval) throws ApiException {
        Call localVarCall = this.listOptionsCandlesticksValidateBeforeCall(contract, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<OptionsCandlestick>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsCandlesticksAsync(String contract, Integer limit, Long from, Long to, String interval, ApiCallback<List<OptionsCandlestick>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsCandlesticksValidateBeforeCall(contract, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsCandlestick>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsCandlesticksRequest listOptionsCandlesticks(String contract) {
        return new APIlistOptionsCandlesticksRequest(contract);
    }

    private Call listOptionsUnderlyingCandlesticksCall(String underlying, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/underlying/candlesticks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsUnderlyingCandlesticksValidateBeforeCall(String underlying, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsUnderlyingCandlesticks(Async)");
        }
        Call localVarCall = this.listOptionsUnderlyingCandlesticksCall(underlying, limit, from, to, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesCandlestick>> listOptionsUnderlyingCandlesticksWithHttpInfo(String underlying, Integer limit, Long from, Long to, String interval) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingCandlesticksValidateBeforeCall(underlying, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsUnderlyingCandlesticksAsync(String underlying, Integer limit, Long from, Long to, String interval, ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsUnderlyingCandlesticksValidateBeforeCall(underlying, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsUnderlyingCandlesticksRequest listOptionsUnderlyingCandlesticks(String underlying) {
        return new APIlistOptionsUnderlyingCandlesticksRequest(underlying);
    }

    private Call listOptionsTradesCall(String contract, String type, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsTradesValidateBeforeCall(String contract, String type, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOptionsTradesCall(contract, type, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesTrade>> listOptionsTradesWithHttpInfo(String contract, String type, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listOptionsTradesValidateBeforeCall(contract, type, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsTradesAsync(String contract, String type, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsTradesValidateBeforeCall(contract, type, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsTradesRequest listOptionsTrades() {
        return new APIlistOptionsTradesRequest();
    }

    public Call listOptionsAccountCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsAccountValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOptionsAccountCall(_callback);
        return localVarCall;
    }

    public OptionsAccount listOptionsAccount() throws ApiException {
        ApiResponse<OptionsAccount> localVarResp = this.listOptionsAccountWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<OptionsAccount> listOptionsAccountWithHttpInfo() throws ApiException {
        Call localVarCall = this.listOptionsAccountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<OptionsAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOptionsAccountAsync(ApiCallback<OptionsAccount> _callback) throws ApiException {
        Call localVarCall = this.listOptionsAccountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<OptionsAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOptionsAccountBookCall(Integer limit, Integer offset, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/account_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsAccountBookValidateBeforeCall(Integer limit, Integer offset, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOptionsAccountBookCall(limit, offset, from, to, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsAccountBook>> listOptionsAccountBookWithHttpInfo(Integer limit, Integer offset, Long from, Long to, String type) throws ApiException {
        Call localVarCall = this.listOptionsAccountBookValidateBeforeCall(limit, offset, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<OptionsAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsAccountBookAsync(Integer limit, Integer offset, Long from, Long to, String type, ApiCallback<List<OptionsAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsAccountBookValidateBeforeCall(limit, offset, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsAccountBookRequest listOptionsAccountBook() {
        return new APIlistOptionsAccountBookRequest();
    }

    private Call listOptionsPositionsCall(String underlying, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsPositionsValidateBeforeCall(String underlying, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOptionsPositionsCall(underlying, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsPosition>> listOptionsPositionsWithHttpInfo(String underlying) throws ApiException {
        Call localVarCall = this.listOptionsPositionsValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<OptionsPosition>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsPositionsAsync(String underlying, ApiCallback<List<OptionsPosition>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsPositionsValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsPosition>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsPositionsRequest listOptionsPositions() {
        return new APIlistOptionsPositionsRequest();
    }

    public Call getOptionsPositionCall(String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/positions/{contract}".replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsPositionValidateBeforeCall(String contract, ApiCallback _callback) throws ApiException {
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsPosition(Async)");
        }
        Call localVarCall = this.getOptionsPositionCall(contract, _callback);
        return localVarCall;
    }

    public OptionsPosition getOptionsPosition(String contract) throws ApiException {
        ApiResponse<OptionsPosition> localVarResp = this.getOptionsPositionWithHttpInfo(contract);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsPosition> getOptionsPositionWithHttpInfo(String contract) throws ApiException {
        Call localVarCall = this.getOptionsPositionValidateBeforeCall(contract, null);
        Type localVarReturnType = new TypeToken<OptionsPosition>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOptionsPositionAsync(String contract, ApiCallback<OptionsPosition> _callback) throws ApiException {
        Call localVarCall = this.getOptionsPositionValidateBeforeCall(contract, _callback);
        Type localVarReturnType = new TypeToken<OptionsPosition>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listOptionsPositionCloseCall(String underlying, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/position_close";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsPositionCloseValidateBeforeCall(String underlying, String contract, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsPositionClose(Async)");
        }
        Call localVarCall = this.listOptionsPositionCloseCall(underlying, contract, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsPositionClose>> listOptionsPositionCloseWithHttpInfo(String underlying, String contract) throws ApiException {
        Call localVarCall = this.listOptionsPositionCloseValidateBeforeCall(underlying, contract, null);
        Type localVarReturnType = new TypeToken<List<OptionsPositionClose>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsPositionCloseAsync(String underlying, String contract, ApiCallback<List<OptionsPositionClose>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsPositionCloseValidateBeforeCall(underlying, contract, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsPositionClose>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsPositionCloseRequest listOptionsPositionClose(String underlying) {
        return new APIlistOptionsPositionCloseRequest(underlying);
    }

    private Call listOptionsOrdersCall(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOptionsOrdersValidateBeforeCall(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listOptionsOrders(Async)");
        }
        Call localVarCall = this.listOptionsOrdersCall(status, contract, underlying, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsOrder>> listOptionsOrdersWithHttpInfo(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listOptionsOrdersValidateBeforeCall(status, contract, underlying, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOptionsOrdersAsync(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
        Call localVarCall = this.listOptionsOrdersValidateBeforeCall(status, contract, underlying, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOptionsOrdersRequest listOptionsOrders(String status) {
        return new APIlistOptionsOrdersRequest(status);
    }

    public Call createOptionsOrderCall(OptionsOrder optionsOrder, ApiCallback _callback) throws ApiException {
        OptionsOrder localVarPostBody = optionsOrder;
        String localVarPath = "/options/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOptionsOrderValidateBeforeCall(OptionsOrder optionsOrder, ApiCallback _callback) throws ApiException {
        if (optionsOrder == null) {
            throw new ApiException("Missing the required parameter 'optionsOrder' when calling createOptionsOrder(Async)");
        }
        Call localVarCall = this.createOptionsOrderCall(optionsOrder, _callback);
        return localVarCall;
    }

    public OptionsOrder createOptionsOrder(OptionsOrder optionsOrder) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = this.createOptionsOrderWithHttpInfo(optionsOrder);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsOrder> createOptionsOrderWithHttpInfo(OptionsOrder optionsOrder) throws ApiException {
        Call localVarCall = this.createOptionsOrderValidateBeforeCall(optionsOrder, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOptionsOrderAsync(OptionsOrder optionsOrder, ApiCallback<OptionsOrder> _callback) throws ApiException {
        Call localVarCall = this.createOptionsOrderValidateBeforeCall(optionsOrder, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOptionsOrdersCall(String contract, String underlying, String side, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOptionsOrdersValidateBeforeCall(String contract, String underlying, String side, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.cancelOptionsOrdersCall(contract, underlying, side, _callback);
        return localVarCall;
    }

    public List<OptionsOrder> cancelOptionsOrders(String contract, String underlying, String side) throws ApiException {
        ApiResponse<List<OptionsOrder>> localVarResp = this.cancelOptionsOrdersWithHttpInfo(contract, underlying, side);
        return localVarResp.getData();
    }

    public ApiResponse<List<OptionsOrder>> cancelOptionsOrdersWithHttpInfo(String contract, String underlying, String side) throws ApiException {
        Call localVarCall = this.cancelOptionsOrdersValidateBeforeCall(contract, underlying, side, null);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOptionsOrdersAsync(String contract, String underlying, String side, ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelOptionsOrdersValidateBeforeCall(contract, underlying, side, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOptionsOrderCall(Long orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsOrderValidateBeforeCall(Long orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOptionsOrder(Async)");
        }
        Call localVarCall = this.getOptionsOrderCall(orderId, _callback);
        return localVarCall;
    }

    public OptionsOrder getOptionsOrder(Long orderId) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = this.getOptionsOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsOrder> getOptionsOrderWithHttpInfo(Long orderId) throws ApiException {
        Call localVarCall = this.getOptionsOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOptionsOrderAsync(Long orderId, ApiCallback<OptionsOrder> _callback) throws ApiException {
        Call localVarCall = this.getOptionsOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOptionsOrderCall(Long orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOptionsOrderValidateBeforeCall(Long orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOptionsOrder(Async)");
        }
        Call localVarCall = this.cancelOptionsOrderCall(orderId, _callback);
        return localVarCall;
    }

    public OptionsOrder cancelOptionsOrder(Long orderId) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = this.cancelOptionsOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsOrder> cancelOptionsOrderWithHttpInfo(Long orderId) throws ApiException {
        Call localVarCall = this.cancelOptionsOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOptionsOrderAsync(Long orderId, ApiCallback<OptionsOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelOptionsOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call countdownCancelAllOptionsCall(CountdownCancelAllOptionsTask countdownCancelAllOptionsTask, ApiCallback _callback) throws ApiException {
        CountdownCancelAllOptionsTask localVarPostBody = countdownCancelAllOptionsTask;
        String localVarPath = "/options/countdown_cancel_all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call countdownCancelAllOptionsValidateBeforeCall(CountdownCancelAllOptionsTask countdownCancelAllOptionsTask, ApiCallback _callback) throws ApiException {
        if (countdownCancelAllOptionsTask == null) {
            throw new ApiException("Missing the required parameter 'countdownCancelAllOptionsTask' when calling countdownCancelAllOptions(Async)");
        }
        Call localVarCall = this.countdownCancelAllOptionsCall(countdownCancelAllOptionsTask, _callback);
        return localVarCall;
    }

    public TriggerTime countdownCancelAllOptions(CountdownCancelAllOptionsTask countdownCancelAllOptionsTask) throws ApiException {
        ApiResponse<TriggerTime> localVarResp = this.countdownCancelAllOptionsWithHttpInfo(countdownCancelAllOptionsTask);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerTime> countdownCancelAllOptionsWithHttpInfo(CountdownCancelAllOptionsTask countdownCancelAllOptionsTask) throws ApiException {
        Call localVarCall = this.countdownCancelAllOptionsValidateBeforeCall(countdownCancelAllOptionsTask, null);
        Type localVarReturnType = new TypeToken<TriggerTime>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call countdownCancelAllOptionsAsync(CountdownCancelAllOptionsTask countdownCancelAllOptionsTask, ApiCallback<TriggerTime> _callback) throws ApiException {
        Call localVarCall = this.countdownCancelAllOptionsValidateBeforeCall(countdownCancelAllOptionsTask, _callback);
        Type localVarReturnType = new TypeToken<TriggerTime>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMyOptionsTradesCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/my_trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMyOptionsTradesValidateBeforeCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listMyOptionsTrades(Async)");
        }
        Call localVarCall = this.listMyOptionsTradesCall(underlying, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsMyTrade>> listMyOptionsTradesWithHttpInfo(String underlying, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listMyOptionsTradesValidateBeforeCall(underlying, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsMyTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMyOptionsTradesAsync(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<OptionsMyTrade>> _callback) throws ApiException {
        Call localVarCall = this.listMyOptionsTradesValidateBeforeCall(underlying, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsMyTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMyOptionsTradesRequest listMyOptionsTrades(String underlying) {
        return new APIlistMyOptionsTradesRequest(underlying);
    }

    private Call getOptionsMMPCall(String underlying, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/options/mmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("underlying", underlying));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOptionsMMPValidateBeforeCall(String underlying, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getOptionsMMPCall(underlying, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OptionsMMP>> getOptionsMMPWithHttpInfo(String underlying) throws ApiException {
        Call localVarCall = this.getOptionsMMPValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<OptionsMMP>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOptionsMMPAsync(String underlying, ApiCallback<List<OptionsMMP>> _callback) throws ApiException {
        Call localVarCall = this.getOptionsMMPValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsMMP>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetOptionsMMPRequest getOptionsMMP() {
        return new APIgetOptionsMMPRequest();
    }

    public Call setOptionsMMPCall(OptionsMMP optionsMMP, ApiCallback _callback) throws ApiException {
        OptionsMMP localVarPostBody = optionsMMP;
        String localVarPath = "/options/mmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setOptionsMMPValidateBeforeCall(OptionsMMP optionsMMP, ApiCallback _callback) throws ApiException {
        if (optionsMMP == null) {
            throw new ApiException("Missing the required parameter 'optionsMMP' when calling setOptionsMMP(Async)");
        }
        Call localVarCall = this.setOptionsMMPCall(optionsMMP, _callback);
        return localVarCall;
    }

    public OptionsMMP setOptionsMMP(OptionsMMP optionsMMP) throws ApiException {
        ApiResponse<OptionsMMP> localVarResp = this.setOptionsMMPWithHttpInfo(optionsMMP);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsMMP> setOptionsMMPWithHttpInfo(OptionsMMP optionsMMP) throws ApiException {
        Call localVarCall = this.setOptionsMMPValidateBeforeCall(optionsMMP, null);
        Type localVarReturnType = new TypeToken<OptionsMMP>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setOptionsMMPAsync(OptionsMMP optionsMMP, ApiCallback<OptionsMMP> _callback) throws ApiException {
        Call localVarCall = this.setOptionsMMPValidateBeforeCall(optionsMMP, _callback);
        Type localVarReturnType = new TypeToken<OptionsMMP>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetOptionsMMPCall(OptionsMMPReset optionsMMPReset, ApiCallback _callback) throws ApiException {
        OptionsMMPReset localVarPostBody = optionsMMPReset;
        String localVarPath = "/options/mmp/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetOptionsMMPValidateBeforeCall(OptionsMMPReset optionsMMPReset, ApiCallback _callback) throws ApiException {
        if (optionsMMPReset == null) {
            throw new ApiException("Missing the required parameter 'optionsMMPReset' when calling resetOptionsMMP(Async)");
        }
        Call localVarCall = this.resetOptionsMMPCall(optionsMMPReset, _callback);
        return localVarCall;
    }

    public OptionsMMP resetOptionsMMP(OptionsMMPReset optionsMMPReset) throws ApiException {
        ApiResponse<OptionsMMP> localVarResp = this.resetOptionsMMPWithHttpInfo(optionsMMPReset);
        return localVarResp.getData();
    }

    public ApiResponse<OptionsMMP> resetOptionsMMPWithHttpInfo(OptionsMMPReset optionsMMPReset) throws ApiException {
        Call localVarCall = this.resetOptionsMMPValidateBeforeCall(optionsMMPReset, null);
        Type localVarReturnType = new TypeToken<OptionsMMP>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resetOptionsMMPAsync(OptionsMMPReset optionsMMPReset, ApiCallback<OptionsMMP> _callback) throws ApiException {
        Call localVarCall = this.resetOptionsMMPValidateBeforeCall(optionsMMPReset, _callback);
        Type localVarReturnType = new TypeToken<OptionsMMP>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetOptionsMMPRequest {
        private String underlying;

        private APIgetOptionsMMPRequest() {
        }

        public APIgetOptionsMMPRequest underlying(String underlying) {
            this.underlying = underlying;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.getOptionsMMPCall(this.underlying, _callback);
        }

        public List<OptionsMMP> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.getOptionsMMPWithHttpInfo(this.underlying);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsMMP>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.getOptionsMMPWithHttpInfo(this.underlying);
        }

        public Call executeAsync(ApiCallback<List<OptionsMMP>> _callback) throws ApiException {
            return OptionsApi.this.getOptionsMMPAsync(this.underlying, _callback);
        }
    }

    public class APIlistMyOptionsTradesRequest {
        private final String underlying;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistMyOptionsTradesRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistMyOptionsTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistMyOptionsTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMyOptionsTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistMyOptionsTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMyOptionsTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listMyOptionsTradesCall(this.underlying, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<OptionsMyTrade> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listMyOptionsTradesWithHttpInfo(this.underlying, this.contract, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsMyTrade>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listMyOptionsTradesWithHttpInfo(this.underlying, this.contract, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<OptionsMyTrade>> _callback) throws ApiException {
            return OptionsApi.this.listMyOptionsTradesAsync(this.underlying, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIlistOptionsOrdersRequest {
        private final String status;
        private String contract;
        private String underlying;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsOrdersRequest(String status) {
            this.status = status;
        }

        public APIlistOptionsOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistOptionsOrdersRequest underlying(String underlying) {
            this.underlying = underlying;
            return this;
        }

        public APIlistOptionsOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistOptionsOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsOrdersCall(this.status, this.contract, this.underlying, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<OptionsOrder> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsOrdersWithHttpInfo(this.status, this.contract, this.underlying, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsOrder>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsOrdersWithHttpInfo(this.status, this.contract, this.underlying, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsOrdersAsync(this.status, this.contract, this.underlying, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIlistOptionsPositionCloseRequest {
        private final String underlying;
        private String contract;

        private APIlistOptionsPositionCloseRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistOptionsPositionCloseRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsPositionCloseCall(this.underlying, this.contract, _callback);
        }

        public List<OptionsPositionClose> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsPositionCloseWithHttpInfo(this.underlying, this.contract);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsPositionClose>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsPositionCloseWithHttpInfo(this.underlying, this.contract);
        }

        public Call executeAsync(ApiCallback<List<OptionsPositionClose>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsPositionCloseAsync(this.underlying, this.contract, _callback);
        }
    }

    public class APIlistOptionsPositionsRequest {
        private String underlying;

        private APIlistOptionsPositionsRequest() {
        }

        public APIlistOptionsPositionsRequest underlying(String underlying) {
            this.underlying = underlying;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsPositionsCall(this.underlying, _callback);
        }

        public List<OptionsPosition> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsPositionsWithHttpInfo(this.underlying);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsPosition>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsPositionsWithHttpInfo(this.underlying);
        }

        public Call executeAsync(ApiCallback<List<OptionsPosition>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsPositionsAsync(this.underlying, _callback);
        }
    }

    public class APIlistOptionsAccountBookRequest {
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;
        private String type;

        private APIlistOptionsAccountBookRequest() {
        }

        public APIlistOptionsAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsAccountBookRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistOptionsAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistOptionsAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsAccountBookCall(this.limit, this.offset, this.from, this.to, this.type, _callback);
        }

        public List<OptionsAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsAccountBookWithHttpInfo(this.limit, this.offset, this.from, this.to, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsAccountBook>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsAccountBookWithHttpInfo(this.limit, this.offset, this.from, this.to, this.type);
        }

        public Call executeAsync(ApiCallback<List<OptionsAccountBook>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsAccountBookAsync(this.limit, this.offset, this.from, this.to, this.type, _callback);
        }
    }

    public class APIlistOptionsTradesRequest {
        private String contract;
        private String type;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsTradesRequest() {
        }

        public APIlistOptionsTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistOptionsTradesRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistOptionsTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistOptionsTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsTradesCall(this.contract, this.type, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<FuturesTrade> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsTradesWithHttpInfo(this.contract, this.type, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesTrade>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsTradesWithHttpInfo(this.contract, this.type, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsTradesAsync(this.contract, this.type, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIlistOptionsUnderlyingCandlesticksRequest {
        private final String underlying;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistOptionsUnderlyingCandlesticksRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistOptionsUnderlyingCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsUnderlyingCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsUnderlyingCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistOptionsUnderlyingCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsUnderlyingCandlesticksCall(this.underlying, this.limit, this.from, this.to, this.interval, _callback);
        }

        public List<FuturesCandlestick> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsUnderlyingCandlesticksWithHttpInfo(this.underlying, this.limit, this.from, this.to, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesCandlestick>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsUnderlyingCandlesticksWithHttpInfo(this.underlying, this.limit, this.from, this.to, this.interval);
        }

        public Call executeAsync(ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsUnderlyingCandlesticksAsync(this.underlying, this.limit, this.from, this.to, this.interval, _callback);
        }
    }

    public class APIlistOptionsCandlesticksRequest {
        private final String contract;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistOptionsCandlesticksRequest(String contract) {
            this.contract = contract;
        }

        public APIlistOptionsCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistOptionsCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsCandlesticksCall(this.contract, this.limit, this.from, this.to, this.interval, _callback);
        }

        public List<OptionsCandlestick> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsCandlesticksWithHttpInfo(this.contract, this.limit, this.from, this.to, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsCandlestick>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsCandlesticksWithHttpInfo(this.contract, this.limit, this.from, this.to, this.interval);
        }

        public Call executeAsync(ApiCallback<List<OptionsCandlestick>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsCandlesticksAsync(this.contract, this.limit, this.from, this.to, this.interval, _callback);
        }
    }

    public class APIlistOptionsOrderBookRequest {
        private final String contract;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistOptionsOrderBookRequest(String contract) {
            this.contract = contract;
        }

        public APIlistOptionsOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistOptionsOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsOrderBookCall(this.contract, this.interval, this.limit, this.withId, _callback);
        }

        public FuturesOrderBook execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsOrderBookWithHttpInfo(this.contract, this.interval, this.limit, this.withId);
            return (FuturesOrderBook)localVarResp.getData();
        }

        public ApiResponse<FuturesOrderBook> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsOrderBookWithHttpInfo(this.contract, this.interval, this.limit, this.withId);
        }

        public Call executeAsync(ApiCallback<FuturesOrderBook> _callback) throws ApiException {
            return OptionsApi.this.listOptionsOrderBookAsync(this.contract, this.interval, this.limit, this.withId, _callback);
        }
    }

    public class APIlistMyOptionsSettlementsRequest {
        private final String underlying;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistMyOptionsSettlementsRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistMyOptionsSettlementsRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistMyOptionsSettlementsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMyOptionsSettlementsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistMyOptionsSettlementsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMyOptionsSettlementsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listMyOptionsSettlementsCall(this.underlying, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<OptionsMySettlements> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listMyOptionsSettlementsWithHttpInfo(this.underlying, this.contract, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsMySettlements>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listMyOptionsSettlementsWithHttpInfo(this.underlying, this.contract, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<OptionsMySettlements>> _callback) throws ApiException {
            return OptionsApi.this.listMyOptionsSettlementsAsync(this.underlying, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIlistOptionsSettlementsRequest {
        private final String underlying;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsSettlementsRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistOptionsSettlementsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOptionsSettlementsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistOptionsSettlementsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistOptionsSettlementsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsSettlementsCall(this.underlying, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<OptionsSettlement> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsSettlementsWithHttpInfo(this.underlying, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsSettlement>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsSettlementsWithHttpInfo(this.underlying, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<OptionsSettlement>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsSettlementsAsync(this.underlying, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIlistOptionsContractsRequest {
        private final String underlying;
        private Long expiration;

        private APIlistOptionsContractsRequest(String underlying) {
            this.underlying = underlying;
        }

        public APIlistOptionsContractsRequest expiration(Long expiration) {
            this.expiration = expiration;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OptionsApi.this.listOptionsContractsCall(this.underlying, this.expiration, _callback);
        }

        public List<OptionsContract> execute() throws ApiException {
            ApiResponse localVarResp = OptionsApi.this.listOptionsContractsWithHttpInfo(this.underlying, this.expiration);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OptionsContract>> executeWithHttpInfo() throws ApiException {
            return OptionsApi.this.listOptionsContractsWithHttpInfo(this.underlying, this.expiration);
        }

        public Call executeAsync(ApiCallback<List<OptionsContract>> _callback) throws ApiException {
            return OptionsApi.this.listOptionsContractsAsync(this.underlying, this.expiration, _callback);
        }
    }
}

